      *
      * COBOLPROG
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product.
      *
      * This COBOL program is intended to be called from a Java class
      * to demonstrate a Java program's ability to CALL a COBOL
      * program.
      *
      * Parameters are passed from the Java side to the COBOL side
      * and then displayed from COBOL.  Data is then generated
      * into the RESULT variable, returning it to the Java side.
      *
      * The Java program 'CallCobol' is considered to be the 'main'
      * program in this sample.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. COBOLPROG.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01 RESULT PIC X(20).
       LINKAGE SECTION.   
       01 PARAMS.
           05 PARAM1 PIC S9(8) USAGE BINARY.      | INT
           05 PARAM2 PIC X(3).                    | STRING
           05 PARAM3 PIC S9(9)V9(9) USAGE COMP-2. | DOUBLE
           05 PARAM4 PIC S9(16) USAGE BINARY.     | LONG
           05 PARAM5 PIC X(1).                    | CHAR

       PROCEDURE DIVISION USING  PARAM1 PARAM2 PARAM3 PARAM4 PARAM5
                          GIVING RESULT.

       MAIN-PARAGRAPH.
           DISPLAY "COBOL PROGRAM: CALLED WITH THESE PARAMETERS:" 
               UPON SYSOUT
           DISPLAY "PARAM1=" PARAM1 UPON SYSOUT
           DISPLAY "PARAM2=" PARAM2 UPON SYSOUT
           DISPLAY "PARAM3=" PARAM3 UPON SYSOUT
           DISPLAY "PARAM4=" PARAM4 UPON SYSOUT
           DISPLAY "PARAM5=" PARAM5 UPON SYSOUT
           MOVE -73 TO PARAM4
           DISPLAY "COBOL PROGRAM: RETURNING TO JAVA" UPON SYSOUT
           MOVE "HELLO FROM COBOL" TO RESULT
           .
