      *
      * DATETIME
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product.
      *
       id division.
       program-id. datetime.
       
       data division.
       working-storage section.
       
       01 date-group.
      *                            "@Y-%m-%d"
           05 plain-date format of date.
       
      *                            "%H:%M:%S"
       01 time-group.
           05 plain-time format of time.
       
      *                            "@Y-%m-%d-%H.%M.%S.@Sm"
       01 timestamp-group.
           05 plain-timestamp format of timestamp.
           05 other-timestamp format of timestamp.
      
       01 packed-decimal-item pic s9(9)v9(9).
       
       01 numedited pic $$$$,$$$.99.
              
       procedure division.
       main-paragraph.
       
           display "AS/400 Style Date/Time/Timestamp Functionality" 
               upon sysout
           display "" 
               upon sysout
       
           move "1972-08-06" to plain-date
           move "12:34:56" to plain-time
           move "1972-08-06-12.34.56.123456" to plain-timestamp
           move "1972-09-08-16.11.22.333333" to other-timestamp
           
           move "$1,234.56" to numedited
           move numedited to packed-decimal-item
           
           display "numedited in packed-decimal: " packed-decimal-item
               upon sysout
           
           move plain-date to packed-decimal-item
           display "plain-date in packed-decimal:" packed-decimal-item
               upon sysout
           move plain-time to packed-decimal-item
           display "plain-time in packed-decimal: " packed-decimal-item
               upon sysout
           .
           
      *
      * There are eight (8) intrinsic functions compatible with the AS/400.
      *
      * ADD-DURATION
      * SUBTRACT-DURATION
      * LOCALE-DATE
      * LOCALE-TIME
      * EXTRACT-DATE-TIME
      * FIND-DURATION
      * TEST-DATE-TIME
      * CONVERT-DATE-TIME
      *
      
      * Many additional formats of date/time have been added to the
      * original by Elastic COBOL.
      
      * The ASSERTs serve to document the expected values of each
      * operation, but have no other effect on the program unless
      * compiled with the -assert flag.
      
       ADD-DURATION.
       
           display "" upon sysout
           display "ADD-DURATION:" upon sysout
           display "" upon sysout
       
           display plain-date
               upon sysout
               
           assert plain-date = "1972-08-06"
           
           display function add-duration(plain-date years 1) 
               upon sysout
               
           assert function add-duration(plain-date years 1) 
               = "1973-08-06"
           
           display function add-duration(plain-date months 1) 
               upon sysout
           
           assert function add-duration(plain-date months 1) 
               = "1972-09-06"
           
           display function add-duration(plain-date days 1) 
               upon sysout
           
           assert function add-duration(plain-date days 1) 
               = "1972-08-07"
           
           display function add-duration(
               plain-date 
               years 1
               months 1
               days 1
               ) 
               upon sysout
           
           assert function add-duration(
                plain-date years 1 months 1 days 1) = "1973-09-07"
               
           display plain-time
               upon sysout
               
           assert plain-time = "12:34:56"
           
           display function add-duration(plain-time hours 1) 
               upon sysout
               
           assert function add-duration(plain-time hours 1) =
               "13:34:56"
               
           display function add-duration(plain-time minutes 1) 
               upon sysout
               
           assert function add-duration(plain-time minutes 1) =
               "12:35:56"
               
           display function add-duration(plain-time seconds 1) 
               upon sysout
           
           assert function add-duration(plain-time seconds 1) =
               "12:34:57"
               
           display function add-duration(
               plain-time 
               hours 1
               minutes 1
               seconds 1
               ) 
               upon sysout
      
           assert function add-duration(plain-time hours 1
               minutes 1 seconds 1) = "13:35:57"
                      
           display plain-timestamp
               upon sysout
           
           assert plain-timestamp = "1972-08-06-12.34.56.123456"
           
           display function add-duration(plain-timestamp years 1) 
               upon sysout
               
           assert function add-duration(plain-timestamp years 1) =
               "1973-08-06-12.34.56.123456"
               
           display function add-duration(plain-timestamp months 1) 
               upon sysout
           
           assert function add-duration(plain-timestamp months 1) =
               "1972-09-06-12.34.56.123456"
               
           display function add-duration(plain-timestamp days 1) 
               upon sysout
           
           assert function add-duration(plain-timestamp days 1) =
               "1972-08-07-12.34.56.123456"
               
           display function add-duration(plain-timestamp hours 1) 
               upon sysout
           
           assert function add-duration(plain-timestamp hours 1) =
               "1972-08-06-13.34.56.123456"
           
           display function add-duration(plain-timestamp minutes 1) 
               upon sysout
           
           assert function add-duration(plain-timestamp minutes 1)=
               "1972-08-06-12.35.56.123456"
               
           display function add-duration(plain-timestamp seconds 1) 
               upon sysout
           
           assert function add-duration(plain-timestamp seconds 1)=
               "1972-08-06-12.34.57.123456"
               
           display function add-duration(plain-timestamp microseconds 1)
               upon sysout
           
           assert function add-duration(plain-timestamp microseconds 1)=
               "1972-08-06-12.34.56.123457"
               
           display function add-duration(
               plain-timestamp 
               years 1
               months 1
               days 1
               hours 1
               minutes 1
               seconds 1
               microseconds 1
               )
               upon sysout
               
           assert function add-duration(
               plain-timestamp 
               years 1
               months 1
               days 1
               hours 1
               minutes 1
               seconds 1
               microseconds 1
               ) =
               "1973-09-07-13.35.57.123457"
               .
               
       
       SUBTRACT-DURATION.
       
           display "" upon sysout
           display "SUBTRACT-DURATION:" upon sysout
           display "" upon sysout
       
           display plain-date
               upon sysout
           assert plain-date = "1972-08-06"
           
           display function subtract-duration(plain-date years 1) 
               upon sysout
           
           assert function subtract-duration(plain-date years 1)=
               "1971-08-06"
               
           display function subtract-duration(plain-date months 1) 
               upon sysout
           assert function subtract-duration(plain-date months 1)=
               "1972-07-06"
               
           display function subtract-duration(plain-date days 1) 
               upon sysout
           assert function subtract-duration(plain-date days 1)=
               "1972-08-05"
           
           display function subtract-duration(
               plain-date 
               years 1
               months 1
               days 1
               ) 
               upon sysout
               
           assert function subtract-duration(
               plain-date 
               years 1
               months 1
               days 1
               ) 
               ="1971-07-05"
               
           display plain-time
               upon sysout
           assert plain-time = "12:34:56"
           
           display function subtract-duration(plain-time hours 1) 
               upon sysout
           assert function subtract-duration(plain-time hours 1)=
               "11:34:56"
           display function subtract-duration(plain-time minutes 1) 
               upon sysout
           assert function subtract-duration(plain-time minutes 1)=
               "12:33:56"
               
           display function subtract-duration(plain-time seconds 1) 
               upon sysout
           assert function subtract-duration(plain-time seconds 1)=
               "12:34:55"
               
           display function subtract-duration(
               plain-time 
               hours 1
               minutes 1
               seconds 1
               ) 
               upon sysout
           assert function subtract-duration(
               plain-time 
               hours 1
               minutes 1
               seconds 1
               ) 
               ="11:33:55"
       
           display plain-timestamp
               upon sysout
               
           assert plain-timestamp = "1972-08-06-12.34.56.123456"
           
           display function subtract-duration(plain-timestamp years 1) 
               upon sysout
           
           assert function subtract-duration(plain-timestamp years 1)=
               "1971-08-06-12.34.56.123456"
           
           display function subtract-duration(plain-timestamp months 1) 
               upon sysout
           assert function subtract-duration(plain-timestamp months 1)=
               "1972-07-06-12.34.56.123456"
               
           display function subtract-duration(plain-timestamp days 1) 
               upon sysout
           assert function subtract-duration(plain-timestamp days 1)=
               "1972-08-05-12.34.56.123456"
               
           display function subtract-duration(plain-timestamp hours 1) 
               upon sysout
           assert function subtract-duration(plain-timestamp hours 1)=
               "1972-08-06-11.34.56.123456"
               
           display function subtract-duration(plain-timestamp minutes 1) 
               upon sysout
           assert function subtract-duration(plain-timestamp minutes 1)=
               "1972-08-06-12.33.56.123456"
               
           display function subtract-duration(plain-timestamp seconds 1) 
               upon sysout
           assert function subtract-duration(plain-timestamp seconds 1)=
               "1972-08-06-12.34.55.123456"
               
           display function subtract-duration(
               plain-timestamp 
               microseconds 1
               )
               upon sysout
           assert function subtract-duration(plain-timestamp 
               microseconds 1)
               ="1972-08-06-12.34.56.123455"
               
           display function subtract-duration(
               plain-timestamp 
               years 1
               months 1
               days 1
               hours 1
               minutes 1
               seconds 1
               microseconds 1
               )
               upon sysout
               
           assert function subtract-duration(
               plain-timestamp 
               years 1
               months 1
               days 1
               hours 1
               minutes 1
               seconds 1
               microseconds 1
               )
               ="1971-07-05-11.33.55.123455"
               .
      
       LOCALE-DATE.
       
           display "" upon sysout
           display "LOCALE-DATE:" upon sysout
           display "" upon sysout
           
           display function locale-date("19720806") 
               upon sysout
           display function locale-date(
               "19720806" locale
               ) 
               upon sysout
           display function locale-date(
               "19720806" locale "en_US"
               ) 
               upon sysout
           display function locale-date(
               "19720806" locale "en_US:S"
               ) 
               upon sysout
           display function locale-date(
               "19720806" locale "en_US:M"
               )
               upon sysout
           display function locale-date(
               "19720806" locale "en_US:L"
               )
               upon sysout
           display function locale-date(
               "19720806" locale "en_US:F"
               )
               upon sysout
               
           display function locale-date(
               "19720806" locale "de_DE"
               ) 
               upon sysout
           display function locale-date(
               "19720806" locale "de_DE:S"
               ) 
               upon sysout
           display function locale-date(
               "19720806" locale "de_DE:M"
               )
               upon sysout
           display function locale-date(
               "19720806" locale "de_DE:L"
               )
               upon sysout
           display function locale-date(
               "19720806" locale "de_DE:F"
               )
               upon sysout
           .
       	       
       LOCALE-TIME.
       
           display "" upon sysout
           display "LOCALE-TIME:" upon sysout
           display "" upon sysout
           
           display function locale-time(
               "184812"
               )
               upon sysout
           display function locale-time(
               "184812" locale
               )
               upon sysout
           display function locale-time(
               "184812" locale "en_US"
               )
               upon sysout
           display function locale-time(
               "184812" locale "en_US:S"
               )
               upon sysout
           display function locale-time(
               "184812" locale "en_US:M"
               )
               upon sysout
           display function locale-time(
               "184812" locale "en_US:L"
               )
               upon sysout
           display function locale-time(
               "184812" locale "en_US:F"
               )
               upon sysout
               .
               
       EXTRACT-DATE-TIME-KEYWORD.
       
           display "" upon sysout
           display "EXTRACT-DATE-TIME (keyword):" upon sysout
           display "" upon sysout
           
           display "plain-timestamp=" plain-timestamp upon sysout
           
           display function extract-date-time 
               (plain-timestamp years) upon sysout
           assert function extract-date-time(plain-timestamp years)=
               "1972"
               
           display function extract-date-time 
               (plain-timestamp months) upon sysout
           assert function extract-date-time(plain-timestamp months)=
               "8"
               
           display function extract-date-time 
               (plain-timestamp days) upon sysout
           assert function extract-date-time(plain-timestamp days)=
               "6"
               
           display function extract-date-time 
               (plain-timestamp hours) upon sysout
           assert function extract-date-time(plain-timestamp hours)=
               "12"
               
           display function extract-date-time 
               (plain-timestamp minutes) upon sysout
           assert function extract-date-time(plain-timestamp minutes)=
               "34"
               
           display function extract-date-time 
               (plain-timestamp seconds) upon sysout
           assert function extract-date-time(plain-timestamp seconds)=
               "56"
               
           display function extract-date-time 
               (plain-timestamp microseconds) upon sysout
           assert function extract-date-time(plain-timestamp
               microseconds)="123456"
           .
      
       EXTRACT-DATE-TIME-AS400.
       
           display "" upon sysout
           display "EXTRACT-DATE-TIME (AS/400 strings):" upon sysout
           display "" upon sysout
           
           display "plain-timestamp=" plain-timestamp upon sysout
           
           display "@C=" function extract-date-time 
               (plain-timestamp "@C") upon sysout
           assert function extract-date-time 
               (plain-timestamp "@C") ="0"
           display "@p=" function extract-date-time 
               (plain-timestamp "@p") upon sysout
           display "@Sh=" function extract-date-time 
               (plain-timestamp "@Sh") upon sysout
           display "@Sm=" function extract-date-time 
               (plain-timestamp "@Sm") upon sysout
           display "@So=" function extract-date-time 
               (plain-timestamp "@So") upon sysout
           display "@St=" function extract-date-time 
               (plain-timestamp "@St") upon sysout
           display "@Y=" function extract-date-time 
               (plain-timestamp "@Y") upon sysout
               
           display "%d=" function extract-date-time 
               (plain-timestamp "%d") upon sysout
           display "%D=" function extract-date-time 
               (plain-timestamp "%D") upon sysout
           display "%H=" function extract-date-time 
               (plain-timestamp "%H") upon sysout
           display "%I=" function extract-date-time 
               (plain-timestamp "%I") upon sysout
           display "%j=" function extract-date-time 
               (plain-timestamp "%j") upon sysout
           display "%m=" function extract-date-time 
               (plain-timestamp "%m") upon sysout
           display "%M=" function extract-date-time 
               (plain-timestamp "%M") upon sysout
           display "%p=" function extract-date-time 
               (plain-timestamp "%p") upon sysout
           display "%r=" function extract-date-time 
               (plain-timestamp "%r") upon sysout
           display "%R=" function extract-date-time 
               (plain-timestamp "%R") upon sysout
           display "%S=" function extract-date-time 
               (plain-timestamp "%S") upon sysout
           display "%y=" function extract-date-time 
               (plain-timestamp "%y") upon sysout
           display "%Y=" function extract-date-time 
               (plain-timestamp "%Y") upon sysout
               
           display "%%=" function extract-date-time 
               (plain-timestamp "%%") upon sysout
           display "@@=" function extract-date-time 
               (plain-timestamp "@@") upon sysout
           .
      
      *	#	INTU
      * &	INTF
      *	!	EXTF
      *	^	EXTU
      *	$	NAML
      *	*	NAMS
      *	`	BINM
      *	~	BINL
         
       EXTRACT-DATE-TIME-INTU.
       
           display "" upon sysout
           display "EXTRACT-DATE-TIME (internal unformat):" upon sysout
           display "" upon sysout
           
           display "#l=" function extract-date-time 
               (plain-timestamp "#l") upon sysout
           display "#e=" function extract-date-time 
               (plain-timestamp "#e") upon sysout
           display "#Y=" function extract-date-time 
               (plain-timestamp "#Y") upon sysout
           display "#y=" function extract-date-time 
               (plain-timestamp "#y") upon sysout
           display "#c=" function extract-date-time 
               (plain-timestamp "#c") upon sysout
           display "#C=" function extract-date-time 
               (plain-timestamp "#C") upon sysout
           display "#N=" function extract-date-time 
               (plain-timestamp "#N") upon sysout
           display "#m=" function extract-date-time 
               (plain-timestamp "#m") upon sysout
           display "#u=" function extract-date-time 
               (plain-timestamp "#u") upon sysout
           display "#W=" function extract-date-time 
               (plain-timestamp "#W") upon sysout
           display "#d=" function extract-date-time 
               (plain-timestamp "#d") upon sysout
           display "#j=" function extract-date-time 
               (plain-timestamp "#j") upon sysout
           display "#w=" function extract-date-time 
               (plain-timestamp "#w") upon sysout
           display "#U=" function extract-date-time 
               (plain-timestamp "#U") upon sysout
           display "#A=" function extract-date-time 
               (plain-timestamp "#A") upon sysout
           display "#I=" function extract-date-time 
               (plain-timestamp "#I") upon sysout
           display "#H=" function extract-date-time 
               (plain-timestamp "#H") upon sysout
           display "#M=" function extract-date-time 
               (plain-timestamp "#M") upon sysout
           display "#S=" function extract-date-time 
               (plain-timestamp "#S") upon sysout
           display "#s=" function extract-date-time 
               (plain-timestamp "#s") upon sysout
           display "#z=" function extract-date-time 
               (plain-timestamp "#z") upon sysout
           display "#Z=" function extract-date-time 
               (plain-timestamp "#Z") upon sysout
           display "#n=" function extract-date-time 
               (plain-timestamp "#n") upon sysout
           .
           
       EXTRACT-DATE-TIME-INTF.
       
           display "" upon sysout
           display "EXTRACT-DATE-TIME (internal format):" upon sysout
           display "" upon sysout
           
           display "&l=" function extract-date-time 
               (plain-timestamp "&l") upon sysout
           display "&e=" function extract-date-time 
               (plain-timestamp "&e") upon sysout
           display "&Y=" function extract-date-time 
               (plain-timestamp "&Y") upon sysout
           display "&y=" function extract-date-time 
               (plain-timestamp "&y") upon sysout
           display "&c=" function extract-date-time 
               (plain-timestamp "&c") upon sysout
           display "&C=" function extract-date-time 
               (plain-timestamp "&C") upon sysout
           display "&N=" function extract-date-time 
               (plain-timestamp "&N") upon sysout
           display "&m=" function extract-date-time 
               (plain-timestamp "&m") upon sysout
           display "&u=" function extract-date-time 
               (plain-timestamp "&u") upon sysout
           display "&W=" function extract-date-time 
               (plain-timestamp "&W") upon sysout
           display "&d=" function extract-date-time 
               (plain-timestamp "&d") upon sysout
           display "&j=" function extract-date-time 
               (plain-timestamp "&j") upon sysout
           display "&w=" function extract-date-time 
               (plain-timestamp "&w") upon sysout
           display "&U=" function extract-date-time 
               (plain-timestamp "&U") upon sysout
           display "&A=" function extract-date-time 
               (plain-timestamp "&A") upon sysout
           display "&I=" function extract-date-time 
               (plain-timestamp "&I") upon sysout
           display "&H=" function extract-date-time 
               (plain-timestamp "&H") upon sysout
           display "&M=" function extract-date-time 
               (plain-timestamp "&M") upon sysout
           display "&S=" function extract-date-time 
               (plain-timestamp "&S") upon sysout
           display "&s=" function extract-date-time 
               (plain-timestamp "&s") upon sysout
           display "&z=" function extract-date-time 
               (plain-timestamp "&z") upon sysout
           display "&Z=" function extract-date-time 
               (plain-timestamp "&Z") upon sysout
           display "&n=" function extract-date-time 
               (plain-timestamp "&n") upon sysout
           .
       	   
       EXTRACT-DATE-TIME-EXTU.
       
           display "" upon sysout
           display "EXTRACT-DATE-TIME (external unformat):" upon sysout
           display "" upon sysout
           
           display "^l=" function extract-date-time 
               (plain-timestamp "^l") upon sysout
           display "^e=" function extract-date-time 
               (plain-timestamp "^e") upon sysout
           display "^Y=" function extract-date-time 
               (plain-timestamp "^Y") upon sysout
           display "^y=" function extract-date-time 
               (plain-timestamp "^y") upon sysout
           display "^c=" function extract-date-time 
               (plain-timestamp "^c") upon sysout
           display "^C=" function extract-date-time 
               (plain-timestamp "^C") upon sysout
           display "^N=" function extract-date-time 
               (plain-timestamp "^N") upon sysout
           display "^m=" function extract-date-time 
               (plain-timestamp "^m") upon sysout
           display "^u=" function extract-date-time 
               (plain-timestamp "^u") upon sysout
           display "^W=" function extract-date-time 
               (plain-timestamp "^W") upon sysout
           display "^d=" function extract-date-time 
               (plain-timestamp "^d") upon sysout
           display "^j=" function extract-date-time 
               (plain-timestamp "^j") upon sysout
           display "^w=" function extract-date-time 
               (plain-timestamp "^w") upon sysout
           display "^U=" function extract-date-time 
               (plain-timestamp "^U") upon sysout
           display "^A=" function extract-date-time 
               (plain-timestamp "^A") upon sysout
           display "^I=" function extract-date-time 
               (plain-timestamp "^I") upon sysout
           display "^H=" function extract-date-time 
               (plain-timestamp "^H") upon sysout
           display "^M=" function extract-date-time 
               (plain-timestamp "^M") upon sysout
           display "^S=" function extract-date-time 
               (plain-timestamp "^S") upon sysout
           display "^s=" function extract-date-time 
               (plain-timestamp "^s") upon sysout
           display "^z=" function extract-date-time 
               (plain-timestamp "^z") upon sysout
           display "^Z=" function extract-date-time 
               (plain-timestamp "^Z") upon sysout
           display "^n=" function extract-date-time 
               (plain-timestamp "^n") upon sysout
           .
       	   
       EXTRACT-DATE-TIME-EXTF.
       
           display "" upon sysout
           display "EXTRACT-DATE-TIME (external format):" upon sysout
           display "" upon sysout
           
           display "!l=" function extract-date-time 
               (plain-timestamp "!l") upon sysout
           display "!e=" function extract-date-time 
               (plain-timestamp "!e") upon sysout
           display "!Y=" function extract-date-time 
               (plain-timestamp "!Y") upon sysout
           display "!y=" function extract-date-time 
               (plain-timestamp "!y") upon sysout
           display "!c=" function extract-date-time 
               (plain-timestamp "!c") upon sysout
           display "!C=" function extract-date-time 
               (plain-timestamp "!C") upon sysout
           display "!N=" function extract-date-time 
               (plain-timestamp "!N") upon sysout
           display "!m=" function extract-date-time 
               (plain-timestamp "!m") upon sysout
           display "!u=" function extract-date-time 
               (plain-timestamp "!u") upon sysout
           display "!W=" function extract-date-time 
               (plain-timestamp "!W") upon sysout
           display "!d=" function extract-date-time 
               (plain-timestamp "!d") upon sysout
           display "!j=" function extract-date-time 
               (plain-timestamp "!j") upon sysout
           display "!w=" function extract-date-time 
               (plain-timestamp "!w") upon sysout
           display "!U=" function extract-date-time 
               (plain-timestamp "!U") upon sysout
           display "!A=" function extract-date-time 
               (plain-timestamp "!A") upon sysout
           display "!I=" function extract-date-time 
               (plain-timestamp "!I") upon sysout
           display "!H=" function extract-date-time 
               (plain-timestamp "!H") upon sysout
           display "!M=" function extract-date-time 
               (plain-timestamp "!M") upon sysout
           display "!S=" function extract-date-time 
               (plain-timestamp "!S") upon sysout
           display "!s=" function extract-date-time 
               (plain-timestamp "!s") upon sysout
           display "!z=" function extract-date-time 
               (plain-timestamp "!z") upon sysout
           display "!Z=" function extract-date-time 
               (plain-timestamp "!Z") upon sysout
           display "!n=" function extract-date-time 
               (plain-timestamp "!n") upon sysout
           .
       	   
       EXTRACT-DATE-TIME-NAML.
       
           display "" upon sysout
           display "EXTRACT-DATE-TIME (name long):" upon sysout
           display "" upon sysout
           
           display "$l=" function extract-date-time 
               (plain-timestamp "$l") upon sysout
           display "$e=" function extract-date-time 
               (plain-timestamp "$e") upon sysout
           display "$Y=" function extract-date-time 
               (plain-timestamp "$Y") upon sysout
           display "$y=" function extract-date-time 
               (plain-timestamp "$y") upon sysout
           display "$c=" function extract-date-time 
               (plain-timestamp "$c") upon sysout
           display "$C=" function extract-date-time 
               (plain-timestamp "$C") upon sysout
           display "$N=" function extract-date-time 
               (plain-timestamp "$N") upon sysout
           display "$m=" function extract-date-time 
               (plain-timestamp "$m") upon sysout
           display "$u=" function extract-date-time 
               (plain-timestamp "$u") upon sysout
           display "$W=" function extract-date-time 
               (plain-timestamp "$W") upon sysout
           display "$d=" function extract-date-time 
               (plain-timestamp "$d") upon sysout
           display "$j=" function extract-date-time 
               (plain-timestamp "$j") upon sysout
           display "$w=" function extract-date-time 
               (plain-timestamp "$w") upon sysout
           display "$U=" function extract-date-time 
               (plain-timestamp "$U") upon sysout
           display "$A=" function extract-date-time 
               (plain-timestamp "$A") upon sysout
           display "$I=" function extract-date-time 
               (plain-timestamp "$I") upon sysout
           display "$H=" function extract-date-time 
               (plain-timestamp "$H") upon sysout
           display "$M=" function extract-date-time 
               (plain-timestamp "$M") upon sysout
           display "$S=" function extract-date-time 
               (plain-timestamp "$S") upon sysout
           display "$s=" function extract-date-time 
               (plain-timestamp "$s") upon sysout
           display "$z=" function extract-date-time 
               (plain-timestamp "$z") upon sysout
           display "$Z=" function extract-date-time 
               (plain-timestamp "$Z") upon sysout
           display "$n=" function extract-date-time 
               (plain-timestamp "$n") upon sysout
           .
       	   
       EXTRACT-DATE-TIME-NAMS.
       
           display "" upon sysout
           display "EXTRACT-DATE-TIME (name short):" upon sysout
           display "" upon sysout
           
           display "*l=" function extract-date-time 
               (plain-timestamp "*l") upon sysout
           display "*e=" function extract-date-time 
               (plain-timestamp "*e") upon sysout
           display "*Y=" function extract-date-time 
               (plain-timestamp "*Y") upon sysout
           display "*y=" function extract-date-time 
               (plain-timestamp "*y") upon sysout
           display "*c=" function extract-date-time 
               (plain-timestamp "*c") upon sysout
           display "*C=" function extract-date-time 
               (plain-timestamp "*C") upon sysout
           display "*N=" function extract-date-time 
               (plain-timestamp "*N") upon sysout
           display "*m=" function extract-date-time 
               (plain-timestamp "*m") upon sysout
           display "*u=" function extract-date-time 
               (plain-timestamp "*u") upon sysout
           display "*W=" function extract-date-time 
               (plain-timestamp "*W") upon sysout
           display "*d=" function extract-date-time 
               (plain-timestamp "*d") upon sysout
           display "*j=" function extract-date-time 
               (plain-timestamp "*j") upon sysout
           display "*w=" function extract-date-time 
               (plain-timestamp "*w") upon sysout
           display "*U=" function extract-date-time 
               (plain-timestamp "*U") upon sysout
           display "*A=" function extract-date-time 
               (plain-timestamp "*A") upon sysout
           display "*I=" function extract-date-time 
               (plain-timestamp "*I") upon sysout
           display "*H=" function extract-date-time 
               (plain-timestamp "*H") upon sysout
           display "*M=" function extract-date-time 
               (plain-timestamp "*M") upon sysout
           display "*S=" function extract-date-time 
               (plain-timestamp "*S") upon sysout
           display "*s=" function extract-date-time 
               (plain-timestamp "*s") upon sysout
           display "*z=" function extract-date-time 
               (plain-timestamp "*z") upon sysout
           display "*Z=" function extract-date-time 
               (plain-timestamp "*Z") upon sysout
           display "*n=" function extract-date-time 
               (plain-timestamp "*n") upon sysout
           .
           
       FIND-DURATION.
       
           display "" upon sysout
           display "FIND-DURATION:" upon sysout
           display "" upon sysout
           
           display "arg1: " plain-timestamp upon sysout
           display "arg2: " other-timestamp upon sysout
           
           display "years: " function find-duration
               (
                   plain-timestamp other-timestamp years
               ) 
               upon sysout
           display "months: " function find-duration
               (
                   plain-timestamp other-timestamp months
               ) 
               upon sysout
           display "days: " function find-duration
               (
                   plain-timestamp other-timestamp days
               ) 
               upon sysout
           display "hours: " function find-duration
               (
                   plain-timestamp other-timestamp hours
               ) 
               upon sysout
           display "minutes: " function find-duration
               (
                   plain-timestamp other-timestamp minutes
               ) 
               upon sysout
           display "seconds: " function find-duration
               (
                   plain-timestamp other-timestamp seconds
               ) 
               upon sysout
           display "microseconds: " function find-duration
               (
                   plain-timestamp other-timestamp microseconds
               ) 
               upon sysout
           .	      
           
       TEST-DATE-TIME.
       
           display "" upon sysout
           display "TEST-DATE-TIME:" upon sysout
           display "" upon sysout
           
           display function test-date-time
               (plain-timestamp)
               upon sysout
           display function test-date-time
               (plain-timestamp timestamp)
               upon sysout
           display function test-date-time
               (plain-timestamp timestamp "@Y-%m-%d-%H.%M.%S.@Sm")
               upon sysout
           display function test-date-time
               (plain-timestamp timestamp locale)
               upon sysout
               .
               
           display function test-date-time
               (plain-time)
               upon sysout
           display function test-date-time
               (plain-time time)
               upon sysout
           display function test-date-time
               (plain-time time locale)
               upon sysout
           display function test-date-time
               (plain-time time "%H:%M:%S")
               upon sysout
               .
               
           display function test-date-time
               (plain-date)
               upon sysout
           display function test-date-time
               (plain-date date)
               upon sysout
           display function test-date-time
               (plain-date date locale)
               upon sysout
           display function test-date-time
               (plain-date date "@Y-%m-%d")
               upon sysout
               .
               
       CONVERT-DATE-TIME-AS400.
       
           display "" upon sysout
           display "CONVERT-DATE-TIME (AS/400 strings):" upon sysout
           display "" upon sysout
           
           display "plain-timestamp=" plain-timestamp upon sysout
           
           display "@C=" function convert-date-time 
               ("0" timestamp "@C") upon sysout
           display "@p=" function convert-date-time 
               ("PM" timestamp "@p") upon sysout
           display "@Sh=" function convert-date-time 
               ("12" timestamp "@Sh") upon sysout
           display "@Sm=" function convert-date-time 
               ("123456" timestamp "@Sm") upon sysout
           display "@So=" function convert-date-time 
               ("123" timestamp "@So") upon sysout
           display "@St=" function convert-date-time 
               ("1" timestamp "@St") upon sysout
           display "@Y=" function convert-date-time 
               ("1972" timestamp "@Y") upon sysout
               
           display "%d=" function convert-date-time 
               ("06" timestamp "%d") upon sysout
           display "%D=" function convert-date-time 
               ("08/06/72" timestamp "%D") upon sysout
           display "%H=" function convert-date-time 
               ("12" timestamp "%H") upon sysout
           display "%I=" function convert-date-time 
               ("12" timestamp "%I") upon sysout
           display "%j=" function convert-date-time 
               ("219" timestamp "%j") upon sysout
           display "%m=" function convert-date-time 
               ("08" timestamp "%m") upon sysout
           display "%M=" function convert-date-time 
               ("34" timestamp "%M") upon sysout
           display "%p=" function convert-date-time 
               ("PM" timestamp "%p") upon sysout
           display "%r=" function convert-date-time 
               ("12:34:56 PM" timestamp "%r") upon sysout
           display "%R=" function convert-date-time 
               ("12:34" timestamp "%R") upon sysout
           display "%S=" function convert-date-time 
               ("56" timestamp "%S") upon sysout
           display "%y=" function convert-date-time 
               ("72" timestamp "%y") upon sysout
           display "%Y=" function convert-date-time 
               ("1972" timestamp "%Y") upon sysout
           .
      
      *	#	INTU
      * &	INTF
      *	!	EXTF
      *	^	EXTU
      *	$	NAML
      *	*	NAMS
      *	`	BINM
      *	~	BINL
         
       CONVERT-DATE-TIME-INTF.
       
           display "" upon sysout
           display "CONVERT-DATE-TIME (internal format):" upon sysout
           display "" upon sysout
           
           display "&l=" function convert-date-time 
               ("1" timestamp "&l") upon sysout
           display "&e=" function convert-date-time 
               ("1" timestamp "&e") upon sysout
           display "&Y=" function convert-date-time 
               ("1972" timestamp "&Y") upon sysout
           display "&y=" function convert-date-time 
               ("72" timestamp "&y") upon sysout
           display "&c=" function convert-date-time 
               ("19" timestamp "&c") upon sysout
           display "&C=" function convert-date-time 
               ("0" timestamp "&C") upon sysout
           display "&N=" function convert-date-time 
               ("1" timestamp "&N") upon sysout
           display "&m=" function convert-date-time 
               ("07" timestamp "&m") upon sysout
           display "&u=" function convert-date-time 
               ("33" timestamp "&u") upon sysout
           display "&W=" function convert-date-time 
               ("2" timestamp "&W") upon sysout
           display "&d=" function convert-date-time 
               ("06" timestamp "&d") upon sysout
           display "&j=" function convert-date-time 
               ("219" timestamp "&j") upon sysout
           display "&w=" function convert-date-time 
               ("1" timestamp "&w") upon sysout
           display "&U=" function convert-date-time 
               ("1" timestamp "&U") upon sysout
           display "&A=" function convert-date-time 
               ("1" timestamp "&A") upon sysout
           display "&I=" function convert-date-time 
               ("12" timestamp "&I") upon sysout
           display "&H=" function convert-date-time 
               ("12" timestamp "&H") upon sysout
           display "&M=" function convert-date-time 
               ("34" timestamp "&M") upon sysout
           display "&S=" function convert-date-time 
               ("56" timestamp "&S") upon sysout
           display "&s=" function convert-date-time 
               ("123" timestamp "&s") upon sysout
           display "&z=" function convert-date-time 
               ("-2880000" timestamp "&z") upon sysout
           display "&Z=" function convert-date-time 
               ("03600000" timestamp "&Z") upon sysout
           display "&n=" function convert-date-time 
               ("123456000" timestamp "&n") upon sysout
           .
       	   
       CONVERT-DATE-TIME-EXTF.
       
           display "" upon sysout
           display "CONVERT-DATE-TIME (external format):" upon sysout
           display "" upon sysout
           
           display "!l=" function convert-date-time 
               ("1" timestamp "!l") upon sysout
           display "!e=" function convert-date-time 
               ("1" timestamp "!e") upon sysout
           display "!Y=" function convert-date-time 
               ("1972" timestamp "!Y") upon sysout
           display "!y=" function convert-date-time 
               ("72" timestamp "!y") upon sysout
           display "!c=" function convert-date-time 
               ("19" timestamp "!c") upon sysout
           display "!C=" function convert-date-time 
               ("0" timestamp "!C") upon sysout
           display "!N=" function convert-date-time 
               ("1" timestamp "!N") upon sysout
           display "!m=" function convert-date-time 
               ("08" timestamp "!m") upon sysout
           display "!u=" function convert-date-time 
               ("33" timestamp "!u") upon sysout
           display "!W=" function convert-date-time 
               ("2" timestamp "!W") upon sysout
           display "!d=" function convert-date-time 
               ("06" timestamp "!d") upon sysout
           display "!j=" function convert-date-time 
               ("219" timestamp "!j") upon sysout
           display "!w=" function convert-date-time 
               ("1" timestamp "!w") upon sysout
           display "!U=" function convert-date-time 
               ("1" timestamp "!U") upon sysout
           display "!A=" function convert-date-time 
               ("1" timestamp "!A") upon sysout
           display "!I=" function convert-date-time 
               ("12" timestamp "!I") upon sysout
           display "!H=" function convert-date-time 
               ("12" timestamp "!H") upon sysout
           display "!M=" function convert-date-time 
               ("34" timestamp "!M") upon sysout
           display "!S=" function convert-date-time 
               ("56" timestamp "!S") upon sysout
           display "!s=" function convert-date-time 
               ("123" timestamp "!s") upon sysout
           display "!z=" function convert-date-time 
               ("-2880000" timestamp "!z") upon sysout
           display "!Z=" function convert-date-time 
               ("03600000" timestamp "!Z") upon sysout
           display "!n=" function convert-date-time 
               ("123456000" timestamp "!n") upon sysout
           .
       	   
       CONVERT-DATE-TIME-NAML.
       
           display "" upon sysout
           display "CONVERT-DATE-TIME (name long):" upon sysout
           display "" upon sysout
           
           display "$l=" function convert-date-time 
               ("LEAP YEAR" timestamp "$l") upon sysout
           display "$e=" function convert-date-time 
               ("CE" timestamp "$e") upon sysout
           display "$Y=" function convert-date-time 
               ("1972" timestamp "$Y") upon sysout
           display "$y=" function convert-date-time 
               ("72" timestamp "$y") upon sysout
           display "$c=" function convert-date-time 
               ("19" timestamp "$c") upon sysout
           display "$C=" function convert-date-time 
               ("0" timestamp "$C") upon sysout
           display "$N=" function convert-date-time 
               ("1" timestamp "$N") upon sysout
           display "$m=" function convert-date-time 
               ("August" timestamp "$m") upon sysout
           display "$u=" function convert-date-time 
               ("33" timestamp "$u") upon sysout
           display "$W=" function convert-date-time 
               ("2" timestamp "$W") upon sysout
           display "$d=" function convert-date-time 
               ("06" timestamp "$d") upon sysout
           display "$j=" function convert-date-time 
               ("219" timestamp "$j") upon sysout
           display "$w=" function convert-date-time 
               ("Sunday" timestamp "$w") upon sysout
           display "$U=" function convert-date-time 
               ("1" timestamp "$U") upon sysout
           display "$A=" function convert-date-time 
               ("PM" timestamp "$A") upon sysout
           display "$I=" function convert-date-time 
               ("12" timestamp "$I") upon sysout
           display "$H=" function convert-date-time 
               ("12" timestamp "$H") upon sysout
           display "$M=" function convert-date-time 
               ("34" timestamp "$M") upon sysout
           display "$S=" function convert-date-time 
               ("56" timestamp "$S") upon sysout
           display "$s=" function convert-date-time 
               ("123" timestamp "$s") upon sysout
           display "$z=" function convert-date-time 
               ("-08:00" timestamp "$z") upon sysout
           display "$Z=" function convert-date-time 
               ("+01:00" timestamp "$Z") upon sysout
           display "$n=" function convert-date-time 
               ("123456000" timestamp "$n") upon sysout
           .
       	   
       CONVERT-DATE-TIME-NAMS.
       
           display "" upon sysout
           display "CONVERT-DATE-TIME (name short):" upon sysout
           display "" upon sysout
           
           display "*l=" function convert-date-time 
               ("L" timestamp "*l") upon sysout
           display "*e=" function convert-date-time 
               ("AD" timestamp "*e") upon sysout
           display "*Y=" function convert-date-time 
               ("1972" timestamp "*Y") upon sysout
           display "*y=" function convert-date-time 
               ("72" timestamp "*y") upon sysout
           display "*c=" function convert-date-time 
               ("19" timestamp "*c") upon sysout
           display "*C=" function convert-date-time 
               ("0" timestamp "*C") upon sysout
           display "*N=" function convert-date-time 
               ("1" timestamp "*N") upon sysout
           display "*m=" function convert-date-time 
               ("Aug" timestamp "*m") upon sysout
           display "*u=" function convert-date-time 
               ("33" timestamp "*u") upon sysout
           display "*W=" function convert-date-time 
               ("2" timestamp "*W") upon sysout
           display "*d=" function convert-date-time 
               ("06" timestamp "*d") upon sysout
           display "*j=" function convert-date-time 
               ("219" timestamp "*j") upon sysout
           display "*w=" function convert-date-time 
               ("Sun" timestamp "*w") upon sysout
           display "*U=" function convert-date-time 
               ("1" timestamp "*U") upon sysout
           display "*A=" function convert-date-time 
               ("PM" timestamp "*A") upon sysout
           display "*I=" function convert-date-time 
               ("12" timestamp "*I") upon sysout
           display "*H=" function convert-date-time 
               ("12" timestamp "*H") upon sysout
           display "*M=" function convert-date-time 
               ("34" timestamp "*M") upon sysout
           display "*S=" function convert-date-time 
               ("56" timestamp "*S") upon sysout
           display "*s=" function convert-date-time 
               ("123" timestamp "*s") upon sysout
           display "*z=" function convert-date-time 
               ("-08:00" timestamp "*z") upon sysout
           display "*Z=" function convert-date-time 
               ("+01:00" timestamp "*Z") upon sysout
           display "*n=" function convert-date-time 
               ("123456000" timestamp "*n") upon sysout
           .
           
           
       DAYOFWEEK.
        
      * The days of the week are numbered 1 through 7 then repeat.
      	
           display "" upon sysout
           display "Day Of Week:" upon sysout
           
           move "2001-05-13" to plain-date
           display "day of week for " plain-date " is " 
               function extract-date-time (plain-date "!w") upon sysout
           move "2001-05-14" to plain-date
           display "day of week for " plain-date " is " 
               function extract-date-time (plain-date "!w") upon sysout
           move "2001-05-15" to plain-date
           display "day of week for " plain-date " is " 
               function extract-date-time (plain-date "!w") upon sysout
           move "2001-05-16" to plain-date
           display "day of week for " plain-date " is " 
               function extract-date-time (plain-date "!w") upon sysout
           move "2001-05-17" to plain-date
           display "day of week for " plain-date " is " 
               function extract-date-time (plain-date "!w") upon sysout
           move "2001-05-18" to plain-date
           display "day of week for " plain-date " is " 
               function extract-date-time (plain-date "!w") upon sysout
           move "2001-05-19" to plain-date
           display "day of week for " plain-date " is " 
               function extract-date-time (plain-date "!w") upon sysout
           move "2001-05-20" to plain-date
           display "day of week for " plain-date " is " 
               function extract-date-time (plain-date "!w") upon sysout
           .
