* GreeterEJB

IDENTIFICATION DIVISION.
CLASS-ID. "samples.hellocobol.ejb.GreeterEJB" INHERITS OBJECT IMPLEMENTS "javax.ejb.SessionBean".

****
METHOD-ID. "getGreeting" THROWS "java.rmi.RemoteException".
DATA DIVISION.
WORKING-STORAGE SECTION.

01 THE-TIME.
  05 THE-HOUR PIC 99.
  05 THE-MIN PIC 99.
  05 THE-SEC PIC 99.
  05 THE-CENTI PIC 99.

LINKAGE SECTION.
    77 result PIC X(80).
PROCEDURE DIVISION GIVING result.
MAIN-PARAGRAPH.

    ACCEPT THE-TIME FROM TIME
    
    EVALUATE THE-HOUR
      WHEN 6 WHEN 7 MOVE "Early Morning of Cobol" TO result
      WHEN 8 WHEN 9 MOVE "Morning of Cobol" TO result
      WHEN 10 WHEN 11 MOVE "Late Morning of Cobol" TO result
      WHEN 12 WHEN 13 MOVE "Noon of Cobol" TO result
      WHEN 14 WHEN 15 MOVE "Early Afternoon of Cobol" TO result
      WHEN 16 WHEN 17 MOVE "Afternoon of Cobol" TO result
      WHEN 18 WHEN 19 MOVE "Late Afternoon of Cobol" TO result
      WHEN 20 WHEN 21 WHEN 22 WHEN 23 MOVE "Evening of Cobol" TO result
      WHEN OTHER MOVE "Late Night of Cobol" TO result
    END-EVALUATE
    .
END-METHOD.
****

* Many EJB's can just copy the remaining code into their code.
*
* All remaining methods in this class are structural methods,
* necessary not for the business logic but rather for the EJB
* Container to be able to control this bean.
*
* Add in some DISPLAY UPON SYSOUT's to the procedure division
* of the methods in order to gain some feel over when these
* methods are called.
*
* We are given the session context, but we don't need it in this
* program so we ignore it.  This method is required to fulfill
* the interface of javax.ejb.SessionBean.
*

METHOD-ID. "setSessionContext".
DATA DIVISION.
LINKAGE SECTION.
    01 sc OBJECT REFERENCE "javax.ejb.SessionContext".

PROCEDURE DIVISION USING BY VALUE sc.
END-METHOD.

* The following methods are required to fulfill the interface
* of javax.ejb.SessionBean.  We don't need to do anything special,
* though, so we just create the method without a body.  When
* the method has no parameters and no result, this is the barest
* possible method definition.

METHOD-ID. "ejbCreate" THROWS "java.rmi.RemoteException", "javax.ejb.CreateException". END-METHOD.
METHOD-ID. "ejbRemove". END-METHOD.
METHOD-ID. "ejbActivate". END-METHOD.
METHOD-ID. "ejbPassivate". END-METHOD.

END-CLASS.
