//
// CallBean
//
// Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
//
// This file and associated files are copyrighted information
// of Heirloom Computing.  Permission is granted for usage in 
// conjunction with the Elastic COBOL product.
//
// Call a COBOL program, using getters and setters for information
// passing between COBOL and Java.

public class CallBean
{
	public static void main(String args[])
	{
		// Construct a Cobol instance before calling it;
		// this same Cobol instance may be used multiple
		// times, just as a Cobol program may be called
		// from Cobol multiple times.  The WORKING-STORAGE
		// will remain from one call to another.  If
		// another instance is created, then an additional
		// WORKING-STORAGE will be created (but not
		// an additional SHARED-STORAGE).  This feature
		// allows multiple instances of a Cobol program
		// designed to run as separate processes to run
		// as separate Java instances; this allows different
		// Java threads to control different instances.
		// This is the Elastic COBOL session capability.
		
		System.out.println("Creating CobolBean...");
		getset instance=new getset();
		System.out.println("Created.");
		
		instance.setMyText("Hello");
		instance.setMyNumber("100.00");
		instance.call();
		System.out.println("From Java, getMyOutput()="+instance.getMyOutput());
		System.out.println("From Java, getMyText()  ="+instance.getMyText());
		
		// Call using BigDecimal this time; all get-sets support
		// String wherever possible for ease of use, but numerics
		// generally support an additional Java numeric type
		// as well.  See the Language Reference under Data Division
		// for GET-PROPERTY and SET-PROPERTY for more information.
		
		instance.setMyText("Again");
		instance.setMyNumber(new java.math.BigDecimal(32));
		instance.call();
		System.out.println("From Java, getMyOutput()="+instance.getMyOutput());
		System.out.println("From Java, getMyText()  ="+instance.getMyText());
	}
}

