* Presidents
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information of
* Heirloom Computing.  Permission is granted for usage in conjunction
* with the Elastic COBOL product.
*
* This program is graphical front-end for a simple indexed file.
*
* Some persons are already included.  A photo is shown, where the
* filename is the identification number followed by .jpg, as in 01.jpg.
* Click Next and Previous to scroll through by identification number.
* Click Clear to clear the fields.  Click Add to add the currently
* visible record if new; click Update to update and existing record.
*
* As this is a demonstration program, the file-status is displayed
* on sysout during some operations.
*
id division.
program-id. presidents.

environment division.
input-output section.
file-control.
    select optional president-file 
    assign to "president" 
    organization is indexed
    access mode is dynamic
    record key is id-file
    file status is file-status
    .

data division.

file section.

fd president-file.
01 president-record-file.
  05 id-file      pic x(12).
  05 name-file    pic x(20).
  05 term-file    pic x(20).
  05 party-file   pic x(20).
  05 state-file   pic x(2).
  05 DOB-file.
     07 b-month-f pic x(02).
     07 b-day-f   pic x(02).
     07 b-year-f  pic x(04).
  05 DOD-file.
     07 d-month-d pic x(02).
     07 d-day-d   pic x(02).
     07 d-year-d  pic x(04).  
  05 spouse-file  pic x(12).
  05 comment-file pic x(40).

working-storage section.

01 president-record.
  05 id-data      pic x(12) value "00".
  05 name-data    pic x(20).
  05 term-data    pic x(20).
  05 party-data   pic x(20).
  05 state-data   pic x(2) value "DC". | default to Washington, DC
   
  05 DOB-data.
     07 b-month-d pic x(02).
     07 b-day-d   pic x(02).
     07 b-year-d  pic x(04).
  05 DOD-data.
     07 d-month-d pic x(02).
     07 d-day-d   pic x(02).
     07 d-year-d  pic x(04).
  05 spouse-data  pic x(12). 
  05 comment-data pic x(40).  

77 photo-name     pic x(16) value "00.jpg".

77 file-status    pic xx value spaces.

77 key-input is special-names crt status pic 9(4) value 0.

* These numbers are arbitrary; they just must match the termination
* value given for the graphical component.  They may be high numbers,
* such as 1000, to avoid function key overlap.

  88 search-button-pushed value 20.
  88 back-button-pushed value 21.
  88 next-button-pushed value 22.
  88 delete-button-pushed value 23.
  88 exit-button-pushed value 24.
  88 clear-button-pushed value 26.
  88 about-button-pushed value 27.
  88 update-button-pushed value 28.

screen section.

01 main-screen.

    05 the-menu menu title "Main Menu".
    
    05 id-label label "Id #" line 3 column 3 transparent.
    05 id-field entry-field using id-data column 14 size 12.
    05 search-button push-button "Search" column plus 3 default-button
       termination-value=20 auto.
    05 name-label label "Name:" line plus 1.5 column 3 transparent.
    05 name-field entry-field using name-data column 14 size 20 auto.
    
    05 term-label label "Term" line plus 1.5 column 3 transparent.
    05 term-field entry-field using term-data column 14 size 20 auto.
    
    05 party-label label "Party" line plus 1.5 column 3 transparent.
    05 party-field entry-field using party-data column 14 size 20 auto.
    
    05 st-label label "State" line plus 1.5 column 3 transparent.
    05 st-field combo-box using state-data column 14 size 4
       drop-list.
    
    05 spouse-label label "Spouse" line plus 1.5 column 3 transparent.
    05 spouse-field entry-field using spouse-data column 14 size 10 auto.
    
    05 DOB-label label "Date of Birth" line plus 1.5 column 3 transparent.
    05 DOB-field entry-field mask-value "##/##/####" using DOB-data 
       column 14 size 14 auto.
       
    05 DOD-label label "Data of Death" line plus 1.5 column 3 transparent.
    05 DOD-field entry-field mask-value "##/##/####" using DOD-data 
       column 14 size 14 auto.  
    
    05 comment-label label "Comments" column 3 line plus 1.5 transparent.
    05 comment-field entry-field using comment-data 
       column 14 lines 2 size 40.
    
    05 photo-image bitmap line 3 column 42 lines 137 size 108
        bitmap-value photo-name.
    05 photo-label label "Presidental Picture" font-name = "Serif-18" transparent 
       column 40 line 1.6 foreground-color 1.
       
    05 back-button push-button   "Previous" line 19 column 13
       termination-value=21.
    05 next-button push-button   "Next" column plus 2
       termination-value=22.
    05 update-button push-button "Update" column plus 2
       termination-value=28.
    05 delete-button push-button "Delete" column plus 2
       termination-value=23.
    05 clear-button push-button  "Clear" column plus 2
       termination-value=26.
    
procedure division.
main-paragraph.

    open i-o president-file

    perform setup-screen
    .

*
* This loop displays and accepts the screen until the exit menu item
* is pressed.
*
    
display-loop.

    perform until exit-button-pushed
    
        display main-screen
        accept main-screen

* Update the key from the graphical screen so the READ verbs will work.
	
	move id-data to id-file
	
	evaluate true
	
	    when search-button-pushed perform do-search
	    when back-button-pushed perform do-back
	    when next-button-pushed perform do-next
	    when delete-button-pushed perform do-delete
	    when clear-button-pushed perform do-clear
	    when about-button-pushed perform do-about
	    when update-button-pushed perform do-update
	
	end-evaluate
	
    end-perform
    
    display "Exit..." upon sysout
    
    close president-file
    stop all run
    .

do-search.
    display "Search..." upon sysout
    read    president-file
    perform update-from-file
    .
    
do-back.
    display "Previous..." upon sysout
    read    president-file previous record
    at end
        display message box "No previous record"
    end-read
    perform update-from-file
    .
    
do-next.
    display "Next..." upon sysout
    read    president-file next record
    at end
        display message box "No next record"
    end-read
    perform update-from-file
    .
    
do-delete.
    display "Delete..." upon sysout
    move    president-record to president-record-file
    read    president-file
    display " FS: " file-status upon sysout
    delete  president-file
    display " FS: " file-status upon sysout
    perform update-from-file
    .

do-update.
    display "Update..." upon sysout
    move    president-record to president-record-file
    read    president-file
    display " FS: " file-status upon sysout
    move    president-record to president-record-file
    if file-status < 10 then
        rewrite president-record-file
    else
        write president-record-file
    end-if
    display " FS: " file-status upon sysout
    .
    
do-clear.
    initialize president-record
    .    
    
do-about.

    display message box
           "Elastic COBOL Presidents Sample, "
           "(C) Heirloom Computing Inc."
    .

*
* setup-screen is done only once.  It creates the window, and does
* the property modifications that should be done only once.
*

setup-screen.

    display standard window lines 20 size 60 
            title "Elastic COBOL Presidents Sample"
	    background-image-scaled="wm.jpg"

* Create the main menu; the termination-values are for each menu item
* individually.
    
    modify the-menu
        begin-menu = "&File"
	    item-to-add = "E&xit" termination-value = 24
	end-menu
        begin-menu = "&Help"
	    item-to-add = "&About" termination-value = 27
	end-menu
	.	

* Add all the U.S. Postal Codes to the state list.  The mass-update
* prevents the screen from refreshing during the add process.
	
    modify st-field mass-update = 1
      item-to-add = (
      "AL", "AK", "AS", "AZ", "AR",
      "CA", "CO", "CT", "DE", "DC",
      "FM", "FL", "GA", "GU", "HI",
      "ID", "IL", "IN", "IA", "KS",
      "KY", "LA", "ME", "MH", "MD",
      "MA", "MI", "MN", "MS", "MO",
      "MT", "NE", "NV", "NH", "NJ",
      "NM", "NY", "NC", "ND", "MP",
      "OH", "OK", "OR", "PW", "PA",
      "PR", "RI", "SC", "SD", "TN",
      "TX", "UT", "VT", "VI", "VA",
      "WA", "WV", "WI", "WY",
      
      "AE", "AA", "AP", | armed forces
    )
    mass-update = 0
    .

* Update from the record to the screen.  Display a photo if one is available.

update-from-file.
    move president-record-file to president-record
    string id-data ".jpg" delimited by spaces into photo-name
    display "    Photo filename: " photo-name upon sysout
    .  
