      *
      * SCREENS
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product.
      *
      * This example shows input/output using the screen section.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. SCREENS.
      
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
           CRT STATUS IS crt-name
           CURSOR IS cursor-name.
      
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01 cursor-name.
           05 linenum pic 99.
           05 colnum pic 99.
       01 crt-name.
           05 crt-key1 pic x.
           05 crt-key2 pic x.
       01 NAME1 PIC X(25) VALUE SPACES.
       01 ADDR1 PIC X(35) VALUE SPACES.
       01 CITY1 PIC X(25) VALUE SPACES.
       01 STATE1 PIC X(2) VALUE SPACES.
       01 ZIP1 PIC X(10) VALUE SPACES.
       01 TELE1 PIC X(18) VALUE SPACES.
       01 PASS1 PIC X(8) VALUE SPACES.
       01 MYDATA PIC X(18) VALUE SPACES.
       
       SCREEN SECTION.
       01 ALPHA AUTO BACKGROUND-COLOR IS 0 
           FOREGROUND-COLOR IS 2 BLANK SCREEN.
           05 NAMEPERSON LINE 5 COLUMN 5 VALUE "NAME:". 
           05 NAMEFIELD COLUMN PLUS 1 UNDERLINE 
              BACKGROUND-COLOR IS 2 FOREGROUND-COLOR IS 0
              PIC X(25) USING NAME1.
           05 ADDR LINE 7 COLUMN 2 VALUE "ADDRESS:".
           05 ADDRESSFIELD COLUMN PLUS 1 UNDERLINE 
              BACKGROUND-COLOR IS 2 FOREGROUND-COLOR IS 0
              PIC X(35) USING ADDR1.
           05 CITY LINE 9 COLUMN 5 VALUE "CITY:" ERASE EOS.
           05 CITYFIELD COLUMN PLUS 1 UNDERLINE 
              BACKGROUND-COLOR IS 2 FOREGROUND-COLOR IS 0
              PIC X(25) USING CITY1. 
           05 STATE COLUMN PLUS 4 PIC X(6) VALUE "STATE:".
           05 STATEFIELD COLUMN PLUS 1 REQUIRED UNDERLINE 
              FULL BACKGROUND-COLOR IS 2 FOREGROUND-COLOR IS 0
              PIC X(2) USING STATE1.
           05 ZIP LINE 11 COLUMN 1 VALUE "ZIP CODE:".
           05 ZIPFIELD COLUMN PLUS 1 BACKGROUND-COLOR IS 2
              UNDERLINE FOREGROUND-COLOR IS 0 PIC X(10) USING ZIP1.
           05 TELEPHONE LINE 13 COLUMN 6 VALUE "TEL:".
           05 TELFIELD COLUMN PLUS 1 UNDERLINE
              BACKGROUND-COLOR IS 2 FOREGROUND-COLOR IS 0
              PIC X(18) USING MYDATA.
           05 PASSWD LINE 15 COLUMN 1 VALUE "PASSWORD:".
           05 PASSFIELD COLUMN PLUS 1 UNDERLINE 
              BACKGROUND-COLOR IS 2 FOREGROUND-COLOR IS 0
              SECURE REQUIRED PIC X(8) USING PASS1.
      
       PROCEDURE DIVISION.
       MAIN-PARAGRAPH.
           DISPLAY ALPHA UPON CONSOLE AT LINE 1 COLUMN 10
           ACCEPT ALPHA FROM CONSOLE AT LINE 1 COLUMN 10
           DISPLAY NAME1 AT LINE 18 COLUMN 10
           DISPLAY ADDR1 AT LINE 19 COLUMN 10
           DISPLAY CITY1 AT LINE 20 COLUMN 10
           DISPLAY STATE1 AT LINE 21 COLUMN 10
           DISPLAY ZIP1 AT LINE 21 COLUMN 13
           DISPLAY MYDATA AT LINE 22 COLUMN 10 
           DISPLAY "ENTER TO EXIT PROGRAM" AT LINE 24 COLUMN 10
           ACCEPT MYDATA
           DISPLAY SPACES WITH BLANK SCREEN
           DISPLAY "PROGRAM TERMINATED" AT 0101
           EXIT PROGRAM
           STOP RUN
           .
