*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in 
* conjunction with the Elastic COBOL product.
*
* This sample shows the usage of host arrays in E-SQL.  The contents
* of the arrays after the select into statements are displayed to
* sysout.
*

IDENTIFICATION DIVISION.
PROGRAM-ID. SQLHostArray. 

ENVIRONMENT DIVISION.
INPUT-OUTPUT SECTION.
DATA DIVISION.


WORKING-STORAGE SECTION.

        EXEC SQL BEGIN DECLARE SECTION END-EXEC
           77 aempno       PIC 9(4) OCCURS 5.
           77 aename       PIC X(10) OCCURS 5.
           77 ajob         PIC X(9) OCCURS 5.
        EXEC SQL END DECLARE SECTION END-EXEC.
 
        EXEC SQL BEGIN DECLARE SECTION END-EXEC
        01 LINE-ARRAY.
           05 haempno       PIC 9(4) OCCURS 5.
           05 haename       PIC X(10) OCCURS 5.
           05 hajob         PIC X(9) OCCURS 5.
             
         EXEC SQL END DECLARE SECTION END-EXEC.
         EXEC SQL INCLUDE SQLCA END-EXEC.
******************************************************************
*	       P R O C E D U R E    D I V I S I O N		 *
******************************************************************

PROCEDURE DIVISION.
MAIN SECTION 01.
BEGIN.
      
     EXEC SQL CONNECT TO 
                 'jdbc:oracle:thin:@127.0.0.1:1521:dev'
             USER 'scott'
             PASSWORD 'tiger'
             DRIVER 'oracle.jdbc.OracleDriver'
     END-EXEC.      
      
     IF SQLCODE NOT = 0 
             DISPLAY "FAILED TO CONNECT TO DATABASE " SQLCODE " " SQLERRM
             UPON SYSERR
             GO TO FIN.

     EXEC SQL 
        select empno, ename, job
        into :aempno, :aename, :ajob
        from emp
        where rownum < 5
     END-EXEC.   
     
     EXEC SQL 
        select empno, ename, job
        into :haempno, :haename, :hajob
        from emp
        where rownum < 5
     END-EXEC.   
           
 
       
     DISPLAY SPACE upon sysout.
     DISPLAY "content of arrays:" upon sysout.
     DISPLAY aempno(1), space, aename(1), ajob(1) upon sysout.
     DISPLAY aempno(2), space, aename(2), ajob(2) upon sysout. 
     DISPLAY aempno(3), space, aename(3), ajob(3) upon sysout.
     DISPLAY aempno(4), space, aename(4), ajob(4) upon sysout.
     DISPLAY space upon sysout.
         
     DISPLAY "content of line arrays:" upon sysout.        
     DISPLAY haempno(1), space, haename(1), hajob(1) upon sysout.
     DISPLAY haempno(2), space, haename(2), hajob(2) upon sysout. 
     DISPLAY haempno(3), space, haename(3), hajob(3) upon sysout.
     DISPLAY haempno(4), space, haename(4), hajob(4) upon sysout.
     DISPLAY space upon sysout.
               
     DISPLAY "End of Program." upon sysout.
  
 FIN.
     stop run.
