*
* guiscreen9
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in
* conjunction with the Elastic COBOL product.
*
id division.
program-id. guiscreen9.

data division.

working-storage section.

    77 title-data pic x(4) value "Mr.".
    77 name-data pic x(20) value spaces.
    77 addr-data pic x(20) value spaces.
    77 city-data pic x(20) value spaces.
    77 state-data pic x(2) value "CA".
    77 zip-data pic 9(5) value spaces.
    77 sex-data pic x value "M".
    77 cust-data pic x value "Y".
    77 sport-data pic 9 value "1".
    
    77 sport-item pic x(9).

* Placing a value in this gives the combo-box a default value.

    77 sex-item pic x(6) value "Male".
    77 cust-item pic 9.

* This is used to check if a menu key was pressed; normally,
* it will be 13 (return).

    77 check-menu pic 999 value 0 is special-names crt status.
    
screen section.
01 main-screen.

* Add a menu to the screen that allows the user to print or exit.
* The different menu items return different termination-values
* that may be checked after the accept is done.
*
* The ampersand (&) character sets the hotkey to the next character.
*

    05 menu
       begin-menu = "&File"
           item-to-add = "&Print" termination-value = 2
	   separator
	   item-to-add = "E&xit" termination-value = 4
       end-menu
       begin-menu = "&Help"
           item-to-add = "&About" termination-value = 6
       end-menu
       .
       
    05 label-title label "Title:" line 2 column 2.

* Make the title a combo-box, but allow additional titles to be
* entered (such as Herr).
    
    05 ask-title combo-box  line 2 column 10
        item-to-add = "Mr."
	item-to-add = "Mrs."
	item-to-add = "Miss"
	item-to-add = "Ms."
	item-to-add = "Dr."
	using title-data
	.
    
    05 label-name label "Name:" line 4 column 2.
    05 ask-name entry-field line 4 column 10 using name-data.
    
    05 label-addr label "Address:" line 6 column 2.
    05 ask-addr entry-field line 6 column 10 using addr-data.
    
    05 label-city label "City:" line 8 column 2.
    05 ask-city entry-field line 8 column 10 using city-data.
    
    05 label-state label "State:" line 10 column 2.
    05 ask-state entry-field line 10 column 10 using state-data.
    
    05 label-zip label "Zip:" line 10 column 17.
    05 ask-zip entry-field line 10 column 22 using zip-data.
    
    05 label-sex label "Sex:" line 12 column 2.

* Create a combo-box for sex instead of an entry-field to limit choices
* to only valid input.
* Set the combo-box to drop-list so no further data may be input.
    
    05 ask-sex combo-box drop-list line 12 column 10
        item-to-add = "Male"
	item-to-add = "Female"
	using sex-item
	.
    
* Get rid of (Y/N) portion of prompt as a checkbox is intuitively Y/N or T/F.
* The check-box's text is displayed as a prompt, so we can eliminate the
* label entirely.  The using item returns a 0 or 1 that we'll need to
* change into a Y/N for the older program logic.
    
    05 ask-cust check-box "Current Customer: " line 14 column 2
        using cust-item
	.
    
    05 label-sport label "Sports" line 16 column 2.
    
    05 list-sport list-box
        line 17.5 column 2 lines 3.5 size 20
        item-to-add = "Golf"
	item-to-add = "Bowling"
	item-to-add = "Hockey"
	using sport-item
	.

* Add an OK button that does the same as hitting the Return key

    05 push-button is ok-button
        line 19 column 23
	.

procedure division.
main-paragraph.

* Create an initial window by specifying it, rather than using default
* Trim the window further so there is only a reasonable amount of space,
* but leave some whitespace for flow.

    display standard window 
        title ="Gui Screen"
        size 30 lines 21
	foreground-color 0
	
    display main-screen
    
main-loop.    
    accept main-screen
    
    evaluate check-menu
        when 2 show window upon printer
	       go to main-loop
	when 4 stop all run
	when 6 display message box "Gui Screen from Text Screen"
	       go to main-loop
    end-evaluate
    
    move sport-item(1:1) to sport-data
    evaluate sport-item(1:1)
        when "G" move 1 to sport-data
	when "B" move 2 to sport-data
	when "H" move 3 to sport-data
    end-evaluate	
    
    move sex-item(1:1) to sex-data
    
    if cust-item = 1 then 
      move "Y" to cust-data
    else 
      move "N" to cust-data
    end-if
    
    perform display-data
    go to main-loop
    .
display-data.
    display "title: " title-data upon sysout
    display "name: " name-data upon sysout
    display "addr: " addr-data upon sysout
    display "city: " city-data upon sysout
    display "state: " state-data upon sysout
    display "zip: " zip-data upon sysout
    display "sex: " sex-data upon sysout
    display "cust: " cust-data upon sysout
    display "sport: " sport-data upon sysout
    .
    
