      *
      * WIN32BEEP
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in
      * conjunction with the Elastic COBOL product.
      *
      * WIN32BEEP is a Windows only program demonstrating the use
      * of native calls.  With the appropriate shared libraries,
      * other systems have similar usages.
      *
      * Native code should generally be used only when attempting to
      * access prior codebases, such as API functions, which are
      * not available as Java objects as portability is greatly
      * diminished when accessing native code.  The facility is available 
      * where necessary, though.
      
       IDENTIFICATION DIVISION.
       PROGRAM-ID. WIN32BEEP.
       
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      * The type to pass to the API function.
      *       
       01 SoundType PIC X(4) COMP-X.
       01 ReturnValue PIC X(4) COMP-X.
      
      *
      * Some possible types of beeps.
      *       
       78 MB-ICONASTERISK PIC 999 VALUE 40.
       78 MB-ICONEXCLAMATION PIC 999 VALUE 30.
       78 MB-ICONHAND PIC 999 VALUE 10.
       78 MB-ICONQUESTION PIC 999 VALUE 20.
       78 MB-OK PIC 999 VALUE 0.
       78 MB-SPEAKER PIC S999 VALUE -1.
       
       PROCEDURE DIVISION.
      
      *
      * Load User32.DLL
      * 
      * This step may be done instead by specifying the
      * DLL-LINK=User32.dll program property; specifying
      * the property will load a comma-delimited list of
      * .DLL's before first accessing native code.  It
      * will also automatically unload them at program
      * exit.
      *
       LOAD-DLL.
           DISPLAY "Loading DLL..." UPON SYSOUT
      
           CALL "User32.dll" GIVING ReturnValue
           
           IF ReturnValue = 0 THEN
               DISPLAY "Could not load DLL, exiting." UPON SYSOUT
               STOP RUN
           ELSE
               DISPLAY "DLL Loaded successfully." UPON SYSOUT
           END-IF
           .
           
      
       MESSAGE-BEEP.	   
           DISPLAY "Calling MessageBeep..." UPON SYSOUT
       
           MOVE MB-ICONASTERISK TO SoundType
      *    MOVE MB-ICONEXCLAMATION TO SoundType
      *    MOVE MB-ICONHAND TO SoundType
      *    MOVE MB-ICONQUESTION TO SoundType
      *    MOVE MB-OK TO SoundType
      *    MOVE MB-SPEAKER TO SoundType
      
      * BY CONTENT and BY REFERENCE are _very_ important
      * for native calls; if SoundType were passed by
      * reference (the default), then the address of
      * its value would be passed instead of the value
      * itself, which is not what the Win32 API function
      * MessageBeep is expecting.  It's expecting a 4-byte
      * integer, satisfied by the PIC X(4) COMP-X definition
      * above.  Native calls automatically convert the
      * data in COMP-X/BINARY/COMP-5 to the correct
      * endian format.
             
           CALL "MessageBeep" USING BY CONTENT SoundType 
                              GIVING ReturnValue
        			 
           DISPLAY "Call complete (Status " ReturnValue ")" 
                   UPON SYSOUT
      
           IF ReturnValue = 0 THEN
               DISPLAY "MessageBeep Failed." UPON SYSOUT
           ELSE
               DISPLAY "MessageBeep Succeeded." UPON SYSOUT
           END-IF
           .
      
      * Unload the DLL.
      *
      * This step may be skipped if the DLL-LINK=User32.dll parameter
      * is passed.
      
       UNLOAD-DLL.
           CANCEL "User32.dll"
           DISPLAY "Done." UPON SYSOUT
           .
