*
* XMLBASIC
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in 
* conjunction with the Elastic COBOL product.
*
id division.
program-id. xmlbasic.

environment division.
input-output section.
file-control.
    select xml-file assign to "xmldata.xml"
    organization is xml
    file status is file-status
    .

data division.
file section.
fd xml-file.

* The level 01 item must always be the XML base tag, the one that
* describes the file as a whole.
*
* The structure of the Cobol record must match the structure of the XML.
* It can have items missing, but for an item to be detected it must
* match.  The XML file may also have items missing.
*
* The identified by "name" gives an exact name to the XML tag to match.

01 customer-database-tag identified by "customer-database".
  05 customer-tag identified by "customer".
    10 customer-name-tag identified by "name".
      15 customer-first pic x(10) identified by "first".
      15 customer-last pic x(15) identified by "last".
    10 customer-state pic x(15) identified by "state".
    
working-storage section.

01 file-status pic xx value space.

procedure division.
main-paragraph.

* Clear the data initially
    initialize customer-database-tag
    
    display "open input" upon sysout
    open input xml-file
    display "opened." upon sysout
    
    perform read-it until file-status >= 10
    
    display "close" upon sysout
    close xml-file
    display "done" upon sysout
    
    stop all run
    .

* Read a single 'record' from the XML file matching the Cobol record    
read-it.
    read xml-file
    
* While the file-status < 10 (an OK status), display it
    if file-status < 10 then
        perform display-it
    end-if
    .

* Display the customer information

display-it.
    display "customer-name: " customer-name-tag upon sysout
    display "state        : " customer-state upon sysout
    .    
    
