/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.debug;

import com.heirloomcomputing.ecs.exec.Variable;
import java.util.ArrayList;

public class DataWatchPoint {
    static DataWatchPoint watchpointSet;
    public static ArrayList<String> launchWatchpoints;
    public static boolean watchBreakEventFired;
    public static ArrayList<Variable> watchPointMap;
    public static String currentWatchpointBreak;

    public static DataWatchPoint getWatchpointSet() {
        if (watchpointSet == null) {
            watchpointSet = new DataWatchPoint();
        }
        return watchpointSet;
    }

    public static void fireWatchBreakEvent() {
    }

    public static void resetDataWatchPointEvent() {
        watchBreakEventFired = false;
    }

    public static ArrayList<String> getWatchpoints(String pgm) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < launchWatchpoints.size(); ++i) {
            String[] watchElements = launchWatchpoints.get(i).split(":", 5);
            if (!watchElements[0].equals(pgm) || !watchElements[3].equalsIgnoreCase("True")) continue;
            result.add(launchWatchpoints.get(i).substring(launchWatchpoints.get(i).indexOf(58) + 1));
        }
        return result;
    }

    public void toggleLaunch(String pname, String vname, String vIndex, boolean enabled) {
        String pre = pname + ":" + vname + ":" + vIndex;
        int i = 0;
        for (i = 0; i < launchWatchpoints.size() && !launchWatchpoints.get(i).startsWith(pre); ++i) {
        }
        if (i < launchWatchpoints.size()) {
            String[] watchElements = launchWatchpoints.get(i).split(":", 5);
            launchWatchpoints.remove(i);
            launchWatchpoints.add(pre + enabled + watchElements[4]);
        }
    }

    public void addToLaunch(String pname, String vname, String vIndex, String enabled, int bType, String bValue) {
        this.removeFromLaunch(pname, vname, vIndex);
        launchWatchpoints.add(pname + ":" + vname + ":" + vIndex + ":" + enabled + ":" + bType + ":" + bValue);
    }

    public void removeFromLaunch(String pname, String vname, String vIndex) {
        String pre = pname + ":" + vname + ":" + vIndex;
        int i = 0;
        for (i = 0; i < launchWatchpoints.size() && !launchWatchpoints.get(i).startsWith(pre); ++i) {
        }
        if (i < launchWatchpoints.size()) {
            launchWatchpoints.remove(i);
        }
    }

    public String getCurrentWatchpointBreak() {
        return currentWatchpointBreak;
    }

    public void resetWatchpointBreak() {
        watchBreakEventFired = false;
        currentWatchpointBreak = "";
    }

    public static void removeWatchpointMap(Variable var) {
        if (watchPointMap != null && watchPointMap.contains(var)) {
            watchPointMap.remove(var);
        }
    }

    public static void setWatchpointMap(Variable var) {
        if (watchPointMap == null) {
            watchPointMap = new ArrayList();
        }
        if (!watchPointMap.contains(var)) {
            watchPointMap.add(var);
        }
    }

    public static boolean checkForWatchpointBreaks(Variable var) {
        if (watchPointMap == null || watchPointMap.isEmpty()) {
            return false;
        }
        for (Variable watchVar : watchPointMap) {
            if (!var.getMemory().equals(watchVar.getMemory()) || (var.getAddress() < watchVar.getAddress() || var.getAddress() >= watchVar.getAddress() + watchVar.getLength()) && (watchVar.getAddress() < var.getAddress() || watchVar.getAddress() >= var.getAddress() + var.getLength()) || !watchVar.isBreakValid()) continue;
            return true;
        }
        return false;
    }

    static {
        launchWatchpoints = new ArrayList();
        watchBreakEventFired = false;
        currentWatchpointBreak = "";
    }
}

