/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecc;

import com.heirloomcomputing.ecc.HCILicensing;
import com.heirloomcomputing.ecc.IRAC;
import com.heirloomcomputing.ecc.RACLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RAC
implements IRAC {
    private static Date RetryRACWhen = null;
    private static int RetryRACEvery = 600000;
    private static Properties GlobalRACProperties = null;
    public static RACLookup GlobalRACLookup = null;
    public static Logger LOGGER = null;

    private static boolean isTrue(String string2) {
        return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("on") || string2.equals("1");
    }

    private static String asCommaList(String[] stringArray) {
        String string2 = "";
        for (String string3 : stringArray) {
            if (!string2.isEmpty()) {
                string2 = string2 + ",";
            }
            string2 = string2 + string3;
        }
        return string2;
    }

    @Override
    public boolean Setup(Properties properties) {
        boolean bl;
        String string2;
        if (properties == null) {
            return false;
        }
        if (LOGGER == null) {
            string2 = properties.getProperty("rac.debug");
            bl = "true".equalsIgnoreCase(string2) || "yes".equalsIgnoreCase(string2) || "on".equalsIgnoreCase(string2) || "1".equals(string2);
            LOGGER = Logger.getLogger("RAC");
            if (bl && LOGGER.getHandlers().length == 0) {
                try {
                    LOGGER.addHandler(new FileHandler("logs/RAC-messages.log"));
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {
                    try {
                        LOGGER.addHandler(new FileHandler("../logs/RAC-messages.log"));
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (IOException iOException2) {
                        try {
                            LOGGER.addHandler(new FileHandler("RAC-messages.log"));
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                }
            }
            for (Handler handler : LOGGER.getHandlers()) {
                handler.setFormatter(new HCIFormatter());
            }
            LOGGER.setLevel(Level.FINEST);
        }
        GlobalRACProperties = properties;
        bl = false;
        if (GlobalRACLookup == null) {
            if (RetryRACWhen != null && RetryRACWhen.after(new Date())) {
                return false;
            }
            string2 = GlobalRACProperties.getProperty("rac.connectionurl");
            if (string2 == null || string2.trim().isEmpty()) {
                RetryRACWhen = new Date();
                RetryRACWhen.setTime(RetryRACWhen.getTime() + (long)RetryRACEvery);
                return false;
            }
            string2 = GlobalRACProperties.getProperty("rac.authentication");
            if (string2 == null || string2.equals("none")) {
                RetryRACWhen = new Date();
                RetryRACWhen.setTime(RetryRACWhen.getTime() + (long)RetryRACEvery);
                return false;
            }
            GlobalRACLookup = new RACLookup();
            bl = true;
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.connectionurl")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getConnectionURL()))) {
            bl = true;
            GlobalRACLookup.setConnectionURL(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.alternateurl")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getAlternateURL()))) {
            bl = true;
            GlobalRACLookup.setAlternateURL(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.connectionname")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getConnectionName()))) {
            bl = true;
            GlobalRACLookup.setConnectionName(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.connectionpassword")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getConnectionPassword()))) {
            bl = true;
            GlobalRACLookup.setConnectionPassword(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.connectiontimeout")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getConnectionTimeout()))) {
            bl = true;
            GlobalRACLookup.setConnectionTimeout(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.authentication")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getAuthentication()))) {
            GlobalRACLookup.setAuthentication(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.opidattribute")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getOpidAttribute()))) {
            GlobalRACLookup.setOpidAttribute(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.protocol")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getProtocol()))) {
            GlobalRACLookup.setProtocol(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.userbase")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getUserBase()))) {
            GlobalRACLookup.setUserBase(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.usersearch")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getUserSearch()))) {
            GlobalRACLookup.setUserSearch(string2);
        }
        if ((string2 = GlobalRACProperties.getProperty("rac.usersearchasuser")) != null && !string2.trim().isEmpty() && !string2.equals("default") && RAC.isTrue(string2) != GlobalRACLookup.isUserSearchAsUser()) {
            GlobalRACLookup.setUserSearchAsUser(RAC.isTrue(string2));
        }
        if ((string2 = GlobalRACProperties.getProperty("rac.usersubtree")) != null && !string2.trim().isEmpty() && !string2.equals("default") && RAC.isTrue(string2) != GlobalRACLookup.isUserSubtree()) {
            GlobalRACLookup.setUserSubtree(RAC.isTrue(string2));
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.userrolename")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getUserRoleName()))) {
            GlobalRACLookup.setUserRoleName(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.resourcename")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getResourceName()))) {
            GlobalRACLookup.setResourceName(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.resourcebase")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getResourceBase()))) {
            GlobalRACLookup.setResourceBase(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.resourcememberattribute")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getResourceMemberAttribute()))) {
            GlobalRACLookup.setResourceMemberAttribute(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.resourceruleattribute")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getResourceRuleAttribute()))) {
            GlobalRACLookup.setResourceRuleAttribute(string2);
        }
        if ((string2 = GlobalRACProperties.getProperty("rac.resourcesearchasuser")) != null && !string2.trim().isEmpty() && !string2.equals("default") && RAC.isTrue(string2) != GlobalRACLookup.isResourceSearchAsUser()) {
            GlobalRACLookup.setResourceSearchAsUser(RAC.isTrue(string2));
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.resourcetypes")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(RAC.asCommaList(GlobalRACLookup.getResourceTypes())))) {
            GlobalRACLookup.setResourceTypes(string2.split(","));
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.rgbase")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getResourceGroupBase()))) {
            GlobalRACLookup.setResourceGroupBase(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.rgname")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getResourceGroupName()))) {
            GlobalRACLookup.setResourceGroupName(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.rgmemberattribute")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getResourceGroupMemberAttribute()))) {
            GlobalRACLookup.setResourceGroupMemberAttribute(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.rgruleattribute")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getResourceGroupRuleAttribute()))) {
            GlobalRACLookup.setResourceGroupRuleAttribute(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.rolebase")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getRoleBase()))) {
            GlobalRACLookup.setRoleBase(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.rolename")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getRoleName()))) {
            GlobalRACLookup.setRoleName(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.rolesearch")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getRoleSearch()))) {
            GlobalRACLookup.setRoleSearch(string2);
        }
        if ((string2 = GlobalRACProperties.getProperty("rac.rolesearchasuser")) != null && !string2.trim().isEmpty() && !string2.equals("default") && RAC.isTrue(string2) != GlobalRACLookup.isRoleSearchAsUser()) {
            GlobalRACLookup.setRoleSearchAsUser(RAC.isTrue(string2));
        }
        if ((string2 = GlobalRACProperties.getProperty("rac.rolesubtree")) != null && !string2.trim().isEmpty() && !string2.equals("default") && RAC.isTrue(string2) != GlobalRACLookup.isRoleSubtree()) {
            GlobalRACLookup.setRoleSubtree(RAC.isTrue(string2));
        }
        if ((string2 = GlobalRACProperties.getProperty("rac.rolenested")) != null && !string2.trim().isEmpty() && !string2.equals("default") && RAC.isTrue(string2) != GlobalRACLookup.isRoleNested()) {
            GlobalRACLookup.setRoleNested(RAC.isTrue(string2));
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.userpassword")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getUserPassword()))) {
            GlobalRACLookup.setUserPassword(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.userroleattribute")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getUserRoleAttribute()))) {
            GlobalRACLookup.setUserRoleAttribute(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.userpattern")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getUserPattern()))) {
            GlobalRACLookup.setUserPattern(string2);
        }
        if (!((string2 = GlobalRACProperties.getProperty("rac.commonrole")) == null || string2.trim().isEmpty() || string2.equals("default") || string2.equals(GlobalRACLookup.getCommonRole()))) {
            GlobalRACLookup.setCommonRole(string2);
        }
        try {
            string2 = GlobalRACProperties.getProperty("rac.sizelimit");
            if (string2 != null && !string2.trim().isEmpty() && !string2.equals("default") && (long)Integer.parseInt(string2) != GlobalRACLookup.getSizeLimit()) {
                GlobalRACLookup.setSizeLimit(Integer.parseInt(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            string2 = GlobalRACProperties.getProperty("rac.timelimit");
            if (string2 != null && !string2.trim().isEmpty() && !string2.equals("default") && Integer.parseInt(string2) != GlobalRACLookup.getTimeLimit()) {
                GlobalRACLookup.setTimeLimit(Integer.parseInt(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string2 = GlobalRACProperties.getProperty("rac.debug");
        if (string2 != null && !string2.trim().isEmpty() && !string2.equals("default") && RAC.isTrue(string2) != GlobalRACLookup.isDebug()) {
            GlobalRACLookup.setDebug(RAC.isTrue(string2));
        }
        try {
            string2 = GlobalRACProperties.getProperty("rac.cachetime");
            if (string2 != null && !string2.trim().isEmpty() && !string2.equals("default") && Integer.parseInt(string2) != GlobalRACLookup.getCacheTime()) {
                GlobalRACLookup.setCacheTime(Integer.parseInt(string2));
                if (GlobalRACLookup.getCacheTime() <= 60) {
                    RetryRACEvery = GlobalRACLookup.getCacheTime() * 60 * 1000;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            string2 = GlobalRACProperties.getProperty("rac.cachesize");
            if (string2 != null && !string2.trim().isEmpty() && !string2.equals("default") && Integer.parseInt(string2) != GlobalRACLookup.getCacheSize()) {
                GlobalRACLookup.setCacheSize(Integer.parseInt(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bl) {
            String string3 = GlobalRACLookup.getConnectionURL();
            String string4 = GlobalRACLookup.getAlternateURL();
            if (string3 == null) {
                LOGGER.log(Level.FINEST, "HCI834I");
                GlobalRACLookup = null;
                RetryRACWhen = new Date();
                RetryRACWhen.setTime(RetryRACWhen.getTime() + (long)RetryRACEvery);
                return false;
            }
            if (string4 == null) {
                string4 = "no alternate security server configured";
            }
            if (GlobalRACLookup.init()) {
                LOGGER.log(Level.INFO, "HCI833I", new Object[]{string3, string4});
                RetryRACWhen = null;
            } else {
                LOGGER.log(Level.SEVERE, "HCI832S", new Object[]{string3, string4});
                GlobalRACLookup = null;
                RetryRACWhen = new Date();
                RetryRACWhen.setTime(RetryRACWhen.getTime() + (long)RetryRACEvery);
                return false;
            }
        }
        return true;
    }

    @Override
    public void TearDown() {
        if (GlobalRACLookup != null) {
            GlobalRACLookup.finish();
            GlobalRACLookup = null;
        }
        RetryRACWhen = null;
    }

    @Override
    public boolean IsRACon() {
        if (GlobalRACLookup != null) {
            return true;
        }
        if (RetryRACWhen == null || RetryRACWhen.before(new Date())) {
            return this.Setup(GlobalRACProperties);
        }
        return GlobalRACLookup != null;
    }

    @Override
    public List<String> GetGroupsForUser(String string2) {
        if (!this.IsRACon()) {
            return null;
        }
        return GlobalRACLookup.getRolesForUser(string2);
    }

    @Override
    public List<String> Authenticate(String string2, String string3) {
        if (!this.IsRACon() || string2 == null) {
            return new ArrayList<String>();
        }
        RACLookup.AuthenticatedUser authenticatedUser = GlobalRACLookup.authenticate(string2, string3);
        if (authenticatedUser == null) {
            return null;
        }
        return authenticatedUser.getRoles();
    }

    @Override
    public boolean Authorize(String string2, List<String> list, int n, String string3, String string4) {
        if (!this.IsRACon() || string2 == null) {
            return true;
        }
        return GlobalRACLookup.authorize(string2, list, n, string3, string4) != null;
    }

    @Override
    public String Attribute(String string2, String string3) {
        String string4;
        if (!this.IsRACon() || string3 == null) {
            return null;
        }
        if ("opid".equals(string2) && (string4 = GlobalRACLookup.getOpidAttribute()) != null) {
            string2 = string4;
        }
        return GlobalRACLookup.attribute(string3, string2);
    }

    protected static class HCIFormatter
    extends Formatter {
        protected HCIFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            if (logRecord == null) {
                return null;
            }
            Pattern pattern = Pattern.compile("HCI(\\d+)\\p{Alpha}+");
            Matcher matcher = pattern.matcher(logRecord.getMessage());
            if (matcher.matches()) {
                int n = 834;
                try {
                    n = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 834;
                }
                return HCILicensing.Message((Integer)n, logRecord.getParameters()) + "\n";
            }
            return logRecord.getMessage();
        }
    }
}

