/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecc;

import com.heirloomcomputing.ecc.IRAC;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;

public final class RACFactory {
    private static IRAC OurRAC = null;

    public static IRAC getRAC(String string2, String string3) {
        if (OurRAC == null) {
            if (string2 == null || string2.isEmpty() || string2.equals("RAC") || string2.equals("com.heirloomcomputing.ecc.RAC")) {
                string2 = "com.heirloomcomputing.ecc.RAC";
            }
            try {
                ClassLoader classLoader = null;
                Class<RACFactory> clazz = RACFactory.class;
                classLoader = clazz.getClassLoader();
                if (classLoader == null) {
                    System.err.println("RAC Error: Cannot getClassLoader for IRAC interface class '" + string2 + "'");
                    return OurRAC;
                }
                if (string3 != null && !string3.isEmpty()) {
                    RACFactory rACFactory = new RACFactory();
                    rACFactory.getClass();
                    classLoader = rACFactory.new RACClassLoader(classLoader, string3);
                }
                Class<?> clazz2 = null;
                try {
                    clazz2 = classLoader.loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz2 == null) {
                    System.err.println("RAC Error: Cannot loadClass for IRAC interface class '" + string2 + "'");
                    return OurRAC;
                }
                Object obj = clazz2.newInstance();
                OurRAC = (IRAC)obj;
            }
            catch (InstantiationException instantiationException) {
                System.err.println("RAC Error: Cannot instantiate implementor of IRAC interface class '" + string2 + "'");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("RAC Error: Cannot access implementor of IRAC interface class '" + string2 + "'");
            }
        }
        return OurRAC;
    }

    private final class RACClassLoader
    extends ClassLoader {
        ClassLoader altClassLoader;

        public RACClassLoader(ClassLoader classLoader, String string2) {
            super(classLoader);
            LinkedList<URL> linkedList = new LinkedList<URL>();
            for (String string3 : string2.split(File.pathSeparator)) {
                try {
                    URL uRL = new File(string3).toURI().toURL();
                    linkedList.add(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            Object[] objectArray = new URL[]{};
            this.altClassLoader = new URLClassLoader((URL[])linkedList.toArray(objectArray));
        }

        @Override
        protected Class<?> findClass(String string2) throws ClassNotFoundException {
            ByteBuffer byteBuffer;
            String string3 = string2.replace('.', '/') + ".class";
            URL uRL = this.findResource(string3);
            if (uRL == null) {
                throw new ClassNotFoundException(string2);
            }
            try {
                byteBuffer = this.loadResource(uRL);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string2, iOException);
            }
            return this.defineClass(string2, byteBuffer, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer loadResource(URL uRL) throws IOException {
            try (InputStream inputStream = null;){
                inputStream = uRL.openStream();
                int n = Math.min(262144, inputStream.available() + 1);
                n = n <= 2 ? 65536 : Math.max(n, 512);
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                while (true) {
                    int n2;
                    if (!byteBuffer.hasRemaining()) {
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(2 * byteBuffer.capacity());
                        byteBuffer.flip();
                        byteBuffer2.put(byteBuffer);
                        byteBuffer = byteBuffer2;
                    }
                    if ((n2 = inputStream.read(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining())) <= 0) break;
                    byteBuffer.position(byteBuffer.position() + n2);
                }
                byteBuffer.flip();
                ByteBuffer byteBuffer3 = byteBuffer;
                return byteBuffer3;
            }
        }

        @Override
        protected URL findResource(String string2) {
            return this.altClassLoader.getResource(string2);
        }

        @Override
        protected Enumeration<URL> findResources(String string2) throws IOException {
            Vector<URL> vector = new Vector<URL>();
            Enumeration<URL> enumeration = this.altClassLoader.getResources(string2);
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
            return vector.elements();
        }
    }
}

