/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ACUBTreeNode;
import com.heirloomcomputing.ecs.exec.ACUFile;
import com.heirloomcomputing.ecs.exec.ACUFilePointer;
import com.heirloomcomputing.ecs.exec.BTreeHandler;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.bTreeNode;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class ACUBTreeHandler
extends BTreeHandler {
    private static final boolean debugMode = false;
    int order = 5;
    protected ACUFile file = null;
    private int bTreeIndex = -1;

    public static void debug(String text) {
        Utilities.debugOutput("ACUBTreeHandler: " + text);
    }

    public ACUBTreeHandler(ACUFile file2, int bTreeIndex) {
        this.bTreeIndex = bTreeIndex;
        this.file = file2;
    }

    @Override
    int getBTreeType() {
        return 2;
    }

    @Override
    int getBTreeOrder() {
        return this.order;
    }

    @Override
    int compareLocation(Object location1, Object location2, boolean truncate) {
        if (!(location1 instanceof ACUFilePointer) || !(location2 instanceof ACUFilePointer)) {
            throw new RuntimeException("Location(s) are not of type ACUFilePointer");
        }
        ACUFilePointer pointer1 = (ACUFilePointer)location1;
        ACUFilePointer pointer2 = (ACUFilePointer)location2;
        return pointer1.compare(pointer2, truncate);
    }

    private void initOrder(ACUFile file2) {
        int maxKeySize = this.getMaximumKeySize();
        int nodeSize = file2.getIndexNodeRecordSize();
        int keyOverhead = 8;
        if (this.allowsDuplicates) {
            keyOverhead += 4;
        }
        int nodeOverhead = 9 + (3 + maxKeySize);
        if (this.allowsDuplicates) {
            nodeOverhead += 4;
        }
        this.order = (nodeSize - nodeOverhead) / keyOverhead + 1;
        ++this.order;
    }

    @Override
    bTreeNode getBTreeNode(comparableByteArray keyTemplate) {
        this.initOrder(this.file);
        ACUBTreeNode node = new ACUBTreeNode(this.file, this.order, keyTemplate, this.bTreeIndex, this.getMaximumKeySize());
        return node;
    }

    @Override
    bTreeNode getBTreeNode(comparableByteArray keyTemplate, Object location) {
        if (!(location instanceof ACUFilePointer)) {
            throw new RuntimeException("location not of type ACUFilePointer");
        }
        this.initOrder(this.file);
        ACUFilePointer pointer = (ACUFilePointer)location;
        long key = pointer.getRecordKey();
        return new ACUBTreeNode(this.file, this.order, key, keyTemplate, this.bTreeIndex, this.getMaximumKeySize());
    }

    @Override
    Object getCurrentLocation() {
        try {
            ACUFilePointer p = (ACUFilePointer)this.tree.getCurrentNodeDataLocation();
            if (p == null) {
                return null;
            }
            long recKey = p.getRecordKey();
            if (recKey < 0L) {
                recKey = -recKey;
                p = (ACUFilePointer)p.copy();
                p.setRecordKey(recKey);
            }
            return p;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    int insertKey(comparableByteArray currentKey, Object location) {
        long keyDupCount;
        long recKey;
        ACUFilePointer p = (ACUFilePointer)location;
        if (p != null && (recKey = p.getRecordKey()) > 0L) {
            p = (ACUFilePointer)p.copy();
            p.setRecordKey(-recKey);
        }
        if (!this.tree.addKey(currentKey, p, keyDupCount = this.file.getCurrentRecordID())) {
            this.warning("ACUBTreeHandler.insertKey", "could not add key");
            return -30;
        }
        this.rootLocation = this.tree.getRootLocation();
        return 0;
    }

    @Override
    int insertKeyAtCursor(comparableByteArray currentKey, Object location, long keyDupCount) {
        keyDupCount = this.file.getCurrentRecordID() - 1L;
        ACUFilePointer p = null;
        try {
            long recKey;
            p = (ACUFilePointer)location;
            if (p != null && (recKey = p.getRecordKey()) > 0L) {
                p = (ACUFilePointer)p.copy();
                p.setRecordKey(-recKey);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.insertKeyAtCursor(currentKey, p, keyDupCount);
    }

    @Override
    int setDataForKey(comparableByteArray currentKey, Object oldLocation, Object newLocation) {
        int returnCode = this.align(currentKey, oldLocation);
        if (returnCode != 0) {
            return returnCode;
        }
        ACUFilePointer p = null;
        try {
            long recKey;
            p = (ACUFilePointer)newLocation;
            if (p != null && (recKey = p.getRecordKey()) > 0L) {
                p = (ACUFilePointer)p.copy();
                p.setRecordKey(-recKey);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.tree.setCurrentNodeDataLocation(p)) {
            this.warning("ACUBTreeHandler.setDataForKey", "invalid key, random record is missing");
            return -23;
        }
        return 0;
    }
}

