/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import java.io.PrintStream;
import java.io.PrintWriter;

public class AbendException
extends RuntimeException {
    public static final String CAUSED_BY = "Caused by:";
    public static final int IGNORE_EXCEPTION = 0;
    public static final int RETHROW_EXCEPTION = 1;
    public static final int EXIT_PROGRAM = 2;
    private int defaultBehavior = -1;
    private String message;
    private String longMessage;
    private Throwable abendException;
    private String abcode;
    private boolean ignoreHandler;
    private boolean presented;
    private boolean nodump;
    private String programName;

    public AbendException(String message, String longMessage, Throwable abendException, String abcode, boolean ignoreHandler) {
        this.message = message;
        this.longMessage = longMessage;
        this.abendException = abendException;
        this.abcode = abcode;
        this.ignoreHandler = ignoreHandler;
    }

    public AbendException(Object exception) {
        if (exception instanceof Throwable) {
            this.abendException = (Throwable)exception;
            this.longMessage = this.message = this.abendException.getMessage();
        } else {
            this.message = String.valueOf(exception);
            this.longMessage = String.valueOf(exception);
        }
        this.defaultBehavior = 1;
        this.abcode = "AUSR";
    }

    public AbendException(int defaultBehavior) {
        this.defaultBehavior = defaultBehavior;
    }

    public void setProgramName(String name) {
        this.programName = name;
    }

    public String getProgramName() {
        return this.programName;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getLongMessage() {
        return this.longMessage;
    }

    public Throwable getAbendException() {
        return this.abendException;
    }

    public int getDefaultBehavior() {
        return this.defaultBehavior;
    }

    public void setDefaultBehavior(int value) {
        this.defaultBehavior = value;
    }

    public boolean isIgnoreHandler() {
        return this.ignoreHandler;
    }

    public String getAbcode() {
        return this.abcode;
    }

    public void setPresented(boolean state) {
        this.presented = state;
    }

    public boolean hasBeenPresented() {
        return this.presented;
    }

    public void setDump(boolean state) {
        this.nodump = !state;
    }

    public boolean hasDump() {
        return !this.nodump;
    }

    public String getDumpMessage() {
        StringBuffer result = new StringBuffer();
        if (this.abcode != null) {
            result.append("ABCODE '").append(this.abcode).append("'");
            if (this.longMessage != null) {
                result.append(": ").append(this.longMessage);
            } else if (this.message != null) {
                result.append(": ").append(this.message);
            }
        }
        return result.toString();
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.abendException != null) {
            System.out.println(CAUSED_BY);
            this.abendException.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.abcode != null ? this.abcode : super.toString();
    }

    @Override
    public void printStackTrace(PrintStream out) {
        out.println("ABEND ABCODE(" + this.toString() + "): " + (this.nodump ? "WITH NO DUMP" : "WITH DUMP"));
        if (this.nodump) {
            throw new RuntimeException("No dump is available.");
        }
        out.println("");
        super.printStackTrace(out);
        if (this.abendException != null) {
            out.println("");
            out.println(CAUSED_BY);
            this.abendException.printStackTrace(out);
        }
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        out.println("ABEND ABCODE(" + this.toString() + "): " + (this.nodump ? "WITH NO DUMP" : "WITH DUMP"));
        if (this.nodump) {
            throw new RuntimeException("No dump is available.");
        }
        out.println("");
        super.printStackTrace(out);
        if (this.abendException != null) {
            out.println("");
            out.println(CAUSED_BY);
            this.abendException.printStackTrace(out);
        }
    }
}

