/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.PackedDecimalP;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.bTree;
import com.heirloomcomputing.ecs.exec.bTreeNode;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public abstract class BTreeHandler {
    public static final boolean debugMode = false;
    protected bTree tree = null;
    protected comparableByteArray savedKey = null;
    protected Object savedLocation = null;
    protected boolean cursorIsUndefined = false;
    protected int maxKeySize = -1;
    protected Object rootLocation = null;
    protected boolean allowsDuplicates = false;

    private static final void debug(String text) {
        System.out.println("BTreeHandler: " + text);
    }

    protected void warning(String method, String text) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.warning("BTreeHandler." + method + ": " + text);
        }
    }

    int init(comparableByteArray keyTemplate, int maxKeySize, boolean allowsDuplicates, boolean readOnlyCaching) {
        this.maxKeySize = maxKeySize;
        this.allowsDuplicates = allowsDuplicates;
        bTreeNode treeNode = this.getBTreeNode(keyTemplate);
        this.tree = new bTree(treeNode, this.getBTreeType(), allowsDuplicates, readOnlyCaching);
        this.rootLocation = treeNode.getLocation();
        return 0;
    }

    int init(comparableByteArray keyTemplate, int maxKeySize, Object rootLocation, boolean allowsDuplicates, boolean readOnlyCaching) {
        this.maxKeySize = maxKeySize;
        this.allowsDuplicates = allowsDuplicates;
        if (keyTemplate instanceof PackedDecimalP) {
            int addr = ((PackedDecimalP)keyTemplate).getAddress();
            int len = ((PackedDecimalP)keyTemplate).itemSize;
            for (int i = addr; i < addr + len; ++i) {
                ((PackedDecimalP)keyTemplate).getMemory().setByte(i, (byte)((((PackedDecimalP)keyTemplate).getMemory().getByte(i) & 0xFF) << 4 | (((PackedDecimalP)keyTemplate).getMemory().getByte(i) & 0xFF) >> 4));
            }
        }
        bTreeNode treeNode = this.getBTreeNode(keyTemplate, rootLocation);
        this.tree = new bTree(treeNode, this.getBTreeType(), allowsDuplicates, readOnlyCaching);
        this.rootLocation = rootLocation;
        return 0;
    }

    void updateRootLocation(Object rootLocation) {
        this.rootLocation = rootLocation;
        this.tree.setRootLocation(rootLocation);
    }

    int getBTreeType() {
        return 0;
    }

    long getTreeHeight() {
        return this.tree.getHeight();
    }

    int getBTreeOrder() {
        return 5;
    }

    int getMaximumKeySize() {
        return this.maxKeySize;
    }

    Object getRootLocation() {
        return this.rootLocation;
    }

    void flushCache() {
        this.tree.flushCache();
    }

    void seekToBeginning() {
        this.tree.seekToBeginning();
    }

    boolean seekPrevious() {
        return this.tree.seekToPrevious();
    }

    boolean seekNext() {
        return this.tree.seekToNext();
    }

    long seekToNextNonDuplicateKey(comparableByteArray key) {
        return this.tree.seekToNextNonDuplicateKey(key);
    }

    int seekToEnd() {
        this.tree.seekToEnd();
        return 0;
    }

    int seek(int mode, comparableByteArray currentKey) {
        boolean found = this.tree.seekToKey(currentKey);
        if (mode == 0) {
            if (!found) {
                this.warning("seek", "invalid key, random record missing");
                return -23;
            }
            return 0;
        }
        if (mode == 2) {
            if (found) {
                this.tree.seekToNextNonDuplicateKey(currentKey);
            }
            if (this.tree.isAtEnd()) {
                this.warning("seek", "invalid key, random record missing");
                return -23;
            }
            return 0;
        }
        if (mode == 1) {
            if (this.tree.isAtEnd()) {
                this.warning("seek", "invalid key, random record missing");
                return -23;
            }
            return 0;
        }
        if (mode == -2) {
            this.tree.seekToPrevious();
            if (this.tree.isAtBeginning()) {
                this.warning("seek", "invalid key, random record missing");
                return -23;
            }
            return 0;
        }
        if (mode == -1) {
            if (found) {
                return 0;
            }
            this.tree.seekToPrevious();
            if (this.tree.isAtBeginning()) {
                this.warning("seek", "invalid key, random record missing");
                return -23;
            }
            return 0;
        }
        return 0;
    }

    byte[] getNextData() {
        byte[] bytes = (byte[])this.tree.getNextData();
        return bytes;
    }

    byte[] getCurrentData() {
        return (byte[])this.tree.getData();
    }

    byte[] getData(comparableByteArray currentKey) {
        return (byte[])this.tree.getData(currentKey);
    }

    boolean isNextKeyDuplicate() {
        return this.tree.isNextKeyDuplicate();
    }

    boolean isAtEnd(comparableByteArray currentKey) {
        boolean flag = this.tree.isAtEnd(currentKey);
        return flag;
    }

    boolean isAtEnd() {
        return this.tree.isAtEnd();
    }

    boolean isAtBeginning() {
        return this.tree.isAtBeginning();
    }

    boolean isNextAtEnd() {
        boolean flag = this.tree.isNextAtEnd();
        return flag;
    }

    boolean isPreviousAtBeginning() {
        boolean flag = this.tree.isPreviousAtBeginning();
        return flag;
    }

    boolean findKey(comparableByteArray currentKey) {
        boolean flag = this.tree.seekToKey(currentKey);
        return flag;
    }

    Object getCurrentLocation() {
        return this.tree.getCurrentNodeDataLocation();
    }

    void saveCurrentLocation() {
        if (this.tree.getCursorPosition() < 0) {
            this.savedKey = null;
            this.cursorIsUndefined = true;
            return;
        }
        this.cursorIsUndefined = false;
        if (this.tree.isAtEnd()) {
            this.savedKey = null;
            return;
        }
        this.savedKey = this.tree.getCurrentKey();
        this.savedLocation = this.getCurrentLocation();
    }

    void restoreCurrentLocation() {
        if (this.savedKey == null) {
            if (this.cursorIsUndefined) {
                return;
            }
            this.tree.seekToEnd();
            return;
        }
        if (!this.findKey(this.savedKey)) {
            this.seekPrevious();
            return;
        }
        Object curLocation = this.getCurrentLocation();
        do {
            if (this.savedLocation != null && this.compareLocation(curLocation, this.savedLocation, true) == 0) {
                return;
            }
            if (!this.seekNext()) {
                return;
            }
            Variable key = (Variable)this.tree.getCurrentKey();
            if (key != null && this.savedKey.compare(key, true) == 0) continue;
            this.seekPrevious();
            return;
        } while ((curLocation = this.getCurrentLocation()) != null);
    }

    int align(comparableByteArray currentKey, Object location) {
        Variable key = null;
        if (!this.findKey(currentKey)) {
            this.warning("align", "invalid key, random record missing");
            return -23;
        }
        Object curLocation = this.getCurrentLocation();
        while (this.compareLocation(curLocation, location, false) != 0) {
            if (!this.seekNext()) {
                this.warning("align", "invalid key, random record missing");
                return -23;
            }
            key = (Variable)this.tree.getCurrentKey();
            if (key == null) {
                this.warning("align", "invalid key, random record missing");
                return -23;
            }
            if (currentKey.compare(key, true) != 0) {
                this.warning("align", "invalid key, random record missing");
                return -23;
            }
            curLocation = this.getCurrentLocation();
        }
        return 0;
    }

    int insertKey(comparableByteArray currentKey, Object location) {
        if (!this.tree.addKey(currentKey, location)) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("BTreeHandler Error: could not add key");
            }
            this.warning("insertKey", "could not add key");
            return -30;
        }
        this.rootLocation = this.tree.getRootLocation();
        return 0;
    }

    int insertKeyAtCursor(comparableByteArray currentKey, Object location, long keyDupCount) {
        if (!this.tree.addKeyAtCursor(currentKey, location, keyDupCount)) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("BTreeHandler Error: could not add key at cursor");
            }
            this.warning("insertKeyAtCursor", "could not add key");
            return -30;
        }
        this.rootLocation = this.tree.getRootLocation();
        return 0;
    }

    int deleteKey(comparableByteArray currentKey, Object location) {
        int returnCode = this.align(currentKey, location);
        if (returnCode != 0) {
            return returnCode;
        }
        if (!this.tree.deleteCurrentKey()) {
            this.warning("deleteKey", "invalid key, random record missing");
            return -23;
        }
        this.rootLocation = this.tree.getRootLocation();
        return 0;
    }

    int setDataForKey(comparableByteArray currentKey, Object oldLocation, Object newLocation) {
        int returnCode = this.align(currentKey, oldLocation);
        if (returnCode != 0) {
            return returnCode;
        }
        if (!this.tree.setCurrentNodeDataLocation(newLocation)) {
            this.warning("setDataForKey", "invalid key, random record missing");
            return -23;
        }
        return 0;
    }

    void outputTree() {
        this.tree.outputTree();
    }

    public long getNumberOfSplits() {
        return this.tree.getNumberOfSplits();
    }

    public long getNumberOfRedistributes() {
        return this.tree.getNumberOfRedistributes();
    }

    abstract int compareLocation(Object var1, Object var2, boolean var3);

    abstract bTreeNode getBTreeNode(comparableByteArray var1);

    abstract bTreeNode getBTreeNode(comparableByteArray var1, Object var2);
}

