/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.Cache;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class Binary
extends BignumType
implements Cloneable,
comparableByteArray {
    private static final long serialVersionUID = 1L;
    protected boolean storeBinary = false;
    protected static final Bignum BIGTEN = new Bignum(10);
    protected static boolean displayInternal = false;
    protected static boolean displayExternal = false;
    private static final Bignum[] truncateBinaryUnsigned;
    private static final Bignum[] truncateBinaryPositive;
    private static final Bignum[] truncateBinaryNegative;

    @Override
    public String getClassName() {
        return "com.heirloomcomputing.ecs.exec.Binary";
    }

    @Override
    public final String getUsage() {
        return "Binary";
    }

    @Override
    public int getStorageClass() {
        return 4;
    }

    public boolean isStoreBinary() {
        return this.storeBinary;
    }

    private boolean overflowBinary() {
        if (this.signPosition == 0) {
            return this.value.compareTo(truncateBinaryUnsigned[this.length() - 1]) > 0;
        }
        return this.value.compareTo(truncateBinaryPositive[this.length() - 1]) > 0 || this.value.compareTo(truncateBinaryNegative[this.length() - 1]) < 0;
    }

    @Override
    protected void truncate() {
        this.numericString = null;
        if (this.scale <= 0) {
            this.value.truncate(this.storeSize, this.place);
            if (this.storeBinary) {
                this.value.truncateBinary(this.length(), this.signPosition != 0);
            }
            return;
        }
        byte bufferPlace = this.place;
        if (this.place > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        this.value.truncate(this.storeSize, bufferPlace);
        if (this.storeBinary) {
            this.value.truncateBinary(this.length(), this.signPosition != 0);
        }
        this.value.movingPoint(this.scale, bufferPlace);
    }

    @Override
    protected void truncateSE() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.truncatePreserveOnFalse(this.storeSize, this.place)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else if (this.storeBinary && this.overflowBinary()) {
                this.setSizeError();
                this.value.make(this.safeValue);
            }
            return;
        }
        byte bufferPlace = this.place;
        if (bufferPlace > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        if (this.value.truncatePreserveOnFalse(this.storeSize, bufferPlace)) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (this.storeBinary && this.overflowBinary()) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (bufferPlace > 0) {
            this.value.movingPointLeft(this.scale);
        } else {
            this.value.movingPointRight(this.scale);
        }
    }

    @Override
    protected void roundSE() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.roundPreserve(this.storeSize, this.place)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else if (this.storeBinary && this.overflowBinary()) {
                this.setSizeError();
                this.value.make(this.safeValue);
            }
            return;
        }
        byte bufferPlace = this.place;
        if (bufferPlace > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        if (this.value.roundPreserve(this.storeSize, bufferPlace)) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (this.storeBinary && this.overflowBinary()) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (bufferPlace > 0) {
            this.value.movingPointLeft(this.scale);
        } else {
            this.value.movingPointRight(this.scale);
        }
    }

    @Override
    protected void truncateToMemory() {
        this.numericString = null;
        if (this.scale <= 0) {
            this.value.truncate(this.storeSize, this.place);
            if (this.storeBinary) {
                this.value.truncateBinary(this.length(), this.signPosition != 0);
            }
            if (this.signPosition == 0 && this.value.signum() < 0) {
                this.value.negating();
            }
            if (Cache.standard) {
                this.flushToMemoryNow();
            } else {
                this.valid = true;
                this.dirty = true;
                this.cleanAncestors();
            }
            return;
        }
        byte bufferPlace = this.place;
        if (this.place > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        this.value.truncate(this.storeSize, bufferPlace);
        if (this.storeBinary) {
            this.value.truncateBinary(this.length(), this.signPosition != 0);
        }
        this.value.movingPoint(this.scale, bufferPlace);
        if (this.signPosition == 0 && this.value.signum() < 0) {
            this.value.negating();
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
            this.cleanAncestors();
        }
    }

    @Override
    protected void truncateSEToMemory() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.truncatePreserveOnFalse(this.storeSize, this.place)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else if (this.storeBinary && this.overflowBinary()) {
                this.setSizeError();
                this.value.make(this.safeValue);
            }
            if (this.signPosition == 0 && this.value.signum() < 0) {
                this.value.negating();
            }
            if (Cache.standard) {
                this.flushToMemoryNow();
            } else {
                this.valid = true;
                this.dirty = true;
                this.cleanAncestors();
            }
            return;
        }
        byte bufferPlace = this.place;
        if (bufferPlace > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        if (this.value.truncatePreserveOnFalse(this.storeSize, bufferPlace)) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (this.storeBinary && this.overflowBinary()) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (bufferPlace > 0) {
            this.value.movingPointLeft(this.scale);
        } else {
            this.value.movingPointRight(this.scale);
        }
        if (this.signPosition == 0 && this.value.signum() < 0) {
            this.value.negating();
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
            this.cleanAncestors();
        }
    }

    @Override
    protected void roundSEToMemory() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.roundPreserve(this.storeSize, this.place)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else if (this.storeBinary && this.overflowBinary()) {
                this.setSizeError();
                this.value.make(this.safeValue);
            }
            if (this.signPosition == 0 && this.value.signum() < 0) {
                this.value.negating();
            }
            if (Cache.standard) {
                this.flushToMemoryNow();
            } else {
                this.valid = true;
                this.dirty = true;
                this.cleanAncestors();
            }
            return;
        }
        byte bufferPlace = this.place;
        if (bufferPlace > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        if (this.value.roundPreserve(this.storeSize, bufferPlace)) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (this.storeBinary && this.overflowBinary()) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (bufferPlace > 0) {
            this.value.movingPointLeft(this.scale);
        } else {
            this.value.movingPointRight(this.scale);
        }
        if (this.signPosition == 0 && this.value.signum() < 0) {
            this.value.negating();
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
            this.cleanAncestors();
        }
    }

    @Override
    public Numeric odoNumeric() {
        Variable odo = this.findOdo();
        if (odo != null) {
            int newSize = odo.itemSize * odo.occurs();
            odo = odo.getParent();
            int difference = newSize - odo.itemSize;
            odo.itemSize = newSize;
            for (odo = odo.getParent(); odo != null; odo = odo.getParent()) {
                odo.itemSize += (difference *= odo.maxIndex);
            }
        }
        return this;
    }

    public Binary() {
        this.itemSize = 8;
    }

    public Binary(long value) {
        super(value);
        this.itemSize = 8;
        this.calcStoreSize();
    }

    public Binary(Handle handle) {
        this.handle = handle;
        this.itemSize = 6;
        this.calcStoreSize();
    }

    public Binary(long longValue, boolean signed, int bytes, int digits) {
        this.value = new Bignum(longValue);
        this.valid = true;
        this.dirty = true;
        this.signPosition = (byte)(signed ? 3 : 0);
        this.itemSize = bytes;
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.pointerAddress = 0;
        if (digits < 0) {
            digits = -1;
        }
        this.storeSize = digits;
        this.calcStoreSize();
    }

    public Binary(Handle handle, boolean temporary) {
        this.handle = handle;
        this.itemSize = 6;
        if (temporary) {
            this.value = new Bignum(handle.getHandleNumber());
            this.valid = true;
            this.dirty = true;
            this.signPosition = 0;
            this.pointerMemory = new Memory(this.itemSize, new String[0]);
            this.pointerAddress = 0;
            this.storeSize = 14;
        }
        this.calcStoreSize();
    }

    @Override
    public int getUsageNumber() {
        return 3;
    }

    @Override
    public void flushToMemoryNow() {
        try {
            if (this.scale > 0) {
                byte temporaryPlace = this.place;
                Bignum storeValue = this.value;
                if (this.place > 0) {
                    storeValue = this.value.movePointRight(this.scale);
                    temporaryPlace = (byte)(temporaryPlace - this.scale);
                } else {
                    storeValue = this.value.movePointLeft(this.scale);
                }
                long temp = temporaryPlace == 0 ? storeValue.longValue() : storeValue.toLongAtPlace(this.place);
                switch (this.length()) {
                    case 1: {
                        this.pointerMemory.setByte(this.pointerAddress, (byte)temp);
                        return;
                    }
                    case 2: {
                        this.pointerMemory.setShort(this.pointerAddress, (short)temp);
                        return;
                    }
                    case 4: {
                        this.pointerMemory.setInt(this.pointerAddress, (int)temp);
                        return;
                    }
                    case 8: {
                        this.pointerMemory.setLong(this.pointerAddress, temp);
                        return;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.pointerMemory.setData(this.pointerAddress, temp, this.length());
                        return;
                    }
                }
                return;
            }
            long temp = this.place == 0 ? this.value.longValue() : this.value.toLongAtPlace(this.place);
            switch (this.length()) {
                case 1: {
                    this.pointerMemory.setByte(this.pointerAddress, (byte)temp);
                    return;
                }
                case 2: {
                    this.pointerMemory.setShort(this.pointerAddress, (short)temp);
                    return;
                }
                case 4: {
                    this.pointerMemory.setInt(this.pointerAddress, (int)temp);
                    return;
                }
                case 8: {
                    this.pointerMemory.setLong(this.pointerAddress, temp);
                    return;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    this.pointerMemory.setData(this.pointerAddress, temp, this.length());
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in BINARY storage of " + this.getQualifiedCobolName(), (Throwable)e);
            return;
        }
    }

    @Override
    public void fillFromMemoryNow() {
        try {
            int len = this.length();
            if (this.scale > 0) {
                byte temporaryPlace = this.place;
                if (this.place > 0) {
                    temporaryPlace = (byte)(temporaryPlace - this.scale);
                }
                long memoryValue = 0L;
                switch (len) {
                    case 1: {
                        memoryValue = this.pointerMemory.getByte(this.pointerAddress);
                        break;
                    }
                    case 2: {
                        memoryValue = this.pointerMemory.getShort(this.pointerAddress);
                        break;
                    }
                    case 4: {
                        memoryValue = this.pointerMemory.getInt(this.pointerAddress);
                        break;
                    }
                    case 8: {
                        memoryValue = this.pointerMemory.getLong(this.pointerAddress);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        memoryValue = this.pointerMemory.getData(this.pointerAddress, this.length());
                        break;
                    }
                    default: {
                        CobolException.runtimeError("Unknown size of BINARY data.", null);
                    }
                }
                this.value = null;
                if (this.signPosition == 0 && memoryValue < 0L) {
                    switch (len) {
                        case 1: {
                            memoryValue &= 0xFFL;
                            break;
                        }
                        case 2: {
                            memoryValue &= 0xFFFFL;
                            break;
                        }
                        case 3: {
                            memoryValue &= 0xFFFFFFL;
                            break;
                        }
                        case 4: {
                            memoryValue &= 0xFFFFFFFFL;
                            break;
                        }
                        case 5: {
                            memoryValue &= 0xFFFFFFFFFFL;
                            break;
                        }
                        case 6: {
                            memoryValue &= 0xFFFFFFFFFFFFL;
                            break;
                        }
                        case 7: {
                            memoryValue &= 0xFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 8: {
                            this.value = new Bignum(memoryValue &= Long.MAX_VALUE, (int)temporaryPlace);
                            this.value.multiplying(2L);
                        }
                    }
                }
                if (this.value == null) {
                    this.value = new Bignum(memoryValue, (int)temporaryPlace);
                }
                this.numericString = null;
                this.value.movingPoint(this.scale, temporaryPlace);
            } else {
                long memoryValue = 0L;
                switch (len) {
                    case 1: {
                        memoryValue = this.pointerMemory.getByte(this.pointerAddress);
                        break;
                    }
                    case 2: {
                        memoryValue = this.pointerMemory.getShort(this.pointerAddress);
                        break;
                    }
                    case 4: {
                        memoryValue = this.pointerMemory.getInt(this.pointerAddress);
                        break;
                    }
                    case 8: {
                        memoryValue = this.pointerMemory.getLong(this.pointerAddress);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        memoryValue = this.pointerMemory.getData(this.pointerAddress, len);
                        break;
                    }
                    default: {
                        CobolException.runtimeError("Unknown size of BINARY data.", null);
                    }
                }
                this.value = null;
                if (this.signPosition == 0 && memoryValue < 0L) {
                    switch (len) {
                        case 1: {
                            memoryValue &= 0xFFL;
                            break;
                        }
                        case 2: {
                            memoryValue &= 0xFFFFL;
                            break;
                        }
                        case 3: {
                            memoryValue &= 0xFFFFFFL;
                            break;
                        }
                        case 4: {
                            memoryValue &= 0xFFFFFFFFL;
                            break;
                        }
                        case 5: {
                            memoryValue &= 0xFFFFFFFFFFL;
                            break;
                        }
                        case 6: {
                            memoryValue &= 0xFFFFFFFFFFFFL;
                            break;
                        }
                        case 7: {
                            memoryValue &= 0xFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 8: {
                            this.value = new Bignum(memoryValue &= Long.MAX_VALUE, (int)this.place);
                            this.value.multiplying(2L);
                        }
                    }
                }
                if (this.value == null) {
                    this.value = new Bignum(memoryValue, (int)this.place);
                }
                this.numericString = null;
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in BINARY retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    public final Binary toBinary() {
        return this;
    }

    @Override
    public final String toNumericString() {
        this.updateFromMemory(false);
        if (this.numericString != null) {
            return this.numericString;
        }
        if (this.alwaysFlush) {
            return this.value.toString();
        }
        this.numericString = this.value.toString();
        return this.numericString;
    }

    public final String toNumericString(int desiredLength, boolean upToNumPicLength) {
        String result;
        int numLength = upToNumPicLength ? (desiredLength > this.picLength ? this.picLength : desiredLength) : desiredLength;
        this.updateFromMemory(false);
        if (this.signPosition == 4 || this.signPosition == 5) {
            --numLength;
        }
        if ((result = this.value.toString()).charAt(0) == '-') {
            int insertLength;
            if ((insertLength = ++numLength - result.length()) > 0) {
                char[] resultBuffer = new char[numLength];
                resultBuffer[0] = 45;
                int length = result.length();
                for (int i = 1; i <= insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(1, length, resultBuffer, insertLength + 1);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                return new String(resultBuffer);
            }
            if (insertLength < 0) {
                result = result.substring(1 + -insertLength);
            }
        } else {
            int insertLength = numLength - result.length();
            if (insertLength > 0) {
                int length = result.length();
                char[] resultBuffer = new char[numLength];
                for (int i = 0; i < insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(0, length, resultBuffer, insertLength);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                return new String(resultBuffer);
            }
            if (insertLength < 0) {
                result = result.substring(-insertLength);
            }
        }
        return result;
    }

    @Override
    public final boolean isAlphabetic() {
        return false;
    }

    @Override
    public final boolean isAlphabeticUpper() {
        return false;
    }

    @Override
    public final boolean isAlphabeticLower() {
        return false;
    }

    @Override
    public boolean isNumeric(ZonedDescription zonedDescription) {
        return true;
    }

    @Override
    public final String toDisplayString() {
        String result;
        if (this.redefinedFrom != null && this.redefinedFrom instanceof DataPointer) {
            return ((DataPointer)this.redefinedFrom).getPointerAddressAsString();
        }
        if (displayInternal) {
            return this.toString();
        }
        int numLength = (int)Math.ceil(Math.log10(Math.pow(2.0, this.length() * 8)));
        this.updateFromMemory(false);
        if (this.signPosition == 4 || this.signPosition == 5) {
            --numLength;
        }
        if ((result = this.value.toString()).charAt(0) == '-') {
            int insertLength;
            if ((insertLength = ++numLength - result.length()) > 0) {
                char[] resultBuffer = new char[numLength];
                resultBuffer[0] = 45;
                int length = result.length();
                for (int i = 1; i <= insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(1, length, resultBuffer, insertLength + 1);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                return new String(resultBuffer);
            }
        } else {
            int insertLength = numLength - result.length();
            if (insertLength > 0) {
                int length = result.length();
                char[] resultBuffer = new char[numLength];
                for (int i = 0; i < insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(0, length, resultBuffer, insertLength);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                return new String(resultBuffer);
            }
        }
        return result;
    }

    @Override
    public final String toInspectString() {
        return this.toDisplayString();
    }

    @Override
    public Object getObjectParameter() {
        switch (this.length()) {
            case 1: {
                return new Byte(this.toByte());
            }
            case 2: {
                return new Short(this.toShort());
            }
            case 3: 
            case 4: {
                return new Integer(this.toInt());
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new Long(this.toLong());
            }
        }
        return super.getObjectParameter();
    }

    @Override
    public final int getAcceptSize() {
        int result = this.storeSize;
        if (this.place > 0) {
            ++result;
        }
        if (this.signPosition != 0) {
            ++result;
        }
        return result;
    }

    @Override
    public final void calcStoreSize() {
        boolean truncBin = RoundOverflow;
        if (this.signPosition == 0) {
            if (this.picLength > 0) {
                this.storeSize = this.picLength;
                switch (this.length()) {
                    case 1: {
                        if (truncBin && this.storeSize < 3) {
                            this.storeSize = 3;
                        }
                        if (this.storeSize < 3) break;
                        this.storeBinary = true;
                        break;
                    }
                    case 2: {
                        if (truncBin && this.storeSize < 5) {
                            this.storeSize = 5;
                        }
                        if (this.storeSize < 5) break;
                        this.storeBinary = true;
                        break;
                    }
                    case 3: {
                        if (truncBin && this.storeSize < 8) {
                            this.storeSize = 8;
                        }
                        if (this.storeSize < 8) break;
                        this.storeBinary = true;
                        break;
                    }
                    case 4: {
                        if (truncBin && this.storeSize < 10) {
                            this.storeSize = 10;
                        }
                        if (this.storeSize < 10) break;
                        this.storeBinary = true;
                        break;
                    }
                    case 5: {
                        if (truncBin && this.storeSize < 13) {
                            this.storeSize = 13;
                        }
                        if (this.storeSize < 13) break;
                        this.storeBinary = true;
                        break;
                    }
                    case 6: {
                        if (truncBin && this.storeSize < 15) {
                            this.storeSize = 15;
                        }
                        if (this.storeSize < 15) break;
                        this.storeBinary = true;
                        break;
                    }
                    case 7: {
                        if (truncBin && this.storeSize < 17) {
                            this.storeSize = 17;
                        }
                        if (this.storeSize < 17) break;
                        this.storeBinary = true;
                        break;
                    }
                    case 8: {
                        if (truncBin && this.storeSize < 20) {
                            this.storeSize = 20;
                        }
                        if (this.storeSize < 20) break;
                        this.storeBinary = true;
                    }
                }
                return;
            }
            this.storeBinary = true;
            switch (this.length()) {
                case 1: {
                    this.storeSize = 3;
                    return;
                }
                case 2: {
                    this.storeSize = 5;
                    return;
                }
                case 3: {
                    this.storeSize = 8;
                    return;
                }
                case 4: {
                    this.storeSize = 10;
                    return;
                }
                case 5: {
                    this.storeSize = 13;
                    return;
                }
                case 6: {
                    this.storeSize = 15;
                    return;
                }
                case 7: {
                    this.storeSize = 17;
                    return;
                }
                case 8: {
                    this.storeSize = 20;
                    return;
                }
            }
            return;
        }
        if (this.picLength > 0) {
            this.storeSize = this.picLength;
            switch (this.length()) {
                case 1: {
                    if (truncBin && this.storeSize < 3) {
                        this.storeSize = 3;
                    }
                    if (this.storeSize < 3) break;
                    this.storeBinary = true;
                    break;
                }
                case 2: {
                    if (truncBin && this.storeSize < 5) {
                        this.storeSize = 5;
                    }
                    if (this.storeSize < 5) break;
                    this.storeBinary = true;
                    break;
                }
                case 3: {
                    if (truncBin && this.storeSize < 7) {
                        this.storeSize = 7;
                    }
                    if (this.storeSize < 7) break;
                    this.storeBinary = true;
                    break;
                }
                case 4: {
                    if (truncBin && this.storeSize < 10) {
                        this.storeSize = 10;
                    }
                    if (this.storeSize < 10) break;
                    this.storeBinary = true;
                    break;
                }
                case 5: {
                    if (truncBin && this.storeSize < 12) {
                        this.storeSize = 12;
                    }
                    if (this.storeSize < 12) break;
                    this.storeBinary = true;
                    break;
                }
                case 6: {
                    if (truncBin && this.storeSize < 15) {
                        this.storeSize = 15;
                    }
                    if (this.storeSize < 15) break;
                    this.storeBinary = true;
                    break;
                }
                case 7: {
                    if (truncBin && this.storeSize < 17) {
                        this.storeSize = 17;
                    }
                    if (this.storeSize < 17) break;
                    this.storeBinary = true;
                    break;
                }
                case 8: {
                    if (truncBin && this.storeSize < 19) {
                        this.storeSize = 19;
                    }
                    if (this.storeSize < 19) break;
                    this.storeBinary = true;
                }
            }
            return;
        }
        this.storeBinary = true;
        switch (this.length()) {
            case 1: {
                this.storeSize = 3;
                return;
            }
            case 2: {
                this.storeSize = 5;
                return;
            }
            case 3: {
                this.storeSize = 7;
                return;
            }
            case 4: {
                this.storeSize = 10;
                return;
            }
            case 5: {
                this.storeSize = 12;
                return;
            }
            case 6: {
                this.storeSize = 15;
                return;
            }
            case 7: {
                this.storeSize = 17;
                return;
            }
            case 8: {
                this.storeSize = 19;
                return;
            }
        }
    }

    @Override
    public int getArgumentType() {
        return this.signPosition == 0 ? 12 : 11;
    }

    @Override
    public byte[] getArgument() {
        this.updateFromMemory(false);
        return ConvertData.nativeLongToGivenBytes(this.value.longValue(), this.length());
    }

    @Override
    public void setArgument(byte[] data) {
        this.setDirtyNoFill();
        this.value.make(ConvertData.nativeBytesToLong(data));
        this.updateToMemory();
    }

    @Override
    public int getType() {
        return this.getBasicType(48);
    }

    static {
        String displaytype = RuntimeEnvironment.getGlobalParameter("display.5");
        if (displaytype != null && displaytype.length() > 0) {
            switch (displaytype.charAt(0)) {
                case 'I': 
                case 'i': {
                    displayInternal = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    displayExternal = true;
                }
            }
        }
        truncateBinaryUnsigned = new Bignum[]{new Bignum(255L), new Bignum(65535L), new Bignum(0xFFFFFFL), new Bignum(0xFFFFFFFFL), new Bignum(0xFFFFFFFFFFL), new Bignum(0xFFFFFFFFFFFFL), new Bignum(0xFFFFFFFFFFFFFFL), new Bignum("18446744073709551615")};
        truncateBinaryPositive = new Bignum[]{new Bignum(127L), new Bignum(32767L), new Bignum(0x7FFFFFL), new Bignum((long)Integer.MAX_VALUE), new Bignum(0x7FFFFFFFFFL), new Bignum(0x7FFFFFFFFFFFL), new Bignum(0x7FFFFFFFFFFFFFL), new Bignum(Long.MAX_VALUE)};
        truncateBinaryNegative = new Bignum[]{new Bignum(-128L), new Bignum(-32768L), new Bignum(-8388608L), new Bignum((long)Integer.MIN_VALUE), new Bignum(-549755813888L), new Bignum(-140737488355328L), new Bignum(-36028797018963968L), new Bignum(Long.MIN_VALUE)};
    }
}

