/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Numeric;

public class Bitmask {
    public static byte andByte(byte source, byte target) {
        return (byte)(source & target);
    }

    public static byte orByte(byte source, byte target) {
        return (byte)(source | target);
    }

    public static byte xorByte(byte source, byte target) {
        return (byte)(source ^ target);
    }

    public static byte eqByte(byte source, byte target) {
        return (byte)(~(source ^ target));
    }

    public static byte impByte(byte source, byte target) {
        return (byte)(source & target | ~source);
    }

    public static byte notByte(byte source) {
        return ~source;
    }

    public static long andLong(long source, long target) {
        return source & target;
    }

    public static long orLong(long source, long target) {
        return source | target;
    }

    public static long xorLong(long source, long target) {
        return source ^ target;
    }

    public static long eqLong(long source, long target) {
        return source ^ target ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long impLong(long source, long target) {
        return source & target | source ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long notLong(long source) {
        return source ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static Numeric and(Numeric sourceNumeric, Numeric targetNumeric) {
        long source = sourceNumeric.toLong();
        long target = targetNumeric.toLong();
        return new Numeric(Bitmask.andLong(source, target));
    }

    public static Numeric or(Numeric sourceNumeric, Numeric targetNumeric) {
        long source = sourceNumeric.toLong();
        long target = targetNumeric.toLong();
        return new Numeric(Bitmask.orLong(source, target));
    }

    public static Numeric xor(Numeric sourceNumeric, Numeric targetNumeric) {
        long source = sourceNumeric.toLong();
        long target = targetNumeric.toLong();
        return new Numeric(Bitmask.xorLong(source, target));
    }

    public static Numeric eq(Numeric sourceNumeric, Numeric targetNumeric) {
        long source = sourceNumeric.toLong();
        long target = targetNumeric.toLong();
        return new Numeric(Bitmask.eqLong(source, target));
    }

    public static Numeric imp(Numeric sourceNumeric, Numeric targetNumeric) {
        long source = sourceNumeric.toLong();
        long target = targetNumeric.toLong();
        return new Numeric(Bitmask.impLong(source, target));
    }

    public static Numeric not(Numeric sourceNumeric) {
        long source = sourceNumeric.toLong();
        return new Numeric(Bitmask.notLong(source));
    }
}

