/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.Numeric;

public class Comp2MVS
extends Comp2 {
    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.Comp2MVS";
    }

    @Override
    public final String getUsage() {
        return "Comp2MVS";
    }

    @Override
    public final void fillFromMemoryNow() {
        try {
            this.flushToMemory();
            this.doubleValue = this.pointerMemory.getDouble370(this.pointerAddress);
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-2-MVS retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            this.pointerMemory.setDouble370(this.pointerAddress, this.doubleValue);
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-2-MVS storage of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final int compare(Numeric param) {
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        double paramn = param.toDouble();
        long paraml = Double.doubleToLongBits(paramn);
        paramn = Double.longBitsToDouble(paraml = ConvertData.d370toIEEE(ConvertData.dIEEEto370(paraml)));
        if (this.doubleValue < paramn) {
            return -1;
        }
        if (this.doubleValue > paramn) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getType() {
        return this.getBasicType(880);
    }

    @Override
    public void initData() {
        this.pointerMemory.setDouble370(this.pointerAddress, 0.0);
    }
}

