/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.debug.DataWatchPoint;
import com.heirloomcomputing.ecs.api.ICallTarget;
import com.heirloomcomputing.ecs.api.ICallTarget2;
import com.heirloomcomputing.ecs.api.ICancelTarget;
import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.api.IEnvironment;
import com.heirloomcomputing.ecs.api.IModule;
import com.heirloomcomputing.ecs.api.IProgramEnvironment;
import com.heirloomcomputing.ecs.api.ISpecialNames;
import com.heirloomcomputing.ecs.exception.EcAll;
import com.heirloomcomputing.ecs.exception.EcFlowImpStopInvalid;
import com.heirloomcomputing.ecs.exception.EcProgram;
import com.heirloomcomputing.ecs.exception.EcProgramPtrNull;
import com.heirloomcomputing.ecs.exception.EcProgramResources;
import com.heirloomcomputing.ecs.exec.AConnect;
import com.heirloomcomputing.ecs.exec.AS400Connect;
import com.heirloomcomputing.ecs.exec.AbendException;
import com.heirloomcomputing.ecs.exec.AcceptSpecial;
import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.CodePageCollation;
import com.heirloomcomputing.ecs.exec.Codepage;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.Display;
import com.heirloomcomputing.ecs.exec.Exec;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.ICallable;
import com.heirloomcomputing.ecs.exec.ICallableProgram;
import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.ICobolInterface;
import com.heirloomcomputing.ecs.exec.ICobolProgram;
import com.heirloomcomputing.ecs.exec.IContextCall;
import com.heirloomcomputing.ecs.exec.IInitialProgram;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.IPCException;
import com.heirloomcomputing.ecs.exec.IResidentProgram;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.MPEIntrinsic;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.NativeCall;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Section;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.SqlContext;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.UnwindException;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.heirloomcomputing.ecs.ezasoket.EzasoketContext;
import com.heirloomcomputing.ecs.libcall.CONDITION_CODE;
import com.heirloomcomputing.etp.transaction.api.TransactionEnvironmentLean;
import com.heirloomcomputing.etp.transaction.exception.AIDException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;

public class Context
implements IProgramEnvironment,
ISpecialNames {
    public static Context activeContext;
    public static int appReturnCode;
    public static boolean ExternalsSessionSafe;
    public static boolean ExternalsSet;
    public static final String LIBCALL_PACKAGE = "com.heirloomcomputing.ecs.libcall.";
    public static final String CALL_MESSAGE_VERIFY = "Corrupted class file.  Check for paragraph >64K or bad file transfer.";
    public static final String CALL_MESSAGE_MEMORY = "Out of Memory.  Use -Xms#m -Xmx#m on java command line for # MB.";
    public static final int CALL_OK = 0;
    public static final int CALL_PROGRAM_FILE_MISSING_OR_INACCESSIBLE = 1;
    public static final int CALL_FILE_NOT_A_COBOL_PROGRAM = 2;
    public static final int CALL_CORRUPTED_PROGRAM_FILE = 3;
    public static final int CALL_INADEQUATE_MEMORY_AVAILABLE_TO_LOAD_PROGRAM = 4;
    public static final int CALL_UNSUPPORTED_OBJECT_CODE_VERSION_NUMBER = 5;
    public static final int CALL_RECURSIVE_CALL_OF_A_PROGRAM = 6;
    public static final int PARAMS_RIGHT_TO_LEFT = 0;
    public static final int PARAMS_LEFT_TO_RIGHT = 1;
    public static final int PARAMS_REMOVED_FROM_STACK_BY_CALLER = 0;
    public static final int PARAMS_REMOVED_FROM_STACK_BY_CALLED = 2;
    public static final int RETURN_CODE_UPDATED_ON_EXIT = 0;
    public static final int RETURN_CODE_NOT_UPDATED_ON_EXIT = 4;
    public static final int NORMAL_LINKING_BEHAVIOR = 0;
    public static final int CALL_RESOLVED_AT_LINK_TIME = 8;
    public static final int OS2_OPTLINK = 16;
    public static final int THUNKED_TO_16_BIT = 32;
    public static final int NT_STDCALL = 64;
    public static final int CC_UNSAFE = 128;
    public static final int THREAD = 256;
    public static final int SESSION = 512;
    public static final int EVENT = 1024;
    public static final int INTRINSIC = 2048;
    public static final int PROGRAM = 4096;
    public static final int SERVICE = 8192;
    public static final int EJB_CLIENT = 16384;
    public static final int COM_CLIENT = 32768;
    public static final int CICS_CLIENT = 65536;
    public static final int IMS_CLIENT = 131072;
    public static final int RPC_CLIENT = 262144;
    public static final int MAX_THREADS = 128;
    private static final String EXTERNAL_IDENTIFIER_KEY = "*~~*";
    private static final String EXTERNAL_FILE_IDENTIFIER_KEY = "*!!*";
    private static final TreeSet<String> forbidden;
    private static final TreeSet<String> libcall;
    private static final String FILES_KEY = ".files.";
    private static final Map<String, Class<?>> stringToClassMap;
    static final Map<String, Object> instancesLoadMap;
    private static final Numeric performResult;
    static final Vector<Integer> uniqueThreadNumbers;
    static final Map<String, String> quickMatch;
    static final Map<String, Class<?>> classesLoad;
    static final Map<String, MPEIntrinsic> mpeIntrinsics;
    static int highestAllocatedUnique;
    private static boolean isOnAS400;
    private static boolean checkedForAS400;
    private static String codeSuffix;
    private static boolean codeSuffixIsAcu;
    private static boolean supportsCodeMapping;
    private static int codeCase;
    private static boolean defsys;
    private static Map<String, Class<?>> contextCallClasses;
    private static Variable SHIFT_OUT;
    private static Variable SHIFT_IN;
    private static Variable SORT_CONTROL;
    private static Variable SORT_MESSAGE;
    private static Binary SORT_CORE_SIZE;
    private static Binary SORT_FILE_SIZE;
    private static Binary SORT_MODE_SIZE;
    private static Binary SORT_RETURN;
    private static Binary TALLY;
    private Map<String, Object> programContextInSession;
    private static Map<String, Object> globalExternalIdentifiers;
    private Map<String, Object> externalIdentifiers;
    private static Map<String, Object> globalExternalFileIdentifiers;
    private Map<String, Object> externalFileIdentifiers;
    protected Context parent;
    protected Object program;
    protected String programName;
    protected boolean entryPointsDeclared;
    private Object transactionEnvironment;
    private Hashtable<String, Object> jmsConnections;
    private Object currentJmsConnection;
    private SqlContext sqlContext;
    private EzasoketContext ezasoketContext;
    private Numeric handleVariable;
    private Map<Variable, String> contextWatchpointMap = null;
    private Section shr;
    private Section fil;
    private Section wrk;
    private Section cns;
    private Section scr;
    private Section cmn;
    private Section rpt;
    private Section lcl;
    private Section lnk;
    private Section prc;
    private Hashtable<String, Object> shrTable;
    private Hashtable<String, Object> filTable;
    private Hashtable<String, Object> wrkTable;
    private Hashtable<String, Object> cnsTable;
    private Hashtable<String, Object> scrTable;
    private Hashtable<String, Object> cmnTable;
    private Hashtable<String, Object> rptTable;
    private Hashtable<String, Object> lclTable;
    private Hashtable<String, Object> lnkTable;
    private Map<Object, Object> lnkArrayTable;
    private String lnkPointerMemory;
    private Vector<Section> wrks;
    private Vector<Section> lnks;
    private Vector<Hashtable<String, Object>> wrksTable;
    private Vector<Hashtable<String, Object>> lnksTable;
    private boolean programIsCalled;
    private ThreadQueue associatedThread;
    private int entryParagraph;
    private ClassLoader classLoader;
    private boolean classLoaderDiscovered;
    private Throwable lastThrowable;
    private Throwable exceptionObject;
    private int currentThread = -1;
    private String packageName;
    public String eventData = "";
    public Object eventObject;
    private Display returnCode;
    private Numeric conditionCode;
    private int argumentPosition = 1;
    private String currentEnvironmentValue;
    private String currentEnvironmentName;
    private static char globalFileCharacter;
    public static final Object IGNORE_CONDITION_OBJECT;
    private Hashtable<String, Object> exceptionHandler;
    private Vector<Hashtable<String, Object>> exceptionHandlers;
    private static final boolean HANDLE_ERROR_CATCHALL_ON;
    private String abcode;
    private String abendProgram;
    private boolean abendHandlerCancelled;
    private ProcedurePointer abendHandlerLabel;
    private String abendHandlerLink;
    private int handlingAbend;
    public static final boolean ABEND_HANDLER = false;
    public static final boolean NO_ABEND_HANDLER = true;
    public static final boolean DUMP = true;
    public static final boolean NO_DUMP = false;
    public static final String ALPHABET_EBCDIC = "EBCDIC";
    public static final String EBCDIC_CODEPAGE_DIRECTIVE = "ebcdic_codepage";
    private Numeric xmlCode;
    private Variable xmlEvent;
    private Variable xmlText;
    private Variable xmlNText;
    private static int callLastFailed;
    private static int callPriorFailed;

    @Override
    public EzasoketContext getEzasoketContext() {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("ezasoketContext=" + this.ezasoketContext + ".");
        }
        if (this.ezasoketContext == null) {
            if (this.isExecutingInTransactionEnvironment()) {
                Object transObj = this.getTransactionEnvironment();
                if (transObj instanceof TransactionEnvironmentLean) {
                    Object obj = ((TransactionEnvironmentLean)transObj).getEzasoketContext();
                    if (obj instanceof EzasoketContext) {
                        this.ezasoketContext = (EzasoketContext)obj;
                    } else {
                        this.ezasoketContext = new EzasoketContext();
                        ((TransactionEnvironmentLean)transObj).setEzasoketContext((Object)this.ezasoketContext);
                    }
                }
            } else {
                this.ezasoketContext = new EzasoketContext();
            }
        }
        return this.ezasoketContext;
    }

    public SqlContext getExistingSqlContext() {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("sqlContext=" + this.sqlContext + ".");
        }
        return this.sqlContext != null ? this.sqlContext : null;
    }

    public SqlContext getSqlContext() {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("sqlContext=" + this.sqlContext + ".");
        }
        return this.sqlContext != null ? this.sqlContext : (this.sqlContext = new SqlContext());
    }

    public void setSqlConnection(String connectionName, Connection con) throws SQLException {
        if (connectionName != null) {
            this.getSqlContext().connect(connectionName, con, null, null, null, null);
        } else {
            this.setSqlConnection(con);
        }
    }

    public void setSqlConnection(Connection con) throws SQLException {
        this.getSqlContext().setConnection(con);
    }

    public Connection getSqlConnection() {
        try {
            return this.getSqlContext().getConnection();
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(Exception e) " + e.getMessage());
            }
            return null;
        }
    }

    public String getDefaultSqlDriver() {
        return this.getParameter("sqldriver") == null ? "sun.jdbc.odbc.JdbcOdbcDriver" : this.getParameter("sqldriver");
    }

    public ThreadQueue getAssociatedThreadQueue() {
        if (this.associatedThread == null) {
            this.associatedThread = new ThreadQueue(null, (Runnable)this.program, this.programName);
        }
        return this.associatedThread;
    }

    public final int getEntryParagraph() {
        return this.entryParagraph;
    }

    public void setEntryParagraph(int value) {
        this.entryParagraph = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader getClassLoader() {
        if (this.classLoaderDiscovered) {
            return this.classLoader;
        }
        try {
            if (this.program != null) {
                Object object = this.program;
                synchronized (object) {
                    this.classLoaderDiscovered = true;
                    this.classLoader = this.program.getClass().getClassLoader();
                    return this.classLoader;
                }
            }
            this.classLoader = this.getClass().getClassLoader();
            return this.classLoader;
        }
        catch (Exception t) {
            try {
                this.classLoader = this.getClass().getClassLoader();
                return this.classLoader;
            }
            catch (Exception t2) {
                this.classLoaderDiscovered = true;
                this.classLoader = null;
                return null;
            }
        }
    }

    protected Class<?> forName(String name) throws ClassNotFoundException, LinkageError {
        try {
            return Class.forName(name, false, this.getClassLoader());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return Class.forName(name);
        }
    }

    public Throwable getThrowable() {
        return this.lastThrowable;
    }

    public Object getThrowableObject() {
        return this.lastThrowable;
    }

    public void setThrowable(Throwable t) {
        this.lastThrowable = t;
        CobolException.dumpCobolStack(t);
        t.printStackTrace();
    }

    public void setThrowable(String name, Throwable t) {
        if (name.equalsIgnoreCase("last")) {
            this.lastThrowable = t;
        }
        CobolException.dumpCobolStack(t);
        t.printStackTrace();
    }

    public Throwable getThrowable(String name) {
        if (name.equalsIgnoreCase("last")) {
            return this.lastThrowable;
        }
        return null;
    }

    public Throwable getExceptionObject() {
        return this.exceptionObject;
    }

    public void setExceptionObject(Throwable t) {
        this.exceptionObject = t;
    }

    public boolean openFailure(boolean enable) {
        if (!enable) {
            enable = this.isParameter("DIALOG.OPENFAIL");
        }
        if (enable) {
            return this.openFailure();
        }
        return false;
    }

    public boolean openFailure() {
        return this.openFailure((String)null);
    }

    public boolean openFailure(boolean enable, String message) {
        if (!enable) {
            enable = this.isParameter("DIALOG.OPENFAIL");
        }
        if (enable) {
            return this.openFailure(message);
        }
        return false;
    }

    public boolean openFailure(String message) {
        if (message == null) {
            try {
                message = ResourceManager.get("dialog.open_failure", "Error opening file");
            }
            catch (Exception formingErrorMessage) {
                message = "Error opening file";
            }
        }
        if (this.transactionEnvironment != null) {
            CobolException.runtimeError(message, null);
        } else {
            try {
                CobolException.runtimeError(message, null);
            }
            catch (Exception anyException) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch(Exception anyException)");
                    anyException.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    public boolean openFailure(boolean enable, Object object) {
        if (!enable) {
            enable = this.isParameter("DIALOG.OPENFAIL");
        }
        if (enable) {
            return this.openFailure(object);
        }
        return false;
    }

    public boolean openFailure(Object object) {
        String message;
        try {
            message = ResourceManager.get("dialog.open_failure", "Error opening file");
            if (object != null) {
                message = message + " " + object;
            }
        }
        catch (Exception formingErrorMessage) {
            message = "Error opening file";
        }
        return this.openFailure(message);
    }

    public boolean openFailure(boolean enable, basicFile file2) {
        if (!enable) {
            enable = this.isParameter("DIALOG.OPENFAIL");
        }
        if (enable) {
            return this.openFailure(file2);
        }
        return false;
    }

    public boolean openFailure(basicFile file2) {
        String message;
        try {
            message = ResourceManager.get("dialog.open_failure", "Error opening file");
            if (file2 != null) {
                message = message + " '" + file2.getFilename() + "'";
            }
        }
        catch (Exception formingErrorMessage) {
            message = "Error opening file";
        }
        return this.openFailure(message);
    }

    public boolean callFailure(boolean enable, ProcedurePointer procPointer) {
        if (!enable) {
            enable = this.isParameter("DIALOG.CALLFAIL");
        }
        String lProgramName = procPointer.getName();
        if (enable) {
            return this.callFailure(lProgramName);
        }
        return false;
    }

    public boolean callFailure(boolean enable, String calledProgramName) {
        if (!enable) {
            enable = this.isParameter("DIALOG.CALLFAIL");
        }
        if (enable) {
            return this.callFailure(calledProgramName);
        }
        return false;
    }

    public boolean callFailure(String calledProgramName) {
        return this.callFailure(this.lastThrowable, calledProgramName);
    }

    public boolean callFailure(boolean enable, String calledProgramName, String message) {
        if (!enable) {
            enable = this.isParameter("DIALOG.CALLFAIL");
        }
        if (enable) {
            return this.callFailure(calledProgramName, message);
        }
        return false;
    }

    public boolean callFailure(String calledProgramName, String message) {
        return this.callFailure(this.lastThrowable, calledProgramName, message);
    }

    public boolean callFailure(boolean enable, Throwable exception, String calledProgramName) {
        if (!enable) {
            enable = this.isParameter("DIALOG.CALLFAIL");
        }
        if (enable) {
            return this.callFailure(exception, calledProgramName);
        }
        return false;
    }

    public boolean callFailure(Throwable exception, String calledProgramName) {
        return this.callFailure(exception, calledProgramName, null);
    }

    public boolean callFailure(boolean enable, Throwable throwable, String calledProgramName, String message) {
        if (!enable) {
            enable = this.isParameter("DIALOG.CALLFAIL");
        }
        if (enable) {
            return this.callFailure(throwable, calledProgramName, message);
        }
        return false;
    }

    public boolean callFailure(Throwable throwable, String calledProgramName, String message) {
        if (calledProgramName == null) {
            calledProgramName = "COBOL Program";
        }
        if (message == null) {
            message = ResourceManager.get("dialog.error_calling", "Error calling") + " '" + calledProgramName + "'";
        }
        if (throwable instanceof IPCException) {
            Throwable nestedException;
            IPCException ipcException = (IPCException)throwable;
            String ipcMessage = ipcException.getMessage();
            if (ipcMessage != null) {
                message = message + ": " + ipcMessage;
            }
            if ((nestedException = ipcException.getIPCException()) != null) {
                throwable = nestedException;
            }
        }
        if (this.transactionEnvironment != null) {
            CobolException.runtimeError(message, throwable);
        } else {
            try {
                CobolException.runtimeError(message, throwable);
            }
            catch (Exception anyException) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch(Exception anyException)");
                    anyException.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    public int getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(int value) {
        this.currentThread = value;
    }

    public String toString() {
        StringBuffer result;
        block22: {
            result = new StringBuffer();
            try {
                String linesep;
                block21: {
                    linesep = System.getProperty("line.separator");
                    if (linesep == null) {
                        linesep = "\n";
                    }
                    result.append(linesep).append(linesep);
                    if (this.programIsCalled) {
                        result.append("PROGRAM IS CALLED SUBPROGRAM").append(linesep);
                    }
                    if (this.returnCode != null) {
                        result.append("RETURN-CODE = ").append(this.returnCode.toInt()).append(linesep);
                    }
                    if (this.conditionCode != null) {
                        result.append("CONDITION-CODE = ").append(this.conditionCode.toInt()).append(linesep);
                    }
                    try {
                        if (this.eventData != null && !this.eventData.equals("")) {
                            result.append("EVENT DATA = {").append(this.eventData).append("}").append(linesep);
                        }
                        if (this.eventObject != null) {
                            result.append("EVENT OBJECT = {").append(this.eventObject).append("}").append(linesep);
                        }
                    }
                    catch (Exception eventException) {
                        if (!LogSetup.IS_LOGGING_INFO) break block21;
                        LogSetup.LOGGER.info("catch(Exception eventException)");
                        eventException.printStackTrace();
                    }
                }
                if (this.xmlCode != null) {
                    result.append("XML-CODE: ").append(this.xmlCode.toInt()).append(linesep);
                }
                if (this.xmlEvent != null) {
                    result.append("XML-EVENT: '").append(this.xmlEvent).append('\'').append(linesep);
                }
                if (this.xmlText != null) {
                    result.append("XML-TEXT: '").append(this.xmlText).append('\'').append(linesep);
                }
                if (this.xmlNText != null) {
                    result.append("XML-NTEXT: ").append(this.xmlNText).append('\'').append(linesep);
                }
                result.append(linesep);
                if (this.shr != null) {
                    result.append("HAS SHARED-STORAGE SECTION").append(linesep);
                }
                if (this.fil != null) {
                    result.append("HAS FILE SECTION").append(linesep);
                }
                if (this.wrk != null || this.wrks != null) {
                    result.append("HAS WORKING-STORAGE SECTION").append(linesep);
                }
                if (this.scr != null) {
                    result.append("HAS SCREEN SECTION").append(linesep);
                }
                if (this.lcl != null) {
                    result.append("HAS LOCAL-STORAGE SECTION").append(linesep);
                }
                if (this.lnk != null || this.lnks != null) {
                    result.append("HAS LINKAGE SECTION").append(linesep);
                }
                if (this.cns != null) {
                    result.append("HAS CONSTANT SECTION").append(linesep);
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block22;
                LogSetup.LOGGER.info("catch(Exception e)");
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    public Context() {
        this(null, "default", null);
    }

    public Context(String calledProgramName) {
        this(null, calledProgramName, null);
    }

    public Context(Context baseContext) {
        this(baseContext, baseContext.programName, baseContext.program);
    }

    public Context(Context baseContext, String calledProgramName) {
        this(baseContext, calledProgramName, baseContext.program);
    }

    public Context(Context baseContext, String calledProgramName, Object calledProgram) {
        this.populateFromParent(baseContext, calledProgramName, calledProgram);
    }

    public void populateFromParent(Context baseContext) {
        this.populateFromParent(baseContext, baseContext.programName, baseContext.program);
    }

    public void populateFromParent(Context baseContext, String calledProgramName, Object calledProgram) {
        this.program = calledProgram;
        if (baseContext != null) {
            this.returnCode = baseContext.returnCode;
            this.programIsCalled = baseContext.programIsCalled;
            this.programContextInSession = baseContext.programContextInSession;
            this.externalIdentifiers = baseContext.externalIdentifiers;
            this.externalFileIdentifiers = baseContext.externalFileIdentifiers;
            this.setParent(baseContext);
            this.sqlContext = baseContext.sqlContext;
            this.entryPointsDeclared = baseContext.entryPointsDeclared;
            this.lnkPointerMemory = baseContext.lnkPointerMemory;
            this.lnkArrayTable = baseContext.lnkArrayTable;
            this.shr = baseContext.shr;
            this.shrTable = baseContext.shrTable;
            this.fil = baseContext.fil;
            this.filTable = baseContext.filTable;
            this.wrk = baseContext.wrk;
            this.wrkTable = baseContext.wrkTable;
            this.cns = baseContext.cns;
            this.cnsTable = baseContext.cnsTable;
            this.scr = baseContext.scr;
            this.scrTable = baseContext.shrTable;
            this.cmn = baseContext.cmn;
            this.cmnTable = baseContext.cmnTable;
            this.rpt = baseContext.rpt;
            this.rptTable = baseContext.rptTable;
            this.lcl = baseContext.lcl;
            this.lclTable = baseContext.lclTable;
            this.lnk = baseContext.lnk;
            this.lnkTable = baseContext.lnkTable;
            this.wrks = baseContext.wrks;
            this.wrksTable = baseContext.wrksTable;
            this.lnks = baseContext.lnks;
            this.lnksTable = baseContext.lnksTable;
            this.transactionEnvironment = baseContext.transactionEnvironment;
            if (this.transactionEnvironment != null) {
                RuntimeEnvironment.setGlobalParameter("JVM-ERROR-EXIT", "0");
            }
            this.programName = calledProgramName == null ? baseContext.programName : calledProgramName;
        } else {
            this.programName = calledProgramName;
            this.programContextInSession = new Hashtable<String, Object>();
            this.externalIdentifiers = new Hashtable<String, Object>();
            this.externalFileIdentifiers = new Hashtable<String, Object>();
            this.returnCode = new Display("99999", "0");
        }
        this.resolveTransactionEnvironmentSqlConnection();
        this.handleVariable = new Numeric("9(10)", Integer.toString(this.hashCode()));
    }

    public void setupContext(Context baseContext, String calledProgramName, Object calledProgram) {
        this.program = calledProgram;
        if (baseContext != null) {
            this.returnCode = baseContext.returnCode;
            this.programIsCalled = baseContext.programIsCalled;
            this.programContextInSession = baseContext.programContextInSession;
            this.externalIdentifiers = baseContext.externalIdentifiers;
            this.externalFileIdentifiers = baseContext.externalFileIdentifiers;
            if (baseContext != this) {
                this.setParent(baseContext);
            }
            this.sqlContext = baseContext.sqlContext;
            this.entryPointsDeclared = baseContext.entryPointsDeclared;
            this.lnkPointerMemory = baseContext.lnkPointerMemory;
            this.lnkArrayTable = baseContext.lnkArrayTable;
            this.shr = baseContext.shr;
            this.shrTable = baseContext.shrTable;
            this.fil = baseContext.fil;
            this.filTable = baseContext.filTable;
            this.wrk = baseContext.wrk;
            this.wrkTable = baseContext.wrkTable;
            this.cns = baseContext.cns;
            this.cnsTable = baseContext.cnsTable;
            this.scr = baseContext.scr;
            this.scrTable = baseContext.shrTable;
            this.cmn = baseContext.cmn;
            this.cmnTable = baseContext.cmnTable;
            this.rpt = baseContext.rpt;
            this.rptTable = baseContext.rptTable;
            this.lcl = baseContext.lcl;
            this.lclTable = baseContext.lclTable;
            this.lnk = baseContext.lnk;
            this.lnkTable = baseContext.lnkTable;
            this.wrks = baseContext.wrks;
            this.wrksTable = baseContext.wrksTable;
            this.lnks = baseContext.lnks;
            this.lnksTable = baseContext.lnksTable;
            this.transactionEnvironment = baseContext.transactionEnvironment;
            if (this.transactionEnvironment != null) {
                RuntimeEnvironment.setGlobalParameter("JVM-ERROR-EXIT", "0");
            }
            this.programName = calledProgramName == null ? baseContext.programName : calledProgramName;
        } else {
            this.programName = calledProgramName;
            this.programIsCalled = false;
            this.programContextInSession = new Hashtable<String, Object>();
            this.externalIdentifiers = new Hashtable<String, Object>();
            this.externalFileIdentifiers = new Hashtable<String, Object>();
            this.setParent(null);
        }
        this.resolveTransactionEnvironmentSqlConnection();
    }

    private void resolveTransactionEnvironmentSqlConnection() {
        if (this.transactionEnvironment != null) {
            try {
                Connection con = ((TransactionEnvironmentLean)this.transactionEnvironment).getSqlConnection("default");
                this.setSqlConnection("default", con);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Context create(Context context) {
        return new Context(context);
    }

    public Context create() {
        return new Context();
    }

    public void setPackage(String packageName) {
        if (packageName == null) {
            return;
        }
        if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        this.packageName = packageName;
    }

    public Object program(String name) {
        Context find = this.parent;
        while (find != null) {
            if (find.programName == name) {
                return find.program;
            }
            find = find.parent;
        }
        return null;
    }

    public Object programEquals(String name) {
        Context find = this.parent;
        while (find != null) {
            if (find.programName.equals(name)) {
                return find.program;
            }
            find = find.parent;
        }
        return null;
    }

    public Object programEqualsIgnoreCase(String name) {
        Context find = this.parent;
        while (find != null) {
            if (find.programName.equalsIgnoreCase(name)) {
                return find.program;
            }
            find = find.parent;
        }
        return null;
    }

    public void setTransactionEnvironment(Object transactionEnvironment) {
        this.transactionEnvironment = transactionEnvironment;
        if (transactionEnvironment != null) {
            RuntimeEnvironment.setGlobalParameter("JVM-ERROR-EXIT", "0");
        }
    }

    public Object getTransactionEnvironment() {
        return this.transactionEnvironment;
    }

    @Override
    public boolean isExecutingInTransactionEnvironment() {
        return this.transactionEnvironment != null;
    }

    public Object getProgram() {
        return this.program;
    }

    public boolean isProgramCalled() {
        return this.programIsCalled;
    }

    public void setProgramCalled(boolean state) {
        this.programIsCalled = state;
    }

    public void setProgramCalled() {
        this.programIsCalled = true;
        this.getReturnCode().move(0);
    }

    public Context defaultThread() {
        this.lcl = null;
        this.lclTable = null;
        return this;
    }

    public Context defaultInvoke() {
        this.lcl = null;
        this.lclTable = null;
        return this;
    }

    public Context defaultSession() {
        this.fil = null;
        this.filTable = null;
        this.wrk = null;
        this.wrkTable = null;
        this.cns = null;
        this.cnsTable = null;
        this.scr = null;
        this.scrTable = null;
        this.cmn = null;
        this.cmnTable = null;
        this.rpt = null;
        this.rptTable = null;
        this.lcl = null;
        this.lclTable = null;
        this.lnk = null;
        this.lnkTable = null;
        this.wrks = null;
        this.wrksTable = null;
        this.lnks = null;
        this.lnksTable = null;
        return this;
    }

    public Context defaultData() {
        this.lnkPointerMemory = null;
        this.lnkArrayTable = null;
        this.shr = null;
        this.shrTable = null;
        this.fil = null;
        this.filTable = null;
        this.wrk = null;
        this.wrkTable = null;
        this.cns = null;
        this.cnsTable = null;
        this.scr = null;
        this.scrTable = null;
        this.cmn = null;
        this.cmnTable = null;
        this.rpt = null;
        this.rptTable = null;
        this.lcl = null;
        this.lclTable = null;
        this.lnk = null;
        this.lnkTable = null;
        this.wrks = null;
        this.wrksTable = null;
        this.lnks = null;
        this.lnksTable = null;
        return this;
    }

    public Context defaultCall() {
        this.lcl = null;
        this.lclTable = null;
        return this;
    }

    public Context defaultRecursive() {
        this.lcl = null;
        this.lclTable = null;
        return this;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void setParent(Context parent) {
        this.parent = parent;
    }

    public Context getParent() {
        return this.parent;
    }

    public static Context getAncestorFromHash(Context c, int h) {
        if (c == null) {
            return c;
        }
        if (c.hashCode() == h) {
            return c;
        }
        return Context.getAncestorFromHash(c.getParent(), h);
    }

    public static Context getAncestorFromName(Context c, String n) {
        if (c == null) {
            return c;
        }
        if (c.getProgramName().equalsIgnoreCase(n)) {
            return c;
        }
        return Context.getAncestorFromName(c.getParent(), n);
    }

    public String getParameter(String name) {
        return RuntimeEnvironment.getGlobalParameter(name);
    }

    public String getParameter(int number) {
        return RuntimeEnvironment.getGlobalRuntimeEnvironment().getParameter(number);
    }

    private void setParameterInternal(String name, String value) {
        this.currentEnvironmentName = name;
        this.currentEnvironmentValue = value;
        if (name != null) {
            String normalizedName;
            if (name.startsWith("log.")) {
                this.setLogging(name.substring(4), value);
            }
            if ("CODE-MAPPING".equals(normalizedName = name.toUpperCase().replace('_', '-'))) {
                supportsCodeMapping = RuntimeEnvironment.isParameterValue(value);
            }
            if ("CODE-SUFFIX".equals(normalizedName)) {
                codeSuffix = value;
                if (codeSuffix != null && codeSuffix.length() > 0) {
                    if (codeSuffix.charAt(0) != '.') {
                        codeSuffix = "." + codeSuffix;
                    }
                    codeSuffixIsAcu = codeSuffix.equalsIgnoreCase(".acu");
                } else {
                    codeSuffixIsAcu = false;
                }
            }
            if ("CODE-CASE".equals(normalizedName)) {
                codeCase = value != null ? ConvertData.parseInt(value) : 0;
            }
        }
        RuntimeEnvironment.setGlobalParameter(name, value);
    }

    public void setParameter(String name, String value) {
        block6: {
            if (name != null) {
                name = name.trim();
            }
            if (value != null) {
                value = value.trim();
            }
            try {
                Properties p = System.getProperties();
                if (value != null) {
                    p.put(name, value);
                } else {
                    p.remove(name);
                }
            }
            catch (Exception securityException) {
                if (!LogSetup.IS_LOGGING_INFO) break block6;
                LogSetup.LOGGER.info("catch(Exception securityException)");
                securityException.printStackTrace();
            }
        }
        this.setParameterInternal(name, value);
        Variable.reconfig();
    }

    public boolean isParameter(String name) {
        String value = this.getParameter(name);
        return RuntimeEnvironment.isParameterValue(value);
    }

    public void setEnvironment(String name, String value) {
        block6: {
            if (name != null) {
                name = name.trim();
            }
            if (value != null) {
                value = value.trim();
            }
            try {
                Properties p = System.getProperties();
                if (value != null) {
                    p.put(name, value);
                } else {
                    p.remove(name);
                }
            }
            catch (Exception securityException) {
                if (!LogSetup.IS_LOGGING_INFO) break block6;
                LogSetup.LOGGER.info("catch(Exception securityException)");
                securityException.printStackTrace();
            }
        }
        this.setParameterInternal(name, value);
    }

    public boolean canThread() {
        return this.transactionEnvironment == null;
    }

    public boolean canSession() {
        return this.transactionEnvironment == null;
    }

    public boolean canCall() {
        return true;
    }

    public boolean canCancel() {
        return true;
    }

    public boolean canExit() {
        return this.transactionEnvironment == null;
    }

    public Section getShr() {
        return this.shr;
    }

    public Section getFil() {
        return this.fil;
    }

    public Section getWrk() {
        return this.wrk;
    }

    public Section getCns() {
        return this.cns;
    }

    public Section getScr() {
        return this.scr;
    }

    public Section getCmn() {
        return this.cmn;
    }

    public Section getRpt() {
        return this.rpt;
    }

    public Section getLcl() {
        return this.lcl;
    }

    public Section getLnk() {
        return this.lnk;
    }

    public Section getPrc() {
        return this.prc;
    }

    public Section getWrk(int n) {
        if (this.wrks == null || this.wrks.size() < n + 1) {
            return null;
        }
        return this.wrks.get(n);
    }

    public Section getLnk(int n) {
        if (this.lnks == null || this.lnks.size() < n + 1) {
            return null;
        }
        return this.lnks.get(n);
    }

    public void setShr(Section val) {
        this.shr = val;
    }

    public void setFil(Section val) {
        this.fil = val;
    }

    public void setWrk(Section val) {
        this.wrk = val;
    }

    public void setCns(Section val) {
        this.cns = val;
    }

    public void setScr(Section val) {
        this.scr = val;
    }

    public void setCmn(Section val) {
        this.cmn = val;
    }

    public void setRpt(Section val) {
        this.rpt = val;
    }

    public void setLcl(Section val) {
        this.lcl = val;
    }

    public void setLnk(Section val) {
        this.lnk = val;
    }

    public void setPrc(Section val) {
        this.prc = val;
    }

    public void setWrk(Section val, int n) {
        if (this.wrks == null) {
            this.wrks = new Vector();
        }
        if (this.wrks.size() < n + 1) {
            this.wrks.setSize(n + 64);
        }
        this.wrks.set(n, val);
    }

    public void setLnk(Section val, int n) {
        if (this.lnks == null) {
            this.lnks = new Vector();
        }
        if (this.lnks.size() < n + 1) {
            this.lnks.setSize(n + 64);
        }
        this.lnks.set(n, val);
    }

    public void fillShr(Section val) {
        if (this.shr == null) {
            this.setShr(val);
        }
    }

    public void fillFil(Section val) {
        if (this.fil == null) {
            this.setFil(val);
        }
    }

    public void fillWrk(Section val) {
        if (this.wrk == null) {
            this.setWrk(val);
        }
    }

    public void fillCns(Section val) {
        if (this.cns == null) {
            this.setCns(val);
        }
    }

    public void fillScr(Section val) {
        if (this.scr == null) {
            this.setScr(val);
        }
    }

    public void fillCmn(Section val) {
        if (this.cmn == null) {
            this.setCmn(val);
        }
    }

    public void fillRpt(Section val) {
        if (this.rpt == null) {
            this.setRpt(val);
        }
    }

    public void fillLcl(Section val) {
        if (this.lcl == null) {
            this.setLcl(val);
        }
    }

    public void fillLnk(Section val) {
        if (this.lnk == null) {
            this.setLnk(val);
        }
    }

    public void fillWrk(Section val, int n) {
        if (this.wrks == null || this.wrks.size() < n + 1 || this.wrks.get(n) == null) {
            this.setWrk(val, n);
        }
    }

    public void fillLnk(Section val, int n) {
        if (this.lnks == null || this.lnks.size() < n + 1 || this.lnks.get(n) == null) {
            this.setLnk(val, n);
        }
    }

    public boolean isShr() {
        return this.shr != null;
    }

    public boolean isFil() {
        return this.fil != null;
    }

    public boolean isWrk() {
        return this.wrk != null;
    }

    public boolean isCns() {
        return this.cns != null;
    }

    public boolean isScr() {
        return this.scr != null;
    }

    public boolean isCmn() {
        return this.cmn != null;
    }

    public boolean isRpt() {
        return this.rpt != null;
    }

    public boolean isLcl() {
        return this.lcl != null;
    }

    public boolean isLnk() {
        return this.lnk != null;
    }

    public boolean isWrk(int n) {
        return this.wrks.get(n) != null;
    }

    public boolean isLnk(int n) {
        return this.lnks.get(n) != null;
    }

    public Map<Object, Object> getlnkArrayTable() {
        return this.lnkArrayTable != null ? this.lnkArrayTable : (this.lnkArrayTable = new HashMap<Object, Object>());
    }

    public String getlnkPointerMemory() {
        return this.lnkPointerMemory != null ? this.lnkPointerMemory : (this.lnkPointerMemory = "");
    }

    public Hashtable<String, Object> getShrData() {
        return this.shrTable != null ? this.shrTable : (this.shrTable = new Hashtable());
    }

    public Hashtable<String, Object> getFilData() {
        return this.filTable != null ? this.filTable : (this.filTable = new Hashtable());
    }

    public Hashtable<String, Object> getWrkData() {
        return this.wrkTable != null ? this.wrkTable : (this.wrkTable = new Hashtable());
    }

    public Hashtable<String, Object> getCnsData() {
        return this.cnsTable != null ? this.cnsTable : (this.cnsTable = new Hashtable());
    }

    public Hashtable<String, Object> getScrData() {
        return this.scrTable != null ? this.scrTable : (this.scrTable = new Hashtable());
    }

    public Hashtable<String, Object> getCmnData() {
        return this.cmnTable != null ? this.cmnTable : (this.cmnTable = new Hashtable());
    }

    public Hashtable<String, Object> getRptData() {
        return this.rptTable != null ? this.rptTable : (this.rptTable = new Hashtable());
    }

    public Hashtable<String, Object> getLclData() {
        return this.lclTable != null ? this.lclTable : (this.lclTable = new Hashtable());
    }

    public Hashtable<String, Object> getLnkData() {
        return this.lnkTable != null ? this.lnkTable : (this.lnkTable = new Hashtable());
    }

    public Hashtable<String, Object> getWrkData(int n) {
        if (this.wrksTable == null) {
            this.wrksTable = new Vector(n + 64, 64);
        }
        if (this.wrksTable.size() < n + 1) {
            this.wrksTable.setSize(n + 64);
        }
        return this.wrksTable.get(n);
    }

    public Hashtable<String, Object> getLnkData(int n) {
        if (this.lnksTable == null) {
            this.lnksTable = new Vector(n + 64, 64);
        }
        if (this.lnksTable.size() < n + 1) {
            this.lnksTable.setSize(n + 64);
        }
        return this.lnksTable.get(n);
    }

    public Object getShrData(String name) {
        return this.shrTable != null ? this.shrTable.get(name) : null;
    }

    public Object getFilData(String name) {
        return this.filTable != null ? this.filTable.get(name) : null;
    }

    public Object getWrkData(String name) {
        return this.wrkTable != null ? this.wrkTable.get(name) : null;
    }

    public Object getCnsData(String name) {
        return this.cnsTable != null ? this.cnsTable.get(name) : null;
    }

    public Object getScrData(String name) {
        return this.scrTable != null ? this.scrTable.get(name) : null;
    }

    public Object getCmnData(String name) {
        return this.cmnTable != null ? this.cmnTable.get(name) : null;
    }

    public Object getRptData(String name) {
        return this.rptTable != null ? this.rptTable.get(name) : null;
    }

    public Object getLclData(String name) {
        return this.lclTable != null ? this.lclTable.get(name) : null;
    }

    public Object getLnkData(String name) {
        return this.lnkTable != null ? this.lnkTable.get(name) : null;
    }

    public Object getWrkData(String name, int n) {
        if (this.wrksTable == null || this.wrksTable.size() < n + 1) {
            return null;
        }
        return this.wrksTable.get(n).get(name);
    }

    public Object getLnkData(String name, int n) {
        if (this.lnksTable == null || this.lnksTable.size() < n + 1) {
            return null;
        }
        return this.lnksTable.get(n).get(name);
    }

    public void setlnkArrayTable(Object child, Object parent) {
        if (this.lnkArrayTable == null) {
            this.lnkArrayTable = new Hashtable<Object, Object>();
        }
        this.lnkArrayTable.put(child, parent);
    }

    public void setlnkPointerMemory(String str) {
        this.lnkPointerMemory = str;
    }

    public void setShrData(String name, Object val) {
        if (this.shrTable == null) {
            this.shrTable = new Hashtable();
        }
        this.shrTable.put(name, val);
    }

    public void setFilData(String name, String val) {
        if (this.filTable == null) {
            this.filTable = new Hashtable();
        }
        this.filTable.put(name, val);
    }

    public void setWrkData(String name, String val) {
        if (this.wrkTable == null) {
            this.wrkTable = new Hashtable();
        }
        this.wrkTable.put(name, val);
    }

    public void setCnsData(String name, String val) {
        if (this.cnsTable == null) {
            this.cnsTable = new Hashtable();
        }
        this.cnsTable.put(name, val);
    }

    public void setScrData(String name, String val) {
        if (this.scrTable == null) {
            this.scrTable = new Hashtable();
        }
        this.scrTable.put(name, val);
    }

    public void setCmnData(String name, String val) {
        if (this.cmnTable == null) {
            this.cmnTable = new Hashtable();
        }
        this.cmnTable.put(name, val);
    }

    public void setRptData(String name, String val) {
        if (this.rptTable == null) {
            this.rptTable = new Hashtable();
        }
        this.rptTable.put(name, val);
    }

    public void setLclData(String name, String val) {
        if (this.lclTable == null) {
            this.lclTable = new Hashtable();
        }
        this.lclTable.put(name, val);
    }

    public void setLnkData(String name, String val) {
        if (this.lnkTable == null) {
            this.lnkTable = new Hashtable();
        }
        this.lnkTable.put(name, val);
    }

    public void setWrkData(String name, String val, int n) {
        if (this.wrksTable == null) {
            this.wrksTable = new Vector(64, 64);
        }
        if (this.wrksTable.size() < n + 1) {
            this.wrksTable.setSize(n + 64);
        }
        this.wrksTable.get(n).put(name, val);
    }

    public void setLnkData(String name, String val, int n) {
        if (this.lnksTable == null) {
            this.lnksTable = new Vector(64, 64);
        }
        if (this.lnksTable.size() < n + 1) {
            this.lnksTable.setSize(n + 64);
        }
        this.lnksTable.get(n).put(name, val);
    }

    public void setBaseContext(Context baseContext) {
        if (baseContext == null) {
            return;
        }
        this.setParent(baseContext);
        this.returnCode = baseContext.returnCode;
        this.sqlContext = baseContext.sqlContext;
        this.entryPointsDeclared = baseContext.entryPointsDeclared;
        this.programName = baseContext.programName;
        this.program = baseContext.program;
        this.programIsCalled = baseContext.programIsCalled;
        this.programContextInSession = baseContext.programContextInSession;
        this.lnkPointerMemory = baseContext.lnkPointerMemory;
        this.lnkArrayTable = baseContext.lnkArrayTable;
        this.shr = baseContext.shr;
        this.shrTable = baseContext.shrTable;
        this.fil = baseContext.fil;
        this.filTable = baseContext.filTable;
        this.wrk = baseContext.wrk;
        this.wrkTable = baseContext.wrkTable;
        this.cns = baseContext.cns;
        this.cnsTable = baseContext.cnsTable;
        this.scr = baseContext.scr;
        this.scrTable = baseContext.shrTable;
        this.cmn = baseContext.cmn;
        this.cmnTable = baseContext.cmnTable;
        this.rpt = baseContext.rpt;
        this.rptTable = baseContext.rptTable;
        this.lcl = baseContext.lcl;
        this.lclTable = baseContext.lclTable;
        this.lnk = baseContext.lnk;
        this.lnkTable = baseContext.lnkTable;
        this.wrks = baseContext.wrks;
        this.wrksTable = baseContext.wrksTable;
        this.lnks = baseContext.lnks;
        this.lnksTable = baseContext.lnksTable;
    }

    public Object getObject(String name) {
        block7: {
            if ((name = name.toUpperCase()).equals("CONTEXT")) {
                return this;
            }
            if (name.equals("SQLCONTEXT")) {
                return this.getSqlContext();
            }
            if (name.equals("SQL")) {
                try {
                    return this.getSqlContext().getConnection();
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) break block7;
                    LogSetup.LOGGER.info("catch(Exception e)");
                    e.printStackTrace();
                }
            }
        }
        if (name.equals("APPLET")) {
            return Utilities.getApplet();
        }
        if (name.equals("APPLETCONTEXT")) {
            return Utilities.getApplet().getAppletContext();
        }
        return null;
    }

    public void restoreLazySessionValues(Context callContext) {
        if (this.sqlContext == null) {
            this.sqlContext = callContext.sqlContext;
        }
    }

    private static String normalizeName(String name) {
        return name != null ? name.trim().toLowerCase().replace('-', '_') : null;
    }

    public void putProgramContextInSession(String name, Context context) {
        this.programContextInSession.put(Context.normalizeName(name), context);
    }

    public void putProgramContextInSession(String name) {
        this.programContextInSession.put(Context.normalizeName(name), this);
    }

    private static String getGlobalProgramByName(String localName, String[][] localNameConverter) {
        if (localNameConverter == null) {
            return localName;
        }
        String normalName = Context.normalizeName(localName);
        for (int i = 0; i < localNameConverter.length; ++i) {
            if (!normalName.equals(localNameConverter[i][0])) continue;
            return localNameConverter[i][1];
        }
        return localName;
    }

    private Class<?> getClassByName(String name) throws IPCException {
        IPCException ipcException;
        block48: {
            Class<?> c;
            block47: {
                block44: {
                    c = null;
                    try {
                        c = stringToClassMap.get(name);
                        if (c != null) {
                            return c;
                        }
                    }
                    catch (Exception exception) {
                        if (!LogSetup.IS_LOGGING) break block44;
                        LogSetup.LOGGER.finest("catch(Exception exception): name=" + name + ". ");
                    }
                }
                if (name == null) {
                    return null;
                }
                String attempt = null;
                String priorAttempt = null;
                String initialAttempt = forbidden.contains(name.toLowerCase()) ? name + "_" : name;
                ipcException = null;
                int startAt = this.packageName == null ? 3 : 0;
                for (int pass = startAt; pass < 6; ++pass) {
                    switch (pass) {
                        case 0: {
                            attempt = this.packageName + Context.normalizeName(initialAttempt);
                            break;
                        }
                        case 1: {
                            attempt = this.packageName + initialAttempt;
                            break;
                        }
                        case 2: {
                            attempt = this.packageName + initialAttempt.toUpperCase().replace('-', '_');
                            break;
                        }
                        case 3: {
                            attempt = Context.normalizeName(initialAttempt);
                            break;
                        }
                        case 4: {
                            attempt = initialAttempt;
                            break;
                        }
                        case 5: {
                            attempt = initialAttempt.toUpperCase().replace('-', '_');
                        }
                    }
                    if (attempt.equals(priorAttempt)) continue;
                    priorAttempt = attempt;
                    try {
                        block45: {
                            c = this.forName(attempt);
                            try {
                                stringToClassMap.put(name, c);
                            }
                            catch (Exception bufferedClassException) {
                                if (!LogSetup.IS_LOGGING) break block45;
                                LogSetup.LOGGER.finest("catch(Exception bufferedClassException)");
                            }
                        }
                        if (c == null) continue;
                        return c;
                    }
                    catch (VerifyError verifyError) {
                        Context.setCallFailCode(3);
                        ipcException = new IPCException(verifyError, CALL_MESSAGE_VERIFY);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (!LogSetup.IS_LOGGING) continue;
                        LogSetup.LOGGER.finest("catch(ClassCastException classCastException): attempt=" + attempt + ". c=" + c + ". ");
                        continue;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        Context.setCallFailCode(4);
                        ipcException = new IPCException(outOfMemoryError, CALL_MESSAGE_MEMORY);
                        continue;
                    }
                    catch (Exception plainName) {
                        if (!LogSetup.IS_LOGGING) continue;
                        LogSetup.LOGGER.fine("catch(Exception plainName): attempt=" + attempt + ". c=" + c + ". ");
                        continue;
                    }
                    catch (LinkageError linkageError) {
                        if (!LogSetup.IS_LOGGING) continue;
                        LogSetup.LOGGER.finest("catch(LinkageError linkageError): attempt=" + attempt + ". c=" + c + ". ");
                    }
                }
                String utilityName = name.toUpperCase().replace('#', 'H');
                if (libcall.contains(utilityName)) {
                    try {
                        block46: {
                            utilityName = LIBCALL_PACKAGE + utilityName;
                            c = this.forName(utilityName);
                            try {
                                stringToClassMap.put(name, c);
                            }
                            catch (Exception bufferedClassException) {
                                if (!LogSetup.IS_LOGGING) break block46;
                                LogSetup.LOGGER.finest("catch(Exception bufferedClassException)");
                            }
                        }
                        return c;
                    }
                    catch (VerifyError verifyError) {
                        Context.setCallFailCode(3);
                        ipcException = new IPCException(verifyError, CALL_MESSAGE_VERIFY);
                    }
                    catch (ClassCastException classCastException) {
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finest("catch(ClassCastException classCastException)");
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        Context.setCallFailCode(4);
                        ipcException = new IPCException(outOfMemoryError, CALL_MESSAGE_MEMORY);
                    }
                    catch (Exception internalName) {
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finest("catch(Exception internalName)");
                        }
                    }
                    catch (LinkageError linkageError) {
                        if (!LogSetup.IS_LOGGING) break block47;
                        LogSetup.LOGGER.finest("catch(LinkageError linkageError)");
                    }
                }
            }
            try {
                block49: {
                    if (name.length() != 1 || name.charAt(0) < '\u0080') break block48;
                    String hexName = "HexCall" + Integer.toHexString(name.charAt(0) & 0xFF).toUpperCase();
                    c = this.forName(LIBCALL_PACKAGE + hexName);
                    try {
                        stringToClassMap.put(name, c);
                    }
                    catch (Exception bufferedClassException) {
                        if (!LogSetup.IS_LOGGING) break block49;
                        LogSetup.LOGGER.finest("catch(Exception bufferedClassException)");
                    }
                }
                return c;
            }
            catch (VerifyError verifyError) {
                Context.setCallFailCode(3);
                ipcException = new IPCException(verifyError, CALL_MESSAGE_VERIFY);
            }
            catch (ClassCastException classCastException) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finest("catch(ClassCastException classCastException)");
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Context.setCallFailCode(4);
                ipcException = new IPCException(outOfMemoryError, CALL_MESSAGE_MEMORY);
            }
            catch (Exception internalName) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finest("catch(Exception internalName)");
                }
            }
            catch (LinkageError linkageError) {
                if (!LogSetup.IS_LOGGING) break block48;
                LogSetup.LOGGER.finest("catch(LinkageError linkageError)");
            }
        }
        if (ipcException != null) {
            throw ipcException;
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Program name is not found. name=" + name + ". ");
        }
        return null;
    }

    public ICallableProgram getEntryByVariable(Variable var, String[][] localNameConverter) {
        try {
            return (ICallableProgram)this.getInstanceByName(var.toString(), localNameConverter);
        }
        catch (Exception t) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(Exception t)");
                t.printStackTrace();
            }
            return null;
        }
    }

    public ICallableProgram getEntryByName(String name, String[][] localNameConverter) {
        try {
            return (ICallableProgram)this.getInstanceByName(name, localNameConverter);
        }
        catch (Exception t) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(Exception t)");
                t.printStackTrace();
            }
            return null;
        }
    }

    private Object getInstanceByName(String name, String[][] localNameConverter) throws IPCException {
        block12: {
            if (localNameConverter == null) {
                block10: {
                    Class<?> c = this.getClassByName(name);
                    if (c != null) {
                        try {
                            Object returnInstance = c.newInstance();
                            instancesLoadMap.put(Context.getGlobalProgramByName(Context.normalizeName(name), localNameConverter), returnInstance);
                            return returnInstance;
                        }
                        catch (Exception instantiationException) {
                            if (!LogSetup.IS_LOGGING_INFO) break block10;
                            LogSetup.LOGGER.info("catch(Exception instantiationException)");
                            instantiationException.printStackTrace();
                        }
                    }
                }
                return null;
            }
            Class<?> c = this.getClassByName(Context.getGlobalProgramByName(name, localNameConverter));
            if (c != null) {
                try {
                    Object instance;
                    block11: {
                        instance = c.newInstance();
                        try {
                            String redirect;
                            if (instance instanceof ICallableProgram && (redirect = ((ICallableProgram)instance).redirectCall()) != null) {
                                instance = this.getInstanceByName(redirect, localNameConverter);
                            }
                        }
                        catch (Exception notCallableProgram) {
                            if (!LogSetup.IS_LOGGING_INFO) break block11;
                            LogSetup.LOGGER.info("catch(Exception notCallableProgram)");
                            notCallableProgram.printStackTrace();
                        }
                    }
                    instancesLoadMap.put(Context.getGlobalProgramByName(Context.normalizeName(name), localNameConverter), instance);
                    return instance;
                }
                catch (Exception instantiationException) {
                    if (!LogSetup.IS_LOGGING_INFO) break block12;
                    LogSetup.LOGGER.info("catch(Exception instantiationException)");
                    instantiationException.printStackTrace();
                }
            }
        }
        return null;
    }

    public boolean getEntryPointsDeclared() {
        return this.entryPointsDeclared;
    }

    public void setEntryPointsDeclared() {
        this.entryPointsDeclared = true;
    }

    public void setEntryPointsDeclared(boolean state) {
        this.entryPointsDeclared = state;
    }

    public void setEntryPoints(String[] names) {
        this.entryPointsDeclared = true;
        if (names == null) {
            return;
        }
        int length = names.length;
        for (int i = 0; i < length; ++i) {
            if (names[i] == null) continue;
            this.putProgramContextInSession(names[i]);
        }
    }

    public void setEntryPoints(Vector<String> names) {
        this.entryPointsDeclared = true;
        if (names == null) {
            return;
        }
        int length = names.size();
        String name = null;
        for (int i = 0; i < length; ++i) {
            name = names.elementAt(i);
            if (name == null) continue;
            this.putProgramContextInSession(name);
        }
    }

    private static Class<?> getContextCall(String asName) {
        Class<?> c;
        block8: {
            block7: {
                c = null;
                asName = asName.toUpperCase();
                try {
                    c = contextCallClasses.get(asName);
                }
                catch (Exception t) {
                    if (!LogSetup.IS_LOGGING_INFO) break block7;
                    LogSetup.LOGGER.info("catch(Exception t)");
                    t.printStackTrace();
                }
            }
            try {
                if (c == null && (c = Class.forName("com.heirloomcomputing.ecs.exec.IContextCall" + asName)) != null) {
                    contextCallClasses.put(asName, c);
                }
            }
            catch (ClassNotFoundException e) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch(ClassNotFoundException e)");
                    e.printStackTrace();
                }
            }
            catch (LinkageError linkageError) {
                if (!LogSetup.IS_LOGGING_INFO) break block8;
                LogSetup.LOGGER.info("catch(LinkageError linkageError)");
                linkageError.printStackTrace();
            }
        }
        return c;
    }

    public Object call(ProcedurePointer p, int callingConvention, String[][] localNameConverter, parameterList params) {
        if (p == null) {
            throw new EcProgramPtrNull();
        }
        p.perform();
        return null;
    }

    public Object call(ProcedurePointer p, String normalizeName, int callingConvention, String[][] localNameConverter, parameterList params) {
        block4: {
            if (p == null) {
                throw new EcProgramPtrNull();
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finest("call(pp,s,i,s[][],localNameconverter,params): p.getProgramObject().getClass().getName()=" + p.getProgramObject().getClass().getName() + ". p.getString()=" + p.getString() + ". p.getIdentifier()=" + p.getIdentifier() + ". p.getName()=" + p.getName() + ". p." + p.toDebugString2() + ". ");
            }
            try {
                this.call(p.getProgramObject().getClass().getName(), null, -1, localNameConverter, null, (Object)this.getReturnCode());
            }
            catch (Throwable e) {
                if (!LogSetup.IS_LOGGING_INFO) break block4;
                LogSetup.LOGGER.info("catch(Throwable e)");
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object call(ProcedurePointer p, int callingConvention, String[][] localNameConverter, parameterList params, Object returnCode) {
        if (p == null) {
            throw new EcProgramPtrNull();
        }
        return this.call(p, callingConvention, localNameConverter, params);
    }

    public Object call(ProcedurePointer p, String normalizeName, int callingConvention, String[][] localNameConverter, parameterList params, Object returnCode) {
        if (p == null) {
            throw new EcProgramPtrNull();
        }
        return this.call(p, normalizeName, callingConvention, localNameConverter, params);
    }

    public Object call(String programName, int callingConvention, String[][] localNameConverter, parameterList params) throws Throwable {
        return this.call(programName, callingConvention, localNameConverter, params, null);
    }

    public Object call(String programName, String normalizeName, int callingConvention, String[][] localNameConverter, parameterList params) throws Throwable {
        return this.call(programName, normalizeName, callingConvention, localNameConverter, params, null);
    }

    public Object call(String programName, int callingConvention, String[][] localNameConverter, parameterList params, Object returnCode) throws Throwable {
        return this.call(programName, null, callingConvention, localNameConverter, params, returnCode);
    }

    private Context findRecursiveContext(String normalName) {
        block5: {
            try {
                Context currentContext = this;
                int counter = 0;
                do {
                    if (currentContext.programName.equals(normalName)) {
                        return currentContext;
                    }
                    if (currentContext.parent == currentContext) {
                        return null;
                    }
                    if (++counter <= 255) continue;
                    return null;
                } while ((currentContext = currentContext.parent) != null);
            }
            catch (Exception noRecursiveContextExceptionAllowed) {
                if (!LogSetup.IS_LOGGING_INFO) break block5;
                LogSetup.LOGGER.info("catch(Exception noRecursiveContextExceptionAllowed)");
                noRecursiveContextExceptionAllowed.printStackTrace();
            }
        }
        return null;
    }

    private static void initializeCallTransformationSettings() {
        block5: {
            supportsCodeMapping = RuntimeEnvironment.isGlobalParameter("CODE_MAPPING");
            codeSuffix = RuntimeEnvironment.getGlobalParameter("CODE-SUFFIX");
            if (codeSuffix != null && codeSuffix.length() > 0) {
                if (codeSuffix.charAt(0) != '.') {
                    codeSuffix = "." + codeSuffix;
                }
                codeSuffixIsAcu = codeSuffix.equalsIgnoreCase(".acu");
            } else {
                codeSuffixIsAcu = false;
            }
            try {
                String codeCaseString = RuntimeEnvironment.getGlobalParameter("CODE-CASE");
                codeCase = codeCaseString != null ? ConvertData.parseInt(codeCaseString) : 0;
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block5;
                LogSetup.LOGGER.info("catch(Exception e)");
                e.printStackTrace();
            }
        }
    }

    public void storeWatchPointInfo() {
        if (DataWatchPoint.watchPointMap != null && DataWatchPoint.watchPointMap.size() > 0) {
            this.contextWatchpointMap = new HashMap<Variable, String>();
            for (Variable var : DataWatchPoint.watchPointMap) {
                if (var instanceof Numeric) {
                    this.contextWatchpointMap.put(var, ((Numeric)var).toNumericString());
                    continue;
                }
                if (var instanceof DataPointer) {
                    this.contextWatchpointMap.put(var, null);
                    continue;
                }
                this.contextWatchpointMap.put(var, var.toString());
            }
            DataWatchPoint.watchPointMap.clear();
        }
    }

    public void restoreWatchPointInfo() {
        if (DataWatchPoint.watchPointMap != null && this.contextWatchpointMap != null && this.contextWatchpointMap.size() > 0) {
            boolean result = false;
            for (Map.Entry<Variable, String> entry : this.contextWatchpointMap.entrySet()) {
                Variable var = entry.getKey();
                int breakType = entry.getKey().watchpointBreakType;
                String preValue = entry.getValue();
                DataWatchPoint.watchPointMap.add(var);
                if (var instanceof Numeric) {
                    if (breakType == 1 && ((Numeric)var).compare(new Numeric(preValue)) != 0) {
                        result = true;
                        var.watchpointValue = ((Numeric)var).toNumericString();
                        continue;
                    }
                    if (breakType != 2 || new Numeric(preValue).compare(new Numeric(var.watchpointValue)) == 0 || ((Numeric)var).compare(new Numeric(var.watchpointValue)) != 0) continue;
                    result = true;
                    continue;
                }
                String newValue = var.toString();
                if (breakType == 1 && newValue.compareTo(preValue) != 0) {
                    result = true;
                    var.watchpointValue = newValue;
                    continue;
                }
                if (breakType != 2 || preValue.equals(var.watchpointValue) || newValue.compareTo(var.watchpointValue) != 0) continue;
                result = true;
            }
            if (result) {
                DataWatchPoint.watchBreakEventFired = true;
                DataWatchPoint.fireWatchBreakEvent();
            }
            this.contextWatchpointMap.clear();
        }
    }

    public Object call(String calledProgramName, String normalName, int callingConvention, String[][] localNameConverter, parameterList params, Object returnCode) throws Throwable {
        boolean chainingParm;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): 0 calledProgramName=" + calledProgramName + ". normalName=" + normalName + ". callingConvention=" + callingConvention + ". localNameConverter=" + localNameConverter + ". params=" + params + ". returnCode=" + returnCode + ". ");
        }
        Object result = null;
        Context callContext = null;
        Object calledProgram = null;
        String normalNameForLookup = Context.normalizeName(calledProgramName);
        normalNameForLookup = Context.getGlobalProgramByName(normalNameForLookup, localNameConverter);
        boolean bl = chainingParm = callingConvention != -1 && (callingConvention & 0x1000) == 4096;
        if (calledProgramName != null) {
            calledProgram = instancesLoadMap.get(normalNameForLookup);
        }
        if (calledProgram != null) {
            if (NativeCall.class.isInstance(calledProgram) && !chainingParm) {
                NativeCall nativeProgram = (NativeCall)calledProgram;
                int cc = nativeProgram.getCallingConvention();
                result = this.callNative(calledProgramName, normalNameForLookup, cc, localNameConverter, params, returnCode, chainingParm, nativeProgram);
                if (result != null) {
                    return result;
                }
            } else {
                if (callContext == null && this.programContextInSession != null && normalNameForLookup != null) {
                    callContext = (Context)this.programContextInSession.get(normalNameForLookup);
                }
                if (callContext != null) {
                    callContext.defaultCall();
                    callContext.setParent(this);
                    callContext.setProgram(calledProgram);
                    callContext.setProgramName(normalName);
                    result = callContext.performCall(chainingParm, params);
                    return result;
                }
            }
        }
        result = this.callDefaultStyle(calledProgramName, normalName, callingConvention, localNameConverter, params, returnCode);
        return result;
    }

    private Object callDefaultStyle(String calledProgramName, String normalName, int callingConvention, String[][] localNameConverter, parameterList params, Object returnCode) throws Throwable {
        int exclamation;
        ICallableProgramGiving nativeCall;
        Object resultTemp;
        String name;
        if (calledProgramName == null) {
            Context.setCallFailCode(1);
            throw new EcProgramPtrNull();
        }
        calledProgramName = calledProgramName.trim();
        if (supportsCodeMapping && (name = this.getParameter(calledProgramName)) != null) {
            calledProgramName = name.trim();
            normalName = null;
        }
        if (calledProgramName.length() == 0) {
            Context.setCallFailCode(1);
            throw new IPCException("Cannot call empty program");
        }
        Context.setCallFailCode(0);
        if (normalName == null) {
            int colonIndex = calledProgramName.indexOf(58);
            if (colonIndex > 0) {
                Throwable protocolExceptionHolder;
                block54: {
                    protocolExceptionHolder = null;
                    try {
                        Class<?> c;
                        String protocolName = calledProgramName.substring(0, colonIndex).trim();
                        IContextCall contextCall = null;
                        if (protocolName != null && (c = Context.getContextCall(protocolName.toUpperCase())) != null) {
                            try {
                                contextCall = (IContextCall)c.newInstance();
                                Object result = contextCall.call(calledProgramName.substring(colonIndex + 1), callingConvention, params, returnCode);
                                Context.setReturnObject(returnCode, result);
                                if (LogSetup.IS_LOGGING) {
                                    LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): return 1: calledProgramName=" + calledProgramName + ". normalName=" + normalName + ". callingConvention=" + callingConvention + ". localNameConverter=" + localNameConverter + ". params=" + params + ". returnCode=" + returnCode + ". ");
                                }
                                return result;
                            }
                            catch (Throwable protocolException) {
                                protocolExceptionHolder = protocolException;
                            }
                        }
                    }
                    catch (Exception notProtocolException) {
                        if (!LogSetup.IS_LOGGING_INFO) break block54;
                        LogSetup.LOGGER.info("catch(Exception notProtocolException)");
                        notProtocolException.printStackTrace();
                    }
                }
                if (protocolExceptionHolder != null) {
                    throw new IPCException(protocolExceptionHolder, "Cannot call specialized function");
                }
            }
            normalName = Context.normalizeName(calledProgramName);
        }
        normalName = Context.getGlobalProgramByName(normalName, localNameConverter);
        boolean chaining = callingConvention != -1 && (callingConvention & 0x1000) == 4096;
        try {
            ICallableProgramGiving calledProgram;
            ICallableProgramGiving connectProgram = this.getConnectProgramByName(calledProgramName);
            ICallableProgramGiving iCallableProgramGiving = calledProgram = connectProgram == null ? this.getInstanceByName(calledProgramName, localNameConverter) : connectProgram;
            if (calledProgram != null) {
                Object result;
                Context callContext = this.findRecursiveContext(normalName);
                if (callContext != null) {
                    callContext = this.create(callContext);
                    callContext.defaultRecursive();
                    callContext.setParent(this);
                    callContext.setProgram(calledProgram);
                    callContext.setProgramName(normalName);
                    result = callContext.performCall(chaining, params);
                } else {
                    callContext = (Context)this.programContextInSession.get(normalName);
                    if (callContext != null) {
                        callContext = this.create(callContext);
                        callContext.defaultCall();
                        callContext.setParent(this);
                        callContext.setProgram(calledProgram);
                        callContext.setProgramName(normalName);
                        result = callContext.performCall(chaining, params);
                    } else {
                        callContext = this.create(this);
                        callContext.defaultData();
                        callContext.setParent(this);
                        callContext.setProgram(calledProgram);
                        callContext.setProgramName(normalName);
                        if (calledProgram instanceof IInitialProgram) {
                            result = callContext.performCall(chaining, params);
                        } else {
                            this.putProgramContextInSession(normalName, callContext);
                            result = callContext.performCall(chaining, params);
                        }
                    }
                }
                this.restoreLazySessionValues(callContext);
                Context.setReturnObject(returnCode, result);
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): return 2: calledProgramName=" + calledProgramName + ". normalName=" + normalName + ". callingConvention=" + callingConvention + ". localNameConverter=" + localNameConverter + ". params=" + params + ". returnCode=" + returnCode + ". ");
                }
                return result;
            }
        }
        catch (EcAll cobolException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(EcAll cobolException)");
                cobolException.printStackTrace();
            }
            throw cobolException;
        }
        if (!chaining && (resultTemp = this.callNative(calledProgramName, normalName, callingConvention, localNameConverter, params, returnCode, chaining, nativeCall = Context.getNativeCall(calledProgramName, localNameConverter, callingConvention))) != null) {
            return resultTemp;
        }
        if (!isOnAS400 && !checkedForAS400) {
            checkedForAS400 = true;
            String OS = this.getParameter("os.name");
            if (OS != null && OS.indexOf("400") >= 0) {
                isOnAS400 = true;
            }
        }
        if (isOnAS400) {
            if (calledProgramName.length() > 6 && calledProgramName.charAt(5) == ':' && (calledProgramName.startsWith("AS400") || calledProgramName.startsWith("as400"))) {
                try {
                    calledProgramName = calledProgramName.substring(6);
                }
                catch (Exception e) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch(Exception e)");
                        e.printStackTrace();
                    }
                }
            } else {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): return 3: calledProgramName=" + calledProgramName + ". normalName=" + normalName + ". callingConvention=" + callingConvention + ". localNameConverter=" + localNameConverter + ". params=" + params + ". returnCode=" + returnCode + ". ");
                }
                return this.call("AS400:" + calledProgramName, callingConvention, localNameConverter, params);
            }
        }
        if ((exclamation = calledProgramName.indexOf(33)) >= 0) {
            ICallableProgramGiving intrinsic;
            String source;
            String name2;
            block55: {
                name2 = null;
                source = null;
                try {
                    name2 = calledProgramName.substring(0, exclamation);
                    source = calledProgramName.substring(exclamation + 1);
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) break block55;
                    LogSetup.LOGGER.info("catch(Exception e)");
                    e.printStackTrace();
                }
            }
            ICallableProgramGiving iCallableProgramGiving = intrinsic = source == null ? Context.getIntrinsicByName(name2, localNameConverter) : Context.getIntrinsicByName(name2, source, localNameConverter);
            if (intrinsic != null) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): return 4: calledProgramName=" + calledProgramName + ". normalName=" + normalName + ". callingConvention=" + callingConvention + ". localNameConverter=" + localNameConverter + ". params=" + params + ". returnCode=" + returnCode + ". ");
                }
                return intrinsic.callGiving(params);
            }
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): 7: calledProgramName=" + calledProgramName + ". params=" + params + ". ");
                if (params != null) {
                    LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): 8: params.getLength()=" + params.getLength() + ". params.getDisplayString(0)=" + params.getDisplayString(0) + ". ");
                }
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(calledProgramName);
            if (params != null) {
                for (int i = 0; i < params.getLength(); ++i) {
                    list.add(params.getDisplayString(i));
                }
            }
            ProcessBuilder proc = new ProcessBuilder(list);
            proc.redirectErrorStream(true);
            Process p = proc.start();
            InputStream is = p.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] bytes = new byte[1024];
            int count = 0;
            while (count > -1) {
                count = bis.read(bytes);
                if (count == -1) continue;
                System.out.print(new String(bytes, 0, count));
            }
            bis.close();
            int exitValue = p.exitValue();
            Numeric numeric = new Numeric(exitValue);
            Context.setReturnObject(returnCode, numeric);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): 4: calledProgramName=" + calledProgramName + ". normalName=" + normalName + ". callingConvention=" + callingConvention + ". localNameConverter=" + localNameConverter + ". params=" + params + ". returnCode=" + returnCode + ". exitValue=" + exitValue + ". ");
            }
            return numeric;
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("Caught Exception in ProcessBuilder. Error executing native program such as *.EXE or *.BAT.");
            }
            StringBuffer commandLine = new StringBuffer(calledProgramName);
            if (params != null) {
                int size = params.size();
                for (int i = 0; i < size; ++i) {
                    commandLine.append(' ').append(params.getDisplayString(i));
                }
            }
            try {
                return new Integer(Exec.execWait(commandLine.toString()));
            }
            catch (EcAll cobolException) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch(EcAll cobolException)");
                    cobolException.printStackTrace();
                }
                Context.setCallFailCode(1);
                throw cobolException;
            }
            catch (Exception e2) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch(Exception e)");
                    e2.printStackTrace();
                }
                Context.setCallFailCode(1);
                throw new IPCException("Cannot find callable program '" + calledProgramName + "'.");
            }
        }
    }

    private Object callNative(String calledProgramName, String normalName, int callingConvention, String[][] localNameConverter, parameterList params, Object returnCode, boolean chaining, ICallableProgramGiving nativeCall) throws Throwable {
        Object result;
        block7: {
            result = null;
            try {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): 6: calledProgramName=" + calledProgramName + ". chaining=" + chaining + ". nativeCall=" + nativeCall + ". params=" + params + ". ");
                }
                if (nativeCall != null) {
                    result = nativeCall.callGiving(params);
                    Context.setReturnObject(returnCode, result);
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): 9: calledProgramName=" + calledProgramName + ". chaining=" + chaining + ". nativeCall=" + nativeCall + ". result=" + result + ". ");
                    }
                    if (result != null) {
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finer("call(s,s,i,s[][],parameterList,Ojbect): return 8: calledProgramName=" + calledProgramName + ". normalName=" + normalName + ". callingConvention=" + callingConvention + ". localNameConverter=" + localNameConverter + ". params=" + params + ". returnCode=" + returnCode + ". ");
                        }
                        return result;
                    }
                }
            }
            catch (Exception nativeException) {
                if (!LogSetup.IS_LOGGING) break block7;
                LogSetup.LOGGER.finer("catch(Exception nativeException)");
            }
        }
        return result;
    }

    private static void setReturnObject(Object returnCode, Object result) {
        if (result == null || returnCode == null) {
            return;
        }
        if (result != null && returnCode != null && returnCode instanceof Variable) {
            if (returnCode instanceof Numeric) {
                if (result instanceof Numeric) {
                    ((Numeric)returnCode).move((Numeric)result);
                } else if (result instanceof Variable) {
                    ((Numeric)returnCode).move((Variable)result);
                } else if (result instanceof Number) {
                    ((Numeric)returnCode).move(((Number)result).intValue());
                }
            } else if (result instanceof Numeric) {
                ((Variable)returnCode).move((Numeric)result);
            } else if (result instanceof Variable) {
                ((Variable)returnCode).move((Variable)result);
            } else if (result instanceof Number) {
                ((Variable)returnCode).move(((Number)result).intValue());
            }
        }
    }

    public boolean thread() {
        return this.thread(0, -1);
    }

    public boolean thread(int from) {
        return this.thread(from, -1);
    }

    public boolean thread(int from, int to) {
        try {
            Thread thread = null;
            if (this.program instanceof Thread) {
                thread = (Thread)this.program;
            } else if (this.program instanceof Runnable) {
                thread = new ThreadQueue((Runnable)this.program);
            }
            Context callContext = this.create(this);
            callContext.setParent(this);
            callContext.defaultThread();
            thread.start();
            return false;
        }
        catch (Exception noSuchJavaProgram) {
            return true;
        }
    }

    public boolean cancel(String name, String[][] localNameConverter) {
        return this.cancel(name);
    }

    private static int getConditionCodeValue() {
        try {
            return CONDITION_CODE.getConditionCodeValue();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public boolean cancel(String name) {
        if (name == null) {
            return true;
        }
        String normalName = Context.normalizeName(name);
        Context currentContext = this;
        Context previousContext = null;
        while (currentContext != null && !currentContext.programName.equals(normalName)) {
            previousContext = currentContext;
            currentContext = currentContext.parent;
        }
        if (currentContext == null) {
            currentContext = (Context)this.programContextInSession.get(normalName);
        }
        if (currentContext != null) {
            Object program = currentContext.getProgram();
            if (program instanceof IResidentProgram) {
                return true;
            }
            this.programContextInSession.remove(normalName);
            if (program instanceof ICallableProgram) {
                try {
                    ((ICallableProgram)program).cancel();
                }
                catch (Exception t) {
                    return true;
                }
            }
            if (program instanceof ICancelTarget) {
                ((ICancelTarget)program).cancel();
            }
            currentContext.defaultData();
            if (previousContext != null) {
                currentContext.setParent(previousContext.parent);
            } else {
                currentContext.setParent(null);
            }
            return false;
        }
        return true;
    }

    public Object performCall(boolean chaining, parameterList params) throws Throwable {
        if (chaining) {
            return this.performProgram(params);
        }
        return this.perform(params);
    }

    public Object perform() throws Throwable {
        if (this.program == null) {
            throw new EcProgramPtrNull();
        }
        if (this.program instanceof ICallable) {
            return ((ICallable)this.program).call(this);
        }
        if (this.program instanceof ICallableProgram) {
            if (this.program instanceof ICallableProgramGiving) {
                return ((ICallableProgramGiving)this.program).callGiving();
            }
            ((ICallableProgram)this.program).call();
            return performResult;
        }
        if (this.program instanceof ICallTarget) {
            if (this.program.getClass().getName().endsWith("VOPENFORMF")) {
                IO.attachScreenHandler(this.program);
            }
            Object result = ((ICallTarget)this.program).call(null, null);
            this.getConditionCode().move(Context.getConditionCodeValue());
            return result;
        }
        if (this.program instanceof ICallTarget2) {
            if (this.program.getClass().getName().endsWith("VOPENFORMF")) {
                IO.attachScreenHandler(this.program);
            }
            Object result = ((ICallTarget2)this.program).call(this, null, null);
            this.getConditionCode().move(Context.getConditionCodeValue());
            return result;
        }
        Class<?> objectClass = this.program.getClass();
        Class[] paramClasses = new Class[]{String[].class};
        Method m = objectClass.getMethod("main", paramClasses);
        if (m == null) {
            throw new EcProgramPtrNull();
        }
        String[] mainParams = new String[]{};
        return m.invoke(this.program, new Object[]{mainParams});
    }

    public Object perform(parameterList params) throws Throwable {
        if (this.program == null) {
            throw new EcProgramPtrNull();
        }
        if (params == null) {
            return this.perform();
        }
        if (this.program instanceof ICallable) {
            return ((ICallable)this.program).call(this, params);
        }
        if (this.program instanceof ICallableProgram) {
            if (this.program instanceof ICallableProgramGiving) {
                return ((ICallableProgramGiving)this.program).callGiving(params);
            }
            ((ICallableProgram)this.program).call(params);
            return performResult;
        }
        if (this.program instanceof ICallTarget) {
            if (this.program.getClass().getName().endsWith("VOPENFORMF")) {
                IO.attachScreenHandler(this.program);
            }
            Object result = ((ICallTarget)this.program).call(params.toConventionArray(), params.toObjectArray());
            this.getConditionCode().move(Context.getConditionCodeValue());
            return result;
        }
        if (this.program instanceof ICallTarget2) {
            if (this.program.getClass().getName().endsWith("VOPENFORMF")) {
                IO.attachScreenHandler(this.program);
            }
            Object result = ((ICallTarget2)this.program).call(this, params.toConventionArray(), params.toObjectArray());
            this.getConditionCode().move(Context.getConditionCodeValue());
            return result;
        }
        Class<?> objectClass = this.program.getClass();
        Class[] paramClasses = new Class[]{String[].class};
        Method m = objectClass.getMethod("main", paramClasses);
        if (m == null) {
            throw new EcProgramPtrNull();
        }
        int size = params.size();
        String[] mainParams = new String[size];
        for (int i = 0; i < size; ++i) {
            mainParams[i] = params.getDisplayString(i);
        }
        return m.invoke(this.program, new Object[]{mainParams});
    }

    public Object performProgram() throws Throwable {
        if (this.program == null) {
            throw new EcProgramPtrNull();
        }
        Class<?> objectClass = this.program.getClass();
        Class[] paramClasses = new Class[]{String[].class};
        Method m = objectClass.getMethod("main", paramClasses);
        if (m == null) {
            throw new EcProgramPtrNull();
        }
        String[] mainParams = new String[]{};
        return m.invoke(this.program, new Object[]{mainParams});
    }

    public Object performProgram(parameterList params) throws Throwable {
        if (this.program == null) {
            throw new EcProgramPtrNull();
        }
        if (params == null) {
            return this.performProgram();
        }
        Class<?> objectClass = this.program.getClass();
        Class[] paramClasses = new Class[]{String[].class};
        Method m = objectClass.getMethod("main", paramClasses);
        if (m == null) {
            throw new EcProgramPtrNull();
        }
        int size = params.size();
        String[] mainParams = new String[size];
        for (int i = 0; i < size; ++i) {
            mainParams[i] = params.getDisplayString(i);
        }
        return m.invoke(this.program, new Object[]{mainParams});
    }

    public void setProgram(Object program) {
        this.program = program;
    }

    public void setProgram(ICobolInterface program) {
        this.program = program;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public static final ICallableProgramGiving getIntrinsicByName(String programName, String[][] localNameConverter) {
        try {
            MPEIntrinsic intrinsic = mpeIntrinsics.get(programName.toUpperCase());
            if (intrinsic != null) {
                return intrinsic;
            }
            intrinsic = new MPEIntrinsic(programName);
            mpeIntrinsics.put(programName.toUpperCase(), intrinsic);
            return intrinsic;
        }
        catch (Exception t) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(Exception t)");
                t.printStackTrace();
            }
            return null;
        }
    }

    public static final ICallableProgramGiving getIntrinsicByName(String programName, String source, String[][] localNameConverter) {
        try {
            MPEIntrinsic intrinsic = mpeIntrinsics.get((programName + "!" + source).toUpperCase());
            if (intrinsic != null) {
                return intrinsic;
            }
            intrinsic = new MPEIntrinsic(programName, source);
            mpeIntrinsics.put(programName.toUpperCase(), intrinsic);
            return intrinsic;
        }
        catch (Exception t) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(Exception t)");
                t.printStackTrace();
            }
            return null;
        }
    }

    private final ICallableProgramGiving getConnectProgramByName(String calledProgramName) {
        block19: {
            try {
                block18: {
                    int programNameLength = calledProgramName.length();
                    if (codeSuffixIsAcu || calledProgramName.charAt(0) == '*') {
                        String acuName = calledProgramName;
                        if (codeCase == 1) {
                            acuName = calledProgramName.toLowerCase();
                        } else if (codeCase == 2) {
                            acuName = calledProgramName.toUpperCase();
                        }
                        if (codeSuffix != null && acuName.indexOf(46) < 0) {
                            acuName = acuName + codeSuffix;
                        }
                        return AConnect.getProgramByName(this, acuName);
                    }
                    if (programNameLength < 4) {
                        return null;
                    }
                    if (calledProgramName.charAt(programNameLength - 4) == '.' && calledProgramName.toUpperCase().endsWith(".ACU")) {
                        String acuName = calledProgramName;
                        if (codeCase == 1) {
                            acuName = calledProgramName.toLowerCase();
                        } else if (codeCase == 2) {
                            acuName = calledProgramName.toUpperCase();
                        }
                        return AConnect.getProgramByName(this, acuName);
                    }
                    if (programNameLength < 7) {
                        return null;
                    }
                    if (calledProgramName.charAt(5) == ':' && (calledProgramName.startsWith("AS400") || calledProgramName.startsWith("as400"))) {
                        try {
                            String as400Name = calledProgramName.substring(6);
                            if (as400Name.indexOf(58) >= 0) {
                                as400Name = "*" + as400Name;
                            }
                            return AS400Connect.getProgramByName(this, as400Name);
                        }
                        catch (Throwable t) {
                            if (!LogSetup.IS_LOGGING_INFO) break block18;
                            LogSetup.LOGGER.info("catch(Throwable t)");
                            t.printStackTrace();
                        }
                    }
                }
                if (calledProgramName.charAt(1) == '$' && ("C$ASYNCRUN".equalsIgnoreCase(calledProgramName) || "C$ASYNCPOLL".equalsIgnoreCase(calledProgramName))) {
                    return AConnect.getProgramByName(this, calledProgramName);
                }
            }
            catch (Exception neverThrowAnExceptionFromThisMethod) {
                if (!LogSetup.IS_LOGGING_INFO) break block19;
                LogSetup.LOGGER.info("catch(Exception neverThrowAnExceptionFromThisMethod)");
                neverThrowAnExceptionFromThisMethod.printStackTrace();
            }
        }
        return null;
    }

    public static final ICallableProgram getProgramByName(String calledProgramName, String[][] localNameConverter, int callingConvention) {
        ICallableProgram result;
        block15: {
            block14: {
                block13: {
                    try {
                        String betterName = quickMatch.get(calledProgramName);
                        if (betterName != null) {
                            Context.setCallFailCode(0);
                            return Context.getInstance(betterName);
                        }
                    }
                    catch (Exception betterNameException) {
                        if (LogSetup.IS_LOGGING_INFO) {
                            LogSetup.LOGGER.info("catch(Exception betterNameException)");
                            betterNameException.printStackTrace();
                        }
                    }
                    catch (LinkageError linkageError) {
                        if (!LogSetup.IS_LOGGING_INFO) break block13;
                        LogSetup.LOGGER.info("catch(LinkageError linkageError)");
                        linkageError.printStackTrace();
                    }
                }
                result = null;
                try {
                    result = Context.getProgramByNameInner(calledProgramName, localNameConverter);
                }
                catch (IPCException exception) {
                    if (!LogSetup.IS_LOGGING_INFO) break block14;
                    LogSetup.LOGGER.info("catch(IPCException exception))");
                    exception.printStackTrace();
                }
            }
            if (result == null) {
                try {
                    result = Context.getProgramByNameInner(LIBCALL_PACKAGE + calledProgramName.toUpperCase(), localNameConverter);
                }
                catch (IPCException exception) {
                    if (!LogSetup.IS_LOGGING_INFO) break block15;
                    LogSetup.LOGGER.info("catch(IPCException exception)");
                    exception.printStackTrace();
                }
            }
        }
        if (result != null) {
            Context.setCallFailCode(0);
        } else if (Context.getCallFailCode() == 0) {
            Context.setCallFailCode(1);
        }
        return result;
    }

    private static final ICallableProgramGiving getNativeCall(String calledProgramName, String[][] localNameConverter, int callingConvention) {
        if (!NativeCall.isSupported()) {
            return null;
        }
        if (NativeCall.isFound(calledProgramName, callingConvention)) {
            NativeCall returnNc = new NativeCall(calledProgramName, callingConvention);
            instancesLoadMap.put(Context.getGlobalProgramByName(Context.normalizeName(calledProgramName), localNameConverter), returnNc);
            return returnNc;
        }
        return null;
    }

    private static final ICallableProgram getInstance(String calledProgramName) throws Exception, LinkageError {
        Class<?> c = classesLoad.get(calledProgramName);
        if (c == null) {
            c = Class.forName(calledProgramName);
            classesLoad.put(calledProgramName, c);
        }
        return (ICallableProgram)c.newInstance();
    }

    private static final ICallableProgram getProgramByNameInner(String calledProgramName, String[][] localNameConverter) {
        String redirectName = null;
        String originalProgramName = calledProgramName;
        calledProgramName = calledProgramName.replace('-', '_');
        EcProgram ipcException = null;
        for (int pass = 0; pass < 3; ++pass) {
            String result;
            ICallableProgram program;
            block20: {
                if (pass == 1) {
                    calledProgramName = calledProgramName.toLowerCase();
                }
                if (pass == 2) {
                    calledProgramName = "_" + calledProgramName;
                }
                try {
                    do {
                        if ((program = Context.getInstance(calledProgramName)) == null) continue;
                        quickMatch.put(originalProgramName, calledProgramName);
                        redirectName = program.redirectCall();
                        if (redirectName == null) continue;
                        calledProgramName = redirectName;
                    } while (redirectName != null);
                    if (program != null) {
                        return program;
                    }
                }
                catch (VerifyError verifyError) {
                    Context.setCallFailCode(3);
                    ipcException = new IPCException(verifyError, CALL_MESSAGE_VERIFY);
                }
                catch (ClassCastException classCastException) {
                    Context.setCallFailCode(2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Context.setCallFailCode(4);
                    ipcException = new EcProgramResources();
                }
                catch (Exception e) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch(Exception e)");
                        e.printStackTrace();
                    }
                }
                catch (LinkageError linkageError) {
                    if (!LogSetup.IS_LOGGING_INFO) break block20;
                    LogSetup.LOGGER.info("catch(LinkageError linkageError)");
                    linkageError.printStackTrace();
                }
            }
            if (pass == 0 || (result = Context.getGlobalProgramByName(calledProgramName, localNameConverter)) == null) continue;
            try {
                calledProgramName = result;
                do {
                    if ((program = Context.getInstance(calledProgramName)) == null) continue;
                    quickMatch.put(originalProgramName, calledProgramName);
                    redirectName = program.redirectCall();
                    if (redirectName == null) continue;
                    calledProgramName = redirectName;
                } while (redirectName != null);
                if (program == null) continue;
                return program;
            }
            catch (VerifyError verifyError) {
                Context.setCallFailCode(3);
                ipcException = new IPCException(verifyError, CALL_MESSAGE_VERIFY);
                continue;
            }
            catch (ClassCastException classCastException) {
                Context.setCallFailCode(2);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Context.setCallFailCode(4);
                ipcException = new EcProgramResources();
                continue;
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) continue;
                LogSetup.LOGGER.info("catch(Exception e)");
                e.printStackTrace();
                continue;
            }
            catch (LinkageError linkageError) {
                if (!LogSetup.IS_LOGGING_INFO) continue;
                LogSetup.LOGGER.info("catch(LinkageError linkageError)");
                linkageError.printStackTrace();
            }
        }
        if (ipcException != null) {
            throw ipcException;
        }
        return null;
    }

    public final void runBegin(int thread) {
        this.currentThread = thread;
        this.runBegin();
    }

    public final void runBegin() {
        if (this.currentThread == -1) {
            this.currentThread = Context.uniqueID();
        }
    }

    public void runEnd() {
        Integer addition = new Integer(this.currentThread);
        if (uniqueThreadNumbers.indexOf(addition) >= 0) {
            return;
        }
        uniqueThreadNumbers.addElement(addition);
    }

    private static final synchronized int uniqueID() {
        if (uniqueThreadNumbers.isEmpty()) {
            return ++highestAllocatedUnique;
        }
        int n = uniqueThreadNumbers.firstElement();
        uniqueThreadNumbers.removeElementAt(0);
        return n;
    }

    public void setCurrency(char c) {
        Memory.setGlobalCurrency(c);
    }

    public void setComma(char c) {
        Memory.setGlobalComma(c);
    }

    public void setDecimal(char c) {
        Memory.setGlobalDecimal(c);
    }

    public void setCollatingSequence(String s) {
        Memory.setGlobalCollatingSequence(s);
    }

    public void setCollatingSequence(byte[] ba) {
        String s = new String(ba, Variable.defaultCharset);
        for (int i = 0; i < s.length() - 2; ++i) {
            if ((byte)s.charAt(i) != -8 || (byte)s.charAt(i + 1) != -1) continue;
            s = s.substring(0, i) + "\uf8ff" + s.substring(i + 2);
        }
        Memory.setGlobalCollatingSequence(s);
    }

    public String getEventData() {
        return this.eventData;
    }

    public void setEventData(Object value) {
        this.eventData = String.valueOf(value);
    }

    public Object getEventObject() {
        return this.eventObject;
    }

    public void setEventObject(Object value) {
        this.eventObject = value;
    }

    public void moveEvent(Context baseContext) {
        if (baseContext == null) {
            return;
        }
        this.eventData = baseContext.eventData;
        this.eventObject = baseContext.eventObject;
    }

    public Display getReturnCode() {
        return this.returnCode != null ? this.returnCode : (this.returnCode = new Display("99999", "0"));
    }

    public int getReturnInt() {
        return this.returnCode != null ? this.returnCode.toInt() : 0;
    }

    public long getReturnLong() {
        return this.returnCode != null ? this.returnCode.toLong() : 0L;
    }

    public void setReturnCode(int value) {
        if (this.returnCode != null) {
            this.returnCode.move(value);
        } else if (value != 0) {
            this.getReturnCode().move(value);
        }
    }

    public void setReturnCode(long value) {
        if (this.returnCode != null) {
            this.returnCode.move(value);
        } else if (value != 0L) {
            this.getReturnCode().move(value);
        }
    }

    public void setReturnCode(Display value) {
        this.returnCode = value;
    }

    public void setReturnCode(Numeric value) {
        this.getReturnCode().move(value);
    }

    public void setReturnCode(Variable value) {
        this.getReturnCode().move(value);
    }

    public Numeric getConditionCode() {
        if (this.conditionCode == null) {
            if (this.parent != null) {
                this.conditionCode = this.parent.conditionCode;
                if (this.conditionCode == null) {
                    this.parent.conditionCode = this.conditionCode = new Numeric();
                }
                return this.conditionCode;
            }
            this.conditionCode = new Numeric();
            return this.conditionCode;
        }
        return this.conditionCode;
    }

    public int getConditionInt() {
        return this.conditionCode != null ? this.conditionCode.toInt() : 0;
    }

    public long getConditionLong() {
        return this.conditionCode != null ? this.conditionCode.toLong() : 0L;
    }

    public void setConditionCode(int value) {
        if (this.conditionCode != null) {
            this.conditionCode.move(value);
        } else if (value != 0) {
            this.getConditionCode().move(value);
        }
    }

    public void setConditionCode(long value) {
        if (this.conditionCode != null) {
            this.conditionCode.move(value);
        } else if (value != 0L) {
            this.getConditionCode().move(value);
        }
    }

    public void setConditionCode(Numeric value) {
        this.getConditionCode().move(value);
    }

    public void setConditionCode(Variable value) {
        this.getConditionCode().move(value);
    }

    @Override
    public int getCC() {
        return this.getConditionInt();
    }

    @Override
    public void setCC(int value) {
        this.setConditionCode(value);
    }

    public String getArgument(int number) {
        return this.getParameter("parameter" + Utilities.format(this.argumentPosition, 2));
    }

    public String acceptArgumentNumber() {
        String result = this.getParameter("parameters");
        return result == null ? "0" : result;
    }

    public boolean displayArgumentNumber(String x) {
        this.argumentPosition = 1;
        try {
            this.argumentPosition = ConvertData.parseInt(x);
        }
        catch (Exception e) {
            return false;
        }
        if (this.argumentPosition < 0) {
            this.argumentPosition = 1;
        }
        return true;
    }

    public String acceptArgumentValue() {
        String result = this.getArgument(this.argumentPosition);
        ++this.argumentPosition;
        return result == null ? "" : result;
    }

    public String acceptEnvironmentValue() {
        this.currentEnvironmentValue = this.getParameter(this.currentEnvironmentName);
        return this.currentEnvironmentValue;
    }

    public boolean displayEnvironmentName(String name) {
        if (name != null) {
            this.currentEnvironmentName = name.trim();
            return true;
        }
        return false;
    }

    public boolean displayEnvironmentValue(String value) {
        if (value == null) {
            value = "";
        }
        if (this.currentEnvironmentName == null) {
            this.currentEnvironmentName = "default.property";
        }
        this.setParameter(this.currentEnvironmentName, value);
        return true;
    }

    public String getCommandLine() {
        return RuntimeEnvironment.getGlobalRuntimeEnvironment().getCommandLine();
    }

    public void setCommandLine(String value) {
        RuntimeEnvironment.getGlobalRuntimeEnvironment().setCommandLine(value);
    }

    public Vector<basicFile> getFiles() {
        Vector files = (Vector)this.getFilData().get(FILES_KEY);
        if (files == null) {
            files = new Vector();
            this.getFilData().put(FILES_KEY, files);
        }
        return files;
    }

    public Vector<basicFile> getFilesReadOnly() {
        return (Vector)this.getFilData().get(FILES_KEY);
    }

    public static void setApplicationParameter(String name, String value) {
        RuntimeEnvironment.setGlobalParameter(name, value);
    }

    public static void initializeApplication(ICobolProgram programObject, String[] args) {
        Utilities.initializeRuntime(programObject, args);
        programObject.setup(null);
    }

    public static final boolean isMainApplication() {
        return Utilities.isMainApplication();
    }

    private void forbidExit(String msg) {
        throw new EcFlowImpStopInvalid();
    }

    public static void applicationExit() {
        Shutdown.appReturnCode = CobolException.getEnvReturnCode(appReturnCode);
        Shutdown.requestExit();
    }

    public void requestExit() {
        this.exitContext();
        if (!this.canExit()) {
            this.forbidExit("request exit");
        }
        Shutdown.requestExit();
    }

    public void exit(String stopLiteral, int param) {
        this.exitContext();
        if (!this.canExit()) {
            this.forbidExit("exit with stop literal='" + stopLiteral + "', exit code=" + param);
        }
        Shutdown.exit(stopLiteral, param);
    }

    public void exit(int param) {
        this.exitContext();
        if (!this.canExit()) {
            this.forbidExit("exit code " + param);
        }
        Shutdown.exit(param);
    }

    public void exitAbend(int param) {
        String abndFileInd = System.getProperty("ABEND-INDICATOR");
        if (abndFileInd != null) {
            File abndFile = new File(abndFileInd);
            try {
                abndFile.createNewFile();
            }
            catch (IOException e) {
                LogSetup.LOGGER.warning("EBP AbendFile creation Error: " + e.getMessage());
                if (LogSetup.LOGGER.isLoggable(Level.WARNING)) {
                    e.printStackTrace();
                }
                e.printStackTrace();
            }
        }
        this.rollbackSQLContext();
        this.exit(param);
    }

    public static void exitAbendActiveContext(int param) {
        if (activeContext != null) {
            activeContext.exitAbend(param);
        }
    }

    private void rollbackSQLContext() {
        block3: {
            if (this.sqlContext != null) {
                try {
                    this.sqlContext.rollback();
                }
                catch (SQLException e) {
                    LogSetup.LOGGER.warning("sqlContext.rollback() has Exception. " + e.getMessage());
                    if (!LogSetup.LOGGER.isLoggable(Level.WARNING)) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public void exit() {
        int retnCode = this.getReturnInt();
        this.exitContext();
        if (!this.canExit()) {
            this.forbidExit("");
        }
        Shutdown.exit(retnCode);
    }

    public void exit(Numeric param) {
        this.exitContext();
        if (!this.canExit()) {
            this.forbidExit("exit code " + param.toInt());
        }
        Shutdown.exit(param);
    }

    public void exit(Variable param) {
        this.exitContext();
        if (!this.canExit()) {
            this.forbidExit("exit code " + param.toInt());
        }
        Shutdown.exit(param);
    }

    public void exitWhenFinished(boolean status) {
        this.exitContext();
        if (!this.canExit()) {
            this.forbidExit(null);
        }
        Shutdown.exitWhenFinished(status);
    }

    private void exitContext() {
        if (this.sqlContext != null) {
            this.sqlContext.exit();
        }
    }

    public void setIdentifiedBy(Variable v, String name) {
    }

    public void setIdentifiedBy(Variable v, String name, String defaultValue) {
    }

    public void setExceptionValue(int exceptionValue, String identifier) {
        Handle.setExceptionValue(exceptionValue, identifier);
    }

    private String externalName(String name) {
        if (name == null) {
            return null;
        }
        return name.toUpperCase().replace('_', '-');
    }

    @Override
    public Object getExternal(String name) {
        if (this.establishExternal()) {
            Object externalIdentifier;
            name = this.externalName(name);
            if (this.externalIdentifiers != null && (externalIdentifier = this.externalIdentifiers.get(name)) != null) {
                return externalIdentifier;
            }
        } else {
            return globalExternalIdentifiers.get(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean establishExternal() {
        if (!ExternalsSet) {
            String value = RuntimeEnvironment.getGlobalRuntimeEnvironment().getParameter("EXTERNALS");
            if (value == null || value.equalsIgnoreCase("SESSIONSAFE") || value.equalsIgnoreCase("ON") || value.equalsIgnoreCase("1")) {
                Context.setSessionSafe(true);
            } else if (value.equalsIgnoreCase("GLOBAL") || value.equalsIgnoreCase("OFF") || value.equalsIgnoreCase("0")) {
                Context.setSessionSafe(false);
            } else {
                System.err.println("Elastic COBOL runtime configuration error:  -DEXTERNALS=SESSIONSAFE|ON|1|GLOBAL|OFF|0");
            }
            ExternalsSet = true;
        }
        if (ExternalsSessionSafe && this.externalIdentifiers == null) {
            Map<String, Object> map = this.programContextInSession;
            synchronized (map) {
                Map<String, Object> map2;
                this.externalIdentifiers = (Hashtable)this.programContextInSession.get(EXTERNAL_IDENTIFIER_KEY);
                if (this.externalIdentifiers == null) {
                    map2 = this.programContextInSession;
                    synchronized (map2) {
                        this.externalIdentifiers = (Hashtable)this.programContextInSession.get(EXTERNAL_IDENTIFIER_KEY);
                        if (this.externalIdentifiers == null) {
                            this.externalIdentifiers = new Hashtable<String, Object>();
                            this.programContextInSession.put(EXTERNAL_IDENTIFIER_KEY, this.externalIdentifiers);
                        }
                    }
                }
                this.externalFileIdentifiers = (Hashtable)this.programContextInSession.get(EXTERNAL_FILE_IDENTIFIER_KEY);
                if (this.externalFileIdentifiers == null) {
                    map2 = this.programContextInSession;
                    synchronized (map2) {
                        this.externalFileIdentifiers = (Hashtable)this.programContextInSession.get(EXTERNAL_FILE_IDENTIFIER_KEY);
                        if (this.externalFileIdentifiers == null) {
                            this.externalFileIdentifiers = new Hashtable<String, Object>();
                            this.programContextInSession.put(EXTERNAL_FILE_IDENTIFIER_KEY, this.externalFileIdentifiers);
                        }
                    }
                }
            }
        }
        return ExternalsSessionSafe;
    }

    public Object getExternal(Object identifier, String name) {
        if (this.establishExternal()) {
            if (this.externalIdentifiers.containsKey(name = this.externalName(name))) {
                return this.externalIdentifiers.get(name);
            }
            this.externalIdentifiers.put(name, identifier);
        } else {
            if (globalExternalIdentifiers.containsKey(name)) {
                return globalExternalIdentifiers.get(name);
            }
            globalExternalIdentifiers.put(name, identifier);
        }
        return null;
    }

    public Object getExternalFile(Object identifier, String name) {
        if (this.establishExternal()) {
            if (this.externalFileIdentifiers.containsKey(name = this.externalName(name))) {
                return this.externalFileIdentifiers.get(name);
            }
            this.externalFileIdentifiers.put(name, identifier);
        } else {
            if (globalExternalFileIdentifiers.containsKey(name)) {
                return globalExternalFileIdentifiers.get(name);
            }
            globalExternalFileIdentifiers.put(name, identifier);
        }
        return null;
    }

    private static void setDefaultIO() {
        defsys = RuntimeEnvironment.isGlobalParameter("DEFSYS");
    }

    public IO console() {
        if (System.getenv("HCI") != null) {
            return this.system();
        }
        return IO.console();
    }

    public IO system() {
        return IO.system();
    }

    public IO syserr() {
        return IO.syserr();
    }

    public IO printer() {
        return IO.printer();
    }

    public IO current() {
        return IO.current();
    }

    public IO servlet() {
        return IO.servlet();
    }

    public IO session() {
        return IO.servlet();
    }

    public IO defaultio() {
        return defsys ? this.system() : this.current();
    }

    public String acceptTerminalInfo() {
        return AcceptSpecial.acceptTerminalInfo(IO.getCurrentIONoCreate());
    }

    public int acceptLines() {
        return AcceptSpecial.acceptLines();
    }

    public int acceptColumns() {
        return AcceptSpecial.acceptColumns();
    }

    public String acceptExceptionStatus() {
        return AcceptSpecial.acceptExceptionStatus();
    }

    public String acceptSystemInfo() {
        return AcceptSpecial.acceptSystemInfo();
    }

    public String acceptInputStatus() {
        return AcceptSpecial.acceptInputStatus();
    }

    public void setColumns(int columns) {
        Utilities.setColumns(columns);
    }

    public void setLines(int lines) {
        Utilities.setLines(lines);
    }

    public IO ioFeedback() {
        return IO.ioFeedback();
    }

    public IO openFeedback() {
        return IO.openFeedback();
    }

    public IO dataArea() {
        return IO.dataArea();
    }

    public IO localData() {
        return IO.localData();
    }

    public IO pipData() {
        return IO.pipData();
    }

    public IO attributeData() {
        return IO.attributeData();
    }

    public final Variable shiftOut() {
        return SHIFT_OUT != null ? SHIFT_OUT : (SHIFT_OUT = new Variable("\u000e"));
    }

    public final Variable shiftIn() {
        return SHIFT_IN != null ? SHIFT_IN : (SHIFT_IN = new Variable("\u000f"));
    }

    public final Variable sortControl() {
        return SORT_CONTROL != null ? SORT_CONTROL : (SORT_CONTROL = new Variable("IGZSRTCD"));
    }

    public final Binary sortCoreSize() {
        return SORT_CORE_SIZE != null ? SORT_CORE_SIZE : (SORT_CORE_SIZE = new Binary(0L, true, 4, 8));
    }

    public final Binary sortFileSize() {
        return SORT_FILE_SIZE != null ? SORT_FILE_SIZE : (SORT_FILE_SIZE = new Binary(0L, true, 4, 8));
    }

    public final Variable sortMessage() {
        return SORT_MESSAGE != null ? SORT_MESSAGE : (SORT_MESSAGE = new Variable("SYSOUT"));
    }

    public final Binary sortModeSize() {
        return SORT_MODE_SIZE != null ? SORT_MODE_SIZE : (SORT_MODE_SIZE = new Binary(0L, true, 4, 5));
    }

    public final Binary sortReturn() {
        return SORT_RETURN != null ? SORT_RETURN : (SORT_RETURN = new Binary(0L, true, 2, 4));
    }

    public final Binary tally() {
        return TALLY != null ? TALLY : (TALLY = new Binary(0L, false, 4, 5));
    }

    public final void initializeSort() {
        if (SORT_RETURN != null) {
            this.sortReturn().move(0);
        }
    }

    public final void cancelSort() {
        this.sortReturn().move(16);
    }

    public final void cancelAll() {
    }

    public final boolean isSortCancelled() {
        if (SORT_RETURN == null) {
            return false;
        }
        return this.sortReturn().compare(16) == 0;
    }

    public final boolean isSortReady() {
        if (SORT_RETURN == null) {
            return true;
        }
        return this.sortReturn().compare(16) != 0;
    }

    public void setLogging(String category, boolean enabled) {
        this.setLogging(category, enabled ? 1 : 0);
    }

    public void setLogging(String category, Object output) {
        if (output == null) {
            this.setLogging(category, false);
            return;
        }
        if (output instanceof String) {
            String outputString = (String)output;
            this.setLogging(category, Integer.parseInt(outputString.trim()));
            return;
        }
        if (output instanceof Number) {
            this.setLogging(category, ((Number)output).intValue());
            return;
        }
    }

    public void setLogging(String category, int level) {
    }

    public static final void setGlobalFileCharacter(String s0) {
        if (s0 != null && s0.length() > 0) {
            Context.setGlobalFileCharacter(s0.charAt(0));
        }
    }

    public static final void setGlobalFileCharacter(char c0) {
        globalFileCharacter = c0;
    }

    public static final void setGlobalFileCharacter() {
        globalFileCharacter = (char)65535;
    }

    public static final char getGlobalFileCharacter() {
        return globalFileCharacter;
    }

    public static final String globalConvertFilename(String filename) {
        return globalFileCharacter == '\uffff' ? filename : filename.replace(globalFileCharacter, File.separatorChar);
    }

    public static final void cleanUpSession(Context ctx) {
        ctx.programContextInSession.forEach((key, value) -> {
            if (instancesLoadMap.get(key) == ((Context)value).program) {
                instancesLoadMap.remove(key);
            }
        });
        if (ctx.programContextInSession != null) {
            ctx.programContextInSession.clear();
        }
        if (ctx.externalIdentifiers != null) {
            ctx.externalIdentifiers.clear();
        }
        if (ctx.lnkArrayTable != null) {
            ctx.lnkArrayTable.clear();
        }
        if (ctx.wrksTable != null) {
            ctx.wrksTable.clear();
        }
        if (stringToClassMap != null) {
            stringToClassMap.clear();
        }
    }

    public final String convertFilename(String filename) {
        return Context.globalConvertFilename(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlingAbend(boolean state) {
        Context context = this;
        synchronized (context) {
            this.handlingAbend += state ? 1 : -1;
        }
    }

    public boolean pushHandle() {
        if (this.parent != null) {
            this.exceptionHandler = null;
            return this.parent.pushHandle();
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new Vector();
        }
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new Hashtable();
        }
        this.exceptionHandlers.addElement(this.exceptionHandler);
        this.exceptionHandler = null;
        return true;
    }

    public boolean popHandle() {
        if (this.parent != null) {
            this.exceptionHandler = null;
            return this.parent.popHandle();
        }
        if (this.exceptionHandlers == null) {
            return false;
        }
        int size = this.exceptionHandlers.size();
        if (size <= 0) {
            return false;
        }
        this.exceptionHandler = this.exceptionHandlers.elementAt(size - 1);
        this.exceptionHandlers.removeElementAt(size - 1);
        return true;
    }

    public Hashtable<String, Object> getExceptionHandler() {
        if (this.parent != null) {
            return this.parent.getExceptionHandler();
        }
        if (this.exceptionHandler != null) {
            return this.exceptionHandler;
        }
        this.exceptionHandler = new Hashtable<String, Object>();
        return this.exceptionHandler;
    }

    public void registerHandler(Object exception, int entryLabel) {
        if (exception == null) {
            return;
        }
        this.registerHandler(exception.getClass(), entryLabel);
    }

    public void registerHandler(Object exception, ProcedurePointer entryLabel) {
        if (exception == null) {
            return;
        }
        this.registerHandler(exception.getClass(), entryLabel);
    }

    public void registerHandler(Class<?> exception, int entryLabel) {
        if (exception == null) {
            return;
        }
        this.registerHandler(exception.getName(), entryLabel);
    }

    public void registerHandler(Class<?> exception, ProcedurePointer entryLabel) {
        if (exception == null) {
            return;
        }
        this.registerHandler(exception.getName(), entryLabel);
    }

    public void registerHandler(String exception, int entryLabel) {
        if (exception == null) {
            return;
        }
        this.getExceptionHandler().put(exception.toUpperCase(), new ProcedurePointer(this.program, this, entryLabel));
    }

    public void registerHandler(String exception, ProcedurePointer entryLabel) {
        if (exception == null) {
            return;
        }
        if (entryLabel == null) {
            this.getExceptionHandler().remove(exception.toUpperCase());
        } else {
            this.getExceptionHandler().put(exception.toUpperCase(), entryLabel);
        }
    }

    public void ignoreHandler(Object exception) {
        if (exception == null) {
            return;
        }
        this.ignoreHandler(exception.getClass());
    }

    public void ignoreHandler(Class<?> exception) {
        if (exception == null) {
            return;
        }
        this.ignoreHandler(exception.getName());
    }

    public void ignoreHandler(String exception) {
        if (exception == null) {
            return;
        }
        this.getExceptionHandler().put(exception.toUpperCase(), IGNORE_CONDITION_OBJECT);
    }

    public void registerHandlerAbend(int entryLabel) {
        this.abendHandlerLabel = new ProcedurePointer(this.program, this, entryLabel);
        this.abendHandlerLink = null;
    }

    public void registerHandlerAbend(ProcedurePointer entryLabel) {
        this.abendHandlerLabel = new ProcedurePointer(entryLabel);
        this.abendHandlerLink = null;
    }

    public void registerHandlerAbend(String linkProgram) {
        this.abendHandlerLabel = null;
        this.abendHandlerLink = linkProgram;
    }

    public void registerHandlerAbendCancel() {
        if (this.parent != null) {
            this.parent.registerHandlerAbendCancel();
        } else {
            this.abendHandlerCancelled = true;
        }
    }

    public void registerHandlerAbendReset() {
        if (this.parent != null) {
            this.parent.registerHandlerAbendReset();
        } else {
            this.abendHandlerCancelled = false;
        }
    }

    private boolean isAbendHandlerAvailable() {
        if (this.parent != null) {
            return this.parent.isAbendHandlerAvailable();
        }
        if (this.abendHandlerCancelled) {
            return false;
        }
        if (this.abendHandlerLink != null) {
            return true;
        }
        return this.abendHandlerLabel != null;
    }

    public Object abend(String message, String longMessage, Throwable exception, String abcode, boolean ignoreHandler, boolean dump) {
        AbendException abendException;
        if (exception instanceof AbendException) {
            abendException = (AbendException)exception;
            ignoreHandler |= abendException.isIgnoreHandler();
            if (abcode == null) {
                abcode = abendException.getAbcode();
            }
            if (!dump) {
                abendException.setDump(false);
            }
        }
        this.abcode = abcode;
        this.abendProgram = this.programName;
        if (!ignoreHandler) {
            if (!this.abendHandlerCancelled && this.handlingAbend <= 0) {
                if (this.abendHandlerLabel != null) {
                    if (this.abendHandlerLabel.getContext() == this) {
                        return new Integer(this.abendHandlerLabel.getParagraph());
                    }
                    this.abendHandlerLabel.getContext().handlingAbend(true);
                    this.abendHandlerLabel.run();
                    this.abendHandlerLabel.getContext().handlingAbend(false);
                    return new Integer(0);
                }
                if (this.abendHandlerLink != null) {
                    String returnAbendHandlerLink = this.abendHandlerLink;
                    this.abendHandlerLink = null;
                    return returnAbendHandlerLink;
                }
            }
            if (this.parent == null || !this.isAbendHandlerAvailable()) {
                switch (CobolException.abend(message, longMessage, exception)) {
                    case 0: {
                        return new Integer(0);
                    }
                    case 2: {
                        return new Integer(-1);
                    }
                }
            }
        }
        if (exception instanceof AbendException) {
            abendException = (AbendException)exception;
        } else {
            abendException = new AbendException(message, longMessage, exception, abcode, ignoreHandler);
            abendException.setProgramName(this.programName);
        }
        if (!dump) {
            abendException.setDump(false);
        }
        throw abendException;
    }

    public Object abend(Object abcode, boolean ignoreHandler, boolean dump) {
        StringBuffer longDescription;
        String abcodeString;
        block6: {
            block5: {
                abcodeString = "????";
                longDescription = new StringBuffer(64);
                if (abcode != null) {
                    try {
                        abcodeString = abcode instanceof IDatatype ? ((IDatatype)abcode).toText() : String.valueOf(abcode);
                    }
                    catch (Exception abcodeException) {
                        if (!LogSetup.IS_LOGGING_INFO) break block5;
                        LogSetup.LOGGER.info("catch(Exception abcodeException)");
                        abcodeException.printStackTrace();
                    }
                }
            }
            try {
                longDescription.append("PROGRAMMATIC ABEND\n\n").append("ABCODE ").append(abcodeString).append(": ").append(dump ? "DUMP" : "NO DUMP").append(", ").append(ignoreHandler ? "CANCEL EXITS" : "USE EXITS");
            }
            catch (Exception longDescriptionException) {
                if (!LogSetup.IS_LOGGING_INFO) break block6;
                LogSetup.LOGGER.info("catch(Exception longDescriptionException)");
                longDescriptionException.printStackTrace();
            }
        }
        return this.abend(abcodeString, longDescription.toString(), null, abcodeString, ignoreHandler, dump);
    }

    public Object abend(String message, Throwable exception) {
        return this.abend(message, null, exception, null, false, true);
    }

    public Object abend(String message) {
        return this.abend(message, null, null, null, false, true);
    }

    public Object abend(Throwable exception) {
        return this.abend(null, null, exception, null, false, true);
    }

    public int handleException(Object exception, boolean ignoreByDefault, String abendCode) {
        if (exception == null) {
            return 0;
        }
        if (exception instanceof Throwable) {
            return this.handleException((Throwable)exception, ignoreByDefault, abendCode);
        }
        if (exception instanceof String) {
            return this.handleException((String)exception, ignoreByDefault, abendCode);
        }
        return this.handleException(exception.getClass(), ignoreByDefault, abendCode);
    }

    public int handleException(Class<?> exception, boolean ignoreByDefault, String abendCode) {
        if (exception == null) {
            return 0;
        }
        return this.handleException(exception.getName(), ignoreByDefault, abendCode);
    }

    public int handleException(String exception, boolean ignoreByDefault, String abendCode) {
        if (exception == null) {
            return 0;
        }
        String exceptionText = exception.toString().toUpperCase();
        Object o = this.getExceptionHandler().get(exceptionText);
        if (o != null) {
            if (o == IGNORE_CONDITION_OBJECT) {
                return 0;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            if (o instanceof ProcedurePointer) {
                ProcedurePointer procPointer = (ProcedurePointer)o;
                if (procPointer.getContext() == this) {
                    return procPointer.getParagraph();
                }
                throw new UnwindException(procPointer);
            }
        }
        if (ignoreByDefault) {
            return 0;
        }
        throw new AbendException("Unhandled Exception", exception.toString(), null, abendCode, false);
    }

    public int handleException(Throwable exception, boolean ignoreByDefault, String abendCode) throws AbendException {
        if (exception == null) {
            return 0;
        }
        Object o = this.getExceptionHandler().get(exception);
        if (o != null) {
            if (o == IGNORE_CONDITION_OBJECT) {
                return 0;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            if (o instanceof ProcedurePointer) {
                ProcedurePointer procPointer = (ProcedurePointer)o;
                if (procPointer.getContext() == this) {
                    return procPointer.getParagraph();
                }
                throw new UnwindException(procPointer);
            }
        }
        if (exception instanceof AbendException) {
            throw (AbendException)exception;
        }
        String exceptionText = exception.toString().toUpperCase();
        Object o2 = null;
        o2 = this.getExceptionHandler().get(exceptionText);
        if (o2 == null && "FILENOTFOUND".equalsIgnoreCase(exceptionText)) {
            o2 = this.getExceptionHandler().get("DSIDERR");
        }
        boolean isCatchAll = false;
        if (HANDLE_ERROR_CATCHALL_ON && o2 == null) {
            isCatchAll = true;
            o2 = this.getExceptionHandler().get("ERROR");
        }
        if (isCatchAll && exception instanceof AIDException) {
            return 0;
        }
        if (o2 != null) {
            if (o2 == IGNORE_CONDITION_OBJECT) {
                return 0;
            }
            if (o2 instanceof Number) {
                return ((Number)o2).intValue();
            }
            if (o2 instanceof ProcedurePointer) {
                ProcedurePointer procPointer = (ProcedurePointer)o2;
                if (procPointer.getContext() == this) {
                    return procPointer.getParagraph();
                }
                throw new UnwindException(procPointer);
            }
        }
        if (ignoreByDefault) {
            return 0;
        }
        throw new AbendException("Unhandled Exception", exception.getMessage(), exception, abendCode, false);
    }

    public boolean assign(String name, Object dataArea) {
        if (name == null) {
            return false;
        }
        if (name.equals("ABCODE")) {
            ((IDatatype)dataArea).fromText(this.abcode != null ? this.abcode : "    ");
            return true;
        }
        if (name.equals("ORGABCODE")) {
            ((IDatatype)dataArea).fromText(this.abcode != null ? this.abcode : "    ");
            return true;
        }
        if (name.equals("ABDUMP")) {
            byte[] data = new byte[]{this.abcode == null || this.abcode.trim().length() == 0 ? (byte)0 : -1};
            ((IDatatype)dataArea).fromByteArray(data);
            return true;
        }
        if (name.equals("ABPROGRAM")) {
            ((IDatatype)dataArea).fromText(this.abendProgram != null ? this.abendProgram : "        ");
            return true;
        }
        return false;
    }

    public static final String getStandardAlphabet(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase(ALPHABET_EBCDIC)) {
            String ebcdicCodepage = RuntimeEnvironment.getGlobalParameter(EBCDIC_CODEPAGE_DIRECTIVE);
            return CodePageCollation.getCodepageCollation(Codepage.parseCodepage(ebcdicCodepage));
        }
        return null;
    }

    public static final boolean always() {
        return true;
    }

    public static final boolean never() {
        return false;
    }

    public void setXmlEvent(String value) {
        this.xmlEvent = new Variable(value);
    }

    public void setXmlText(String value) {
        this.xmlNText = this.xmlText = new Variable(value);
    }

    void resetXmlSpecialRegisters() {
        this.xmlCode = null;
        this.xmlEvent = null;
        this.xmlText = null;
        this.xmlNText = null;
    }

    boolean shouldContinueXmlProcessing() {
        if (this.xmlCode == null) {
            return true;
        }
        return this.xmlCode.toInt() == 0;
    }

    public Numeric getXmlCode() {
        if (this.xmlCode == null) {
            this.xmlCode = new Numeric();
        }
        return this.xmlCode;
    }

    public int getXmlInt() {
        if (this.xmlCode == null) {
            return 0;
        }
        return this.xmlCode.toInt();
    }

    public Variable getXmlEvent() {
        if (this.xmlEvent == null) {
            this.xmlEvent = new Variable();
        }
        return this.xmlEvent;
    }

    public int getXmlEventLength() {
        return this.xmlEvent != null ? this.xmlEvent.length() : 0;
    }

    public Variable getXmlText() {
        if (this.xmlText == null) {
            this.xmlText = new Variable();
        }
        return this.xmlText;
    }

    public int getXmlTextLength() {
        return this.xmlText != null ? this.xmlText.length() : 0;
    }

    public Variable getXmlNText() {
        if (this.xmlNText == null) {
            this.xmlNText = new Variable();
        }
        return this.xmlNText;
    }

    public int getXmlNTextLength() {
        return this.xmlNText != null ? this.xmlNText.length() : 0;
    }

    public static final int getCallFailCode() {
        return callLastFailed;
    }

    public static final int getCallPriorFailCode() {
        return callPriorFailed;
    }

    public static final void setCallFailCode(int value) {
        callPriorFailed = callLastFailed;
        callLastFailed = value;
    }

    public static final String getCallFailMessage() {
        return Context.getCallFailMessage(Context.getCallFailCode());
    }

    public static final String getCallFailMessage(int callLastFailed) {
        switch (callLastFailed) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "Program file missing or inaccessible";
            }
            case 2: {
                return "File not a COBOL program";
            }
            case 3: {
                return "Corrupted program file";
            }
            case 4: {
                return "Inadequate memory available to load program";
            }
            case 5: {
                return "Unsupported object code version number";
            }
            case 6: {
                return "Recursive call of a program";
            }
        }
        return "Unknown Error";
    }

    @Override
    public Object get(Object key) {
        Object result = null;
        if (this.transactionEnvironment instanceof IEnvironment) {
            result = ((IEnvironment)this.transactionEnvironment).get(key);
            return result;
        }
        return RuntimeEnvironment.getGlobalParameter(String.valueOf(key).trim());
    }

    @Override
    public Object put(Object key, Object value) {
        Object result = null;
        if (this.transactionEnvironment instanceof IEnvironment) {
            ((IEnvironment)this.transactionEnvironment).put(key, value);
            return result;
        }
        String valueString = value != null ? String.valueOf(value).trim() : null;
        RuntimeEnvironment.setGlobalParameter(String.valueOf(key).trim(), valueString);
        return value;
    }

    @Override
    public Object remove(Object key) {
        Object result = null;
        if (this.transactionEnvironment instanceof IEnvironment) {
            result = ((IEnvironment)this.transactionEnvironment).remove(key);
            return result;
        }
        RuntimeEnvironment.setGlobalParameter(String.valueOf(key).trim(), null);
        return null;
    }

    @Override
    public Object getJDBCConnection(String name) {
        block15: {
            if (this.transactionEnvironment != null) {
                try {
                    Object jdbcConnection;
                    block16: {
                        Method m = this.transactionEnvironment.getClass().getDeclaredMethod("getSqlConnection", String.class);
                        jdbcConnection = m.invoke(this.transactionEnvironment, name);
                        if (jdbcConnection == null) break block15;
                        try {
                            this.getSqlContext().setConnection(name, jdbcConnection);
                        }
                        catch (SQLException e2) {
                            if (!LogSetup.IS_LOGGING_INFO) break block16;
                            LogSetup.LOGGER.info("catch (SQLException e2)");
                            e2.printStackTrace();
                        }
                    }
                    return jdbcConnection;
                }
                catch (SecurityException e1) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch (SecurityException e1)");
                        e1.printStackTrace();
                    }
                }
                catch (IllegalArgumentException e1) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch (IllegalArgumentException e1)");
                        e1.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e1) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch (NoSuchMethodException e1)");
                        e1.printStackTrace();
                    }
                }
                catch (IllegalAccessException e1) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch (IllegalAccessException e1)");
                        e1.printStackTrace();
                    }
                }
                catch (InvocationTargetException e1) {
                    if (!LogSetup.IS_LOGGING_INFO) break block15;
                    LogSetup.LOGGER.info("catch (InvocationTargetException e1)");
                    e1.printStackTrace();
                }
            }
        }
        try {
            return this.getSqlContext().getConnection(name);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public void setJDBCConnection(String name, Object con) throws Exception {
        if (name == null) {
            this.getSqlContext().setConnection(con);
        } else {
            this.getSqlContext().connect(name, con, null, null, null, null);
        }
    }

    @Override
    public Object getJMSConnection(String name) {
        if (name == null) {
            return this.currentJmsConnection;
        }
        if (this.jmsConnections == null) {
            return null;
        }
        return this.jmsConnections.get(name);
    }

    @Override
    public void setJMSConnection(String name, Object con) throws Exception {
        if (name == null) {
            this.currentJmsConnection = con;
            return;
        }
        if (this.jmsConnections == null) {
            this.jmsConnections = new Hashtable();
        }
        if (con == null) {
            this.jmsConnections.remove(name);
        } else {
            this.jmsConnections.put(name, con);
        }
    }

    @Override
    public IDatatype getCursor() {
        return (IDatatype)this.getWrkData().get("cursor");
    }

    public void setCursor(IDatatype cursor) {
        this.getWrkData().put("cursor", cursor);
    }

    public IDatatype getCursor(int n) {
        return (IDatatype)this.getWrkData(n).get("cursor");
    }

    public void setCursor(IDatatype cursor, int n) {
        this.getWrkData(n).put("cursor", cursor);
    }

    @Override
    public IDatatype getCrtStatus() {
        return (IDatatype)this.getWrkData().get("crt_status");
    }

    public void setCrtStatus(IDatatype crtStatus) {
        this.getWrkData().put("crt_status", crtStatus);
    }

    public IDatatype getCrtStatus(int n) {
        return (IDatatype)this.getWrkData().get("crt_status");
    }

    public void setCrtStatus(IDatatype crtStatus, int n) {
        this.getWrkData().put("crt_status", crtStatus);
    }

    @Override
    public IDatatype getEventStatus() {
        return (IDatatype)this.getWrkData().get("event_status");
    }

    public void setEventStatus(IDatatype eventStatus) {
        this.getWrkData().put("event_status", eventStatus);
    }

    public IDatatype getEventStatus(int n) {
        return (IDatatype)this.getWrkData(n).get("event_status");
    }

    public void setEventStatus(IDatatype eventStatus, int n) {
        this.getWrkData(n).put("event_status", eventStatus);
    }

    @Override
    public IDatatype getScreenControl() {
        return (IDatatype)this.getWrkData().get("screen_control");
    }

    public void setScreenControl(IDatatype screenControl) {
        this.getWrkData().put("screen_control", screenControl);
    }

    public IDatatype getScreenControl(int n) {
        return (IDatatype)this.getWrkData(n).get("screen_control");
    }

    public void setScreenControl(IDatatype screenControl, int n) {
        this.getWrkData(n).put("screen_control", screenControl);
    }

    @Override
    public IModule getModule(String moduleName) {
        return null;
    }

    public Numeric getHandleVariable() {
        return this.handleVariable;
    }

    public void setHandleVariable(Numeric handleVariable) {
        this.handleVariable = handleVariable;
    }

    public static void setSessionSafe(boolean externalsSessionSafe) {
        ExternalsSessionSafe = externalsSessionSafe;
    }

    public static Context getActiveContext() {
        return activeContext;
    }

    public static void setActiveContext(Context activeContext) {
        Context.activeContext = activeContext;
    }

    static {
        appReturnCode = 0;
        ExternalsSessionSafe = true;
        ExternalsSet = false;
        forbidden = new TreeSet<String>(Arrays.asList("abstract", "assert", "baseline", "boolean", "break", "byte", "byvalue", "case", "cast", "catch", "char", "class", "clone", "cmn", "cns", "const", "continue", "default", "define", "delegate", "destroy", "do", "double", "else", "enum", "enumerate", "equals", "extends", "false", "fil", "final", "finalize", "finally", "float", "for", "future", "generic", "goto", "if", "implements", "import", "init", "inner", "instanceof", "int", "interface", "interrupt", "interrupted", "join", "lcl", "lnk", "long", "main", "multicast", "native", "new", "notify", "null", "operator", "outer", "package", "param", "private", "protected", "public", "rest", "resume", "return", "rpt", "run", "scr", "self", "service", "setup", "short", "shr", "sleep", "stackable", "start", "static", "stop", "strictfp", "super", "suspend", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "ubyte", "var", "void", "volatile", "wait", "widefp", "while", "wrk", "yield"));
        libcall = new TreeSet<String>(Arrays.asList("ASCII2EBCDIC", "ASCII2HEX", "ASCII2OCTAL", "C$ASYNCPOLL", "C$ASYNCRUN", "C$BITMAP", "C$BTRV", "C$CALLEDBY", "C$CALLERR", "C$CARD", "C$CENTURY", "C$CHAIN", "C$CHDIR", "C$CLEARDEVELOPMENTMODE", "C$COPY", "C$DELAY", "C$DELETE", "C$EXCEPINFO", "C$FILEINFO", "C$FILESYS", "C$FORGET", "C$FULLNAME", "C$GETCGI", "C$GETENV", "C$GETEVENTDATA", "C$GETEVENTPARAM", "C$GETLASTFILENAME", "C$GETLASTFILEOP", "C$GETRMINFO", "C$GETSYN", "C$GETSYSINFO", "C$GUICFG", "C$JUSTIFY", "C$KEYMAP", "C$KEYPROGRESS", "C$LOCALPRINT", "C$LOCKPID", "C$MAKEDIR", "C$MBAR", "C$MEMCPY", "C$MEMORYALLOCATE", "C$MEMORYDEALLOCATE", "C$NARG", "C$OPENSAVEBOX", "C$OSLOCKINFO", "C$PARAMSIZE", "C$PLAYSOUND", "C$RBMENU", "C$RECOVER", "C$RERR", "C$RERRNAME", "C$RESOURCE", "C$RUN", "C$SBAR", "C$SCRD", "C$SCWR", "C$SETDEVELOPMENTMODE", "C$SETENV", "C$SETEVENTDATA", "C$SETEVENTPARAM", "C$SETSYN", "C$SHOW", "C$SHOWARGS", "C$SLEEP", "C$SYSTEM", "C$TBAR", "C$TBAREN", "C$TBARSEQ", "C$TITLE", "C$TOLOWER", "C$TOUPPER", "C$WRU", "CBLTDLI", "CBL_ALLOC_MEM", "CBL_AND", "CBL_CHANGE_DIR", "CBL_CHECK_FILE_EXIST", "CBL_CLOSE_FILE", "CBL_COPY_FILE", "CBL_CREATE_DIR", "CBL_CREATE_FILE", "CBL_DEBUGBREAK", "CBL_DELETE_DIR", "CBL_DELETE_FILE", "CBL_EQ", "CBL_ERROR_PROC", "CBL_EXIT_PROC", "CBL_FLUSH_FILE", "CBL_FREE_MEM", "CBL_GET_OS_INFO", "CBL_GET_PROGRAM_INFO", "CBL_IMP", "CBL_JOIN_FILENAME", "CBL_LOCATE_FILE", "CBL_NOT", "CBL_OPEN_FILE", "CBL_OR", "CBL_READ_DIR", "CBL_READ_FILE", "CBL_RENAME_FILE", "CBL_TOLOWER", "CBL_TOUPPER", "CBL_TRANSFORM", "CBL_WRITE_FILE", "CBL_XOR", "CBL_YIELD_RUN_UNIT", "CEE3ABD", "CEELOCT", "CEEDAYS", "CEEDYWK", "CEESITST", "CEESISET", "CEESICLR", "CEEGTST", "CEEFRST", "CEE5INF", "CEEDSHP", "CICSEXTERNALCALL", "CONDITION_CODE", "DBNTRY", "DFHXCIS", "DISPLAY", "DSNTIAR", "EBCDIC2ASCII", "ETP_LINK", "EZACIC08", "EZASOKET", "HEX2ASCII", "HH", "HS", "HW", "IGZEDT4", "ILBOABN0", "JOBXMIT", "LIB", "M$ALLOC", "M$FREE", "M$PUT", "M$GET", "MQBACK", "MQBEGIN", "MQCLOSE", "MQCMIT", "MQCONN", "MQCONNX", "MQDISC", "MQGET", "MQINQ", "MQOPEN", "MQPUT1", "MQPUT", "MQSET", "OCTAL2ASCII", "P$CHANGEDEVICEMODES", "P$CLEARDIALOG", "P$CLEARDIALOG", "P$CLEARFONT", "P$CLOSE", "P$COMMAND", "P$COMPONENTOUT", "P$CONNECTOR", "P$CONNECTORTHICKNESS", "P$DISABLEDIALOG", "P$DISABLEESCAPESEQUENCES", "P$DISPLAYDIALOG", "P$DISPLAYDIALOG", "P$DRAWBITMAP", "P$DRAWBOX", "P$DRAWLINE", "P$DRAWOVAL", "P$EJECT", "P$ENABLEDIALOG", "P$ENABLEESCAPESEQUENCES", "P$GETDEVICECAPABILITIES", "P$GETDIALOG", "P$GETHANDLE", "P$GETPOSITION", "P$GETPRINTERINFO", "P$GETTEXTEXTENT", "P$GETTEXTMETRICS", "P$GETTEXTPOSITION", "P$LINETO", "P$MOVETO", "P$OPEN", "P$SETBOTTOMMARGIN", "P$SETBOXSHADE", "P$SETDEFAULTALIGNMENT", "P$SETDEFAULTMODE", "P$SETDEFAULTUNITS", "P$SETDIALOG", "P$SETDRIVER", "P$SETFONT", "P$SETHANDLE", "P$SETLEFTMARGIN", "P$SETLINEEXTENDMODE", "P$SETPAINTMODE", "P$SETPEN", "P$SETPITCH", "P$SETPOSITION", "P$SETRAWMODE", "P$SETTABSTOPS", "P$SETTEXTCOLOR", "P$SETTEXTPOSITION", "P$SETTOPMARGIN", "P$TEXTOUT", "RENAME", "SYSTEM", "TBCALL", "TBCALLV", "TBCALLI", "WIN$PRINTER", "WIN$VERSION", "WIN$PLAYSOUND", "W$BITMAP", "W$FONT", "W$FORGET", "W$GETC", "W$KEYBUF", "W$MENU", "W$MESSAGEBOX", "W$MOUSE", "W$PALETTE", "W$TEXTSIZE", "W$WINHELP", "_CODESET"));
        stringToClassMap = new Hashtable();
        instancesLoadMap = new Hashtable<String, Object>();
        performResult = new Numeric(1);
        uniqueThreadNumbers = new Vector(32);
        quickMatch = new Hashtable<String, String>();
        classesLoad = new Hashtable();
        mpeIntrinsics = new Hashtable<String, MPEIntrinsic>();
        highestAllocatedUnique = 1;
        contextCallClasses = new Hashtable();
        globalExternalIdentifiers = new Hashtable<String, Object>();
        globalExternalFileIdentifiers = new Hashtable<String, Object>();
        Context.initializeCallTransformationSettings();
        Context.setDefaultIO();
        globalFileCharacter = (char)65535;
        IGNORE_CONDITION_OBJECT = new Object();
        HANDLE_ERROR_CATCHALL_ON = !"OFF".equalsIgnoreCase(RuntimeEnvironment.getGlobalParameter("HANDLE-ERROR")) && !"FALSE".equalsIgnoreCase(RuntimeEnvironment.getGlobalParameter("HANDLE-ERROR"));
    }

    static class ShutdownFiles
    extends Thread {
        private Vector<basicFile> files;

        public ShutdownFiles(Vector<basicFile> files) {
            this.files = files;
        }

        @Override
        public void run() {
            if (this.files != null) {
                int size = this.files.size();
                basicFile f = null;
                for (int i = size - 1; i >= 0; --i) {
                    f = this.files.elementAt(i);
                    try {
                        f.init();
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (!LogSetup.IS_LOGGING_INFO) continue;
                        LogSetup.LOGGER.info("catch(RuntimeException e)");
                        e.printStackTrace();
                    }
                }
                this.files.clear();
            }
        }
    }
}

