/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;

public class ConvertData {
    private static final int fMAXIEEEi = 0x7F7FFFFF;
    private static final int fMAX370i = Integer.MAX_VALUE;
    private static final long dMAX370l = Long.MAX_VALUE;
    private static boolean LITTLE_ENDIAN = RuntimeEnvironment.isLittleEndian();

    public static final int f370toIEEE(int src) {
        if ((src & Integer.MAX_VALUE) == 0) {
            return src;
        }
        int s = src & Integer.MIN_VALUE;
        int e = ((src & 0x7F000000) >> 24) - 64;
        int f = src & 0xFFFFFF;
        e = e >= 0 ? (e <<= 2) : -(-e << 2);
        if ((f >>= 1) != 0) {
            while (((long)f & 0x800000L) == 0L) {
                f <<= 1;
                --e;
            }
        }
        int dst = (e += 127) >= 255 ? s | 0x7F7FFFFF : (e <= 0 ? s : s | e << 23 | (f &= 0x7FFFFF));
        return dst;
    }

    public static final long d370toIEEE(long src) {
        if ((src & 0x7FFFFFFF00000000L) == 0L) {
            return src;
        }
        long s = src & Long.MIN_VALUE;
        long e = ((src & 0x7F00000000000000L) >> 56) - 64L;
        long f = (src & 0xFFFFFFFFFFFFFFL) >> 4;
        e = e >= 0L ? (e <<= 2) : -(-e << 2);
        if ((f & 0xFFFFFFFF00000000L) != 0L) {
            while ((f & 0x10000000000000L) == 0L) {
                f <<= 1;
                --e;
            }
        }
        long dst = (e += 1023L) >= 2047L ? s | Long.MAX_VALUE : (e <= 0L ? s : s | e << 52 | (f &= 0xFFFFFFFFFFFFFL));
        return dst;
    }

    public static final int fIEEEto370(int src) {
        if (((long)src & Integer.MAX_VALUE) == 0L) {
            return src;
        }
        int s = src & Integer.MIN_VALUE;
        int e = ((src & 0x7F800000) >> 23) - 127;
        int f = src & 0x7FFFFF;
        f <<= 1;
        f = (int)((long)f | 0x1000000L);
        if (e >= 0) {
            f <<= e & 3;
            e >>= 2;
        } else {
            f >>= -e & 3;
            e = -(-e >> 2);
        }
        if ((f & 0xF000000) != 0) {
            f >>= 4;
            ++e;
        }
        int dst = (e += 64) > 127 ? s | Integer.MAX_VALUE : (e < 0 ? s : s | e << 24 | f);
        return dst;
    }

    public static final long dIEEEto370(long src) {
        if ((src & Long.MAX_VALUE) == 0L) {
            return src;
        }
        long s = src & Long.MIN_VALUE;
        long e = ((src & 0x7FF0000000000000L) >> 52) - 1023L;
        long f = src & 0xFFFFFFFFFFFFFL;
        f <<= 4;
        f |= 0x100000000000000L;
        if (e >= 0L) {
            f <<= (int)(e & 3L);
            e >>= 2;
        } else {
            f >>= (int)(-e & 3L);
            e = -(-e >> 2);
        }
        if ((f & 0xF00000000000000L) != 0L) {
            f >>= 4;
            ++e;
        }
        long dst = (e += 64L) > 127L ? s | Long.MAX_VALUE : (e < 0L ? s : s | e << 56 | f);
        return dst;
    }

    public static final int bytesToInt(byte[] array) {
        return (array[3] & 0xFF) << 24 | (array[2] & 0xFF) << 16 | (array[1] & 0xFF) << 8 | array[0] & 0xFF;
    }

    public static final int bytesToInt(byte[] array, int offset) {
        return (array[3 + offset] & 0xFF) << 24 | (array[2 + offset] & 0xFF) << 16 | (array[1 + offset] & 0xFF) << 8 | array[0 + offset] & 0xFF;
    }

    public static final byte[] intToBytes(int number) {
        byte[] result = new byte[]{(byte)(number & 0xFF), (byte)(number >> 8 & 0xFF), (byte)(number >> 16 & 0xFF), (byte)(number >> 24 & 0xFF)};
        return result;
    }

    public static final long bytesToLong(byte[] array) {
        long number = 0L;
        number = ((long)array[7] & 0xFFL) << 56 | ((long)array[6] & 0xFFL) << 48 | ((long)array[5] & 0xFFL) << 40 | ((long)array[4] & 0xFFL) << 32 | ((long)array[3] & 0xFFL) << 24 | ((long)array[2] & 0xFFL) << 16 | ((long)array[1] & 0xFFL) << 8 | (long)array[0] & 0xFFL;
        return number;
    }

    public static final byte[] longToBytes(long number) {
        byte[] result = new byte[]{(byte)(number & 0xFFL), (byte)(number >> 8 & 0xFFL), (byte)(number >> 16 & 0xFFL), (byte)(number >> 24 & 0xFFL), (byte)(number >> 32 & 0xFFL), (byte)(number >> 40 & 0xFFL), (byte)(number >> 48 & 0xFFL), (byte)(number >> 56 & 0xFFL)};
        return result;
    }

    public static final int nativeBytesToInt(byte[] array) {
        if (LITTLE_ENDIAN) {
            return (array[3] & 0xFF) << 24 | (array[2] & 0xFF) << 16 | (array[1] & 0xFF) << 8 | array[0] & 0xFF;
        }
        return (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
    }

    public static final int nativeBytesToInt(byte[] array, int offset) {
        if (LITTLE_ENDIAN) {
            return (array[3 + offset] & 0xFF) << 24 | (array[2 + offset] & 0xFF) << 16 | (array[1 + offset] & 0xFF) << 8 | array[0 + offset] & 0xFF;
        }
        return (array[0 + offset] & 0xFF) << 24 | (array[1 + offset] & 0xFF) << 16 | (array[2 + offset] & 0xFF) << 8 | array[3 + offset] & 0xFF;
    }

    public static final byte[] nativeIntToBytes(int number) {
        byte[] result = new byte[4];
        if (LITTLE_ENDIAN) {
            result[0] = (byte)(number & 0xFF);
            result[1] = (byte)(number >> 8 & 0xFF);
            result[2] = (byte)(number >> 16 & 0xFF);
            result[3] = (byte)(number >> 24 & 0xFF);
        } else {
            result[0] = (byte)(number >> 24 & 0xFF);
            result[1] = (byte)(number >> 16 & 0xFF);
            result[2] = (byte)(number >> 8 & 0xFF);
            result[3] = (byte)(number & 0xFF);
        }
        return result;
    }

    public static final byte[] nativeLongToGivenBytes(long number, int count) {
        byte[] result = new byte[count];
        for (int i = 0; i < count; ++i) {
            if (LITTLE_ENDIAN) {
                result[i] = (byte)(number & 0xFFL);
                number >>= 8;
                continue;
            }
            result[count - i - 1] = (byte)(number & 0xFFL);
            number >>= 8;
        }
        return result;
    }

    public static final long nativeBytesToLong(byte[] array) {
        int length = array.length;
        long number = 0L;
        if (LITTLE_ENDIAN) {
            for (int i = 0; i < length; ++i) {
                number <<= 8;
                number |= (long)(array[length - i - 1] & 0xFF);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                number <<= 8;
                number |= (long)(array[i] & 0xFF);
            }
        }
        return number;
    }

    public static final byte[] nativeLongToBytes(long number) {
        byte[] result = new byte[8];
        if (LITTLE_ENDIAN) {
            result[0] = (byte)(number & 0xFFL);
            result[1] = (byte)(number >> 8 & 0xFFL);
            result[2] = (byte)(number >> 16 & 0xFFL);
            result[3] = (byte)(number >> 24 & 0xFFL);
            result[4] = (byte)(number >> 32 & 0xFFL);
            result[5] = (byte)(number >> 40 & 0xFFL);
            result[6] = (byte)(number >> 48 & 0xFFL);
            result[7] = (byte)(number >> 56 & 0xFFL);
        } else {
            result[7] = (byte)(number & 0xFFL);
            result[6] = (byte)(number >> 8 & 0xFFL);
            result[5] = (byte)(number >> 16 & 0xFFL);
            result[4] = (byte)(number >> 24 & 0xFFL);
            result[3] = (byte)(number >> 32 & 0xFFL);
            result[2] = (byte)(number >> 40 & 0xFFL);
            result[1] = (byte)(number >> 48 & 0xFFL);
            result[0] = (byte)(number >> 56 & 0xFFL);
        }
        return result;
    }

    public static int parseInt(String value) throws NumberFormatException {
        if (value == null) {
            throw new NumberFormatException("Null string=" + value);
        }
        int result = 0;
        int valueLength = (value = value.trim()).length();
        if (valueLength == 0) {
            throw new NumberFormatException("Null or zero length string=" + value);
        }
        boolean opt1 = false;
        boolean opt2 = false;
        boolean opt3 = false;
        char c1 = value.charAt(0);
        char c2 = valueLength > 1 ? value.charAt(1) : (char)'\u0000';
        char ce = value.charAt(valueLength - 1);
        opt1 = c1 == '0' && (c2 == 'x' || c2 == 'X');
        if (opt1 || (opt2 = ce == 'h' || ce == 'H') || (opt3 = c1 == '$')) {
            int i = 0;
            if (opt1) {
                i = 2;
            } else if (opt3) {
                i = 1;
            } else if (opt2) {
                --valueLength;
            }
            while (i < valueLength) {
                char c = value.charAt(i);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        result = result * 16 + (c - 48);
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        result = result * 16 + (c - 65 + 10);
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        result = result * 16 + (c - 97 + 10);
                        break;
                    }
                    default: {
                        throw new NumberFormatException("Bad hex value=" + value);
                    }
                }
                ++i;
            }
            return result;
        }
        opt1 = c1 == '0' && (c2 == 'b' || c2 == 'B');
        if (opt1 || (opt2 = c1 == '%') || (opt3 = ce == 'b' || ce == 'B')) {
            int i = 0;
            if (opt1) {
                i = 2;
            } else if (opt2) {
                i = 1;
            } else if (opt3) {
                --valueLength;
            }
            while (i < valueLength) {
                char c = value.charAt(i);
                switch (c) {
                    case '0': 
                    case '1': {
                        result = result * 2 + (c - 48);
                        break;
                    }
                    default: {
                        throw new NumberFormatException("Bad binary value=" + value);
                    }
                }
                ++i;
            }
            return result;
        }
        opt1 = c1 == '0';
        if (opt1 || (opt1 = c1 == '&') || (opt2 = ce == 'o' || ce == 'O')) {
            int i = 0;
            if (opt1) {
                i = 1;
            } else if (opt2) {
                --valueLength;
            }
            while (i < valueLength) {
                char c = value.charAt(i);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        result = result * 8 + (c - 48);
                        break;
                    }
                    default: {
                        throw new NumberFormatException("Bad octal value=" + value);
                    }
                }
                ++i;
            }
            return result;
        }
        if (c1 == '#') {
            value = value.substring(1);
        }
        return Integer.parseInt(value);
    }

    public static int parseDecimal(String value) throws NumberFormatException {
        if (value == null) {
            throw new NumberFormatException("Null string=" + value);
        }
        int valueLength = (value = value.trim()).length();
        if (valueLength == 0) {
            return 0;
        }
        return Integer.parseInt(value);
    }
}

