/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.DataPointerSubscript;
import com.heirloomcomputing.ecs.exec.ExternalUnbufferedMemory;
import com.heirloomcomputing.ecs.exec.ExternalUnbufferedSpaceClearedMemory;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.SharedMemory;
import com.heirloomcomputing.ecs.exec.SmartMemory;
import com.heirloomcomputing.ecs.exec.SmartSpaceClearedMemory;
import com.heirloomcomputing.ecs.exec.SpaceClearedMemory;
import com.heirloomcomputing.ecs.exec.UnbufferedMemory;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.smartheap.SmartHeapManager;
import java.util.Arrays;

public class DataPointer
extends Variable {
    public static int SIZE_POINTER = 4;
    public static final int FLAG_NULL = 0;
    public static final int FLAG_INDIRECT = Integer.MIN_VALUE;
    public static final int FLAG_SHARED = 0x40000000;
    public static final int FLAG_USECONTENT = -1;
    public static final int FLAG_INVALID = -2;
    public static final int MASK_INDEX = 0x3FFF0000;
    public static final int MASK_ADDRESS = 65535;
    public static final DataPointer NULL = new DataPointer(0, 0);
    public static boolean NULL_POINTER_DEREFERENCE;
    private static Memory PAGE_ZERO;
    int internalPointer;
    int dataSize;
    private boolean shared;
    private int sharedBaseAddr;
    private boolean logGC;

    public static void Reconfig() {
        SIZE_POINTER = RuntimeEnvironment.getArchitecture() == 32 ? 4 : 8;
        String NULL_POINTER_DEREFERENCE_STRING = RuntimeEnvironment.getGlobalParameter("NULL-POINTER-DEREFERENCE");
        NULL_POINTER_DEREFERENCE = NULL_POINTER_DEREFERENCE_STRING != null && ("yes".equalsIgnoreCase(NULL_POINTER_DEREFERENCE_STRING) || "true".equalsIgnoreCase(NULL_POINTER_DEREFERENCE_STRING) || "on".equalsIgnoreCase(NULL_POINTER_DEREFERENCE_STRING) || "1".equals(NULL_POINTER_DEREFERENCE_STRING));
        PAGE_ZERO = NULL_POINTER_DEREFERENCE ? new Memory(4096, "NULL POINTER") : null;
    }

    public DataPointer() {
        this.pointerMemory = null;
        this.pointerAddress = -2;
        this.itemSize = 0;
        this.dataSize = 0;
        this.internalPointer = -1;
        this.setSharedBaseAddr(0);
        this.setLogGC("true".equalsIgnoreCase(System.getProperty("log_ptr_gc", "false")));
    }

    public DataPointer(byte[] data) {
        this.itemSize = this.dataSize = data.length;
        this.pointerMemory = data != null ? new Memory(data) : null;
        this.pointerAddress = 0;
        this.internalPointer = -1;
        this.setSharedBaseAddr(0);
        this.setUsageMisc();
        this.setLogGC("true".equalsIgnoreCase(System.getProperty("log_ptr_gc", "false")));
    }

    public DataPointer(Variable v) {
        int aPtr;
        if (v == null) {
            if (NULL_POINTER_DEREFERENCE) {
                aPtr = this.internalPointerOf(PAGE_ZERO, 0);
                this.dataSize = 0;
            } else {
                aPtr = 0;
                this.dataSize = 0;
            }
        } else {
            aPtr = this.internalPointerOf(v);
            this.dataSize = v.getSize();
        }
        this.itemSize = SIZE_POINTER;
        this.pointerAddress = 0;
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.internalPointer = -1;
        this.setSharedBaseAddr(0);
        this.storeInternalPointer(aPtr);
        this.setLogGC("true".equalsIgnoreCase(System.getProperty("log_ptr_gc", "false")));
    }

    private DataPointer(int ptrAddr, int internalPtr) {
        this();
        this.pointerAddress = ptrAddr;
        this.internalPointer = internalPtr;
        this.setSharedBaseAddr(0);
        this.setLogGC("true".equalsIgnoreCase(System.getProperty("log_ptr_gc", "false")));
    }

    @Override
    public void init() {
        if (this.initValue == null) {
            this.setPointerNull();
        }
    }

    public final void setPointerToObject(Object v) {
        if (v instanceof Variable) {
            this.setPointerToAddress((Variable)v);
        } else if (v instanceof byte[]) {
            this.setPointerToBytes((byte[])v);
        } else if (v instanceof DataPointer) {
            this.setPointerToPointer((DataPointer)v);
        } else {
            this.setPointerNull();
        }
    }

    public final void setPointerToObject(DataPointer v) {
        this.setPointerToPointer(v);
    }

    public final void setPointerToObject(Variable v) {
        this.setPointerToAddress(v);
    }

    public final void setPointerToObject(byte[] v) {
        this.setPointerToBytes(v);
    }

    public final void setPointerToPointer(DataPointer v) {
        if (this.internalPointer == -1 && v.internalPointer == -1) {
            if (v.pointerAddress >= 0 && v.pointerAddress + SIZE_POINTER <= v.getMemory().getTopOfMemory() && this.pointerAddress >= 0 && this.pointerAddress + SIZE_POINTER <= this.pointerMemory.getTopOfMemory()) {
                this.pointerMemory.copy(v.getMemory(), v.pointerAddress, this.pointerAddress, SIZE_POINTER);
            } else {
                CobolException.runtimeError("Invalid Memory Pointer Location");
            }
        } else if (this.internalPointer == -1) {
            this.storeInternalPointer(v.internalPointer);
        } else {
            this.internalPointer = v.internalPointer == -1 ? v.loadInternalPointer() : v.internalPointer;
        }
        this.dataSize = v.dataSize;
        if (v.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
        }
    }

    public final void setPointerToAddress(Variable v) {
        int a = this.internalPointerOf(v);
        if (this.internalPointer == -1) {
            this.storeInternalPointer(a);
        } else {
            this.internalPointer = a;
        }
        this.dataSize = v.getSize();
        if (v.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
        }
    }

    @Override
    public final int setPointerToBytes(byte[] memorySpace) {
        if (memorySpace != null && memorySpace.length == 0) {
            if (this.internalPointer == -1) {
                int ptr = this.loadInternalPointer();
                if (ptr != -2 && ptr != 0) {
                    SmartHeapManager.get().free(ptr);
                }
            } else if (this.internalPointer != -2 && this.internalPointer != 0) {
                SmartHeapManager.get().free(this.internalPointer);
            }
        }
        if (memorySpace == null || memorySpace.length == 0) {
            if (this.internalPointer == -1) {
                this.storeInternalPointer(0);
            } else {
                this.internalPointer = 0;
            }
            return 0;
        }
        Memory dynamicMemory = this.pointerMemory instanceof UnbufferedMemory ? new UnbufferedMemory(memorySpace) : (this.pointerMemory instanceof SmartSpaceClearedMemory ? new SmartSpaceClearedMemory(memorySpace) : (this.pointerMemory instanceof SmartMemory ? new SmartMemory(memorySpace) : (this.pointerMemory instanceof SpaceClearedMemory ? new SpaceClearedMemory(memorySpace) : (this.pointerMemory instanceof ExternalUnbufferedMemory ? new ExternalUnbufferedMemory(memorySpace) : (this.pointerMemory instanceof ExternalUnbufferedSpaceClearedMemory ? new ExternalUnbufferedSpaceClearedMemory(memorySpace) : new Memory(memorySpace))))));
        dynamicMemory.setDynamic();
        int a = this.internalPointerOf(dynamicMemory, 0);
        if (this.internalPointer == -1) {
            this.storeInternalPointer(a);
            if (this.isShared()) {
                this.setSharedBaseAddr(a);
            }
        } else {
            this.internalPointer = a;
        }
        this.dataSize = memorySpace.length;
        return memorySpace.length;
    }

    public final int setPointerToSharedBytes(byte[] memorySpace) {
        this.setShared(true);
        return this.setPointerToBytes(memorySpace);
    }

    public final void setPointerUp(int value) {
        Memory mem = this.getPointerMemory();
        int addr = this.getPointerAddress();
        if ((addr += value) < mem.getTopOfMemory()) {
            this.storeInternalPointer(this.internalPointerOf(mem, addr));
        } else {
            CobolException.runtimeError("Memory Pointer Out Of Range");
        }
    }

    public final void setPointerDown(int value) {
        Memory mem = this.getPointerMemory();
        int addr = this.getPointerAddress();
        if ((addr -= value) >= 0) {
            this.storeInternalPointer(this.internalPointerOf(mem, addr));
        } else {
            CobolException.runtimeError("Memory Pointer Out Of Range");
        }
    }

    public final void setPointerNull() {
        if (NULL_POINTER_DEREFERENCE) {
            this.internalPointer = this.internalPointerOf(PAGE_ZERO, 0);
        } else {
            byte[] b = new byte[SIZE_POINTER];
            Arrays.fill(b, (byte)0);
            this.fromByteArray(b);
        }
        this.setNull();
    }

    public boolean isNullPointer() {
        if (this.isNull()) {
            return true;
        }
        int ptr = this.loadInternalPointer();
        return ptr == 0;
    }

    @Override
    public int compare(DataPointer param) {
        int intPtr2;
        int intPtr1 = this.loadInternalPointer();
        if (intPtr1 == (intPtr2 = param.loadInternalPointer())) {
            return 0;
        }
        if (intPtr1 < intPtr2) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equalsPointer(DataPointer param) {
        return this.compare(param) == 0;
    }

    @Override
    public int compare(Variable param) {
        int intPtr2;
        int intPtr1 = this.loadInternalPointer();
        if (intPtr1 == (intPtr2 = this.internalPointerOf(param))) {
            return 0;
        }
        if (intPtr1 < intPtr2) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equalsPointer(Variable param) {
        return this.compare(param) == 0;
    }

    public static final DataPointer getNull() {
        return new DataPointer((Variable)null);
    }

    @Override
    public String toDisplayString() {
        if (this.pointerMemory == null) {
            return "null";
        }
        try {
            int length = this.pointerMemory.getTopOfMemory() - this.pointerAddress;
            boolean dots = false;
            if (length > 256) {
                dots = true;
                length = 256;
            }
            int offset = this.pointerAddress;
            char[] dest = new char[length + (dots ? 3 : 0)];
            try {
                for (int i = 0; i < length; ++i) {
                    dest[i] = this.pointerMemory.getChar(offset++);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dots) {
                dest[length] = 46;
                dest[length + 1] = 46;
                dest[length + 2] = 46;
            }
            return new String(dest);
        }
        catch (Exception veryOddException) {
            return "invalid";
        }
    }

    private int internalPointerOf(Variable v) {
        return this.internalPointerOf(v.pointerMemory, v.pointerAddress);
    }

    private int internalPointerOf(Memory pMemory, int pAddress) {
        int ptr = 0;
        if (pMemory == null) {
            return ptr;
        }
        if (pMemory.getTopOfMemory() < 65536 && !pMemory.isDynamic()) {
            int index = SmartHeapManager.get().index(pMemory);
            if (index > 32760) {
                CobolException.runtimeError("Memory Pointer Maximum Reached");
                ptr = -2;
            }
            ptr = index << 16 | pAddress;
        } else if (this.isShared()) {
            int index = SharedMemory.getInstance().makeSharedMemory(pMemory);
            ptr = 0x40000000 | index;
        } else if (pMemory.isShared()) {
            int index = SharedMemory.getInstance().getSharedMemoryIndex(pMemory);
            ptr = 0x40000000 | index;
        } else {
            int index = SmartHeapManager.get().index(pMemory, pAddress);
            ptr = Integer.MIN_VALUE | index;
        }
        return ptr;
    }

    private int loadInternalPointer() {
        if (this.internalPointer == 0) {
            return 0;
        }
        if (this.internalPointer == -1) {
            if (this.itemSize != SIZE_POINTER) {
                CobolException.runtimeError("Invalid Memory Pointer - POINTER " + this.getName() + " has incorrect size");
                return -2;
            }
            if (this.pointerMemory == null || this.pointerAddress + SIZE_POINTER > this.pointerMemory.getTopOfMemory()) {
                CobolException.runtimeError("Invalid Memory Pointer");
                return -2;
            }
            return this.pointerMemory.getInt(this.pointerAddress);
        }
        return this.internalPointer;
    }

    private void storeInternalPointer(int ptr) {
        if (this.internalPointer == -1) {
            if (this.itemSize != SIZE_POINTER) {
                CobolException.runtimeError("Undefined Memory Pointer");
                return;
            }
            if (this.pointerMemory == null || this.pointerAddress + SIZE_POINTER > this.pointerMemory.getTopOfMemory()) {
                CobolException.runtimeError("Invalid Memory Pointer");
                return;
            }
            this.pointerMemory.setInt(this.pointerAddress, ptr);
        } else {
            this.internalPointer = ptr;
        }
    }

    public Memory getPointerMemory() {
        int ptr = this.loadInternalPointer();
        if (ptr == 0) {
            return null;
        }
        if ((ptr & Integer.MIN_VALUE) == 0) {
            if ((ptr & 0x40000000) == 0) {
                int index = ptr >> 16;
                Memory mem = SmartHeapManager.get().memoryD(index);
                if (mem != null) {
                    return mem;
                }
                CobolException.runtimeError("Invalid Memory Pointer " + DataPointer.getPointerString(ptr));
                return null;
            }
            boolean allowPtrArith = RuntimeEnvironment.getGlobalParameter("ENABLE-PTR-ARITH") != null;
            int index = (allowPtrArith ? this.getSharedBaseAddr() : ptr) & 0xBFFFFFFF;
            Memory mem = SharedMemory.getInstance().getSharedMemory(index);
            if (mem != null) {
                this.setShared(true);
                return mem;
            }
            CobolException.runtimeError("Invalid Memory Pointer " + DataPointer.getPointerString(ptr));
            return null;
        }
        int index = ptr & Integer.MAX_VALUE;
        Memory mem = SmartHeapManager.get().memoryI(index);
        if (mem != null) {
            return mem;
        }
        CobolException.runtimeError("Invalid Memory Pointer " + DataPointer.getPointerString(ptr));
        return null;
    }

    public int getPointerAddress() {
        int ptr = this.loadInternalPointer();
        if (ptr == 0) {
            return 0;
        }
        if ((ptr & Integer.MIN_VALUE) == 0) {
            int nextSibAddrValue;
            byte[] nextSibBytes;
            Variable redefinedFrom;
            Variable nextSib;
            boolean allowPtrArith;
            if ((ptr & 0x40000000) == 0) {
                return ptr & 0xFFFF;
            }
            int adjustedAddr = 0;
            boolean bl = allowPtrArith = RuntimeEnvironment.getGlobalParameter("ENABLE-PTR-ARITH") != null;
            if (allowPtrArith && (nextSib = this.getSibling()) != null && (redefinedFrom = nextSib.redefinedFrom) != null && redefinedFrom == this && (nextSibBytes = nextSib.getBytes()).length >= 4 && (adjustedAddr = (nextSibAddrValue = (nextSibBytes[0] & 0xFF) << 24 | (nextSibBytes[1] & 0xFF) << 16 | (nextSibBytes[2] & 0xFF) << 8 | (nextSibBytes[3] & 0xFF) << 0) - this.getSharedBaseAddr()) < 0) {
                adjustedAddr = 0;
            }
            return adjustedAddr;
        }
        int index = ptr & Integer.MAX_VALUE;
        int addr = SmartHeapManager.get().addressI(index);
        if (addr < 0) {
            CobolException.runtimeError("Invalid Memory Pointer " + DataPointer.getPointerString(ptr));
            return -2;
        }
        return addr;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        Memory mem = this.getPointerMemory();
        if (mem == null) {
            return null;
        }
        int addr = this.getPointerAddress();
        int len = this.dataSize == 0 ? mem.getTopOfMemory() - addr : this.dataSize;
        return mem.getBytes(addr, len);
    }

    public String getPointerAddressAsString() {
        return SIZE_POINTER == 4 ? Integer.toString(this.getPointerAddress()) : Long.toString(this.getPointerAddress());
    }

    public final String getPointerString() {
        int ptr = this.loadInternalPointer();
        return DataPointer.getPointerString(ptr);
    }

    private static final String getPointerString(int ptr) {
        if (ptr == 0) {
            return "($NULL POINTER)";
        }
        if ((ptr & Integer.MIN_VALUE) == 0) {
            if ((ptr & 0x40000000) == 0) {
                int index = ptr >> 16;
                Memory mem = SmartHeapManager.get().memoryD(index);
                if (mem == PAGE_ZERO) {
                    return "($NULL POINTER)";
                }
                int off = ptr & 0xFFFF;
                if (mem != null) {
                    if (off < mem.getTopOfMemory()) {
                        return "($POINTER " + index + ":" + off + ")";
                    }
                    return "($INVALID POINTER OFFSET " + index + ":" + off + ")";
                }
                return "(!INVALID POINTER " + index + ":" + off + ")";
            }
            int index = ptr & 0xBFFFFFFF;
            Memory mem = SharedMemory.getInstance().getSharedMemory(index);
            if (mem == PAGE_ZERO) {
                return "(#NULL POINTER)";
            }
            if (mem != null) {
                int off = 0;
                return "(#DYNAMIC SHARED POINTER " + index + ":" + off + ")";
            }
            return "(!INVALID DYNAMIC SHARED POINTER " + index + ")";
        }
        int index = ptr & Integer.MAX_VALUE;
        Memory mem = SmartHeapManager.get().memoryI(index);
        if (mem == PAGE_ZERO) {
            return "(#NULL POINTER)";
        }
        if (mem != null) {
            int off = SmartHeapManager.get().addressI(index);
            if (off < mem.getTopOfMemory()) {
                return "(#DYNAMIC POINTER " + index + ":" + off + ")";
            }
            return "(!INVALID POINTER OFFSET " + index + ":" + off + ")";
        }
        return "(!INVALID DYNAMIC POINTER " + index + ")";
    }

    public static final String getPointerString(Variable v) {
        if (v.pointerMemory == null) {
            return "(@NULL)";
        }
        return "(@" + v.pointerMemory + ":" + v.pointerAddress + ")";
    }

    @Override
    protected final DataPointer setupSubscript(int offset) {
        this.setAddress(offset);
        this.arrayChild = null;
        this.setTableElement();
        return this;
    }

    public DataPointerSubscript createDataPointerArray(int dimensions) {
        int[] siz = this.createArraySiz(dimensions);
        int[] dim = this.createArrayDim(dimensions);
        if (siz == null) {
            return null;
        }
        DataPointerSubscript vs = new DataPointerSubscript(this, dim, siz);
        this.setSubscriptChild(vs);
        return vs;
    }

    @Override
    public DataPointer subscript(int[] usingIndex) {
        try {
            Variable temp = this;
            DataPointer result = (DataPointer)this.clone();
            int dimension = usingIndex.length - 1;
            int offset = this.pointerAddress;
            while (true) {
                int dimension_subscript;
                if (temp != null && !temp.isArray()) {
                    temp = temp.parent;
                    continue;
                }
                if (temp == null) {
                    CobolException.runtimeError("Table Subscript has illegal depth on " + this.getName() + ".", null);
                    return null;
                }
                if ((dimension_subscript = usingIndex[dimension--] - 1) >= temp.maxIndex || dimension_subscript < 0) {
                    CobolException.runtimeError("Illegal Table Subscript " + (dimension_subscript + 1) + " for size " + temp.maxIndex + " on " + this.getName() + ".", null);
                    return null;
                }
                offset += dimension_subscript * temp.itemSize;
                if (dimension < 0) {
                    return result.setupSubscript(offset);
                }
                temp = temp.parent;
            }
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return null;
        }
    }

    public final DataPointer[] createArray1() {
        int[] dim = this.createArrayDim(1);
        if (dim == null) {
            return null;
        }
        DataPointer[] result = new DataPointer[dim[0]];
        result[0] = null;
        for (int i0 = 1; i0 < dim[0]; ++i0) {
            result[i0] = this.subscript(new int[]{i0});
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][] createArray2() {
        int[] dim = this.createArrayDim(2);
        if (dim == null) {
            return null;
        }
        DataPointer[][] result = new DataPointer[dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[1]; ++i0) {
            for (int i1 = 0; i1 < dim[0]; ++i1) {
                result[i0][i1] = i0 == 0 || i1 == 0 ? null : this.subscript(new int[]{i0, i1});
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][] createArray3() {
        int[] dim = this.createArrayDim(3);
        if (dim == null) {
            return null;
        }
        DataPointer[][][] result = new DataPointer[dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[2]; ++i0) {
            for (int i1 = 0; i1 < dim[1]; ++i1) {
                for (int i2 = 0; i2 < dim[0]; ++i2) {
                    result[i0][i1][i2] = i0 == 0 || i1 == 0 || i2 == 0 ? null : this.subscript(new int[]{i0, i1, i2});
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][] createArray4() {
        int[] dim = this.createArrayDim(4);
        if (dim == null) {
            return null;
        }
        DataPointer[][][][] result = new DataPointer[dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[3]; ++i0) {
            for (int i1 = 0; i1 < dim[2]; ++i1) {
                for (int i2 = 0; i2 < dim[1]; ++i2) {
                    for (int i3 = 0; i3 < dim[0]; ++i3) {
                        result[i0][i1][i2][i3] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 ? null : this.subscript(new int[]{i0, i1, i2, i3});
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][][] createArray5() {
        int[] dim = this.createArrayDim(5);
        if (dim == null) {
            return null;
        }
        DataPointer[][][][][] result = new DataPointer[dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[4]; ++i0) {
            for (int i1 = 0; i1 < dim[3]; ++i1) {
                for (int i2 = 0; i2 < dim[2]; ++i2) {
                    for (int i3 = 0; i3 < dim[1]; ++i3) {
                        for (int i4 = 0; i4 < dim[0]; ++i4) {
                            result[i0][i1][i2][i3][i4] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 ? null : this.subscript(new int[]{i0, i1, i2, i3, i4});
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][][][] createArray6() {
        int[] dim = this.createArrayDim(6);
        if (dim == null) {
            return null;
        }
        DataPointer[][][][][][] result = new DataPointer[dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[5]; ++i0) {
            for (int i1 = 0; i1 < dim[4]; ++i1) {
                for (int i2 = 0; i2 < dim[3]; ++i2) {
                    for (int i3 = 0; i3 < dim[2]; ++i3) {
                        for (int i4 = 0; i4 < dim[1]; ++i4) {
                            for (int i5 = 0; i5 < dim[0]; ++i5) {
                                result[i0][i1][i2][i3][i4][i5] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 ? null : this.subscript(new int[]{i0, i1, i2, i3, i4, i5});
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][][][][] createArray7() {
        int[] dim = this.createArrayDim(7);
        if (dim == null) {
            return null;
        }
        DataPointer[][][][][][][] result = new DataPointer[dim[6]][dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[6]; ++i0) {
            for (int i1 = 0; i1 < dim[5]; ++i1) {
                for (int i2 = 0; i2 < dim[4]; ++i2) {
                    for (int i3 = 0; i3 < dim[3]; ++i3) {
                        for (int i4 = 0; i4 < dim[2]; ++i4) {
                            for (int i5 = 0; i5 < dim[1]; ++i5) {
                                for (int i6 = 0; i6 < dim[0]; ++i6) {
                                    result[i0][i1][i2][i3][i4][i5][i6] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 ? null : this.subscript(new int[]{i0, i1, i2, i3, i4, i5, i6});
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][][][][][] createArray8() {
        int[] dim = this.createArrayDim(8);
        if (dim == null) {
            return null;
        }
        DataPointer[][][][][][][][] result = new DataPointer[dim[7]][dim[6]][dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[7]; ++i0) {
            for (int i1 = 0; i1 < dim[6]; ++i1) {
                for (int i2 = 0; i2 < dim[5]; ++i2) {
                    for (int i3 = 0; i3 < dim[4]; ++i3) {
                        for (int i4 = 0; i4 < dim[3]; ++i4) {
                            for (int i5 = 0; i5 < dim[2]; ++i5) {
                                for (int i6 = 0; i6 < dim[1]; ++i6) {
                                    for (int i7 = 0; i7 < dim[0]; ++i7) {
                                        result[i0][i1][i2][i3][i4][i5][i6][i7] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 || i7 == 0 ? null : this.subscript(new int[]{i0, i1, i2, i3, i4, i5, i6, i7});
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[] createArray1(DataPointer[] result) {
        int[] dim = this.createArrayDim(1);
        if (dim == null) {
            return null;
        }
        result[0] = null;
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 1; i0 < dim[0]; ++i0) {
            result[i0].updateSubscript(new int[]{i0}, memory, offset);
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][] createArray2(DataPointer[][] result) {
        int[] dim = this.createArrayDim(2);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[1]; ++i0) {
            for (int i1 = 0; i1 < dim[0]; ++i1) {
                if (i0 == 0 || i1 == 0) {
                    result[i0][i1] = null;
                    continue;
                }
                result[i0][i1].updateSubscript(new int[]{i0, i1}, memory, offset);
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][] createArray3(DataPointer[][][] result) {
        int[] dim = this.createArrayDim(3);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[2]; ++i0) {
            for (int i1 = 0; i1 < dim[1]; ++i1) {
                for (int i2 = 0; i2 < dim[0]; ++i2) {
                    if (i0 == 0 || i1 == 0 || i2 == 0) {
                        result[i0][i1][i2] = null;
                        continue;
                    }
                    result[i0][i1][i2].updateSubscript(new int[]{i0, i1, i2}, memory, offset);
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][] createArray4(DataPointer[][][][] result) {
        int[] dim = this.createArrayDim(4);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[3]; ++i0) {
            for (int i1 = 0; i1 < dim[2]; ++i1) {
                for (int i2 = 0; i2 < dim[1]; ++i2) {
                    for (int i3 = 0; i3 < dim[0]; ++i3) {
                        if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0) {
                            result[i0][i1][i2][i3] = null;
                            continue;
                        }
                        result[i0][i1][i2][i3].updateSubscript(new int[]{i0, i1, i2, i3}, memory, offset);
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][][] createArray5(DataPointer[][][][][] result) {
        int[] dim = this.createArrayDim(5);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[4]; ++i0) {
            for (int i1 = 0; i1 < dim[3]; ++i1) {
                for (int i2 = 0; i2 < dim[2]; ++i2) {
                    for (int i3 = 0; i3 < dim[1]; ++i3) {
                        for (int i4 = 0; i4 < dim[0]; ++i4) {
                            if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) {
                                result[i0][i1][i2][i3][i4] = null;
                                continue;
                            }
                            result[i0][i1][i2][i3][i4].updateSubscript(new int[]{i0, i1, i2, i3, i4}, memory, offset);
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][][][] createArray6(DataPointer[][][][][][] result) {
        int[] dim = this.createArrayDim(6);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[5]; ++i0) {
            for (int i1 = 0; i1 < dim[4]; ++i1) {
                for (int i2 = 0; i2 < dim[3]; ++i2) {
                    for (int i3 = 0; i3 < dim[2]; ++i3) {
                        for (int i4 = 0; i4 < dim[1]; ++i4) {
                            for (int i5 = 0; i5 < dim[0]; ++i5) {
                                if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0) {
                                    result[i0][i1][i2][i3][i4][i5] = null;
                                    continue;
                                }
                                result[i0][i1][i2][i3][i4][i5].updateSubscript(new int[]{i0, i1, i2, i3, i4, i5}, memory, offset);
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][][][][] createArray7(DataPointer[][][][][][][] result) {
        int[] dim = this.createArrayDim(7);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[6]; ++i0) {
            for (int i1 = 0; i1 < dim[5]; ++i1) {
                for (int i2 = 0; i2 < dim[4]; ++i2) {
                    for (int i3 = 0; i3 < dim[3]; ++i3) {
                        for (int i4 = 0; i4 < dim[2]; ++i4) {
                            for (int i5 = 0; i5 < dim[1]; ++i5) {
                                for (int i6 = 0; i6 < dim[0]; ++i6) {
                                    if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0) {
                                        result[i0][i1][i2][i3][i4][i5][i6] = null;
                                        continue;
                                    }
                                    result[i0][i1][i2][i3][i4][i5][i6].updateSubscript(new int[]{i0, i1, i2, i3, i4, i5, i6}, memory, offset);
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final DataPointer[][][][][][][][] createArray8(DataPointer[][][][][][][][] result) {
        int[] dim = this.createArrayDim(8);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[7]; ++i0) {
            for (int i1 = 0; i1 < dim[6]; ++i1) {
                for (int i2 = 0; i2 < dim[5]; ++i2) {
                    for (int i3 = 0; i3 < dim[4]; ++i3) {
                        for (int i4 = 0; i4 < dim[3]; ++i4) {
                            for (int i5 = 0; i5 < dim[2]; ++i5) {
                                for (int i6 = 0; i6 < dim[1]; ++i6) {
                                    for (int i7 = 0; i7 < dim[0]; ++i7) {
                                        if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 || i7 == 0) {
                                            result[i0][i1][i2][i3][i4][i5][i6][i7] = null;
                                            continue;
                                        }
                                        result[i0][i1][i2][i3][i4][i5][i6][i7].updateSubscript(new int[]{i0, i1, i2, i3, i4, i5, i6, i7}, memory, offset);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    private final DataPointer updateSubscript(int[] usingIndex, Memory memory, int offset) {
        try {
            Variable temp = this;
            int dimension = usingIndex.length - 1;
            while (true) {
                if (temp != null && !temp.isArray()) {
                    temp = temp.parent;
                    continue;
                }
                if (temp == null) {
                    CobolException.runtimeError("Table Subscript has illegal depth on " + this.getName() + ".", null);
                    return null;
                }
                int dimension_subscript = usingIndex[dimension--] - 1;
                offset += dimension_subscript * temp.itemSize;
                if (dimension < 0) {
                    this.alwaysFlush = memory.alwaysFlush;
                    this.pointerMemory = memory;
                    this.pointerAddress = offset;
                    this.setTableElement();
                    return this;
                }
                temp = temp.parent;
            }
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return null;
        }
    }

    public DataPointer get(DataPointer[] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0];
    }

    public DataPointer get(DataPointer[][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0];
    }

    public DataPointer get(DataPointer[][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0];
    }

    public DataPointer get(DataPointer[][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0];
    }

    public DataPointer get(DataPointer[][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0];
    }

    public DataPointer get(DataPointer[][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0];
    }

    public DataPointer get(DataPointer[][][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]][idxArray[6]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0][0];
    }

    public DataPointer get(DataPointer[][][][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]][idxArray[6]][idxArray[7]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0][0][0];
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public int getSharedBaseAddr() {
        if (this.sharedBaseAddr == 0) {
            int ptr = this.loadInternalPointer();
            this.setSharedBaseAddr(ptr);
        }
        return this.sharedBaseAddr;
    }

    public void setSharedBaseAddr(int sharedBaseAddr) {
        this.sharedBaseAddr = sharedBaseAddr;
    }

    public void finalize() throws Throwable {
        if (this.isLogGC()) {
            System.out.println(String.format("%-30s%-50s", "GC - DataPointer::finalize()", this.getPointerString()));
        }
    }

    public boolean isLogGC() {
        return this.logGC;
    }

    public void setLogGC(boolean logGC) {
        this.logGC = logGC;
    }

    static {
        DataPointer.Reconfig();
    }
}

