/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ConvertData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;

public class FormatDateTime {
    public static final int FORMAT_IBM1 = 1;
    public static final int FORMAT_IBM2 = 2;
    public static final int FORMAT_INTU = 4;
    public static final int FORMAT_INTF = 8;
    public static final int FORMAT_EXTU = 16;
    public static final int FORMAT_EXTF = 32;
    public static final int FORMAT_NAML = 64;
    public static final int FORMAT_NAMS = 128;
    public static final int FORMAT_BINM = 256;
    public static final int FORMAT_BINL = 512;
    public static final char FORMAT_IBM1_CHAR = '%';
    public static final char FORMAT_IBM2_CHAR = '@';
    public static final char FORMAT_INTU_CHAR = '#';
    public static final char FORMAT_INTF_CHAR = '&';
    public static final char FORMAT_EXTU_CHAR = '!';
    public static final char FORMAT_EXTF_CHAR = '^';
    public static final char FORMAT_NAML_CHAR = '$';
    public static final char FORMAT_NAMS_CHAR = '*';
    public static final char FORMAT_BINM_CHAR = '`';
    public static final char FORMAT_BINL_CHAR = '~';
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int TIMESTAMP = 3;
    private static final int DEFAULT_NANOS = -1;

    private static int digit(String format, int position) {
        try {
            return format.charAt(position) - 48;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int digits(String format, int position, int length) {
        int number = 0;
        length += position;
        for (int i = position; i < length; ++i) {
            number *= 10;
            number += FormatDateTime.digit(format, i);
        }
        return number;
    }

    public static Date format(int type, String format, String dateString, String locale) {
        return FormatDateTime.format(type, format, dateString);
    }

    public static Date format(String format, String dateString, String locale) {
        return FormatDateTime.format(0, format, dateString);
    }

    public static Date format(String format, String dateString) {
        return FormatDateTime.format(0, format, dateString);
    }

    public static Date format(int fieldType, String format, String dateString) {
        GregorianCalendar cal = new GregorianCalendar();
        if (format != null) {
            if (format.startsWith("(DATE)")) {
                fieldType = 1;
                format = format.substring(6);
            } else if (format.startsWith("(TIME)")) {
                fieldType = 2;
                format = format.substring(6);
            } else if (format.startsWith("(TIMESTAMP)")) {
                fieldType = 3;
                format = format.substring(11);
            }
        }
        int nanos = 0;
        boolean setDate = false;
        boolean setTime = false;
        boolean setNanos = false;
        if (dateString == null) {
            return cal.getTime();
        }
        switch (fieldType) {
            case 1: {
                setDate = true;
                break;
            }
            case 2: {
                setTime = true;
                break;
            }
            case 3: {
                setDate = true;
                setTime = true;
            }
        }
        dateString = dateString.toUpperCase();
        int length = format.length();
        char c = '\u0000';
        char next = '\u0000';
        int type = 0;
        int setField = -1;
        int bias = 0;
        int places = 0;
        int cursor = 0;
        int special = 0;
        boolean found = false;
        String name = null;
        int number = 0;
        int multiplier = 1;
        block171: for (int i = 0; i < length; ++i) {
            c = format.charAt(i);
            places = 0;
            setField = -1;
            bias = 0;
            special = 0;
            type = 0;
            switch (c) {
                case '%': {
                    type = 1;
                    ++i;
                    break;
                }
                case '@': {
                    type = 2;
                    ++i;
                    break;
                }
                case '#': {
                    type = 4;
                    ++i;
                    break;
                }
                case '&': {
                    type = 8;
                    ++i;
                    break;
                }
                case '^': {
                    type = 32;
                    ++i;
                    break;
                }
                case '!': {
                    type = 16;
                    ++i;
                    break;
                }
                case '$': {
                    type = 64;
                    ++i;
                    break;
                }
                case '*': {
                    type = 128;
                    ++i;
                    break;
                }
                case '`': {
                    type = 256;
                    ++i;
                    break;
                }
                case '~': {
                    type = 512;
                    ++i;
                }
            }
            if (i < length) {
                c = format.charAt(i);
            }
            next = i < length - 1 ? format.charAt(i + 1) : (char)'\u0000';
            multiplier = 1;
            block18 : switch (type) {
                default: {
                    ++cursor;
                    break;
                }
                case 4: 
                case 8: {
                    switch (c) {
                        case 'l': {
                            ++cursor;
                            break;
                        }
                        case 'e': {
                            places = 1;
                            setField = 0;
                            setDate = true;
                            break;
                        }
                        case 'Y': {
                            places = 4;
                            setField = 1;
                            setDate = true;
                            break;
                        }
                        case 'y': {
                            places = 2;
                            bias = 1900;
                            setField = 1;
                            setDate = true;
                            break;
                        }
                        case 'm': {
                            places = 2;
                            setField = 2;
                            setDate = true;
                            break;
                        }
                        case 'u': {
                            places = 2;
                            setField = 3;
                            setDate = true;
                            break;
                        }
                        case 'W': {
                            places = 1;
                            setField = 4;
                            setDate = true;
                            break;
                        }
                        case 'd': {
                            places = 2;
                            setField = 5;
                            setDate = true;
                            break;
                        }
                        case 'j': {
                            places = 3;
                            setField = 6;
                            setDate = true;
                            break;
                        }
                        case 'w': {
                            places = 1;
                            setField = 7;
                            setDate = true;
                            break;
                        }
                        case 'U': {
                            places = 1;
                            setField = 8;
                            setDate = true;
                            break;
                        }
                        case 'A': {
                            places = 1;
                            setField = 9;
                            setTime = true;
                            break;
                        }
                        case 'I': {
                            places = 2;
                            setField = 10;
                            setTime = true;
                            break;
                        }
                        case 'H': {
                            places = 2;
                            setField = 11;
                            setTime = true;
                            break;
                        }
                        case 'M': {
                            places = 2;
                            setField = 12;
                            setTime = true;
                            break;
                        }
                        case 'S': {
                            places = 2;
                            setField = 13;
                            setTime = true;
                            break;
                        }
                        case 's': {
                            places = 3;
                            setField = 14;
                            setTime = true;
                            break;
                        }
                        case 'z': {
                            places = 8;
                            setField = 15;
                            break;
                        }
                        case 'Z': {
                            places = 8;
                            setField = 16;
                            break;
                        }
                        case 'n': {
                            places = 9;
                            setField = 9999;
                            setTime = true;
                        }
                    }
                    break;
                }
                case 16: 
                case 32: {
                    switch (c) {
                        case 'l': {
                            ++cursor;
                            break;
                        }
                        case 'e': {
                            places = 1;
                            setField = 0;
                            setDate = true;
                            break;
                        }
                        case 'Y': {
                            places = 4;
                            setField = 1;
                            setDate = true;
                            break;
                        }
                        case 'y': {
                            places = 2;
                            bias = 1900;
                            setField = 1;
                            setDate = true;
                            break;
                        }
                        case 'm': {
                            places = 2;
                            setField = 2;
                            bias = -1;
                            setDate = true;
                            break;
                        }
                        case 'u': {
                            places = 2;
                            setField = 3;
                            setDate = true;
                            break;
                        }
                        case 'W': {
                            places = 1;
                            setField = 4;
                            setDate = true;
                            break;
                        }
                        case 'd': {
                            places = 2;
                            setField = 5;
                            setDate = true;
                            break;
                        }
                        case 'j': {
                            places = 3;
                            setField = 6;
                            setDate = true;
                            break;
                        }
                        case 'w': {
                            places = 1;
                            setField = 7;
                            setDate = true;
                            break;
                        }
                        case 'U': {
                            places = 1;
                            setField = 8;
                            setDate = true;
                            break;
                        }
                        case 'A': {
                            places = 1;
                            setField = 9;
                            setTime = true;
                            break;
                        }
                        case 'I': {
                            places = 2;
                            setField = 10;
                            setTime = true;
                            break;
                        }
                        case 'H': {
                            places = 2;
                            setField = 11;
                            setTime = true;
                            break;
                        }
                        case 'M': {
                            places = 2;
                            setField = 12;
                            setTime = true;
                            break;
                        }
                        case 'S': {
                            places = 2;
                            setField = 13;
                            setTime = true;
                            break;
                        }
                        case 's': {
                            places = 3;
                            setField = 14;
                            setTime = true;
                            break;
                        }
                        case 'z': {
                            places = 8;
                            setField = 15;
                            break;
                        }
                        case 'Z': {
                            places = 8;
                            setField = 16;
                            break;
                        }
                        case 'n': {
                            places = 9;
                            setField = 9999;
                            setTime = true;
                        }
                    }
                    break;
                }
                case 256: 
                case 512: {
                    ++cursor;
                    found = false;
                    do {
                        found = false;
                        if (c == '>') {
                            bias = 100;
                            c = format.charAt(++i);
                            found = true;
                        }
                        if (c == '<') {
                            bias = -100;
                            c = format.charAt(++i);
                            found = true;
                        }
                        if (c == '+') {
                            bias = 1;
                            c = format.charAt(++i);
                            found = true;
                        }
                        if (c != '-') continue;
                        bias = 1;
                        c = format.charAt(++i);
                        found = true;
                    } while (found && i < length);
                    bias = -bias;
                    places = -1;
                    switch (c) {
                        case 'l': {
                            ++cursor;
                            break block18;
                        }
                        case 'e': {
                            setField = 0;
                            setDate = true;
                            break block18;
                        }
                        case 'Y': {
                            setField = 1;
                            setDate = true;
                            break block18;
                        }
                        case 'y': {
                            setField = 1;
                            setDate = true;
                            bias = 1900;
                            break block18;
                        }
                        case 'm': {
                            setField = 2;
                            setDate = true;
                            break block18;
                        }
                        case 'u': {
                            setField = 3;
                            setDate = true;
                            break block18;
                        }
                        case 'W': {
                            setField = 4;
                            setDate = true;
                            break block18;
                        }
                        case 'd': {
                            setField = 5;
                            setDate = true;
                            break block18;
                        }
                        case 'j': {
                            setField = 6;
                            setDate = true;
                            break block18;
                        }
                        case 'w': {
                            setField = 7;
                            setDate = true;
                            break block18;
                        }
                        case 'U': {
                            setField = 8;
                            setDate = true;
                            break block18;
                        }
                        case 'A': {
                            setField = 9;
                            setTime = true;
                            break block18;
                        }
                        case 'I': {
                            setField = 10;
                            setTime = true;
                            break block18;
                        }
                        case 'H': {
                            setField = 11;
                            setTime = true;
                            break block18;
                        }
                        case 'M': {
                            setField = 12;
                            setTime = true;
                            break block18;
                        }
                        case 'S': {
                            setField = 13;
                            setTime = true;
                            break block18;
                        }
                        case 's': {
                            setField = 14;
                            setTime = true;
                            break block18;
                        }
                        case 'z': {
                            setField = 15;
                            break block18;
                        }
                        case 'Z': {
                            setField = 16;
                            break block18;
                        }
                        case 'n': {
                            setField = 9999;
                            setTime = true;
                            break block18;
                        }
                    }
                    places = 0;
                    break;
                }
                case 64: {
                    switch (c) {
                        case 'l': {
                            cursor += 9;
                            break;
                        }
                        case 'e': {
                            if (dateString.charAt(cursor) == 'B') {
                                cal.set(0, 0);
                            } else {
                                cal.set(0, 1);
                            }
                            setDate = true;
                            cursor += 3;
                            places = 0;
                            break;
                        }
                        case 'Y': {
                            places = 4;
                            setField = 1;
                            setDate = true;
                            break;
                        }
                        case 'y': {
                            places = 2;
                            setField = 1;
                            setDate = true;
                            bias = 1900;
                            break;
                        }
                        case 'm': {
                            name = dateString.substring(cursor, cursor + 3);
                            if (name.startsWith("JA")) {
                                number = 0;
                                cursor += 7;
                            } else if (name.startsWith("F")) {
                                number = 1;
                                cursor += 8;
                            } else if (name.startsWith("MAR")) {
                                number = 2;
                                cursor += 5;
                            } else if (name.startsWith("AP")) {
                                number = 3;
                                cursor += 5;
                            } else if (name.startsWith("MAY")) {
                                number = 4;
                                cursor += 3;
                            } else if (name.startsWith("JUN")) {
                                number = 5;
                                cursor += 4;
                            } else if (name.startsWith("JUL")) {
                                number = 6;
                                cursor += 4;
                            } else if (name.startsWith("AU")) {
                                number = 7;
                                cursor += 6;
                            } else if (name.startsWith("S")) {
                                number = 8;
                                cursor += 9;
                            } else if (name.startsWith("O")) {
                                number = 9;
                                cursor += 7;
                            } else if (name.startsWith("N")) {
                                number = 10;
                                cursor += 8;
                            } else if (name.startsWith("D")) {
                                number = 11;
                                cursor += 8;
                            } else {
                                number = -1;
                            }
                            if (number >= 0) {
                                cal.set(2, number);
                                setDate = true;
                            }
                            number = 0;
                            break;
                        }
                        case 'u': {
                            places = 2;
                            setField = 3;
                            setDate = true;
                            break;
                        }
                        case 'W': {
                            places = 1;
                            setField = 4;
                            setDate = true;
                            break;
                        }
                        case 'd': {
                            places = 2;
                            setField = 5;
                            setDate = true;
                            break;
                        }
                        case 'j': {
                            places = 3;
                            setField = 6;
                            setDate = true;
                            break;
                        }
                        case 'w': {
                            name = dateString.substring(cursor, cursor + 2);
                            if (name.startsWith("SU")) {
                                number = 0;
                                cursor += 6;
                            } else if (name.startsWith("MO")) {
                                number = 1;
                                cursor += 6;
                            } else if (name.startsWith("TU")) {
                                number = 2;
                                cursor += 7;
                            } else if (name.startsWith("WE")) {
                                number = 3;
                                cursor += 9;
                            } else if (name.startsWith("TH")) {
                                number = 4;
                                cursor += 8;
                            } else if (name.startsWith("FR")) {
                                number = 5;
                                cursor += 6;
                            } else if (name.startsWith("SA")) {
                                number = 6;
                                cursor += 8;
                            } else {
                                number = -1;
                            }
                            if (number >= 0) {
                                cal.set(7, number);
                                setDate = true;
                            }
                            places = 0;
                            break;
                        }
                        case 'U': {
                            places = 1;
                            setField = 4;
                            setDate = true;
                            break;
                        }
                        case 'A': {
                            if (dateString.charAt(cursor) == 'A') {
                                cal.set(9, 0);
                            } else {
                                cal.set(9, 1);
                            }
                            setTime = true;
                            cursor += 2;
                            places = 0;
                            break;
                        }
                        case 'I': {
                            places = 2;
                            setField = 10;
                            setTime = true;
                            break;
                        }
                        case 'H': {
                            places = 2;
                            setField = 11;
                            setTime = true;
                            break;
                        }
                        case 'M': {
                            places = 2;
                            setField = 12;
                            setTime = true;
                            break;
                        }
                        case 'S': {
                            places = 2;
                            setField = 13;
                            setTime = true;
                            break;
                        }
                        case 's': {
                            places = 3;
                            setField = 14;
                            setTime = true;
                            break;
                        }
                        case 'z': {
                            name = dateString.substring(cursor, cursor + 6);
                            number = ConvertData.parseDecimal(name.substring(1, 3)) * 60 * 60 * 1000 + ConvertData.parseDecimal(name.substring(4, 6)) * 60 * 1000;
                            if (name.charAt(0) == '-') {
                                number = -number;
                            }
                            cal.set(15, number);
                            places = 0;
                            cursor += 6;
                            break;
                        }
                        case 'Z': {
                            name = dateString.substring(cursor, cursor + 6);
                            number = ConvertData.parseDecimal(name.substring(1, 3)) * 60 * 60 * 1000 + ConvertData.parseDecimal(name.substring(4, 6)) * 60 * 1000;
                            if (name.charAt(0) == '-') {
                                number = -number;
                            }
                            cal.set(16, number);
                            places = 0;
                            cursor += 6;
                            break;
                        }
                        case 'n': {
                            places = 9;
                            setField = 9999;
                            setTime = true;
                        }
                    }
                    break;
                }
                case 128: {
                    switch (c) {
                        case 'l': {
                            ++cursor;
                            break;
                        }
                        case 'e': {
                            if (dateString.charAt(cursor) == 'B') {
                                cal.set(0, 0);
                            } else {
                                cal.set(0, 1);
                            }
                            setDate = true;
                            cursor += 2;
                            places = 0;
                            break;
                        }
                        case 'Y': {
                            places = 4;
                            setField = 1;
                            setDate = true;
                            break;
                        }
                        case 'y': {
                            places = 2;
                            setField = 1;
                            setDate = true;
                            bias = 1900;
                            break;
                        }
                        case 'm': {
                            name = dateString.substring(cursor, cursor + 3);
                            number = name.startsWith("JA") ? 0 : (name.startsWith("F") ? 1 : (name.startsWith("MAR") ? 2 : (name.startsWith("AP") ? 3 : (name.startsWith("MAY") ? 4 : (name.startsWith("JUN") ? 5 : (name.startsWith("JUL") ? 6 : (name.startsWith("AU") ? 7 : (name.startsWith("S") ? 8 : (name.startsWith("O") ? 9 : (name.startsWith("N") ? 10 : (name.startsWith("D") ? 11 : -1)))))))))));
                            if (number >= 0) {
                                cal.set(2, number);
                                setDate = true;
                                cursor += 3;
                            }
                            places = 0;
                            break;
                        }
                        case 'u': {
                            places = 2;
                            setField = 3;
                            setDate = true;
                            break;
                        }
                        case 'W': {
                            places = 1;
                            setField = 4;
                            setDate = true;
                            break;
                        }
                        case 'd': {
                            places = 2;
                            setField = 5;
                            setDate = true;
                            break;
                        }
                        case 'j': {
                            places = 3;
                            setField = 6;
                            setDate = true;
                            break;
                        }
                        case 'w': {
                            name = dateString.substring(cursor, cursor + 2);
                            number = name.startsWith("SU") ? 0 : (name.startsWith("MO") ? 1 : (name.startsWith("TU") ? 2 : (name.startsWith("WE") ? 3 : (name.startsWith("TH") ? 4 : (name.startsWith("FR") ? 5 : (name.startsWith("SA") ? 6 : -1))))));
                            if (number >= 0) {
                                cal.set(7, number);
                                setDate = true;
                                cursor += 3;
                            }
                            places = 0;
                            break;
                        }
                        case 'U': {
                            places = 1;
                            setField = 4;
                            setDate = true;
                            break;
                        }
                        case 'A': {
                            if (dateString.charAt(cursor) == 'A') {
                                cal.set(9, 0);
                            } else {
                                cal.set(9, 1);
                            }
                            setTime = true;
                            cursor += 2;
                            places = 0;
                            break;
                        }
                        case 'I': {
                            places = 2;
                            setField = 10;
                            setTime = true;
                            break;
                        }
                        case 'H': {
                            places = 2;
                            setField = 11;
                            setTime = true;
                            break;
                        }
                        case 'M': {
                            places = 2;
                            setField = 12;
                            setTime = true;
                            break;
                        }
                        case 'S': {
                            places = 2;
                            setField = 13;
                            setTime = true;
                            break;
                        }
                        case 's': {
                            places = 3;
                            setField = 14;
                            setTime = true;
                            break;
                        }
                        case 'z': {
                            name = dateString.substring(cursor, cursor + 6);
                            number = ConvertData.parseDecimal(name.substring(1, 3)) * 60 * 60 * 1000 + ConvertData.parseDecimal(name.substring(4, 6)) * 60 * 1000;
                            if (name.charAt(0) == '-') {
                                number = -number;
                            }
                            cal.set(15, number);
                            places = 0;
                            cursor += 6;
                            break;
                        }
                        case 'Z': {
                            name = dateString.substring(cursor, cursor + 6);
                            number = ConvertData.parseDecimal(name.substring(1, 3)) * 60 * 60 * 1000 + ConvertData.parseDecimal(name.substring(4, 6)) * 60 * 1000;
                            if (name.charAt(0) == '-') {
                                number = -number;
                            }
                            cal.set(16, number);
                            places = 0;
                            cursor += 6;
                            break;
                        }
                        case 'n': {
                            places = 9;
                            setField = 9999;
                            setTime = true;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case 'd': {
                            places = 2;
                            setField = 5;
                            setDate = true;
                            break;
                        }
                        case 'D': {
                            special = 1;
                            setDate = true;
                            break;
                        }
                        case 'H': {
                            places = 2;
                            setField = 11;
                            setTime = true;
                            break;
                        }
                        case 'I': {
                            places = 2;
                            setField = 10;
                            setTime = true;
                            break;
                        }
                        case 'j': {
                            places = 3;
                            setField = 6;
                            setDate = true;
                            break;
                        }
                        case 'm': {
                            places = 2;
                            setField = 2;
                            bias = -1;
                            setDate = true;
                            break;
                        }
                        case 'M': {
                            places = 2;
                            setField = 12;
                            setTime = true;
                            break;
                        }
                        case 'p': {
                            if (dateString.charAt(cursor) == 'A') {
                                cal.set(9, 0);
                            } else {
                                cal.set(9, 1);
                            }
                            cursor += 2;
                            setTime = true;
                            break;
                        }
                        case 'r': {
                            special = 2;
                            setTime = true;
                            break;
                        }
                        case 'R': {
                            special = 3;
                            setTime = true;
                            break;
                        }
                        case 'S': {
                            places = 2;
                            setField = 13;
                            setTime = true;
                            break;
                        }
                        case 'y': {
                            places = 2;
                            setField = 1;
                            setDate = true;
                            bias = 1900;
                            break;
                        }
                        case 'Y': {
                            places = 4;
                            setField = 1;
                            setDate = true;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'p': {
                            if (dateString.charAt(cursor) == 'A') {
                                cal.set(9, 0);
                            } else {
                                cal.set(9, 1);
                            }
                            cursor += 2;
                            setTime = true;
                            break block18;
                        }
                        case 'Y': 
                        case 'y': {
                            places = 4;
                            setField = 1;
                            setDate = true;
                            break block18;
                        }
                        case 'S': {
                            ++i;
                            switch (next) {
                                case 'n': {
                                    places = 9;
                                    setField = 9999;
                                    setTime = true;
                                    break block18;
                                }
                                case 'h': {
                                    places = 2;
                                    setField = 14;
                                    multiplier = 10;
                                    break block18;
                                }
                                case 'm': {
                                    places = 6;
                                    setField = 9999;
                                    multiplier = 1000;
                                    setTime = true;
                                    break block18;
                                }
                                case 'o': {
                                    places = 3;
                                    setField = 14;
                                    setTime = true;
                                    break block18;
                                }
                                case 't': {
                                    places = 1;
                                    setField = 14;
                                    multiplier = 100;
                                    setTime = true;
                                }
                            }
                        }
                    }
                }
            }
            switch (special) {
                case 0: {
                    if (places > 0) {
                        number = 0;
                        try {
                            while (places > 0) {
                                number *= 10;
                                number += dateString.charAt(cursor++) - 48;
                                --places;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        number += bias;
                        number *= multiplier;
                        if (setField >= 0) {
                            if (setField == 9999) {
                                nanos = number;
                                setNanos = true;
                            } else {
                                cal.set(setField, number);
                            }
                        }
                        cursor += places;
                        places = 0;
                        continue block171;
                    }
                    if (places >= 0 || setField < 0) continue block171;
                    number = dateString.charAt(cursor++);
                    number += bias;
                    number *= multiplier;
                    if (setField == 9999) {
                        nanos = number;
                        setNanos = true;
                        continue block171;
                    }
                    cal.set(setField, number);
                    continue block171;
                }
                case 1: {
                    cal.set(2, FormatDateTime.digits(dateString, cursor, 2) - 1);
                    cal.set(5, FormatDateTime.digits(dateString, cursor + 3, 2));
                    cal.set(1, FormatDateTime.digits(dateString, cursor + 6, 2) + 1900);
                    cursor += 8;
                    setDate = true;
                    continue block171;
                }
                case 2: {
                    int rh = FormatDateTime.digits(dateString, cursor, 2);
                    if (rh >= 12) {
                        rh -= 12;
                    }
                    int rm = FormatDateTime.digits(dateString, cursor + 3, 2);
                    int rs = FormatDateTime.digits(dateString, cursor + 6, 2);
                    char ap = dateString.charAt(cursor + 9);
                    if (ap == 'p' || ap == 'P') {
                        rh += 12;
                    }
                    cursor += 11;
                    cal.set(11, rh);
                    cal.set(12, rm);
                    cal.set(13, rs);
                    continue block171;
                }
                case 3: {
                    cal.set(11, FormatDateTime.digits(dateString, cursor, 2));
                    cal.set(12, FormatDateTime.digits(dateString, cursor + 3, 2));
                    cursor += 5;
                }
            }
        }
        if (setNanos) {
            Timestamp timestamp = new Timestamp(cal.getTime().getTime());
            timestamp.setNanos(nanos);
            return timestamp;
        }
        if (setDate && setTime) {
            return new Timestamp(cal.getTime().getTime());
        }
        if (setDate) {
            return new java.sql.Date(cal.getTime().getTime());
        }
        if (setTime) {
            return new Time(cal.getTime().getTime());
        }
        return cal.getTime();
    }

    public static String format(String format, Date dateObject) {
        if (format == null) {
            return dateObject.toString();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dateObject);
        int nanos = ((Timestamp)dateObject).getNanos();
        return FormatDateTime.format(format, cal, nanos);
    }

    public static String format(String format, GregorianCalendar greg) {
        return FormatDateTime.format(format, greg, -1);
    }

    /*
     * Unable to fully structure code
     */
    public static String format(String format, GregorianCalendar greg, int nanos) {
        if (format == null) {
            return greg.toString();
        }
        uppercase = false;
        lowercase = false;
        result = new StringBuffer();
        l = format.length();
        c = '\u0000';
        next = '\u0000';
        HOUR = 3600000;
        MINUTE = 60000;
        type = 0;
        era = greg.get(0);
        year = greg.get(1);
        leap = greg.isLeapYear(year) != false ? 1 : 0;
        yy = year % 100;
        cc = year / 100;
        ce = cc - 19;
        millenium = cc / 10;
        month = greg.get(2);
        weekOfYear = greg.get(3);
        weekOfMonth = greg.get(4);
        date = greg.get(5);
        julian = greg.get(6);
        weekday = greg.get(7);
        weekInMonth = greg.get(8);
        ampm = greg.get(9);
        hour12 = greg.get(10);
        if (hour12 == 0) {
            hour12 = 12;
        }
        hour24 = greg.get(11);
        minute = greg.get(12);
        second = greg.get(13);
        millis = greg.get(14);
        zone = greg.get(15);
        dst = greg.get(16);
        v0 = trueCentury = yy == 0 ? cc : cc + 1;
        if (nanos >= 0) {
            millis = nanos / 1000000;
        } else {
            nanos = millis * 1000000;
        }
        bias = 0;
        found = false;
        block439: for (i = 0; i < l; ++i) {
            c = format.charAt(i);
            next = i < l - 1 ? format.charAt(i + 1) : '\u0000';
            block0 : switch (c) {
                case ' ': 
                case '\'': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': {
                    result.append(c);
                    continue block439;
                }
                default: {
                    if (c == '\"') {
                        for (j = i + 1; j < l; ++j) {
                            c = format.charAt(j);
                            if (c == '\"') {
                                i = j;
                                continue block439;
                            }
                            result.append(c);
                        }
                        continue block439;
                    }
                    if (c == next) {
                        switch (c) {
                            case '%': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '@': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '#': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '&': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '^': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '!': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '$': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '*': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '`': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                            case '~': {
                                result.append(c);
                                ++i;
                                continue block439;
                            }
                        }
                    }
                    type = 0;
                    switch (c) {
                        case '%': {
                            type = 1;
                            break;
                        }
                        case '@': {
                            type = 2;
                            break;
                        }
                        case '#': {
                            type = 4;
                            break;
                        }
                        case '&': {
                            type = 8;
                            break;
                        }
                        case '^': {
                            type = 32;
                            break;
                        }
                        case '!': {
                            type = 16;
                            break;
                        }
                        case '$': {
                            type = 64;
                            break;
                        }
                        case '*': {
                            type = 128;
                            break;
                        }
                        case '`': {
                            type = 256;
                            break;
                        }
                        case '~': {
                            type = 512;
                        }
                    }
                    if (type != 0) ** GOTO lbl796
                    switch (c) {
                        case '_': {
                            c = format.charAt(++i);
                            switch (c) {
                                case 'U': 
                                case 'u': {
                                    uppercase = true;
                                    continue block439;
                                }
                                case 'L': 
                                case 'l': {
                                    lowercase = true;
                                    continue block439;
                                }
                                case 'D': 
                                case 'd': {
                                    continue block439;
                                }
                                case 'T': 
                                case 't': {
                                    continue block439;
                                }
                            }
                            continue block439;
                        }
                    }
                    check = format.substring(i);
                    if (check == null || check.length() <= 0) ** GOTO lbl-1000
                    block36 : switch (check.charAt(0)) {
                        case 'A': {
                            if (check.startsWith("AD")) {
                                if (era == 1) {
                                    result.append("AD");
                                } else {
                                    result.append("BC");
                                }
                                ++i;
                                break;
                            }
                            if (check.startsWith("A.D.")) {
                                if (era == 1) {
                                    result.append("A.D.");
                                } else {
                                    result.append("B.C.");
                                }
                                i += 3;
                                break;
                            }
                            if (check.startsWith("AM")) {
                                if (ampm == 0) {
                                    result.append("AM");
                                } else {
                                    result.append("PM");
                                }
                                ++i;
                                break;
                            }
                            if (check.startsWith("A.M.")) {
                                if (ampm == 0) {
                                    result.append("AM");
                                } else {
                                    result.append("PM");
                                }
                                i += 3;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'B': {
                            if (check.startsWith("BC")) {
                                if (era == 1) {
                                    result.append("AD");
                                } else {
                                    result.append("BC");
                                }
                                ++i;
                                break;
                            }
                            if (check.startsWith("B.C.")) {
                                if (era == 1) {
                                    result.append("A.D.");
                                } else {
                                    result.append("B.C.");
                                }
                                i += 3;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'C': {
                            if (check.startsWith("CC")) {
                                if (trueCentury > 0) {
                                    result.append(trueCentury);
                                } else {
                                    result.append(-trueCentury);
                                }
                                ++i;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'D': {
                            if (check.startsWith("DAY")) {
                                switch (weekday) {
                                    case 1: {
                                        result.append("Sunday   ");
                                        break;
                                    }
                                    case 2: {
                                        result.append("Monday   ");
                                        break;
                                    }
                                    case 3: {
                                        result.append("Tuesday  ");
                                        break;
                                    }
                                    case 4: {
                                        result.append("Wednesday");
                                        break;
                                    }
                                    case 5: {
                                        result.append("Thursday ");
                                        break;
                                    }
                                    case 6: {
                                        result.append("Friday   ");
                                        break;
                                    }
                                    case 7: {
                                        result.append("Saturday ");
                                    }
                                }
                                i += 2;
                                break;
                            }
                            if (check.startsWith("DDD")) {
                                result.append(FormatDateTime.format(julian, 2));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("DD")) {
                                result.append(FormatDateTime.format(date, 2));
                                ++i;
                                break;
                            }
                            if (check.startsWith("D")) {
                                result.append(48 + weekday);
                                break;
                            }
                            if (check.startsWith("DY")) {
                                switch (weekday) {
                                    case 1: {
                                        result.append("Sun");
                                        break;
                                    }
                                    case 2: {
                                        result.append("Mon");
                                        break;
                                    }
                                    case 3: {
                                        result.append("Tue");
                                        break;
                                    }
                                    case 4: {
                                        result.append("Wed");
                                        break;
                                    }
                                    case 5: {
                                        result.append("Thu");
                                        break;
                                    }
                                    case 6: {
                                        result.append("Fri");
                                        break;
                                    }
                                    case 7: {
                                        result.append("Sat");
                                    }
                                }
                                ++i;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'E': {
                            if (check.startsWith("EE")) {
                                switch (era) {
                                    case 1: {
                                        result.append("C.E.  ");
                                        break;
                                    }
                                    case 0: {
                                        result.append("B.C.E.");
                                    }
                                }
                                ++i;
                                break;
                            }
                            if (check.startsWith("E")) {
                                switch (era) {
                                    case 1: {
                                        result.append("CE ");
                                        break block36;
                                    }
                                    case 0: {
                                        result.append("BCE");
                                    }
                                }
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'F': {
                            if (check.startsWith("FF1")) {
                                result.append(FormatDateTime.format(millis / 100, 1));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF2")) {
                                result.append(FormatDateTime.format(millis / 10, 2));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF3")) {
                                result.append(FormatDateTime.format(millis, 3));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF4")) {
                                result.append(FormatDateTime.format(millis * 10, 4));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF5")) {
                                result.append(FormatDateTime.format(millis * 100, 5));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF6")) {
                                result.append(FormatDateTime.format(millis * 1000, 6));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF7")) {
                                result.append(FormatDateTime.format(millis * 10000, 7));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF8")) {
                                result.append(FormatDateTime.format(millis * 100000, 8));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF9")) {
                                result.append(FormatDateTime.format(millis * 1000000, 9));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("FF")) {
                                result.append(FormatDateTime.format(millis / 10, 2));
                                ++i;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'H': {
                            if (check.startsWith("HH12")) {
                                result.append(FormatDateTime.format(hour12, 2));
                                i += 3;
                                break;
                            }
                            if (check.startsWith("HH24")) {
                                result.append(FormatDateTime.format(hour24, 2));
                                i += 3;
                                break;
                            }
                            if (check.startsWith("HH")) {
                                result.append(FormatDateTime.format(hour12, 2));
                                ++i;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'I': {
                            if (check.startsWith("IW")) {
                                result.append(FormatDateTime.format(weekOfYear, 2));
                                ++i;
                                break;
                            }
                            if (check.startsWith("IYYY")) {
                                i += 3;
                                result.append(FormatDateTime.format(year, 4));
                                break;
                            }
                            if (check.startsWith("IYY")) {
                                i += 2;
                                result.append(FormatDateTime.format(year % 1000, 3));
                                break;
                            }
                            if (check.startsWith("IY")) {
                                ++i;
                                result.append(FormatDateTime.format(year % 100, 2));
                                break;
                            }
                            if (check.startsWith("I")) {
                                result.append(year % 10);
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'J': {
                            if (check.startsWith("J")) {
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'M': {
                            if (check.startsWith("MI")) {
                                result.append(FormatDateTime.format(minute, 2));
                                ++i;
                                break;
                            }
                            if (check.startsWith("MM")) {
                                switch (month) {
                                    case 0: {
                                        result.append("01");
                                        break;
                                    }
                                    case 1: {
                                        result.append("02");
                                        break;
                                    }
                                    case 2: {
                                        result.append("03");
                                        break;
                                    }
                                    case 3: {
                                        result.append("04");
                                        break;
                                    }
                                    case 4: {
                                        result.append("05");
                                        break;
                                    }
                                    case 5: {
                                        result.append("06");
                                        break;
                                    }
                                    case 6: {
                                        result.append("07");
                                        break;
                                    }
                                    case 7: {
                                        result.append("08");
                                        break;
                                    }
                                    case 8: {
                                        result.append("09");
                                        break;
                                    }
                                    case 9: {
                                        result.append("10");
                                        break;
                                    }
                                    case 10: {
                                        result.append("11");
                                        break;
                                    }
                                    case 11: {
                                        result.append("12");
                                    }
                                }
                                ++i;
                                break;
                            }
                            if (check.startsWith("MONTH")) {
                                switch (month) {
                                    case 0: {
                                        result.append("January  ");
                                        break;
                                    }
                                    case 1: {
                                        result.append("February ");
                                        break;
                                    }
                                    case 2: {
                                        result.append("March    ");
                                        break;
                                    }
                                    case 3: {
                                        result.append("April    ");
                                        break;
                                    }
                                    case 4: {
                                        result.append("May      ");
                                        break;
                                    }
                                    case 5: {
                                        result.append("June     ");
                                        break;
                                    }
                                    case 6: {
                                        result.append("July     ");
                                        break;
                                    }
                                    case 7: {
                                        result.append("August   ");
                                        break;
                                    }
                                    case 8: {
                                        result.append("September");
                                        break;
                                    }
                                    case 9: {
                                        result.append("October  ");
                                        break;
                                    }
                                    case 10: {
                                        result.append("November ");
                                        break;
                                    }
                                    case 11: {
                                        result.append("December ");
                                    }
                                }
                                i += 4;
                                break;
                            }
                            if (check.startsWith("MON")) {
                                switch (month) {
                                    case 0: {
                                        result.append("Jan");
                                        break;
                                    }
                                    case 1: {
                                        result.append("Feb");
                                        break;
                                    }
                                    case 2: {
                                        result.append("Mar");
                                        break;
                                    }
                                    case 3: {
                                        result.append("Apr");
                                        break;
                                    }
                                    case 4: {
                                        result.append("May");
                                        break;
                                    }
                                    case 5: {
                                        result.append("Jun");
                                        break;
                                    }
                                    case 6: {
                                        result.append("Jul");
                                        break;
                                    }
                                    case 7: {
                                        result.append("Aug");
                                        break;
                                    }
                                    case 8: {
                                        result.append("Sep");
                                        break;
                                    }
                                    case 9: {
                                        result.append("Oct");
                                        break;
                                    }
                                    case 10: {
                                        result.append("Nov");
                                        break;
                                    }
                                    case 11: {
                                        result.append("Dec");
                                    }
                                }
                                i += 2;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'P': {
                            if (!check.startsWith("PM")) ** GOTO lbl603
                            if (ampm == 0) {
                                result.append("AM");
                            } else {
                                result.append("PM");
                            }
                            ++i;
                            ** GOTO lbl791
lbl603:
                            // 1 sources

                            if (!check.startsWith("P.M.")) ** GOTO lbl791
                            if (ampm == 0) {
                                result.append("A.M.");
                            } else {
                                result.append("P.M.");
                            }
                            i += 3;
                            ** GOTO lbl791
                        }
                        case 'Q': {
                            if (check.startsWith("Q")) {
                                switch (month) {
                                    case 0: 
                                    case 1: 
                                    case 2: {
                                        result.append('1');
                                        break block36;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        result.append('2');
                                        break block36;
                                    }
                                    case 6: 
                                    case 7: 
                                    case 8: {
                                        result.append('3');
                                        break block36;
                                    }
                                    case 9: 
                                    case 10: 
                                    case 11: {
                                        result.append('4');
                                    }
                                }
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'R': {
                            if (check.startsWith("RM")) {
                                switch (month) {
                                    case 0: {
                                        result.append("I   ");
                                        break;
                                    }
                                    case 1: {
                                        result.append("II  ");
                                        break;
                                    }
                                    case 2: {
                                        result.append("III ");
                                        break;
                                    }
                                    case 3: {
                                        result.append("IV  ");
                                        break;
                                    }
                                    case 4: {
                                        result.append("V   ");
                                        break;
                                    }
                                    case 5: {
                                        result.append("VI  ");
                                        break;
                                    }
                                    case 6: {
                                        result.append("VII ");
                                        break;
                                    }
                                    case 7: {
                                        result.append("VIII");
                                        break;
                                    }
                                    case 8: {
                                        result.append("IX  ");
                                        break;
                                    }
                                    case 9: {
                                        result.append("X   ");
                                        break;
                                    }
                                    case 10: {
                                        result.append("XI  ");
                                        break;
                                    }
                                    case 11: {
                                        result.append("XII ");
                                    }
                                }
                                ++i;
                                break;
                            }
                            if (!check.startsWith("RR")) ** GOTO lbl689
                            result.append(year % 100);
                            ++i;
                            ** GOTO lbl791
lbl689:
                            // 1 sources

                            if (!check.startsWith("RRRR")) ** GOTO lbl791
                            result.append(year);
                            i += 3;
                            ** GOTO lbl791
                        }
                        case 'S': {
                            if (check.startsWith("SSSSS")) {
                                i += 4;
                                break;
                            }
                            if (check.startsWith("SS")) {
                                result.append(second);
                                ++i;
                                break;
                            }
                            if (check.startsWith("SCC")) {
                                if (era == 0) {
                                    result.append('-');
                                }
                                result.append(trueCentury);
                                i += 2;
                                break;
                            }
                            if (check.startsWith("SYEAR")) {
                                if (era == 0) {
                                    result.append('-').append(FormatDateTime.spell(year));
                                } else {
                                    result.append(FormatDateTime.spell(year));
                                }
                                i += 4;
                                break;
                            }
                            if (check.startsWith("SYYYY")) {
                                if (era == 0) {
                                    result.append('-').append(FormatDateTime.format(year, 4));
                                } else {
                                    result.append(year);
                                }
                                i += 4;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'T': {
                            if (check.startsWith("TZD")) {
                                i += 2;
                                break;
                            }
                            if (check.startsWith("TZH")) {
                                i += 2;
                                break;
                            }
                            if (check.startsWith("TZM")) {
                                i += 2;
                                break;
                            }
                            if (check.startsWith("TZR")) {
                                i += 2;
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'W': {
                            if (check.startsWith("WW")) {
                                result.append(FormatDateTime.format(weekOfYear, 2));
                                ++i;
                                break;
                            }
                            if (check.startsWith("W")) {
                                result.append(weekOfMonth);
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'X': {
                            if (check.startsWith("X")) {
                                result.append('.');
                                break;
                            }
                            ** GOTO lbl791
                        }
                        case 'Y': {
                            if (check.startsWith("Y,YYY")) {
                                result.append(year / 1000).append(',').append(FormatDateTime.format(year % 1000, 3));
                                i += 3;
                                break;
                            }
                            if (check.startsWith("YEAR")) {
                                result.append(FormatDateTime.spell(year));
                                i += 3;
                                break;
                            }
                            if (check.startsWith("YYYY")) {
                                result.append(FormatDateTime.format(year, 4));
                                i += 3;
                                break;
                            }
                            if (check.startsWith("YYY")) {
                                result.append(FormatDateTime.format(year % 1000, 3));
                                i += 2;
                                break;
                            }
                            if (check.startsWith("YY")) {
                                result.append(FormatDateTime.format(year % 100, 2));
                                ++i;
                                break;
                            }
                            if (check.startsWith("Y")) {
                                result.append(year % 10);
                                break;
                            }
                        }
lbl791:
                        // 24 sources

                        default: lbl-1000:
                        // 2 sources

                        {
                            result.append(c);
                            break;
                        }
                    }
                    continue block439;
lbl796:
                    // 1 sources

                    c = next;
                    if (++i < l - 1) {
                        next = format.charAt(i + 1);
                    }
                    switch (type) {
                        case 4: {
                            switch (c) {
                                case 'l': {
                                    result.append(leap);
                                    break;
                                }
                                case 'e': {
                                    result.append(era);
                                    break;
                                }
                                case 'Y': {
                                    result.append(year);
                                    break;
                                }
                                case 'y': {
                                    result.append(yy);
                                    break;
                                }
                                case 'c': {
                                    result.append(cc);
                                    break;
                                }
                                case 'C': {
                                    result.append(ce);
                                    break;
                                }
                                case 'N': {
                                    result.append(millenium);
                                    break;
                                }
                                case 'm': {
                                    result.append(month);
                                    break;
                                }
                                case 'u': {
                                    result.append(weekOfYear);
                                    break;
                                }
                                case 'W': {
                                    result.append(weekOfMonth);
                                    break;
                                }
                                case 'd': {
                                    result.append(date);
                                    break;
                                }
                                case 'j': {
                                    result.append(julian);
                                    break;
                                }
                                case 'w': {
                                    result.append(weekday);
                                    break;
                                }
                                case 'U': {
                                    result.append(weekInMonth);
                                    break;
                                }
                                case 'A': {
                                    result.append(ampm);
                                    break;
                                }
                                case 'I': {
                                    result.append(hour12);
                                    break;
                                }
                                case 'H': {
                                    result.append(hour24);
                                    break;
                                }
                                case 'M': {
                                    result.append(minute);
                                    break;
                                }
                                case 'S': {
                                    result.append(second);
                                    break;
                                }
                                case 's': {
                                    result.append(millis);
                                    break;
                                }
                                case 'z': {
                                    result.append(zone);
                                    break;
                                }
                                case 'Z': {
                                    result.append(dst);
                                    break;
                                }
                                case 'n': {
                                    result.append(nanos);
                                }
                            }
                            continue block439;
                        }
                        case 8: {
                            switch (c) {
                                case 'l': {
                                    result.append(leap);
                                    break;
                                }
                                case 'e': {
                                    result.append(era);
                                    break;
                                }
                                case 'Y': {
                                    result.append(year);
                                    break;
                                }
                                case 'y': {
                                    result.append(FormatDateTime.format(yy, 2));
                                    break;
                                }
                                case 'c': {
                                    result.append(FormatDateTime.format(cc, 2));
                                    break;
                                }
                                case 'C': {
                                    result.append(ce);
                                    break;
                                }
                                case 'N': {
                                    result.append(millenium);
                                    break;
                                }
                                case 'm': {
                                    result.append(FormatDateTime.format(month, 2));
                                    break;
                                }
                                case 'u': {
                                    result.append(FormatDateTime.format(weekOfYear, 2));
                                    break;
                                }
                                case 'W': {
                                    result.append(weekOfMonth);
                                    break;
                                }
                                case 'd': {
                                    result.append(FormatDateTime.format(date, 2));
                                    break;
                                }
                                case 'j': {
                                    result.append(FormatDateTime.format(julian, 3));
                                    break;
                                }
                                case 'w': {
                                    result.append(weekday);
                                    break;
                                }
                                case 'U': {
                                    result.append(weekInMonth);
                                    break;
                                }
                                case 'A': {
                                    result.append(ampm);
                                    break;
                                }
                                case 'I': {
                                    result.append(FormatDateTime.format(hour12, 2));
                                    break;
                                }
                                case 'H': {
                                    result.append(FormatDateTime.format(hour24, 2));
                                    break;
                                }
                                case 'M': {
                                    result.append(FormatDateTime.format(minute, 2));
                                    break;
                                }
                                case 'S': {
                                    result.append(FormatDateTime.format(second, 2));
                                    break;
                                }
                                case 's': {
                                    result.append(FormatDateTime.format(millis, 3));
                                    break;
                                }
                                case 'z': {
                                    result.append(FormatDateTime.format(zone, 8));
                                    break;
                                }
                                case 'Z': {
                                    result.append(FormatDateTime.format(dst, 8));
                                    break;
                                }
                                case 'n': {
                                    result.append(FormatDateTime.format(nanos, 9));
                                }
                            }
                            continue block439;
                        }
                        case 16: {
                            switch (c) {
                                case 'l': {
                                    result.append(leap);
                                    break;
                                }
                                case 'e': {
                                    result.append(era);
                                    break;
                                }
                                case 'Y': {
                                    result.append(year);
                                    break;
                                }
                                case 'y': {
                                    result.append(yy);
                                    break;
                                }
                                case 'c': {
                                    result.append(cc);
                                    break;
                                }
                                case 'C': {
                                    result.append(ce);
                                    break;
                                }
                                case 'N': {
                                    result.append(millenium);
                                    break;
                                }
                                case 'm': {
                                    result.append(month + 1);
                                    break;
                                }
                                case 'u': {
                                    result.append(weekOfYear);
                                    break;
                                }
                                case 'W': {
                                    result.append(weekOfMonth);
                                    break;
                                }
                                case 'd': {
                                    result.append(date);
                                    break;
                                }
                                case 'j': {
                                    result.append(julian);
                                    break;
                                }
                                case 'w': {
                                    result.append(weekday);
                                    break;
                                }
                                case 'U': {
                                    result.append(weekInMonth);
                                    break;
                                }
                                case 'A': {
                                    result.append(ampm);
                                    break;
                                }
                                case 'I': {
                                    if (hour12 == 0) {
                                        result.append("12");
                                        break;
                                    }
                                    result.append(hour12);
                                    break;
                                }
                                case 'H': {
                                    result.append(hour24);
                                    break;
                                }
                                case 'M': {
                                    result.append(minute);
                                    break;
                                }
                                case 'S': {
                                    result.append(second);
                                    break;
                                }
                                case 's': {
                                    result.append(millis);
                                    break;
                                }
                                case 'z': {
                                    result.append(zone);
                                    break;
                                }
                                case 'Z': {
                                    result.append(dst);
                                    break;
                                }
                                case 'n': {
                                    result.append(nanos);
                                }
                            }
                            continue block439;
                        }
                        case 32: {
                            switch (c) {
                                case 'l': {
                                    result.append(leap);
                                    break;
                                }
                                case 'e': {
                                    result.append(era);
                                    break;
                                }
                                case 'Y': {
                                    result.append(year);
                                    break;
                                }
                                case 'y': {
                                    result.append(FormatDateTime.format(yy, 2));
                                    break;
                                }
                                case 'c': {
                                    result.append(FormatDateTime.format(cc, 2));
                                    break;
                                }
                                case 'C': {
                                    result.append(ce);
                                    break;
                                }
                                case 'N': {
                                    result.append(millenium);
                                    break;
                                }
                                case 'm': {
                                    result.append(FormatDateTime.format(month + 1, 2));
                                    break;
                                }
                                case 'u': {
                                    result.append(FormatDateTime.format(weekOfYear, 2));
                                    break;
                                }
                                case 'W': {
                                    result.append(weekOfMonth);
                                    break;
                                }
                                case 'd': {
                                    result.append(FormatDateTime.format(date, 2));
                                    break;
                                }
                                case 'j': {
                                    result.append(FormatDateTime.format(julian, 3));
                                    break;
                                }
                                case 'w': {
                                    result.append(weekday);
                                    break;
                                }
                                case 'U': {
                                    result.append(weekInMonth);
                                    break;
                                }
                                case 'A': {
                                    result.append(ampm);
                                    break;
                                }
                                case 'I': {
                                    if (hour12 == 0) {
                                        result.append("12");
                                        break;
                                    }
                                    result.append(FormatDateTime.format(hour12, 2));
                                    break;
                                }
                                case 'H': {
                                    result.append(FormatDateTime.format(hour24, 2));
                                    break;
                                }
                                case 'M': {
                                    result.append(FormatDateTime.format(minute, 2));
                                    break;
                                }
                                case 'S': {
                                    result.append(FormatDateTime.format(second, 2));
                                    break;
                                }
                                case 's': {
                                    result.append(FormatDateTime.format(millis, 3));
                                    break;
                                }
                                case 'z': {
                                    result.append(FormatDateTime.format(zone, 8));
                                    break;
                                }
                                case 'Z': {
                                    result.append(FormatDateTime.format(dst, 8));
                                    break;
                                }
                                case 'n': {
                                    result.append(FormatDateTime.format(nanos, 9));
                                }
                            }
                            continue block439;
                        }
                        case 256: 
                        case 512: {
                            bias = 0;
                            found = false;
                            do {
                                found = false;
                                if (c == '>') {
                                    bias = 100;
                                    c = format.charAt(++i);
                                    found = true;
                                }
                                if (c == '<') {
                                    bias = -100;
                                    c = format.charAt(++i);
                                    found = true;
                                }
                                if (c == '+') {
                                    bias = 1;
                                    c = format.charAt(++i);
                                    found = true;
                                }
                                if (c != '-') continue;
                                bias = 1;
                                c = format.charAt(++i);
                                found = true;
                            } while (found && i < l);
                            switch (c) {
                                case 'l': {
                                    result.append((char)(leap + bias));
                                    break;
                                }
                                case 'e': {
                                    result.append((char)(era + bias));
                                    break;
                                }
                                case 'Y': {
                                    result.append((char)(year + bias));
                                    break;
                                }
                                case 'y': {
                                    result.append((char)(yy + bias));
                                    break;
                                }
                                case 'c': {
                                    result.append((char)(cc + bias));
                                    break;
                                }
                                case 'C': {
                                    result.append((char)(c + bias));
                                    break;
                                }
                                case 'N': {
                                    result.append((char)(millenium + bias));
                                    break;
                                }
                                case 'm': {
                                    result.append((char)(month + bias));
                                    break;
                                }
                                case 'u': {
                                    result.append((char)(weekOfYear + bias));
                                    break;
                                }
                                case 'W': {
                                    result.append((char)(weekOfMonth + bias));
                                    break;
                                }
                                case 'd': {
                                    result.append((char)(date + bias));
                                    break;
                                }
                                case 'j': {
                                    result.append((char)(julian + bias));
                                    break;
                                }
                                case 'w': {
                                    result.append((char)(weekday + bias));
                                    break;
                                }
                                case 'U': {
                                    result.append((char)(weekInMonth + bias));
                                    break;
                                }
                                case 'A': {
                                    result.append((char)(ampm + bias));
                                    break;
                                }
                                case 'I': {
                                    result.append((char)(hour12 + bias));
                                    break;
                                }
                                case 'H': {
                                    result.append((char)(hour24 + bias));
                                    break;
                                }
                                case 'M': {
                                    result.append((char)(minute + bias));
                                    break;
                                }
                                case 'S': {
                                    result.append((char)(second + bias));
                                    break;
                                }
                                case 's': {
                                    result.append((char)(millis + bias));
                                    break;
                                }
                                case 'z': {
                                    result.append((char)(zone + bias));
                                    break;
                                }
                                case 'Z': {
                                    result.append((char)(dst + bias));
                                    break;
                                }
                                case 'n': {
                                    result.append((char)(nanos + bias));
                                }
                            }
                            continue block439;
                        }
                        case 64: {
                            switch (c) {
                                case 'l': {
                                    switch (leap) {
                                        case 0: {
                                            result.append("         ");
                                            break;
                                        }
                                        case 1: {
                                            result.append("LEAP YEAR");
                                        }
                                    }
                                    break;
                                }
                                case 'e': {
                                    switch (era) {
                                        case 0: {
                                            result.append("BCE");
                                            break;
                                        }
                                        case 1: {
                                            result.append("CE ");
                                        }
                                    }
                                    break;
                                }
                                case 'Y': {
                                    result.append(year);
                                    break;
                                }
                                case 'y': {
                                    result.append(FormatDateTime.format(yy, 2));
                                    break;
                                }
                                case 'c': {
                                    result.append(FormatDateTime.format(cc, 2));
                                    break;
                                }
                                case 'C': {
                                    result.append(ce);
                                    break;
                                }
                                case 'N': {
                                    result.append(millenium);
                                    break;
                                }
                                case 'm': {
                                    switch (month + 1) {
                                        case 1: {
                                            result.append("January");
                                            break;
                                        }
                                        case 2: {
                                            result.append("February");
                                            break;
                                        }
                                        case 3: {
                                            result.append("March");
                                            break;
                                        }
                                        case 4: {
                                            result.append("April");
                                            break;
                                        }
                                        case 5: {
                                            result.append("May");
                                            break;
                                        }
                                        case 6: {
                                            result.append("June");
                                            break;
                                        }
                                        case 7: {
                                            result.append("July");
                                            break;
                                        }
                                        case 8: {
                                            result.append("August");
                                            break;
                                        }
                                        case 9: {
                                            result.append("September");
                                            break;
                                        }
                                        case 10: {
                                            result.append("October");
                                            break;
                                        }
                                        case 11: {
                                            result.append("November");
                                            break;
                                        }
                                        case 12: {
                                            result.append("December");
                                        }
                                    }
                                    break;
                                }
                                case 'u': {
                                    result.append(FormatDateTime.format(weekOfYear, 2));
                                    break;
                                }
                                case 'W': {
                                    result.append(weekOfMonth);
                                    break;
                                }
                                case 'd': {
                                    result.append(FormatDateTime.format(date, 2));
                                    break;
                                }
                                case 'j': {
                                    result.append(FormatDateTime.format(julian, 3));
                                    break;
                                }
                                case 'w': {
                                    switch (weekday) {
                                        case 1: {
                                            result.append("Sunday   ");
                                            break;
                                        }
                                        case 2: {
                                            result.append("Monday   ");
                                            break;
                                        }
                                        case 3: {
                                            result.append("Tuesday  ");
                                            break;
                                        }
                                        case 4: {
                                            result.append("Wednesday");
                                            break;
                                        }
                                        case 5: {
                                            result.append("Thursday ");
                                            break;
                                        }
                                        case 6: {
                                            result.append("Friday   ");
                                            break;
                                        }
                                        case 7: {
                                            result.append("Saturday ");
                                        }
                                    }
                                    break;
                                }
                                case 'U': {
                                    result.append(weekInMonth);
                                    break;
                                }
                                case 'A': {
                                    switch (ampm) {
                                        case 0: {
                                            result.append("AM");
                                            break;
                                        }
                                        case 1: {
                                            result.append("PM");
                                        }
                                    }
                                    break;
                                }
                                case 'I': {
                                    if (hour12 == 0) {
                                        result.append("12");
                                        break;
                                    }
                                    result.append(FormatDateTime.format(hour12, 2));
                                    break;
                                }
                                case 'H': {
                                    result.append(FormatDateTime.format(hour24, 2));
                                    break;
                                }
                                case 'M': {
                                    result.append(FormatDateTime.format(minute, 2));
                                    break;
                                }
                                case 'S': {
                                    result.append(FormatDateTime.format(second, 2));
                                    break;
                                }
                                case 's': {
                                    result.append(FormatDateTime.format(millis, 3));
                                    break;
                                }
                                case 'z': {
                                    if (zone < 0) {
                                        result.append('-');
                                    } else {
                                        result.append('+');
                                    }
                                    zoneHour = zone / HOUR;
                                    zoneMinute = zone / HOUR * 60 - zone / MINUTE;
                                    if (zoneHour < 0) {
                                        zoneHour = -zoneHour;
                                    }
                                    if (zoneMinute < 0) {
                                        zoneMinute = -zoneMinute;
                                    }
                                    result.append(FormatDateTime.format(zoneHour, 2));
                                    result.append(':');
                                    result.append(FormatDateTime.format(zoneMinute, 2));
                                    break;
                                }
                                case 'Z': {
                                    if (dst < 0) {
                                        result.append('-');
                                    } else {
                                        result.append('+');
                                    }
                                    zoneHour = dst / HOUR;
                                    zoneMinute = dst / HOUR * 60 - dst / MINUTE;
                                    if (zoneHour < 0) {
                                        zoneHour = -zoneHour;
                                    }
                                    if (zoneMinute < 0) {
                                        zoneMinute = -zoneMinute;
                                    }
                                    result.append(FormatDateTime.format(zoneHour, 2));
                                    result.append(':');
                                    result.append(FormatDateTime.format(zoneMinute, 2));
                                    break;
                                }
                                case 'n': {
                                    result.append(FormatDateTime.format(nanos, 9));
                                }
                            }
                            continue block439;
                        }
                        case 128: {
                            switch (c) {
                                case 'l': {
                                    switch (leap) {
                                        case 0: {
                                            result.append(" ");
                                            break;
                                        }
                                        case 1: {
                                            result.append("L");
                                        }
                                    }
                                    break;
                                }
                                case 'e': {
                                    switch (era) {
                                        case 0: {
                                            result.append("BC");
                                            break;
                                        }
                                        case 1: {
                                            result.append("AD");
                                        }
                                    }
                                    break;
                                }
                                case 'Y': {
                                    result.append(year);
                                    break;
                                }
                                case 'y': {
                                    result.append(FormatDateTime.format(yy, 2));
                                    break;
                                }
                                case 'c': {
                                    result.append(FormatDateTime.format(cc, 2));
                                    break;
                                }
                                case 'C': {
                                    result.append(ce);
                                    break;
                                }
                                case 'N': {
                                    result.append(millenium);
                                    break;
                                }
                                case 'm': {
                                    switch (month + 1) {
                                        case 1: {
                                            result.append("Jan");
                                            break;
                                        }
                                        case 2: {
                                            result.append("Feb");
                                            break;
                                        }
                                        case 3: {
                                            result.append("Mar");
                                            break;
                                        }
                                        case 4: {
                                            result.append("Apr");
                                            break;
                                        }
                                        case 5: {
                                            result.append("May");
                                            break;
                                        }
                                        case 6: {
                                            result.append("Jun");
                                            break;
                                        }
                                        case 7: {
                                            result.append("Jul");
                                            break;
                                        }
                                        case 8: {
                                            result.append("Aug");
                                            break;
                                        }
                                        case 9: {
                                            result.append("Sep");
                                            break;
                                        }
                                        case 10: {
                                            result.append("Oct");
                                            break;
                                        }
                                        case 11: {
                                            result.append("Nov");
                                            break;
                                        }
                                        case 12: {
                                            result.append("Dec");
                                        }
                                    }
                                    break;
                                }
                                case 'u': {
                                    result.append(FormatDateTime.format(weekOfYear, 2));
                                    break;
                                }
                                case 'W': {
                                    result.append(weekOfMonth);
                                    break;
                                }
                                case 'd': {
                                    result.append(FormatDateTime.format(date, 2));
                                    break;
                                }
                                case 'j': {
                                    result.append(FormatDateTime.format(julian, 3));
                                    break;
                                }
                                case 'w': {
                                    switch (weekday) {
                                        case 1: {
                                            result.append("Sun");
                                            break;
                                        }
                                        case 2: {
                                            result.append("Mon");
                                            break;
                                        }
                                        case 3: {
                                            result.append("Tue");
                                            break;
                                        }
                                        case 4: {
                                            result.append("Wed");
                                            break;
                                        }
                                        case 5: {
                                            result.append("Thu");
                                            break;
                                        }
                                        case 6: {
                                            result.append("Fri");
                                            break;
                                        }
                                        case 7: {
                                            result.append("Sat");
                                        }
                                    }
                                    break;
                                }
                                case 'U': {
                                    result.append(weekInMonth);
                                    break;
                                }
                                case 'A': {
                                    switch (ampm) {
                                        case 0: {
                                            result.append("AM");
                                            break;
                                        }
                                        case 1: {
                                            result.append("PM");
                                        }
                                    }
                                    break;
                                }
                                case 'I': {
                                    if (hour12 == 0) {
                                        result.append("12");
                                        break;
                                    }
                                    result.append(FormatDateTime.format(hour12, 2));
                                    break;
                                }
                                case 'H': {
                                    result.append(FormatDateTime.format(hour24, 2));
                                    break;
                                }
                                case 'M': {
                                    result.append(FormatDateTime.format(minute, 2));
                                    break;
                                }
                                case 'S': {
                                    result.append(FormatDateTime.format(second, 2));
                                    break;
                                }
                                case 's': {
                                    result.append(FormatDateTime.format(millis, 3));
                                    break;
                                }
                                case 'z': {
                                    if (zone < 0) {
                                        result.append('-');
                                    } else {
                                        result.append('+');
                                    }
                                    zoneHour = zone / HOUR;
                                    zoneMinute = zone / HOUR * 60 - zone / MINUTE;
                                    if (zoneHour < 0) {
                                        zoneHour = -zoneHour;
                                    }
                                    if (zoneMinute < 0) {
                                        zoneMinute = -zoneMinute;
                                    }
                                    result.append(FormatDateTime.format(zoneHour, 2));
                                    result.append(':');
                                    result.append(FormatDateTime.format(zoneMinute, 2));
                                    break;
                                }
                                case 'Z': {
                                    if (dst < 0) {
                                        result.append('-');
                                    } else {
                                        result.append('+');
                                    }
                                    zoneHour = dst / HOUR;
                                    zoneMinute = dst / HOUR * 60 - dst / MINUTE;
                                    if (zoneHour < 0) {
                                        zoneHour = -zoneHour;
                                    }
                                    if (zoneMinute < 0) {
                                        zoneMinute = -zoneMinute;
                                    }
                                    result.append(FormatDateTime.format(zoneHour, 2));
                                    result.append(':');
                                    result.append(FormatDateTime.format(zoneMinute, 2));
                                    break;
                                }
                                case 'n': {
                                    result.append(FormatDateTime.format(nanos, 9));
                                }
                            }
                            continue block439;
                        }
                        case 1: {
                            switch (c) {
                                case 'd': {
                                    result.append(FormatDateTime.format(date, 2));
                                    break;
                                }
                                case 'D': {
                                    result.append(FormatDateTime.format(month + 1, 2));
                                    result.append('/');
                                    result.append(FormatDateTime.format(date, 2));
                                    result.append('/');
                                    result.append(FormatDateTime.format(yy, 2));
                                    break;
                                }
                                case 'H': {
                                    result.append(FormatDateTime.format(hour24, 2));
                                    break;
                                }
                                case 'I': {
                                    result.append(FormatDateTime.format(hour12, 2));
                                    break;
                                }
                                case 'j': {
                                    result.append(FormatDateTime.format(julian, 3));
                                    break;
                                }
                                case 'm': {
                                    result.append(FormatDateTime.format(month + 1, 2));
                                    break;
                                }
                                case 'M': {
                                    result.append(FormatDateTime.format(minute, 2));
                                    break;
                                }
                                case 'p': {
                                    switch (ampm) {
                                        case 0: {
                                            result.append("AM");
                                            break;
                                        }
                                        case 1: {
                                            result.append("PM");
                                        }
                                    }
                                    break;
                                }
                                case 'r': {
                                    result.append(FormatDateTime.format(hour12, 2));
                                    result.append(':');
                                    result.append(FormatDateTime.format(minute, 2));
                                    result.append(':');
                                    result.append(FormatDateTime.format(second, 2));
                                    switch (ampm) {
                                        case 0: {
                                            result.append(" AM");
                                            break;
                                        }
                                        case 1: {
                                            result.append(" PM");
                                        }
                                    }
                                    break;
                                }
                                case 'R': {
                                    result.append(FormatDateTime.format(hour24, 2));
                                    result.append(':');
                                    result.append(FormatDateTime.format(minute, 2));
                                    break;
                                }
                                case 'S': {
                                    result.append(FormatDateTime.format(second, 2));
                                    break;
                                }
                                case 'y': {
                                    result.append(FormatDateTime.format(yy, 2));
                                    break;
                                }
                                case 'Y': {
                                    result.append(FormatDateTime.format(year, 4));
                                }
                            }
                            continue block439;
                        }
                        case 2: {
                            switch (c) {
                                case 'C': {
                                    result.append(ce);
                                    break block0;
                                }
                                case 'p': {
                                    switch (ampm) {
                                        case 0: {
                                            result.append("AM");
                                            break block0;
                                        }
                                        case 1: {
                                            result.append("PM");
                                        }
                                    }
                                    break block0;
                                }
                                case 'Y': 
                                case 'y': {
                                    result.append(FormatDateTime.format(year, 4));
                                    break block0;
                                }
                                case 'S': {
                                    ++i;
                                    switch (next) {
                                        case 'h': {
                                            result.append(FormatDateTime.format(millis % 1000 / 10, 2));
                                            break block0;
                                        }
                                        case 'm': {
                                            result.append(FormatDateTime.format(nanos / 1000, 6));
                                            break block0;
                                        }
                                        case 'o': {
                                            result.append(FormatDateTime.format(millis % 1000, 3));
                                            break block0;
                                        }
                                        case 't': {
                                            result.append(FormatDateTime.format(millis % 1000 / 100, 1));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (uppercase) {
            return result.toString().toUpperCase();
        }
        if (lowercase) {
            return result.toString().toLowerCase();
        }
        return result.toString();
    }

    public static final String format(int n, int digits) {
        if (digits <= 0) {
            return "";
        }
        String result = String.valueOf(n);
        if (result.length() == digits) {
            return result;
        }
        if (result.length() > digits) {
            return result.substring(0, digits);
        }
        int deficitDigits = digits - result.length();
        char[] deficit = new char[deficitDigits];
        for (int i = 0; i < deficitDigits; ++i) {
            deficit[i] = 48;
        }
        return new StringBuffer(digits).append(deficit).append(result).toString();
    }

    private static String spell(int value) {
        int thousands;
        int millions;
        StringBuffer result = new StringBuffer();
        if (value < 0) {
            result.append("negative ");
            value = -value;
        }
        if ((millions = value / 1000000 % 1000) != 0) {
            result.append(FormatDateTime.spellThousand(millions)).append(" million, ");
        }
        if ((thousands = value / 1000 % 1000) != 0) {
            result.append(FormatDateTime.spellThousand(thousands)).append(" thousand, ");
        }
        int ones = value % 1000;
        result.append(FormatDateTime.spellThousand(ones));
        String resultString = result.toString().trim();
        if (resultString.length() == 0) {
            return "zero";
        }
        return resultString;
    }

    private static String spellThousand(int value) {
        StringBuffer result = new StringBuffer();
        int hundred = (value %= 1000) % 100;
        switch (value / 100) {
            case 0: {
                break;
            }
            case 1: {
                result.append("one-hundred");
                break;
            }
            case 2: {
                result.append("two-hundred");
                break;
            }
            case 3: {
                result.append("three-hundred");
                break;
            }
            case 4: {
                result.append("four-hundred");
                break;
            }
            case 5: {
                result.append("five-hundred");
                break;
            }
            case 6: {
                result.append("six-hundred");
                break;
            }
            case 7: {
                result.append("seven-hundred");
                break;
            }
            case 8: {
                result.append("eight-hundred");
                break;
            }
            case 9: {
                result.append("nine-hundred");
            }
        }
        if (hundred != 0) {
            result.append('-');
            result.append(FormatDateTime.spellHundred(hundred));
        }
        return result.toString();
    }

    private static String spellHundred(int value) {
        switch (value %= 100) {
            case 0: {
                return "";
            }
            case 1: {
                return "one";
            }
            case 2: {
                return "two";
            }
            case 3: {
                return "three";
            }
            case 4: {
                return "four";
            }
            case 5: {
                return "five";
            }
            case 6: {
                return "six";
            }
            case 7: {
                return "seven";
            }
            case 8: {
                return "eight";
            }
            case 9: {
                return "nine";
            }
            case 10: {
                return "ten";
            }
            case 11: {
                return "eleven";
            }
            case 12: {
                return "twelve";
            }
            case 13: {
                return "thirteen";
            }
            case 14: {
                return "fourteen";
            }
            case 15: {
                return "fifteen";
            }
            case 16: {
                return "sixteen";
            }
            case 17: {
                return "seventeen";
            }
            case 18: {
                return "eighteen";
            }
            case 19: {
                return "nineteen";
            }
            case 20: {
                return "twenty";
            }
        }
        int tens = value % 10;
        switch (value / 10) {
            case 2: {
                if (tens == 0) {
                    return "twenty";
                }
                return "twenty-" + FormatDateTime.spellHundred(tens);
            }
            case 3: {
                if (tens == 0) {
                    return "thirty";
                }
                return "thirty-" + FormatDateTime.spellHundred(tens);
            }
            case 4: {
                if (tens == 0) {
                    return "forty";
                }
                return "forty-" + FormatDateTime.spellHundred(tens);
            }
            case 5: {
                if (tens == 0) {
                    return "fifty";
                }
                return "fifty-" + FormatDateTime.spellHundred(tens);
            }
            case 6: {
                if (tens == 0) {
                    return "sixty";
                }
                return "sixty-" + FormatDateTime.spellHundred(tens);
            }
            case 7: {
                if (tens == 0) {
                    return "seventy";
                }
                return "seventy-" + FormatDateTime.spellHundred(tens);
            }
            case 8: {
                if (tens == 0) {
                    return "eighty";
                }
                return "eighty-" + FormatDateTime.spellHundred(tens);
            }
            case 9: {
                if (tens == 0) {
                    return "ninety";
                }
                return "ninety-" + FormatDateTime.spellHundred(tens);
            }
        }
        return String.valueOf(value);
    }
}

