/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.basicFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;

public abstract class IndexedFile {
    private static final boolean debugMode = false;
    static final int NOTHING = 0;
    static final int READING = 1;
    static final int WRITING = 2;
    static final int REWRITING = 3;
    static final int STARTING = 4;
    static final int DELETING = 5;
    private String dataCharsetName = null;
    protected boolean remote = false;
    protected Socket server = null;
    protected String site;
    protected int port;
    protected DataInputStream in = null;
    protected DataOutputStream out = null;
    protected String filename;
    protected boolean optional;
    protected String assignTo;
    protected int reserve;
    protected Variable fileStatus;
    protected int accessMode;
    protected int blockFrom;
    protected int blockTo;
    protected boolean isRecords;
    protected int recordFrom;
    protected int recordTo;
    protected Variable dependingOn;
    protected int newModes = 0;
    protected int keyCompression = 0;
    protected int dataCompression = 0;
    protected boolean dataEncryption = false;
    protected int idxFormat = 3;
    protected int minimum = -1;
    protected int maximum = -1;
    protected int numberOfKeys = 0;
    protected Variable masterRecord = null;
    protected Variable[] keyArray = null;
    protected int[] keyLength = new int[256];
    protected boolean[] keyDuplicates = null;
    protected int priorErrorCode = 0;
    protected int lastAccessError = 0;
    protected boolean lastWasARead = false;
    protected boolean lastWasAStart = false;
    protected boolean isRewrite = false;
    protected int[] keyOffsets = new int[256];
    protected int fileMarkerKeyOffset = 0;
    protected boolean readOnlyCaching = true;
    protected int[] splitKeyList = null;
    protected int numberOfSplitKeys = 0;
    protected int seqDirection = 1;
    protected int openMode = 0;
    protected boolean locking = false;
    private byte[] tempRecord;
    private long totalTransactions = 0L;
    protected Context context;
    protected boolean readDataResult = false;
    private final char[] smallChar = new char[]{'0', '0'};

    public static void debug(String text) {
        System.out.println("IndexedFile: " + text);
    }

    protected void warning(String method, String text) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.warning("IndexedFile." + method + ": " + text);
        }
    }

    public void setContext(Context context) {
        this.context = context;
    }

    protected final byte[] readBytes(DataInputStream in) {
        try {
            int length = in.readInt();
            byte[] byteArray = new byte[length];
            in.readFully(byteArray);
            return byteArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final boolean writeBytes(DataOutputStream out, byte[] byteArray) {
        if (byteArray == null || out == null) {
            return false;
        }
        try {
            int length = byteArray.length;
            out.writeInt(length);
            out.write(byteArray, 0, length);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected final boolean writeString(DataOutputStream out, String stringData) {
        if (stringData == null || out == null) {
            return false;
        }
        try {
            out.writeInt(stringData.length());
            for (int i = 0; i < stringData.length(); ++i) {
                out.writeChar(stringData.charAt(i));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void deactivateRemote() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        this.in = null;
        this.out = null;
    }

    protected boolean activateRemote() {
        this.deactivateRemote();
        try {
            this.server = new Socket(this.site, this.port);
            this.in = new DataInputStream(new BufferedInputStream(this.server.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.server.getOutputStream()));
        }
        catch (Exception e) {
            this.deactivateRemote();
            return false;
        }
        return true;
    }

    protected void synchronizeKeys() {
        if (this.splitKeyList == null) {
            return;
        }
        for (int i = 0; i < this.numberOfSplitKeys; ++i) {
            ((VariableList)this.keyArray[this.splitKeyList[i]]).fillFromMemory();
        }
    }

    protected Variable getKeyFromBytes(int keyOffset, byte[] tempBytes) {
        return this.keyArray[keyOffset].createKeyFromBytes(tempBytes, this.masterRecord.getAddress());
    }

    protected int findKeyOffset(Variable currentKey) {
        int currentAddress = currentKey.getAddress();
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (currentAddress != this.keyArray[i].getAddress()) continue;
            boolean cisVL = currentKey instanceof VariableList;
            boolean kisVL = this.keyArray[i] instanceof VariableList;
            if (cisVL || kisVL) {
                if (!cisVL || !kisVL || !((VariableList)currentKey).hasSameAddresses((VariableList)this.keyArray[i])) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    protected boolean remote_init() {
        if (!this.activateRemote()) {
            return false;
        }
        try {
            this.out.writeByte(64);
            this.out.writeBoolean(this.optional);
            this.writeString(this.out, this.filename);
            this.out.writeInt(this.reserve);
            this.out.writeInt(this.accessMode);
            this.out.writeInt(this.blockFrom);
            this.out.writeInt(this.blockTo);
            this.out.writeBoolean(this.isRecords);
            this.out.writeInt(this.recordFrom);
            this.out.writeInt(this.recordTo);
            this.out.writeBoolean(this.dependingOn != null);
            this.out.writeInt(this.newModes);
            this.out.writeInt(this.keyCompression);
            this.out.writeInt(this.dataCompression);
            this.out.writeInt(this.idxFormat);
            this.out.writeByte(65);
            this.out.writeInt(this.masterRecord.getAddress());
            this.out.writeInt(this.numberOfKeys);
            for (int i = 0; i < this.numberOfKeys; ++i) {
                this.writeString(this.out, this.keyArray[i].getClassName());
                this.out.writeBoolean(this.keyDuplicates[i]);
                this.out.writeInt(this.keyLength[i]);
                this.writeBytes(this.out, this.keyArray[i].toIdxByteArray());
            }
            this.out.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_resetCache() {
        try {
            this.out.writeByte(86);
            this.out.flush();
            int returnStatus = this.in.readInt();
            boolean booleanStatus = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_flushCache() {
        try {
            this.out.writeByte(85);
            this.out.flush();
            int returnStatus = this.in.readInt();
            boolean booleanStatus = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_open(int mode) {
        try {
            this.fileMarkerKeyOffset = 0;
            this.out.writeByte(66);
            this.out.writeInt(mode);
            this.out.flush();
            int returnStatus = this.in.readInt();
            boolean booleanStatus = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_close(int mode) {
        try {
            this.out.writeByte(67);
            this.out.writeInt(mode);
            this.out.flush();
            int returnStatus = this.in.readInt();
            boolean booleanStatus = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_start(int mode, Variable currentKey) {
        int keyOffset = 0;
        try {
            keyOffset = this.findKeyOffset(currentKey);
            if (keyOffset >= 0 && this.keyArray[keyOffset] != currentKey) {
                keyOffset = -2 - keyOffset;
            }
            this.out.writeByte(68);
            this.out.writeInt(mode);
            this.out.writeInt(keyOffset);
            this.writeBytes(this.out, currentKey.toByteArray());
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.fileMarkerKeyOffset = this.in.readInt();
            boolean returnBoolean = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return returnBoolean;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static final int min(int x, int y) {
        if (x < y) {
            return x;
        }
        return y;
    }

    protected int readData(Variable keyIs, int keyOffset, byte[] bytes, int mode, double timeout) {
        boolean isOpen = this.isOpen();
        boolean isSeq = this.isSequential();
        if (!isOpen && this.isOptional()) {
            this.lastAccessError = 1;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            if (isSeq && this.seqDirection >= 0) {
                int returnCode = -10;
                this.setIOStatus(-10);
                this.readDataResult = true;
                return 0;
            }
            int returnCode = -23;
            this.setIOStatus(-23);
            this.readDataResult = this.isInvalidKey(returnCode);
            this.warning("readData", "invalid key, random record missing");
            return 0;
        }
        if (!isOpen || !this.isReadable()) {
            this.lastAccessError = 1;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            this.warning("readData", "operation on file not open for input");
            int returnCode = -47;
            this.setIOStatus(-47);
            this.readDataResult = true;
            return 0;
        }
        if (isSeq && this.lastAccessError == 1) {
            this.lastWasARead = false;
            this.lastWasAStart = false;
            int returnCode = -46;
            this.setIOStatus(-46);
            this.readDataResult = this.isInvalidKey(returnCode);
            this.warning("readData", "can't read, prior error file status ignored");
            return 0;
        }
        int returnCode = 0;
        this.setIOStatus(0);
        this.lastAccessError = 1;
        this.lastWasARead = false;
        keyOffset = this.findKeyOffset(keyIs);
        if (keyOffset < 0) {
            this.lastWasAStart = false;
            this.fileMarkerKeyOffset = -1;
            returnCode = -23;
            this.setIOStatus(-23);
            this.readDataResult = this.isInvalidKey(returnCode);
            this.warning("readData", "invalid key, random record missing");
            return 0;
        }
        return this.idx_readData(keyIs, keyOffset, bytes, mode, timeout);
    }

    protected boolean remote_read(Variable intoVar, Variable keyIs, int mode, double timeout) {
        try {
            this.out.writeByte(69);
            this.out.writeInt(mode);
            this.out.writeDouble(timeout);
            int keyOffset = this.findKeyOffset(keyIs);
            this.out.writeInt(keyOffset);
            this.writeBytes(this.out, keyIs.toByteArray());
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.fileMarkerKeyOffset = this.in.readInt();
            byte[] data = this.readBytes(this.in);
            boolean booleanStatus = data[0] != 0;
            int length = data.length - 1;
            if (length > 0) {
                intoVar.writeBytesToMemory(data, 1, length);
                if (this.dependingOn != null) {
                    this.dependingOn.move(length);
                }
            }
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_readNext(Variable intoVar, int mode, double timeout) {
        try {
            this.out.writeByte(70);
            this.out.writeInt(mode);
            this.out.writeDouble(timeout);
            this.out.writeInt(this.fileMarkerKeyOffset);
            int useKey = this.fileMarkerKeyOffset;
            if (useKey < 0) {
                useKey = 0;
            }
            this.writeBytes(this.out, this.keyArray[useKey].toByteArray());
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.fileMarkerKeyOffset = this.in.readInt();
            byte[] data = this.readBytes(this.in);
            boolean booleanStatus = data[0] != 0;
            int length = data.length - 1;
            if (length > 0) {
                intoVar.writeBytesToMemory(data, 1, length);
                if (this.dependingOn != null) {
                    this.dependingOn.move(length);
                }
            }
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_readPrevious(Variable intoVar, int mode, double timeout) {
        try {
            this.out.writeByte(91);
            this.out.writeInt(mode);
            this.out.writeDouble(timeout);
            this.out.writeInt(this.fileMarkerKeyOffset);
            int useKey = this.fileMarkerKeyOffset;
            if (useKey < 0) {
                useKey = 0;
            }
            this.writeBytes(this.out, this.keyArray[useKey].toByteArray());
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.fileMarkerKeyOffset = this.in.readInt();
            byte[] data = this.readBytes(this.in);
            boolean booleanStatus = data[0] != 0;
            int length = data.length - 1;
            if (length > 0) {
                intoVar.writeBytesToMemory(data, 1, length);
                if (this.dependingOn != null) {
                    this.dependingOn.move(length);
                }
            }
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_write(Variable fromVar, int mode, double timeout) {
        try {
            this.out.writeByte(71);
            this.out.writeInt(mode);
            this.out.writeDouble(timeout);
            this.out.writeBoolean(false);
            if (this.dependingOn != null) {
                this.out.writeInt(this.dependingOn.toInt());
            } else {
                this.out.writeInt(-1);
            }
            this.writeBytes(this.out, fromVar.toByteArray());
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.fileMarkerKeyOffset = this.in.readInt();
            boolean booleanStatus = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_writeNext(Variable fromVar) {
        try {
            this.out.writeByte(72);
            this.out.writeBoolean(true);
            if (this.dependingOn != null) {
                this.out.writeInt(this.dependingOn.toInt());
            } else {
                this.out.writeInt(-1);
            }
            this.writeBytes(this.out, fromVar.toByteArray());
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.fileMarkerKeyOffset = this.in.readInt();
            boolean booleanStatus = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_rewrite(Variable fromVar, int mode, double timeout) {
        try {
            this.out.writeByte(73);
            this.out.writeInt(mode);
            this.out.writeDouble(timeout);
            if (this.dependingOn != null) {
                this.out.writeInt(this.dependingOn.toInt());
            } else {
                this.out.writeInt(-1);
            }
            this.writeBytes(this.out, fromVar.toByteArray());
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.fileMarkerKeyOffset = this.in.readInt();
            boolean booleanStatus = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean remote_delete(int mode, double timeout) {
        try {
            this.out.writeByte(74);
            this.out.writeInt(mode);
            this.out.writeDouble(timeout);
            this.writeBytes(this.out, this.masterRecord.toByteArray());
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.fileMarkerKeyOffset = this.in.readInt();
            boolean booleanStatus = this.in.readBoolean();
            this.setIOStatus(returnStatus);
            return booleanStatus;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void remote_unlock() {
        try {
            this.out.writeByte(87);
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.setIOStatus(returnStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void remote_exclusive() {
        try {
            this.out.writeByte(88);
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.setIOStatus(returnStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void remote_exclusiveConditionally() {
        try {
            this.out.writeByte(89);
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.setIOStatus(returnStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void remote_unexclusive() {
        try {
            this.out.writeByte(90);
            this.out.flush();
            int returnStatus = this.in.readInt();
            this.setIOStatus(returnStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTotalNumberOfTransactions(long val) {
        this.totalTransactions = val;
    }

    public long getTotalNumberOfTransactions() {
        return this.totalTransactions;
    }

    public int getFileMarkerKeyOffset() {
        return this.fileMarkerKeyOffset;
    }

    boolean init(boolean remote2, String site, int port, String filename, int numberOfKeys, Variable[] keyArray, boolean[] keyDuplicates, boolean optional, int reserve, Variable fileStatus, int accessMode, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        return this.init(remote2, site, port, filename, numberOfKeys, keyArray, keyDuplicates, optional, reserve, fileStatus, accessMode, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, 0, 0, 0, 0);
    }

    boolean init(boolean remote2, String site, int port, String filename, int numberOfKeys, Variable[] keyArray, boolean[] keyDuplicates, boolean optional, int reserve, Variable fileStatus, int accessMode, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        return this.init(remote2, site, port, filename, numberOfKeys, keyArray, keyDuplicates, optional, reserve, fileStatus, accessMode, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, newModes, 0, 0, 0);
    }

    boolean init(boolean remote2, String site, int port, String filename, int numberOfKeys, Variable[] keyArray, boolean[] keyDuplicates, boolean optional, int reserve, Variable fileStatus, int accessMode, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes, int keyCompression, int dataCompression, int idxFormat) {
        return this.init(remote2, site, port, filename, numberOfKeys, keyArray, keyDuplicates, optional, reserve, fileStatus, accessMode, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, newModes, keyCompression, dataCompression, idxFormat, false);
    }

    public boolean init(boolean remote2, String site, int port, String filename, int numberOfKeys, Variable[] keyArray, boolean[] keyDuplicates, boolean optional, int reserve, Variable fileStatus, int accessMode, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes, int keyCompression, int dataCompression, int idxFormat, boolean dataEncryption) {
        if (keyArray == null) {
            return false;
        }
        this.remote = remote2;
        this.site = site;
        this.port = port;
        this.filename = filename;
        this.numberOfKeys = numberOfKeys;
        this.keyArray = keyArray;
        this.keyDuplicates = keyDuplicates;
        this.optional = optional;
        this.reserve = reserve;
        this.fileStatus = fileStatus;
        this.accessMode = accessMode;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.isRecords = isRecords;
        this.recordFrom = recordFrom;
        this.recordTo = recordTo;
        this.dependingOn = dependingOn;
        this.newModes = newModes;
        this.keyCompression = keyCompression;
        this.dataCompression = dataCompression;
        this.dataEncryption = dataEncryption;
        this.idxFormat = idxFormat;
        this.minimum = recordFrom;
        this.maximum = recordTo;
        if (this.maximum < 0) {
            this.maximum = -1;
        }
        if (this.minimum < 0) {
            this.minimum = -1;
        }
        if (this.minimum < 0 && this.maximum >= 0) {
            this.minimum = this.maximum;
        }
        if (this.maximum < 0 && this.minimum >= 0) {
            this.maximum = this.minimum;
        }
        if (this.minimum > this.maximum) {
            this.maximum = this.minimum;
        }
        if (this.blockFrom < 0) {
            this.blockFrom = -1;
        }
        if (this.blockTo < 0) {
            this.blockTo = -1;
        }
        if (this.blockFrom > this.blockTo) {
            this.blockTo = this.blockFrom;
        }
        if (this.blockFrom < 0 && this.blockTo >= 0) {
            this.blockFrom = this.blockTo;
        }
        this.splitKeyList = new int[255];
        this.numberOfSplitKeys = 0;
        for (int i = 0; i < numberOfKeys; ++i) {
            if (!(keyArray[i] instanceof VariableList)) continue;
            this.splitKeyList[this.numberOfSplitKeys++] = i;
        }
        this.synchronizeKeys();
        this.masterRecord = keyArray[0];
        if (this.masterRecord == null) {
            return false;
        }
        if (this.masterRecord instanceof VariableList) {
            this.masterRecord = ((VariableList)this.masterRecord).getList()[0];
        }
        while (this.masterRecord.getParent() != null) {
            this.masterRecord = this.masterRecord.getParent();
        }
        int masterAddress = this.masterRecord.getAddress();
        for (int i = 0; i < numberOfKeys; ++i) {
            if (keyArray[i] != null) {
                this.keyLength[i] = keyArray[i].length();
            }
            this.keyOffsets[i] = keyArray[i] instanceof VariableList ? 0 : keyArray[i].getAddress() - masterAddress;
        }
        this.tempRecord = new byte[this.maximum];
        boolean flag = this.idx_init();
        if (!flag) {
            return false;
        }
        if (remote2) {
            flag = this.remote_init();
        }
        return flag;
    }

    void resetKeyInfo() {
        this.numberOfSplitKeys = 0;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (!(this.keyArray[i] instanceof VariableList)) continue;
            this.splitKeyList[this.numberOfSplitKeys++] = i;
        }
        this.synchronizeKeys();
        int masterAddress = this.masterRecord.getAddress();
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (this.keyArray[i] != null) {
                this.keyLength[i] = this.keyArray[i].length();
            }
            this.keyOffsets[i] = this.keyArray[i] instanceof VariableList ? 0 : this.keyArray[i].getAddress() - masterAddress;
        }
    }

    boolean setFilename(String filename) {
        this.filename = filename;
        return this.idx_setFilename(filename);
    }

    boolean resetCache() {
        if (this.remote) {
            return this.remote_resetCache();
        }
        return this.idx_resetCache();
    }

    boolean flushCache() {
        if (this.remote) {
            return this.remote_flushCache();
        }
        return this.idx_flushCache();
    }

    boolean open(int mode) {
        this.synchronizeKeys();
        if (this.remote) {
            boolean success = this.remote_open(mode);
            if (success) {
                ++this.totalTransactions;
            }
            return success;
        }
        this.setOpenMode(mode);
        this.lastAccessError = 0;
        this.lastWasARead = false;
        this.lastWasAStart = false;
        if (this.isOpen()) {
            this.setIOStatus(-41);
            this.warning("open", "operation not valid, file already open");
            return false;
        }
        if ((mode & 4) != 0 && !this.isSequential()) {
            this.setIOStatus(-37);
            this.warning("open", "open extend on non-sequential not supported");
            return false;
        }
        if (this.optional) {
            mode |= 8;
        }
        this.readOnlyCaching = true;
        String cacheMode = RuntimeEnvironment.getGlobalParameter("IDXCACHEMODE");
        if (cacheMode != null && ((cacheMode = cacheMode.trim()).equalsIgnoreCase("READWRITE") || cacheMode.equalsIgnoreCase("RW"))) {
            this.readOnlyCaching = false;
        }
        if (this.readOnlyCaching && (mode & 0x8000) != 0) {
            this.readOnlyCaching = false;
            if (!this.readOnlyCaching && cacheMode != null && (cacheMode.equalsIgnoreCase("READONLY") || cacheMode.equalsIgnoreCase("RO"))) {
                this.readOnlyCaching = true;
            }
        }
        this.setIOStatus(0);
        boolean success = this.idx_open(mode);
        if (success) {
            ++this.totalTransactions;
        }
        return success;
    }

    boolean close(int mode) {
        this.synchronizeKeys();
        if (this.remote) {
            return this.remote_close(mode);
        }
        this.lastAccessError = 0;
        this.lastWasARead = false;
        this.lastWasAStart = false;
        if (!this.isOpen()) {
            this.setIOStatus(-42);
            this.warning("close", "already closed");
            return false;
        }
        this.flushCache();
        this.setIOStatus(0);
        return this.idx_close(mode);
    }

    boolean start(int mode) {
        return this.start(mode, this.keyArray[0]);
    }

    boolean start(int mode, int keyOffset, byte[] data) {
        if (keyOffset >= 0) {
            this.keyArray[keyOffset].writeBytesToMemory(data, 0, data.length);
        } else if (keyOffset < -1) {
            int effectiveKey = -2 - keyOffset;
            Variable nonKey = new Variable(data, this.keyArray[effectiveKey].getMemory(), this.keyArray[effectiveKey].getAddress());
            return this.start(mode, nonKey);
        }
        return this.start(mode, keyOffset);
    }

    boolean start(int mode, int keyOffset) {
        if (keyOffset < 0) {
            this.lastAccessError = 4;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            this.fileMarkerKeyOffset = -1;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("start", "invalid key, random record missing");
            return this.isInvalidKey(returnCode);
        }
        return this.start(mode, this.keyArray[keyOffset]);
    }

    boolean start(int mode, Variable currentKey) {
        this.synchronizeKeys();
        if (this.remote) {
            return this.remote_start(mode, currentKey);
        }
        this.lastAccessError = 4;
        this.lastWasARead = false;
        this.lastWasAStart = false;
        if (!this.isOpen() && this.isOptional()) {
            this.fileMarkerKeyOffset = -1;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("start", "invalid key, random record missing");
            return this.isInvalidKey(returnCode);
        }
        if (!this.isOpen() || !this.isReadable()) {
            this.fileMarkerKeyOffset = -1;
            int returnCode = -47;
            this.setIOStatus(-47);
            this.warning("start", "operation invalid, file not open for input");
            return this.isInvalidKey(returnCode);
        }
        this.setIOStatus(0);
        return this.idx_start(mode, currentKey);
    }

    byte[] read(boolean seqOverride, int keyOffset, byte[] keyData, int mode, double timeout, int direction) {
        int tempAccessMode = this.accessMode;
        if (this.isRandom()) {
            seqOverride = false;
        }
        if (this.isSequential()) {
            seqOverride = true;
        }
        if (seqOverride) {
            if (this.fileMarkerKeyOffset < 0) {
                this.lastAccessError = 1;
                this.lastWasARead = false;
                this.lastWasAStart = false;
                int returnCode = -23;
                this.setIOStatus(-23);
                this.warning("read", "invalid key, random record missing");
                boolean booleanStatus = this.isInvalidKey(returnCode);
                byte[] newData = new byte[]{(byte)(booleanStatus ? 1 : 0)};
                return newData;
            }
            this.accessMode = 1;
        }
        this.seqDirection = direction;
        if (keyOffset < 0) {
            this.fileMarkerKeyOffset = -1;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("start", "invalid key, random record missing");
            boolean booleanStatus = this.isInvalidKey(returnCode);
            byte[] newData = new byte[]{(byte)(booleanStatus ? 1 : 0)};
            return newData;
        }
        this.keyArray[keyOffset].writeBytesToMemory(keyData, 0, IndexedFile.min(keyData.length, this.keyArray[keyOffset].length()));
        int len = this.readData(this.keyArray[keyOffset], keyOffset, this.tempRecord, mode, timeout);
        byte[] newData = new byte[len + 1];
        if (len > 0) {
            System.arraycopy(this.tempRecord, 0, newData, 1, len);
        }
        newData[0] = (byte)(this.readDataResult ? 1 : 0);
        if (seqOverride) {
            this.accessMode = tempAccessMode;
        }
        if (newData.length > 1) {
            for (int i = 0; i < this.numberOfKeys; ++i) {
                try {
                    this.keyArray[i].writeBytesToMemory(newData, this.keyArray[i].getAddress() + 1, this.keyArray[i].length());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return newData;
    }

    boolean read(Variable intoVar, Variable keyIs, int mode, double timeout) {
        this.synchronizeKeys();
        if (this.remote) {
            boolean invalidKey = this.remote_read(intoVar, keyIs, mode, timeout);
            if (!invalidKey) {
                ++this.totalTransactions;
            }
            return invalidKey;
        }
        int keyOffset = this.findKeyOffset(keyIs);
        int length = this.readData(keyIs, keyOffset, this.tempRecord, mode, timeout);
        if (length > 0) {
            intoVar.writeBytesToMemory(this.tempRecord, 0, length);
        }
        if (!this.readDataResult) {
            ++this.totalTransactions;
        }
        return this.readDataResult;
    }

    boolean read(Variable intoVar, int mode, double timeout) {
        if (this.isSequential()) {
            return this.readNext(intoVar, mode, timeout);
        }
        return this.read(intoVar, this.keyArray[0], mode, timeout);
    }

    boolean readFirst(Variable intoVar, int mode, double timeout) {
        if (this.fileMarkerKeyOffset < 0) {
            this.lastAccessError = 1;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("readFirst", "invalid key, random record missing");
            return this.isInvalidKey(returnCode);
        }
        Variable currentKey = this.keyArray[this.fileMarkerKeyOffset];
        Variable saveKey = (Variable)currentKey.copy();
        currentKey.move(new Variable().low_values());
        boolean result = this.start(-1, this.fileMarkerKeyOffset);
        if (!this.isOK() && this.getPriorError() != -23) {
            this.warning("readFirst", "invalid key, random record missing");
            return result;
        }
        currentKey.move(saveKey);
        return this.readNext(intoVar, mode, timeout);
    }

    boolean readLast(Variable intoVar, int mode, double timeout) {
        if (this.fileMarkerKeyOffset < 0) {
            this.lastAccessError = 1;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("readLast", "invalid key, random record missing");
            return this.isInvalidKey(returnCode);
        }
        Variable currentKey = this.keyArray[this.fileMarkerKeyOffset];
        Variable saveKey = (Variable)currentKey.copy();
        currentKey.move((byte)4);
        boolean result = this.start(1, this.fileMarkerKeyOffset);
        if (!this.isOK() && this.getPriorError() != -23) {
            this.warning("readLast", "invalid key, random record missing");
            return result;
        }
        currentKey.move(saveKey);
        return this.readPrevious(intoVar, mode, timeout);
    }

    boolean readNext(Variable intoVar, int mode, double timeout) {
        this.synchronizeKeys();
        if (this.isRandom()) {
            return this.read(intoVar, mode, timeout);
        }
        if (this.remote) {
            boolean invalidKey = this.remote_readNext(intoVar, mode, timeout);
            if (!invalidKey) {
                ++this.totalTransactions;
            }
            return invalidKey;
        }
        int tempAccessMode = this.accessMode;
        if (this.fileMarkerKeyOffset < 0) {
            this.lastAccessError = 1;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("readNext", "invalid key, random record missing");
            return this.isInvalidKey(returnCode);
        }
        this.accessMode = 1;
        this.seqDirection = 1;
        boolean booleanReturnCode = this.read(intoVar, this.keyArray[this.fileMarkerKeyOffset], mode, timeout);
        this.accessMode = tempAccessMode;
        return booleanReturnCode;
    }

    boolean readPrevious(Variable intoVar, int mode, double timeout) {
        this.synchronizeKeys();
        if (this.isRandom()) {
            return this.read(intoVar, mode, timeout);
        }
        if (this.remote) {
            boolean invalidKey = this.remote_readPrevious(intoVar, mode, timeout);
            if (!invalidKey) {
                ++this.totalTransactions;
            }
            return invalidKey;
        }
        int tempAccessMode = this.accessMode;
        if (this.fileMarkerKeyOffset < 0) {
            this.lastAccessError = 1;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("readPrefious", "invalid key, random record missing");
            return this.isInvalidKey(returnCode);
        }
        this.accessMode = 1;
        this.seqDirection = -1;
        boolean booleanReturnCode = this.read(intoVar, this.keyArray[this.fileMarkerKeyOffset], mode, timeout);
        this.accessMode = tempAccessMode;
        return booleanReturnCode;
    }

    boolean write(boolean seqOverride, int dependingOnLength, byte[] data, int mode, double timeout) {
        if (this.isRandom()) {
            seqOverride = false;
        }
        int tempAccessMode = this.accessMode;
        if (seqOverride) {
            this.accessMode = 1;
        }
        if (this.dependingOn != null) {
            this.dependingOn.move(dependingOnLength);
        }
        this.masterRecord = new Variable(data);
        for (int i = 0; i < this.numberOfKeys; ++i) {
            this.keyArray[i].writeBytesToMemory(data, this.keyArray[i].getAddress(), this.keyArray[i].length());
        }
        boolean booleanStatus = this.write(this.masterRecord, mode, timeout);
        if (seqOverride) {
            this.accessMode = tempAccessMode;
        }
        return booleanStatus;
    }

    boolean write(Variable fromVar, int mode, double timeout) {
        this.synchronizeKeys();
        fromVar.flushToMemory();
        if (this.remote) {
            boolean invalidKey = this.remote_write(fromVar, mode, timeout);
            if (!invalidKey) {
                ++this.totalTransactions;
            }
            return invalidKey;
        }
        this.setIOStatus(0);
        this.lastAccessError = 2;
        this.lastWasARead = false;
        this.lastWasAStart = false;
        if (!this.isOpen() || !this.isWritable()) {
            int returnCode = -48;
            this.setIOStatus(-48);
            this.warning("write", "invalid operation, file not open for output");
            return this.isInvalidKey(returnCode);
        }
        boolean invalidKey = this.idx_write(fromVar, mode, timeout);
        if (!invalidKey) {
            ++this.totalTransactions;
        }
        return invalidKey;
    }

    boolean writeNext(Variable fromVar) {
        this.synchronizeKeys();
        if (this.remote) {
            boolean invalidKey = this.remote_writeNext(fromVar);
            if (!invalidKey) {
                ++this.totalTransactions;
            }
            return invalidKey;
        }
        int tempAccessMode = this.accessMode;
        if (this.isRandom()) {
            return this.write(fromVar, 0, 0.0);
        }
        this.accessMode = 1;
        boolean returnCode = this.write(fromVar, 0, 0.0);
        this.accessMode = tempAccessMode;
        return returnCode;
    }

    boolean rewrite(int dependingOnLength, byte[] data, int mode, double timeout) {
        if (this.dependingOn != null) {
            this.dependingOn.move(dependingOnLength);
        }
        this.masterRecord = new Variable(data);
        for (int i = 0; i < this.numberOfKeys; ++i) {
            this.keyArray[i].writeBytesToMemory(data, this.keyArray[i].getAddress(), this.keyArray[i].length());
        }
        return this.rewrite(this.masterRecord, mode, timeout);
    }

    boolean rewrite(Variable fromVar, int mode, double timeout) {
        int length;
        this.synchronizeKeys();
        fromVar.flushToMemory();
        if (this.remote) {
            boolean invalidKey = this.remote_rewrite(fromVar, mode, timeout);
            if (!invalidKey) {
                ++this.totalTransactions;
            }
            return invalidKey;
        }
        this.setIOStatus(0);
        if (!this.isOpen() || !this.isIO()) {
            this.lastAccessError = 3;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            int returnCode = -49;
            this.setIOStatus(-49);
            this.warning("rewrite", "invalid operation, file not open for I-O");
            return this.isInvalidKey(returnCode);
        }
        if (this.isSequential()) {
            if (this.lastAccessError == 1 || !this.lastWasARead) {
                this.lastAccessError = 3;
                this.lastWasARead = false;
                this.lastWasAStart = false;
                this.warning("rewrite", "invalid operation, rewrite not after read");
                int returnCode = -43;
                this.setIOStatus(-43);
                return this.isInvalidKey(returnCode);
            }
            if (this.fileMarkerKeyOffset < 0) {
                this.lastAccessError = 3;
                this.lastWasARead = false;
                this.lastWasAStart = false;
                this.warning("rewrite", "invalid key, random record missing");
                int returnCode = -23;
                this.setIOStatus(-23);
                return this.isInvalidKey(returnCode);
            }
        }
        if ((length = fromVar.length()) > this.maximum || length <= 0) {
            this.lastAccessError = 3;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            this.warning("rewrite", "data record length out of bounds (between 0 and maximum " + this.maximum + ")");
            int returnCode = -44;
            this.setIOStatus(-44);
            return this.isInvalidKey(returnCode);
        }
        this.lastAccessError = 3;
        boolean invalidKey = this.idx_rewrite(fromVar, mode, timeout);
        if (!invalidKey) {
            ++this.totalTransactions;
        }
        return invalidKey;
    }

    boolean delete(byte[] keyData, int mode, double timeout, boolean generic) {
        this.masterRecord = new Variable(keyData);
        for (int i = 0; i < this.numberOfKeys; ++i) {
            this.keyArray[i].writeBytesToMemory(keyData, this.keyArray[i].getAddress(), this.keyArray[i].length());
        }
        return this.delete(mode, timeout);
    }

    boolean delete(int mode, double timeout) {
        this.synchronizeKeys();
        if (this.remote) {
            boolean invalidKey = this.remote_delete(mode, timeout);
            if (!invalidKey) {
                ++this.totalTransactions;
            }
            return invalidKey;
        }
        this.setIOStatus(0);
        if (!this.isOpen() || !this.isIO()) {
            this.lastAccessError = 5;
            this.lastWasARead = false;
            this.lastWasAStart = false;
            int returnCode = -49;
            this.setIOStatus(-49);
            this.warning("delete", "invalid operation, file not open for I-O");
            return this.isInvalidKey(returnCode);
        }
        if (this.isSequential()) {
            if (this.lastAccessError == 1 || !this.lastWasARead) {
                this.lastAccessError = 5;
                this.lastWasARead = false;
                this.lastWasAStart = false;
                int returnCode = -43;
                this.setIOStatus(-43);
                this.warning("delete", "invalid operation, delete not after read");
                return this.isInvalidKey(returnCode);
            }
            if (this.fileMarkerKeyOffset < 0) {
                this.lastAccessError = 5;
                this.lastWasARead = false;
                this.lastWasAStart = false;
                int returnCode = -23;
                this.setIOStatus(-23);
                this.warning("delete", "invalid key, random record missing");
                return this.isInvalidKey(returnCode);
            }
        }
        this.lastAccessError = 5;
        this.lastWasARead = false;
        this.lastWasAStart = false;
        boolean invalidKey = this.idx_delete(mode, timeout);
        if (!invalidKey) {
            ++this.totalTransactions;
        }
        return invalidKey;
    }

    void unlock() {
        if (this.remote) {
            this.remote_unlock();
            return;
        }
        this.idx_unlock();
    }

    void exclusive() {
        if (this.remote) {
            this.remote_exclusive();
            return;
        }
        this.idx_exclusive();
    }

    void exclusiveConditionally() {
        if (this.remote) {
            this.remote_exclusiveConditionally();
            return;
        }
        this.idx_exclusiveConditionally();
    }

    void unexclusive() {
        if (this.remote) {
            this.remote_unexclusive();
            return;
        }
        this.idx_unexclusive();
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean begin() {
        return false;
    }

    public boolean commit() {
        return false;
    }

    public boolean rollback() {
        return false;
    }

    public boolean recover() {
        return false;
    }

    final int getSize() {
        return this.maximum;
    }

    final boolean isAtEnd(int returnCode) {
        return returnCode == -10;
    }

    final boolean isInvalidKey(int returnCode) {
        if (this.isSequential() && this.lastAccessError == 1) {
            return this.isAtEnd(returnCode);
        }
        if (returnCode < 0) {
            returnCode = -returnCode;
        }
        return returnCode >= 20 && returnCode <= 29;
    }

    final boolean isOptional() {
        return this.optional;
    }

    final boolean isRandom() {
        return this.accessMode == 2;
    }

    final boolean isDynamic() {
        return this.accessMode == 4;
    }

    final boolean isSequential() {
        return this.accessMode == 1;
    }

    boolean isFixed() {
        return this.minimum == this.maximum;
    }

    boolean isVariable() {
        return this.minimum != this.maximum;
    }

    final boolean ignoreAtEnd() {
        return this.isRandom();
    }

    final boolean isOK() {
        return this.getPriorError() > -10;
    }

    final int getPriorError() {
        if (this.priorErrorCode > 0) {
            return -this.priorErrorCode;
        }
        return this.priorErrorCode;
    }

    final void setPriorError(int priorError) {
        this.priorErrorCode = priorError;
    }

    final int setIOStatus(int status) {
        if ((status = (status = this.idx_mapStatusCode(status)) < 0 ? -status : 0) == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            if (status == 0) {
                this.fileStatus.moveZeroes();
            } else if (status < 10) {
                this.smallChar[1] = (char)(status + 48);
                this.fileStatus.move(this.smallChar);
            } else {
                this.fileStatus.move(status);
            }
        }
        return status;
    }

    final int setIOStatus(String x) {
        int status = 0;
        try {
            status = Integer.decode(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.setIOStatus(-status);
    }

    public void init() {
        if (this.remote) {
            try {
                this.out.writeByte(75);
                this.out.flush();
                int returnStatus = this.in.readInt();
                this.setIOStatus(returnStatus);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        if (this.isOpen()) {
            this.close(0);
        }
    }

    final boolean isOpen() {
        return this.idx_isOpen();
    }

    final boolean isInput() {
        if (this.remote) {
            try {
                this.out.writeByte(76);
                this.out.flush();
                boolean booleanStatus = this.in.readBoolean();
                return booleanStatus;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.idx_isInput();
    }

    final boolean isOutput() {
        if (this.remote) {
            try {
                this.out.writeByte(77);
                this.out.flush();
                boolean booleanStatus = this.in.readBoolean();
                return booleanStatus;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.idx_isOutput();
    }

    final boolean isIO() {
        if (this.remote) {
            try {
                this.out.writeByte(78);
                this.out.flush();
                boolean booleanStatus = this.in.readBoolean();
                return booleanStatus;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.idx_isIO();
    }

    final boolean isExtend() {
        if (this.remote) {
            try {
                this.out.writeByte(79);
                this.out.flush();
                boolean booleanStatus = this.in.readBoolean();
                return booleanStatus;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.idx_isExtend();
    }

    final boolean isWritable() {
        if (this.remote) {
            try {
                this.out.writeByte(80);
                this.out.flush();
                boolean booleanStatus = this.in.readBoolean();
                return booleanStatus;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.idx_isWritable();
    }

    final boolean isReadable() {
        return this.idx_isReadable();
    }

    final boolean isNewFile() {
        return this.idx_isNewFile();
    }

    boolean deleteFile() {
        return this.idx_deleteFile();
    }

    void setOpenMode(int openMode) {
        this.openMode = openMode;
        this.locking = basicFile.locking(openMode);
    }

    int getOpenMode() {
        return this.openMode;
    }

    protected boolean locking() {
        return this.locking;
    }

    protected boolean lockingAutomatic() {
        return basicFile.lockingAutomatic(this.openMode);
    }

    protected boolean lockingManual() {
        return basicFile.lockingManual(this.openMode);
    }

    protected boolean lockingMultiple() {
        return basicFile.lockingMultiple(this.openMode);
    }

    protected boolean lockingSingle() {
        return basicFile.lockingSingle(this.openMode);
    }

    public final void setCharsetName(String charsetName) {
        this.dataCharsetName = charsetName;
    }

    public final String getCharsetName() {
        return this.dataCharsetName;
    }

    abstract boolean idx_init();

    abstract boolean idx_setFilename(String var1);

    abstract boolean idx_resetCache();

    abstract boolean idx_flushCache();

    abstract boolean idx_open(int var1);

    abstract boolean idx_close(int var1);

    abstract boolean idx_start(int var1, Variable var2);

    abstract int idx_readData(Variable var1, int var2, byte[] var3, int var4, double var5);

    abstract boolean idx_write(Variable var1, int var2, double var3);

    abstract boolean idx_rewrite(Variable var1, int var2, double var3);

    abstract boolean idx_delete(int var1, double var2);

    abstract void idx_unlock();

    abstract void idx_exclusive();

    abstract void idx_exclusiveConditionally();

    abstract void idx_unexclusive();

    abstract boolean idx_isOpen();

    abstract boolean idx_isInput();

    abstract boolean idx_isOutput();

    abstract boolean idx_isIO();

    abstract boolean idx_isExtend();

    abstract boolean idx_isWritable();

    abstract boolean idx_isReadable();

    abstract boolean idx_isNewFile();

    abstract boolean idx_deleteFile();

    abstract int idx_mapStatusCode(int var1);
}

