/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.Cache;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.FormatDateTime;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.XOpenInternational;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.SimpleTimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Intrinsic {
    public static final double LOGE10 = Math.log(10.0);
    public static final Numeric ZERO = new Numeric();
    public static Variable WHEN_COMPILED = null;
    static final double double_one = 1.0;
    private static String ef_status = "00";
    private static String ef_filename = null;
    private static final String JCS_DATE_PARAMETER = "jcsjobdate";
    private static final Numeric[] factorial_storage = new Numeric[]{new Numeric(1), new Numeric(1), new Numeric(2), new Numeric(6), new Numeric(24), new Numeric(120), new Numeric(720), new Numeric(5040), new Numeric(40320), new Numeric(362880), new Numeric(3628800)};
    private static final Calendar cobolEpoch = new GregorianCalendar(1600, 11, 31);
    private static Random random = new Random(0L);
    private Vector<Numeric> buildVector = new Vector();
    private Vector<Variable> buildVectorAlphanum = new Vector();
    private int items = 0;
    public static final Numeric PI = new Numeric("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
    public static final Comp2 E = new Comp2(Math.E);
    private static boolean strict_as400_add_duration = true;
    public static final int YEARS = 1;
    public static final int MONTHS = 2;
    public static final int DAYS = 5;
    public static final int HOURS = 11;
    public static final int MINUTES = 12;
    public static final int SECONDS = 13;
    public static final int MICROSECONDS = 9998;
    public static final int SHORT = 3;
    public static final int MEDIUM = 2;
    public static final int LONG = 1;
    public static final int FULL = 0;
    public static int DEFAULT_LOCALE_STYLE = 3;
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int TIMESTAMP = 3;

    public static Variable urlEncode(Variable data) {
        try {
            return new Variable(URLEncoder.encode(data.toString(), "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            return data;
        }
    }

    private static char hexValueOf(char d1, char d2) {
        int value = 0;
        if (d1 >= '0' && d1 <= '9') {
            value = d1 - 48;
        } else if (d1 >= 'a' && d1 <= 'f') {
            value = d1 - 97 + 10;
        } else if (d1 >= 'A' && d1 <= 'F') {
            value = d1 - 65 + 10;
        }
        value *= 16;
        if (d2 >= '0' && d2 <= '9') {
            value |= d2 - 48;
        } else if (d2 >= 'a' && d2 <= 'f') {
            value |= d2 - 97 + 10;
        } else if (d2 >= 'A' && d2 <= 'F') {
            value |= d2 - 65 + 10;
        }
        return (char)value;
    }

    public static Variable urlDecode(Variable data) {
        String value = data.toString();
        StringBuffer result = new StringBuffer(value.length());
        int l = value.length();
        char c = ' ';
        char c1 = ' ';
        char c2 = ' ';
        for (int i = 0; i < l; ++i) {
            c = value.charAt(i);
            if (c == '+') {
                result.append(' ');
                continue;
            }
            if (c != '%') {
                result.append(c);
                continue;
            }
            if (++i >= l) continue;
            c1 = value.charAt(i);
            if (c1 == '%') {
                result.append('%');
                continue;
            }
            if (++i >= l) continue;
            c2 = value.charAt(i);
            result.append(Intrinsic.hexValueOf(c1, c2));
        }
        return new Variable(result.toString());
    }

    public static final Comp2 acos(Numeric arg1) {
        return new Comp2(Math.acos(arg1.toDouble()));
    }

    public static final Comp2 annuity(Numeric arg1, Numeric arg2) {
        if (arg1.compare(ZERO) == 0) {
            return new Comp2(1.0 / arg2.toDouble());
        }
        return new Comp2(arg1.toDouble() / (1.0 - Math.pow(1.0 + arg1.toDouble(), -arg2.toDouble())));
    }

    public static final Comp2 asin(Numeric arg1) {
        return new Comp2(Math.asin(arg1.toDouble()));
    }

    public static final Comp2 atan(Numeric arg1) {
        return new Comp2(Math.atan(arg1.toDouble()));
    }

    public static final Comp2 atan2(Numeric arg1, Numeric arg2) {
        return new Comp2(Math.atan2(arg1.toDouble(), arg2.toDouble()));
    }

    public static final Variable character(Numeric arg1) {
        char x;
        String collatingSequence = XOpenInternational.collatingSequence;
        if (collatingSequence == null) {
            byte[] chars = new byte[]{(byte)(arg1.toInt() - 1)};
            return new Variable(chars);
        }
        char newx = x = (char)(arg1.toInt() - 1);
        if (x >= '\u0000' && x < collatingSequence.length()) {
            newx = collatingSequence.charAt(x);
        }
        byte[] chars = new byte[]{(byte)newx};
        return new Variable(chars);
    }

    public static final Variable characterNational(Numeric arg1) {
        char x = (char)(arg1.toInt() - 1);
        byte[] chars = new byte[]{(byte)(x >> 8 & 0xFF), (byte)(x & 0xFF)};
        Variable result = new Variable(chars);
        result.setInternational();
        return result;
    }

    public static final Variable displayOf(Variable arg1, Variable arg2) {
        return new Variable(arg1).setInternational(false);
    }

    public static final Variable displayOf(Variable arg1) {
        return new Variable(arg1).setInternational(false);
    }

    public static final Variable nationalOf(Variable arg1, Variable arg2) {
        String string2 = arg1.toString();
        if ((string2.length() & 1) == 1) {
            string2 = string2 + " ";
        }
        return new Variable(string2).setInternational();
    }

    public static final Variable nationalOf(Variable arg1) {
        String string2 = arg1.toString();
        if ((string2.length() & 1) == 1) {
            string2 = string2 + " ";
        }
        return new Variable(string2).setInternational();
    }

    public static final Numeric booleanOf(Numeric arg1, Numeric arg2) {
        return new Numeric();
    }

    public static final Variable exceptionFile() {
        char[] result = new char[134];
        try {
            result[0] = ef_status.charAt(0);
            result[1] = ef_status.charAt(1);
            if (ef_filename == null) {
                ef_filename = "";
            }
            for (int i = 2; i < 134; ++i) {
                result[i] = 32;
            }
            ef_filename.getChars(0, ef_filename.length(), result, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Variable(result);
    }

    public static final void setExceptionFile(int iostatus, String filename) {
        if (iostatus < 0) {
            iostatus = -iostatus;
        }
        ef_status = iostatus < 10 ? "0" + iostatus : String.valueOf(iostatus);
        ef_filename = filename;
    }

    public static final Variable exceptionLocation() {
        char[] result = new char[127];
        for (int i = 0; i < 127; ++i) {
            result[i] = 32;
        }
        return new Variable(result);
    }

    public static final Variable exceptionStatement() {
        char[] result = new char[31];
        for (int i = 0; i < 31; ++i) {
            result[i] = 32;
        }
        return new Variable(result);
    }

    public static final Variable exceptionStatus() {
        char[] result = new char[31];
        for (int i = 0; i < 31; ++i) {
            result[i] = 32;
        }
        return new Variable(result);
    }

    public static final Comp2 cos(Numeric arg1) {
        return new Comp2(Math.cos(arg1.toDouble()));
    }

    public static final Variable current_date() {
        StringBuffer result = new StringBuffer(24);
        Calendar today = Intrinsic.getCurrentCalendar();
        boolean plus = false;
        int tz = -1 * (today.get(15) / 1000 / 60 + today.get(16) / 1000 / 60);
        if (tz < 0) {
            plus = true;
            tz = -tz;
        }
        int tzHour = tz / 60;
        int tzMin = tz % 60;
        if (tzHour == 0) {
            plus = true;
        }
        result.append(Utilities.format(today.get(1), 4)).append(Utilities.format(today.get(2) + 1, 2)).append(Utilities.format(today.get(5), 2)).append(Utilities.format(today.get(11), 2)).append(Utilities.format(today.get(12), 2)).append(Utilities.format(today.get(13), 2)).append(Utilities.format(today.get(14) / 10, 2));
        if (plus) {
            result.append("+");
        } else {
            result.append("-");
        }
        result.append(Utilities.format(tzHour, 2)).append(Utilities.format(tzMin, 2));
        Variable resultVar = new Variable("000000000000000000000");
        resultVar.setString(result.toString());
        return resultVar;
    }

    private static Calendar getCurrentCalendar() {
        Calendar today = Calendar.getInstance();
        if (RuntimeEnvironment.getGlobalParameter(JCS_DATE_PARAMETER) != null) {
            try {
                String receivedDate = RuntimeEnvironment.getGlobalParameter(JCS_DATE_PARAMETER);
                DateTimeFormatter pattern = DateTimeFormatter.ofPattern("dd/MM/yyyy");
                LocalDate localDate = LocalDate.parse(receivedDate, pattern);
                today.clear();
                today.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth());
            }
            catch (Exception e) {
                today = Calendar.getInstance();
            }
        }
        return today;
    }

    public static final Numeric date_of_integer(Variable arg1) {
        long days = arg1.toLong();
        GregorianCalendar calcDate = new GregorianCalendar(1600, 11, 31);
        calcDate.add(5, (int)days);
        return new Numeric(Utilities.format(calcDate.get(1), 4) + Utilities.format(calcDate.get(2) + 1, 2) + Utilities.format(calcDate.get(5), 2));
    }

    public static final Numeric day_of_integer(Variable arg1) {
        long days = arg1.toLong();
        GregorianCalendar calcDate = new GregorianCalendar(1600, 11, 31);
        calcDate.add(5, (int)days);
        return new Numeric(Utilities.format(calcDate.get(1), 4) + Utilities.format(calcDate.get(6), 3));
    }

    public static final Numeric factorial(Numeric arg1) {
        long n = arg1.toLong();
        if (n < 0L) {
            return new Numeric(1);
        }
        if (n < 11L) {
            return factorial_storage[(int)n];
        }
        long result = 39916800L;
        while (n > 11L) {
            result *= n;
            --n;
        }
        return new Numeric(result);
    }

    public static final Comp1 integer(Comp1 arg1) {
        return new Comp1(Math.floor(arg1.toFloat()));
    }

    public static final Comp2 integer(Comp2 arg1) {
        return new Comp2(Math.floor(arg1.toDouble()));
    }

    public static final Binary integer(Binary arg1) {
        return arg1;
    }

    public static final Numeric integer(Numeric arg1) {
        return new Numeric(arg1).floor();
    }

    public static final Numeric integer_of_date(Variable arg1) {
        String iod = arg1.toNumericString();
        if (iod.length() < 8) {
            iod = "00000000" + iod;
        }
        if (iod.length() > 8) {
            iod = iod.substring(iod.length() - 8);
        }
        long result = 0L;
        try {
            int y = Integer.parseInt(iod.substring(0, 4));
            int m = Integer.parseInt(iod.substring(4, 6));
            int d = Integer.parseInt(iod.substring(6, 8));
            GregorianCalendar laterDate = new GregorianCalendar(y, m - 1, d);
            long duration = laterDate.getTime().getTime() - cobolEpoch.getTime().getTime();
            long ONE_HOUR = 3600000L;
            result = (duration + ONE_HOUR) / (24L * ONE_HOUR);
            return new Numeric(result);
        }
        catch (Exception e) {
            return new Numeric();
        }
    }

    public static final Numeric integer_of_day(Variable arg1) {
        String iod = arg1.toNumericString();
        if (iod.length() < 7) {
            iod = "0000000" + iod;
        }
        if (iod.length() > 7) {
            iod = iod.substring(iod.length() - 7);
        }
        try {
            int y = Integer.parseInt(iod.substring(0, 4));
            int d = Integer.parseInt(iod.substring(4, 7));
            return new Numeric((y -= 1601) * 365 + y / 4 - y / 100 + y / 400 + d);
        }
        catch (Exception e) {
            return new Numeric();
        }
    }

    public static final Comp1 integer_part(Comp1 arg1) {
        float test = arg1.toFloat();
        if (test >= 0.0f) {
            return new Comp1(Math.floor(test));
        }
        return new Comp1(Math.ceil(test));
    }

    public static final Comp2 integer_part(Comp2 arg1) {
        double test = arg1.toDouble();
        if (test >= 0.0) {
            return new Comp2(Math.floor(test));
        }
        return new Comp2(Math.ceil(test));
    }

    public static final Binary integer_part(Binary arg1) {
        return arg1;
    }

    public static final Numeric integer_part(Numeric arg1) {
        if (arg1.value.isPositive()) {
            return new Numeric(arg1).floor();
        }
        return new Numeric(arg1).ceil();
    }

    public static final Numeric lengthForLengthOfSyntax(Variable arg1) {
        if (arg1.isInternational()) {
            return new Numeric(arg1.lengthForLengthOfSyntax() / 2);
        }
        return new Numeric(arg1.lengthForLengthOfSyntax());
    }

    public static final Numeric length(Variable arg1) {
        if (arg1.isInternational()) {
            return new Numeric(arg1.length() / 2);
        }
        return new Numeric(arg1.length());
    }

    public static final Numeric lengthAlphanumericForLengthOfSyntax(Variable arg1) {
        return new Numeric(arg1.lengthForLengthOfSyntax());
    }

    public static final Numeric lengthAlphanumeric(Variable arg1) {
        return new Numeric(arg1.length());
    }

    public static final Numeric leng(Variable arg1) {
        if (arg1.isInternational()) {
            return new Numeric(arg1.length() / 2);
        }
        return new Numeric(arg1.length());
    }

    public static final Numeric stored_char_length(Variable arg1) {
        int length;
        String string2 = arg1.toString();
        for (length = string2.length(); length > 0 && string2.charAt(length - 1) == ' '; --length) {
        }
        return new Numeric(length);
    }

    public static final Variable format(Variable arg1) {
        String format = arg1.getFormat();
        return format != null ? new Variable(format) : new Variable(" ");
    }

    public static final Numeric addr(Variable arg1) {
        return new Numeric(arg1.getAddress());
    }

    public static final Comp2 log(Numeric arg1) {
        return new Comp2(Math.log(arg1.toDouble()));
    }

    public static final Comp2 log10(Numeric arg1) {
        return new Comp2(Math.log(arg1.toDouble()) / LOGE10);
    }

    public static final Variable lower_case(Variable arg1) {
        String result = arg1.toString();
        String uppercase = XOpenInternational.uppercase;
        String lowercase = XOpenInternational.lowercase;
        if (uppercase == null || lowercase == null || uppercase.length() != lowercase.length()) {
            return new Variable(result.toLowerCase());
        }
        StringBuffer resultBuffer = new StringBuffer(result);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            int x = uppercase.indexOf(c);
            if (x < 0) continue;
            resultBuffer.setCharAt(i, lowercase.charAt(x));
        }
        return new Variable(resultBuffer.toString());
    }

    public static final Numeric mod(Numeric arg1, Numeric arg2) {
        if (arg2.compare(Numeric.ZERO) == 0) {
            return Numeric.ZERO;
        }
        return Numeric.subGiving(arg1, Numeric.mulGiving(arg2, Intrinsic.integer(Numeric.divGiving(arg1, arg2))));
    }

    public static final Numeric rem(Numeric arg1, Numeric arg2) {
        if (arg2.isZero()) {
            return new Numeric();
        }
        return Numeric.subGiving(arg1, Numeric.mulGiving(arg2, Intrinsic.integer_part(Numeric.divGiving(arg1, arg2))));
    }

    public static final Numeric ord(Variable arg1) {
        char param = arg1.toChar();
        String collatingSequence = XOpenInternational.collatingSequence;
        if (collatingSequence == null) {
            return new Numeric(param + '\u0001');
        }
        int x = collatingSequence.indexOf(param);
        if (x >= 0) {
            return new Numeric(param + '\u0001');
        }
        return new Numeric(param + '\u0001');
    }

    public static final Comp2 random() {
        return new Comp2(random.nextDouble());
    }

    public static final Comp2 random(Numeric arg1) {
        random = new Random(Double.doubleToLongBits(arg1.toDouble()));
        return Intrinsic.random();
    }

    public static final Variable reverse(Variable arg1) {
        StringBuffer stringToReverse = new StringBuffer(arg1.toString()).reverse();
        return new Variable(stringToReverse.toString());
    }

    public static final Comp2 sin(Numeric arg1) {
        return new Comp2(Math.sin(arg1.toDouble()));
    }

    public static final Comp2 sqrt(Numeric arg1) {
        return new Comp2(Math.sqrt(arg1.toDouble()));
    }

    public static final Comp2 tan(Numeric arg1) {
        return new Comp2(Math.tan(arg1.toDouble()));
    }

    public static final Variable upper_case(Variable arg1) {
        String result = arg1.toString();
        String uppercase = XOpenInternational.uppercase;
        String lowercase = XOpenInternational.lowercase;
        if (uppercase == null || lowercase == null || uppercase.length() != lowercase.length()) {
            return new Variable(result.toUpperCase());
        }
        StringBuffer resultBuffer = new StringBuffer(result);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            int x = lowercase.indexOf(c);
            if (x < 0) continue;
            resultBuffer.setCharAt(i, uppercase.charAt(x));
        }
        return new Variable(resultBuffer.toString());
    }

    public static final void set_when_compiled(String arg) {
        WHEN_COMPILED = new Variable(arg.substring(0, 21));
    }

    public static final Variable when_compiled() {
        if (WHEN_COMPILED != null) {
            return WHEN_COMPILED;
        }
        WHEN_COMPILED = new Variable("                     ");
        WHEN_COMPILED.setString("199704010000000000000");
        return WHEN_COMPILED;
    }

    public static final Intrinsic start(Numeric arg1) {
        Intrinsic startVector = new Intrinsic();
        return startVector.param(arg1);
    }

    public static final Intrinsic start() {
        Intrinsic startVector = new Intrinsic();
        return startVector;
    }

    private final int[][] totalElements(Variable arg1) {
        int dimensions = 0;
        int[][] indices = new int[2][];
        Variable examine = arg1;
        while (examine != null) {
            if (examine.maxIndex > 1 && examine.isArray()) {
                ++dimensions;
            }
            examine = examine.parent;
        }
        indices[0] = new int[dimensions];
        indices[1] = new int[dimensions];
        dimensions = indices[0].length - 1;
        examine = arg1;
        while (examine != null) {
            if (examine.maxIndex > 1 && examine.isArray()) {
                indices[0][dimensions] = examine.minIndex;
                indices[1][dimensions--] = examine.maxIndex;
            }
            examine = examine.parent;
        }
        return indices;
    }

    private final int[] startIndex(int[][] minsmaxes) {
        int[] indices = new int[minsmaxes[0].length];
        for (int n = 0; n < indices.length; ++n) {
            indices[n] = minsmaxes[0][n];
        }
        return indices;
    }

    private final boolean nextIndex(int[] counters, int[][] minsmaxes) {
        int n;
        for (n = counters.length - 1; n >= 0; --n) {
            int n2 = n;
            counters[n2] = counters[n2] + 1;
            if (counters[n2] <= minsmaxes[1][n]) break;
            counters[n] = minsmaxes[0][n];
        }
        return n >= 0;
    }

    public final Intrinsic param(Numeric arg1) {
        int[][] indices = this.totalElements(arg1);
        if (Cache.forbid && arg1.arrayChild != null) {
            Variable.cleanArray(arg1.arrayChild, true);
        }
        if (indices[0].length == 0 || (arg1.flagBits & 0x40000) != 0) {
            this.buildVector.addElement(arg1);
        } else {
            int[] counters = this.startIndex(indices);
            do {
                this.buildVector.addElement(arg1.numericSubscript(counters));
            } while (this.nextIndex(counters, indices));
        }
        return this;
    }

    public final Intrinsic param(Numeric arg1, int[] subs) {
        int l;
        int[][] indices = this.totalElements(arg1);
        if (Cache.forbid && arg1.arrayChild != null) {
            Variable.cleanArray(arg1.arrayChild, true);
        }
        if (indices[0].length < (l = subs.length)) {
            l = indices[0].length;
        }
        for (int i = 0; i < l; ++i) {
            if (subs[i] == 0) continue;
            indices[0][i] = subs[i];
            indices[1][i] = subs[i];
        }
        int[] counters = this.startIndex(indices);
        do {
            this.buildVector.addElement(arg1.numericSubscript(counters));
        } while (this.nextIndex(counters, indices));
        return this;
    }

    public final Intrinsic param(int arg1) {
        this.buildVector.addElement(new Numeric(arg1));
        return this;
    }

    public final Intrinsic param(String arg1) {
        this.buildVectorAlphanum.addElement(new Variable(arg1));
        return this;
    }

    public final Intrinsic param(Variable arg1) {
        int[][] indices = this.totalElements(arg1);
        int[] counters = this.startIndex(indices);
        if (indices[0].length > 0) {
            do {
                if (arg1 instanceof Numeric) {
                    this.buildVector.addElement(arg1.numericSubscript(counters));
                    continue;
                }
                this.buildVectorAlphanum.addElement(arg1.subscript(counters));
            } while (this.nextIndex(counters, indices));
        } else {
            this.buildVectorAlphanum.addElement(arg1);
        }
        return this;
    }

    public final Intrinsic param(Variable arg1, int[] subs) {
        int l;
        int[][] indices = this.totalElements(arg1);
        if (indices[0].length < (l = subs.length)) {
            l = indices[0].length;
        }
        for (int i = 0; i < l; ++i) {
            if (subs[i] == 0) continue;
            indices[0][i] = subs[i];
            indices[1][i] = subs[i];
        }
        int[] counters = this.startIndex(indices);
        do {
            if (arg1 instanceof Numeric) {
                this.buildVector.addElement(arg1.numericSubscript(counters));
                continue;
            }
            this.buildVectorAlphanum.addElement(arg1.numericSubscript(counters));
        } while (this.nextIndex(counters, indices));
        return this;
    }

    public final Numeric sum() {
        this.items = this.buildVector.size();
        Numeric result = new Numeric();
        for (int i = 0; i < this.items; ++i) {
            Numeric element = this.buildVector.elementAt(i);
            result.add(element);
        }
        return result;
    }

    public final Numeric mean() {
        Numeric sumResult = this.sum();
        return Numeric.divGiving(sumResult, new Numeric(this.buildVector.size()));
    }

    public final Comp2 standard_deviation() {
        if (this.buildVector.size() <= 1) {
            return new Comp2(0.0f);
        }
        Numeric meanResult = this.mean();
        Numeric total = new Numeric();
        for (int i = 0; i < this.buildVector.size(); ++i) {
            Numeric portion = Numeric.subGiving(this.buildVector.elementAt(i), meanResult);
            portion = Numeric.mulGiving(portion, portion);
            total = Numeric.addGiving(total, portion);
        }
        total = Numeric.divGiving(total, new Numeric(this.buildVector.size()));
        return new Comp2(Math.sqrt(total.toDouble()));
    }

    public final Numeric variance() {
        if (this.buildVector.size() <= 1) {
            return new Numeric();
        }
        Numeric meanResult = this.mean();
        Numeric total = new Numeric();
        for (int i = 0; i < this.buildVector.size(); ++i) {
            Numeric portion = Numeric.subGiving(this.buildVector.elementAt(i), meanResult);
            portion = Numeric.mulGiving(portion, portion);
            total = Numeric.addGiving(total, portion);
        }
        total = Numeric.divGiving(total, new Numeric(this.buildVector.size()));
        return total;
    }

    private final Numeric elementAt(int n) {
        return this.buildVector.elementAt(n);
    }

    private final Variable elementAtAlphanum(int n) {
        return this.buildVectorAlphanum.elementAt(n);
    }

    public final Numeric ord_min() {
        this.items = this.buildVector.size();
        if (this.items <= 0) {
            this.items = this.buildVectorAlphanum.size();
            if (this.items < 0) {
                return new Numeric();
            }
            int min = 0;
            Variable minVariable = this.elementAtAlphanum(0);
            for (int i = 1; i < this.items; ++i) {
                if (this.elementAtAlphanum(i).compare(minVariable) >= 0) continue;
                min = i;
                minVariable = this.elementAtAlphanum(i);
            }
            return new Numeric(min + 1);
        }
        int min = 0;
        Numeric minNumeric = this.elementAt(0);
        for (int i = 1; i < this.items; ++i) {
            if (this.elementAt(i).compare(minNumeric) >= 0) continue;
            min = i;
            minNumeric = this.elementAt(i);
        }
        return new Numeric(min + 1);
    }

    public final Numeric ord_max() {
        this.items = this.buildVector.size();
        if (this.items <= 0) {
            this.items = this.buildVectorAlphanum.size();
            if (this.items <= 0) {
                return new Numeric();
            }
            int max = 0;
            Variable maxVariable = this.elementAtAlphanum(0);
            for (int i = 1; i < this.items; ++i) {
                if (this.elementAtAlphanum(i).compare(maxVariable) <= 0) continue;
                max = i;
                maxVariable = this.elementAtAlphanum(i);
            }
            return new Numeric(max + 1);
        }
        int max = 0;
        Numeric maxNumeric = this.elementAt(0);
        for (int i = 1; i < this.items; ++i) {
            if (this.elementAt(i).compare(maxNumeric) <= 0) continue;
            max = i;
            maxNumeric = this.elementAt(i);
        }
        return new Numeric(max + 1);
    }

    public final Variable min() {
        this.items = this.buildVector.size();
        if (this.items <= 0) {
            this.items = this.buildVectorAlphanum.size();
            if (this.items <= 0) {
                return new Numeric();
            }
            Variable minVariable = this.elementAtAlphanum(0);
            for (int i = 1; i < this.items; ++i) {
                if (this.elementAtAlphanum(i).compare(minVariable) >= 0) continue;
                minVariable = this.elementAtAlphanum(i);
            }
            return minVariable;
        }
        Numeric minNumeric = this.elementAt(0);
        for (int i = 1; i < this.items; ++i) {
            if (this.elementAt(i).compare(minNumeric) >= 0) continue;
            minNumeric = this.elementAt(i);
        }
        return minNumeric;
    }

    public final Variable max() {
        this.items = this.buildVector.size();
        if (this.items <= 0) {
            this.items = this.buildVectorAlphanum.size();
            if (this.items <= 0) {
                return new Numeric();
            }
            Variable maxVariable = this.elementAtAlphanum(0);
            for (int i = 1; i < this.items; ++i) {
                if (this.elementAtAlphanum(i).compare(maxVariable) <= 0) continue;
                maxVariable = this.elementAtAlphanum(i);
            }
            return maxVariable;
        }
        Numeric maxNumeric = this.elementAt(0);
        for (int i = 1; i < this.items; ++i) {
            if (this.elementAt(i).compare(maxNumeric) <= 0) continue;
            maxNumeric = this.elementAt(i);
        }
        return maxNumeric;
    }

    public final Numeric nummax() {
        return (Numeric)this.max();
    }

    public final Numeric nummin() {
        return (Numeric)this.min();
    }

    public final Numeric midrange() {
        return Numeric.divGiving(Numeric.addGiving(this.nummin(), this.nummax()), new Numeric(2));
    }

    public final Numeric range() {
        return Numeric.subGiving(this.nummax(), this.nummin());
    }

    public final Numeric median() {
        this.items = this.buildVector.size();
        if (this.items <= 0) {
            return new Numeric();
        }
        Numeric[] a = new Numeric[this.items];
        for (int i = 0; i < this.items; ++i) {
            a[i] = this.elementAt(i);
        }
        this.quicksort(a, 0, this.items - 1);
        if ((this.items & 1) == 1) {
            Numeric result = a[this.items / 2];
            a = null;
            return result;
        }
        int pos = this.items / 2;
        Numeric result = Numeric.divGiving(Numeric.addGiving(a[pos], a[pos - 1]), new Numeric(2));
        a = null;
        return result;
    }

    private final void quicksort(Numeric[] a, int l, int r) {
        if (r > l) {
            Numeric temp;
            Numeric v = a[r];
            int i = l - 1;
            int j = r;
            while (true) {
                if (i < r && a[++i].compare(v) < 0) {
                    continue;
                }
                while (j > 0 && a[--j].compare(v) > 0) {
                }
                if (i >= j) break;
                temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
            temp = a[i];
            a[i] = a[r];
            a[r] = temp;
            this.quicksort(a, l, i - 1);
            this.quicksort(a, i + 1, r);
        }
    }

    public static final Numeric numval(Variable arg1) {
        String args1 = arg1.toNumericString();
        int i = (args1 = args1.trim()).indexOf("CR");
        if (i >= 0) {
            args1 = "-" + args1.substring(0, i);
        } else {
            i = args1.indexOf("DB");
            if (i >= 0) {
                args1 = "-" + args1.substring(0, i);
            } else {
                i = args1.indexOf("+");
                if (i > 0) {
                    args1 = args1.substring(0, i);
                } else {
                    i = args1.indexOf("-");
                    if (i > 0) {
                        args1 = "-" + args1.substring(0, i);
                    }
                }
            }
        }
        return new Numeric(args1);
    }

    public static final Numeric test_numval(Variable arg1) {
        char decSym = Memory.getGlobalDecimal();
        char comSym = Memory.getGlobalComma();
        String comRep = "\\" + comSym;
        String argS = arg1.toString().replaceAll(comRep, "");
        Pattern numval1 = Pattern.compile("^(\\s*)?(\\+|-)?(\\s*)?[0-9]{0,18}(\\" + decSym + "[0-9]{0,18})?(\\s*)?$", 2);
        Pattern numval2 = Pattern.compile("^(\\s*)?[0-9]{0,18}(\\" + decSym + "[0-9]{0,18})?(\\s*)?(\\+|-|CR|DB)?(\\s*)$", 2);
        return new Numeric(Intrinsic.numval_format(arg1, argS, numval1, numval2));
    }

    public static final Numeric test_numval_c(Variable arg1) {
        return new Numeric(Intrinsic.test_numval_c(arg1, new Variable(Character.valueOf(Memory.getGlobalCurrency()))));
    }

    public static final Numeric test_numval_c(Variable arg1, Variable arg2) {
        String curSym = arg2.toString().trim();
        char decSym = Memory.getGlobalDecimal();
        char comSym = Memory.getGlobalComma();
        String comRep = "\\" + comSym;
        String argS = arg1.toString().replaceAll(comRep, "");
        Pattern curChk = Pattern.compile("[0-9\\+-\\.,]");
        Matcher curMat = curChk.matcher(curSym);
        if (curMat.find()) {
            return new Numeric(-1);
        }
        Pattern numval1 = Pattern.compile("^(\\s*)?(\\+|-)?(\\s*)?(\\" + curSym + ")?(\\s*)?[0-9]{0,18}(\\" + decSym + "[0-9]{0,18})?(\\s*)?$", 2);
        Pattern numval2 = Pattern.compile("^(\\s*)?(\\" + curSym + ")?(\\s*)?[0-9]{0,18}(\\" + decSym + "[0-9]{0,18})?(\\s*)?(\\+|-|CR|DB)?(\\s*)$", 2);
        return new Numeric(Intrinsic.numval_format(arg1, argS, numval1, numval2));
    }

    public static Numeric numval_format(Variable arg1, String argS, Pattern numval1, Pattern numval2) {
        if (argS.trim().isEmpty()) {
            return new Numeric(arg1.length() + 1);
        }
        char decSym = Memory.getGlobalDecimal();
        char curSym = Memory.getGlobalCurrency();
        Matcher match1 = numval1.matcher(argS);
        Matcher match2 = numval2.matcher(argS);
        if (match1.find() || match2.find()) {
            return new Numeric(0);
        }
        Pattern numval3 = Pattern.compile("^[\\d\\s]+$", 2);
        Matcher match3 = numval3.matcher(argS);
        if (match3.find()) {
            int s = argS.indexOf(32);
            while (argS.charAt(s) == ' ') {
                ++s;
            }
            return new Numeric(++s);
        }
        Pattern firstCh = Pattern.compile("[^0-9|\\s|\\" + decSym + "|\\" + curSym + "|\\+|-|CR|DB]", 2);
        Matcher match4 = firstCh.matcher(argS);
        if (match4.find()) {
            return new Numeric(argS.charAt(match4.start()));
        }
        return new Numeric(arg1.length() + 1);
    }

    public static final Numeric numval_c(Variable arg1) {
        try {
            String args1 = arg1.toNumericString().trim();
            int i = args1.indexOf("CR");
            if (i >= 0) {
                args1 = "-" + args1.substring(0, i);
            } else {
                i = args1.indexOf("DB");
                if (i >= 0) {
                    args1 = "-" + args1.substring(0, i);
                } else {
                    i = args1.indexOf("+");
                    if (i > 0) {
                        args1 = args1.substring(0, i);
                    } else {
                        i = args1.indexOf("-");
                        if (i > 0) {
                            args1 = "-" + args1.substring(0, i);
                        }
                    }
                }
            }
            return new Numeric(args1);
        }
        catch (Exception t) {
            return new Numeric();
        }
    }

    public static final Numeric numval_c(Variable arg1, Variable arg2) {
        try {
            String args1 = arg1.toNumericString().trim();
            int i = args1.indexOf("CR");
            if (i >= 0) {
                args1 = "-" + args1.substring(0, i);
            } else {
                i = args1.indexOf("DB");
                if (i >= 0) {
                    args1 = "-" + args1.substring(0, i);
                } else {
                    i = args1.indexOf("+");
                    if (i > 0) {
                        args1 = args1.substring(0, i);
                    } else {
                        i = args1.indexOf("-");
                        if (i > 0) {
                            args1 = "-" + args1.substring(0, i);
                        }
                    }
                }
            }
            return new Numeric(args1);
        }
        catch (Exception t) {
            return new Numeric();
        }
    }

    public final Comp2 present_value() {
        this.items = this.buildVector.size();
        double arg1 = this.elementAt(0).toDouble();
        double total = 0.0;
        if (arg1 < -1.0) {
            return new Comp2(0.0f);
        }
        for (int i = 1; i < this.items; ++i) {
            total += this.elementAt(i).toDouble() / Math.pow(1.0 + arg1, i);
        }
        return new Comp2(total);
    }

    public static final Variable soundex(Variable arg1) {
        StringBuffer result = new StringBuffer("    ");
        try {
            String setOriginal = arg1.toString();
            String original = setOriginal.toUpperCase();
            result.setCharAt(0, original.charAt(0));
            int dest = 1;
            int source = 1;
            char sourceChar = ' ';
            while (dest < 4 && source < original.length()) {
                sourceChar = original.charAt(source);
                switch (sourceChar) {
                    case 'B': 
                    case 'F': 
                    case 'P': 
                    case 'V': {
                        result.setCharAt(dest, '1');
                        ++dest;
                        break;
                    }
                    case 'C': 
                    case 'G': 
                    case 'J': 
                    case 'K': 
                    case 'Q': 
                    case 'S': 
                    case 'X': 
                    case 'Z': {
                        result.setCharAt(dest, '2');
                        ++dest;
                        break;
                    }
                    case 'D': 
                    case 'T': {
                        result.setCharAt(dest, '3');
                        ++dest;
                        break;
                    }
                    case 'L': {
                        result.setCharAt(dest, '4');
                        ++dest;
                        break;
                    }
                    case 'M': 
                    case 'N': {
                        result.setCharAt(dest, '5');
                        ++dest;
                        break;
                    }
                    case 'R': {
                        result.setCharAt(dest, '6');
                        ++dest;
                    }
                }
                while (sourceChar == original.charAt(source)) {
                    ++source;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Variable(result.toString());
    }

    public static final Numeric pi() {
        return PI;
    }

    public static final Comp2 e() {
        return E;
    }

    public static final Comp2 exp(Numeric arg1) {
        return new Comp2(Math.exp(arg1.toDouble()));
    }

    public static final Comp2 exp10(Numeric arg1) {
        return new Comp2(Math.pow(10.0, arg1.toDouble()));
    }

    public static final Numeric sign(Numeric arg1) {
        int result = arg1.compare(ZERO);
        if (result < 0) {
            return new Numeric(-1);
        }
        if (result > 0) {
            return new Numeric(1);
        }
        return new Numeric();
    }

    public static final Numeric abs(Numeric arg1) {
        int result = arg1.compare(ZERO);
        if (result >= 0) {
            return new Numeric(arg1);
        }
        return new Numeric().sub(arg1);
    }

    public static final Numeric allocated_occurances(Variable arg1) {
        return new Numeric(arg1.occurs());
    }

    public static final Variable character_national(Numeric arg1) {
        char x = (char)(arg1.toInt() - 1);
        byte[] chars = new byte[]{(byte)x};
        return new Variable(chars);
    }

    public static final Numeric year_to_yyyy(Numeric arg1) {
        return Intrinsic.year_to_yyyy(arg1, new Numeric(50));
    }

    public static final Numeric year_to_yyyy(Numeric arg1, Numeric arg2) {
        int arg2Int;
        int maxYear;
        int maxYearLowOrder;
        Calendar today = Calendar.getInstance();
        int year = today.get(1);
        int arg1Int = arg1.toInt();
        int lowOrder = arg1Int % 100;
        if (lowOrder > (maxYearLowOrder = (maxYear = year + (arg2Int = arg2.toInt())) % 100)) {
            return new Numeric((maxYear / 100 - 1) * 100 + lowOrder);
        }
        return new Numeric(maxYear / 100 * 100 + lowOrder);
    }

    public static final Variable standard_compare(Variable arg1, Variable arg2) {
        return Intrinsic.standard_compare(arg1, arg2, new Numeric(3));
    }

    public static final Variable standard_compare(Variable arg1, Variable arg2, Numeric arg3) {
        int result = arg1.compare(arg2);
        if (result < 0) {
            return new Variable("<");
        }
        if (result > 0) {
            return new Variable(">");
        }
        return new Variable("=");
    }

    public static final Comp2 numval_f(Variable arg1) {
        String right;
        String left;
        String arg1s = arg1.toNumericString();
        arg1s = arg1s.trim();
        int i = -1;
        do {
            if ((i = arg1s.indexOf(32, i + 1)) < 0) continue;
            left = null;
            right = null;
            try {
                left = arg1s.substring(0, i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                right = arg1s.substring(i + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            arg1s = left + right;
        } while (i >= 0);
        i = -1;
        do {
            if ((i = arg1s.indexOf(44, i + 1)) < 0) continue;
            left = null;
            right = null;
            try {
                left = arg1s.substring(0, i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                right = arg1s.substring(i + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            arg1s = left + "." + right;
        } while (i >= 0);
        double d = 0.0;
        try {
            d = Double.valueOf(arg1s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Comp2(d);
    }

    public static final Numeric lowest_algebraic(Numeric arg1) {
        return new Numeric(Variable.LOW_VALUES.special(arg1));
    }

    public static final Numeric highest_algebraic(Numeric arg1) {
        return new Numeric(Variable.HIGH_VALUES.special(arg1));
    }

    public static final Numeric lowest_algebraic(Variable arg1) {
        if (!arg1.isTypeNumericEdited()) {
            return new Numeric(Variable.LOW_VALUES.special(arg1));
        }
        try {
            return new Numeric(Variable.LOW_VALUES.special(arg1.surrogate()));
        }
        catch (Exception e) {
            try {
                return new Numeric(Variable.LOW_VALUES.special(arg1.surrogate()));
            }
            catch (Exception e2) {
                return new Numeric();
            }
        }
    }

    public static final Numeric highest_algebraic(Variable arg1) {
        if (!arg1.isTypeNumericEdited()) {
            return new Numeric(Variable.HIGH_VALUES.special(arg1));
        }
        try {
            return new Numeric(Variable.HIGH_VALUES.special(arg1.surrogate()));
        }
        catch (Exception e) {
            try {
                return new Numeric(Variable.HIGH_VALUES.special(arg1.surrogate()));
            }
            catch (Exception e2) {
                return new Numeric();
            }
        }
    }

    public static final Numeric date_to_yyyymmdd(Numeric arg1) {
        return Intrinsic.date_to_yyyymmdd(arg1, new Numeric(50));
    }

    public static final Numeric date_to_yyyymmdd(Numeric arg1, Numeric arg2) {
        String remainder = "000000" + arg1.toInt();
        remainder = remainder.substring(remainder.length() - 6);
        Numeric year = new Numeric(remainder.substring(0, 2));
        remainder = remainder.substring(2);
        Numeric newYearNumeric = Intrinsic.year_to_yyyy(year, arg2);
        String newYearString = Utilities.format(newYearNumeric.toInt(), 4);
        return new Numeric("99999999", newYearString + remainder);
    }

    public static final Numeric day_to_yyyyddd(Numeric arg1) {
        return Intrinsic.day_to_yyyyddd(arg1, new Numeric(50));
    }

    public static final Numeric day_to_yyyyddd(Numeric arg1, Numeric arg2) {
        String remainder = "00000" + arg1.toInt();
        remainder = remainder.substring(remainder.length() - 5);
        Numeric year = new Numeric(remainder.substring(0, 2));
        remainder = remainder.substring(2);
        Numeric newYearNumeric = Intrinsic.year_to_yyyy(year, arg2);
        String newYearString = Utilities.format(newYearNumeric.toInt(), 4);
        return new Numeric("9999999", newYearString + remainder);
    }

    public static final Variable sr_current_date() {
        Calendar today = Calendar.getInstance();
        StringBuffer result = new StringBuffer(8);
        int year = today.get(1) % 100;
        result.append(Utilities.format(today.get(2) + 1, 2) + "/" + Utilities.format(today.get(5), 2) + "/" + Utilities.format(year, 2));
        return new Variable(result.toString());
    }

    public static final String sr_current_julian_date() {
        Calendar today = Calendar.getInstance();
        StringBuffer result = new StringBuffer(8);
        result.append(Utilities.format(today.get(1) - 1900, 3)).append(Utilities.format(today.get(6), 3));
        return result.toString();
    }

    public static final Numeric sr_time_of_day() {
        return new Numeric("999999", Intrinsic.sr_current_julian_time());
    }

    public static final String sr_current_julian_time() {
        Calendar today = Calendar.getInstance();
        StringBuffer result = new StringBuffer(6);
        result.append(Utilities.format(today.get(11), 2) + Utilities.format(today.get(12), 2) + Utilities.format(today.get(13), 2));
        return result.toString();
    }

    public static final Variable sr_current_time() {
        Calendar today = Calendar.getInstance();
        StringBuffer result = new StringBuffer(6);
        result.append(Utilities.format(today.get(11), 2) + ":" + Utilities.format(today.get(12), 2) + ":" + Utilities.format(today.get(13), 2));
        return new Variable(result.toString());
    }

    public static final Variable trim(Variable arg1) {
        String result = arg1.toString().trim();
        return new Variable(result.toString());
    }

    public static final Variable trim(Variable arg1, int qual) {
        String result = arg1.toString();
        if (qual == 1) {
            return new Variable(result.replaceAll("^\\s+", ""));
        }
        if (qual == 2) {
            return new Variable(result.replaceAll("\\s+$", ""));
        }
        return new Variable(result.toString());
    }

    public static final Variable add_duration(Variable arg1, int years, int months, int days, int hours, int minutes, int seconds, int microseconds) {
        if (strict_as400_add_duration) {
            if (years < 0) {
                years = -years;
            }
            if (months < 0) {
                months = -months;
            }
            if (days < 0) {
                days = -days;
            }
            if (hours < 0) {
                hours = -hours;
            }
            if (minutes < 0) {
                minutes = -minutes;
            }
            if (seconds < 0) {
                seconds = -seconds;
            }
            if (microseconds < 0) {
                microseconds = -microseconds;
            }
        }
        Date dateObject = arg1.getDate();
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTime(dateObject);
        if (years != 0) {
            greg.add(1, years);
        }
        if (months != 0) {
            greg.add(2, months);
        }
        if (days != 0) {
            greg.add(5, days);
        }
        if (hours != 0) {
            greg.add(11, hours);
        }
        if (minutes != 0) {
            greg.add(12, minutes);
        }
        if (seconds != 0) {
            greg.add(13, seconds);
        }
        if (microseconds != 0) {
            greg.add(14, microseconds / 1000);
        }
        Variable result = Variable.newVariableOfSize(arg1.length());
        String format = arg1.getFormat();
        if (format != null) {
            result.setFormat(format);
        }
        if (microseconds != 0) {
            try {
                int nanos = microseconds * 1000;
                greg.set(14, 0);
                result.move(greg, nanos);
            }
            catch (Exception e) {
                greg.add(14, microseconds /= 1000);
                result.move(greg);
            }
        } else {
            result.move(greg, 0);
        }
        return result;
    }

    public static final Variable subtract_duration(Variable arg1, int years, int months, int days, int hours, int minutes, int seconds, int microseconds) {
        if (strict_as400_add_duration) {
            if (years < 0) {
                years = -years;
            }
            if (months < 0) {
                months = -months;
            }
            if (days < 0) {
                days = -days;
            }
            if (hours < 0) {
                hours = -hours;
            }
            if (minutes < 0) {
                minutes = -minutes;
            }
            if (seconds < 0) {
                seconds = -seconds;
            }
            if (microseconds < 0) {
                microseconds = -microseconds;
            }
        }
        years = -years;
        months = -months;
        days = -days;
        hours = -hours;
        minutes = -minutes;
        seconds = -seconds;
        microseconds = -microseconds;
        Date dateObject = arg1.getDate();
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTime(dateObject);
        int nanos = 0;
        boolean oldNanos = false;
        try {
            Timestamp timestamp = null;
            timestamp = (Timestamp)dateObject;
            nanos = timestamp.getNanos();
            oldNanos = true;
            greg.set(14, nanos / 1000000);
        }
        catch (Exception e) {
            try {
                int currentMillisecond = (int)(dateObject.getTime() % 1000L);
                greg.set(14, currentMillisecond);
            }
            catch (Exception currentMillisecond) {
                // empty catch block
            }
        }
        if (years != 0) {
            greg.add(1, years);
        }
        if (months != 0) {
            greg.add(2, months);
        }
        if (days != 0) {
            greg.add(5, days);
        }
        if (hours != 0) {
            greg.add(11, hours);
        }
        if (minutes != 0) {
            greg.add(12, minutes);
        }
        if (seconds != 0) {
            greg.add(13, seconds);
        }
        if (microseconds != 0) {
            greg.add(14, microseconds / 1000);
        }
        Variable result = Variable.newVariableOfSize(arg1.length());
        String format = arg1.getFormat();
        if (format != null) {
            result.setFormat(format);
        }
        if (microseconds != 0) {
            try {
                nanos = microseconds * 1000;
                greg.set(14, 0);
                result.move(greg, nanos);
            }
            catch (Exception e) {
                greg.add(14, microseconds /= 1000);
                result.move(greg);
            }
        } else if (oldNanos) {
            result.move(greg, nanos);
        } else {
            result.move(greg);
        }
        return result;
    }

    public static final Variable find_duration(Variable arg1, Variable arg2, int field) {
        try {
            Date arg1Date = arg1.getDate();
            Date arg2Date = arg2.getDate();
            Calendar arg1Cal = Calendar.getInstance();
            arg1Cal.setTime(arg1Date);
            Calendar arg2Cal = Calendar.getInstance();
            arg2Cal.setTime(arg2Date);
            long arg1Time = arg1.getDate().getTime();
            long arg2Time = arg2.getDate().getTime();
            long difference = 0L;
            int val1 = 0;
            int val2 = 0;
            long MICROSECOND = 1000L;
            long SECOND = 1000L;
            long MINUTE = 60L * SECOND;
            long HOUR = 60L * MINUTE;
            long DAY = 24L * HOUR;
            switch (field) {
                case 1: {
                    return new Numeric(arg2Cal.get(1) - arg1Cal.get(1));
                }
                case 2: {
                    val2 = (arg2Cal.get(1) - 1900) * 12 + arg2Cal.get(2);
                    val1 = (arg1Cal.get(1) - 1900) * 12 + arg1Cal.get(2);
                    return new Numeric(val2 - val1);
                }
                case 5: {
                    difference = (arg2Time - arg1Time) / DAY;
                    return new Numeric(difference);
                }
                case 11: {
                    difference = (arg2Time - arg1Time) / HOUR;
                    return new Numeric(difference);
                }
                case 12: {
                    difference = (arg2Time - arg1Time) / MINUTE;
                    return new Numeric(difference);
                }
                case 13: {
                    difference = (arg2Time - arg1Time) / SECOND;
                    return new Numeric(difference);
                }
                case 9998: {
                    difference = (arg2Time - arg1Time) * MICROSECOND;
                    return new Numeric(difference);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Numeric(0);
    }

    private static final int getStyle(String locale) {
        try {
            int index;
            if (locale != null && (index = locale.indexOf(58)) >= 0) {
                switch (locale.charAt(index + 1)) {
                    case 'S': 
                    case 's': {
                        return 3;
                    }
                    case 'M': 
                    case 'm': {
                        return 2;
                    }
                    case 'L': 
                    case 'l': {
                        return 1;
                    }
                    case 'F': 
                    case 'f': {
                        return 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DEFAULT_LOCALE_STYLE;
    }

    private static final String trimStyle(String locale) {
        if (locale == null) {
            return locale;
        }
        int index = locale.indexOf(58);
        if (index >= 0) {
            return locale.substring(0, index);
        }
        return locale;
    }

    public static final Variable locale_date(String date, String locale) {
        try {
            if (date.length() < 8) {
                return new Variable(" ");
            }
            int month = ConvertData.parseDecimal(date.substring(4, 6));
            int dateOfMonth = ConvertData.parseDecimal(date.substring(6));
            int year = ConvertData.parseDecimal(date.substring(0, 4));
            int style = Intrinsic.getStyle(locale);
            Locale javaLocale = Intrinsic.getLocale(Intrinsic.trimStyle(locale));
            DateFormat format = DateFormat.getDateInstance(style, javaLocale);
            Calendar cal = Calendar.getInstance();
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, dateOfMonth);
            return new Variable(format.format(cal));
        }
        catch (Exception exception) {
            return new Variable(" ");
        }
    }

    public static final Variable locale_time(String date, String locale) {
        try {
            if (date.length() < 6) {
                return new Variable(" ");
            }
            int hour = ConvertData.parseDecimal(date.substring(0, 2));
            int minute = ConvertData.parseDecimal(date.substring(2, 4));
            int second = ConvertData.parseDecimal(date.substring(4, 6));
            int style = Intrinsic.getStyle(locale);
            Locale javaLocale = Intrinsic.getLocale(Intrinsic.trimStyle(locale));
            DateFormat format = DateFormat.getTimeInstance(style, javaLocale);
            try {
                boolean plus = false;
                if (date.charAt(8) == '+') {
                    plus = true;
                }
                int tzHour = ConvertData.parseDecimal(date.substring(9, 11));
                int tzMinute = ConvertData.parseDecimal(date.substring(11));
                int timeZone = tzHour * 60 + tzMinute;
                if (!plus) {
                    timeZone = -timeZone;
                }
                format.setTimeZone(new SimpleTimeZone(timeZone, "COBOL"));
            }
            catch (Exception plus) {
                // empty catch block
            }
            Calendar cal = Calendar.getInstance();
            cal.set(10, hour);
            cal.set(12, minute);
            cal.set(13, second);
            return new Variable(format.format(cal));
        }
        catch (Exception exception) {
            return new Variable(" ");
        }
    }

    public static final Locale getLocale(String locale) {
        if (locale == null) {
            return Locale.getDefault();
        }
        int index = -1;
        String language = null;
        String country = null;
        String variant = null;
        index = locale.indexOf(95);
        if (index >= 0) {
            language = locale.substring(0, index);
            if ((index = (locale = locale.substring(index + 1)).indexOf(95)) >= 0) {
                country = locale.substring(0, index);
                variant = locale.substring(index + 1);
            } else {
                country = locale;
            }
        } else {
            language = locale;
        }
        if (language != null) {
            language = language.toLowerCase();
        }
        if (country != null) {
            country = country.toUpperCase();
        }
        if (variant != null) {
            return new Locale(language, country, variant);
        }
        return new Locale(language, country);
    }

    public static final Variable extract_date_time(Variable arg1, int field) {
        Date date = arg1.getDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (field) {
            case 1: {
                return new Numeric(cal.get(1));
            }
            case 2: {
                return new Numeric(cal.get(2) + 1);
            }
            case 5: {
                return new Numeric(cal.get(5));
            }
            case 11: {
                return new Numeric(cal.get(10));
            }
            case 12: {
                return new Numeric(cal.get(12));
            }
            case 13: {
                return new Numeric(cal.get(13));
            }
            case 9998: {
                return new Numeric(cal.get(14000));
            }
        }
        return new Numeric(0);
    }

    public static final Variable extract_date_time(Variable arg1, String format) {
        Date date = arg1.getDate();
        return new Variable(FormatDateTime.format(format, date));
    }

    public static final Variable convert_date_time(Variable arg1, int type, String format, String locale) {
        String arg1Format = arg1.getFormat();
        if (format == null) {
            format = arg1Format;
        }
        Variable result = null;
        switch (type) {
            case 1: {
                result = new Variable("          ");
            }
            case 2: {
                result = new Variable("        ");
            }
            case 3: {
                result = new Variable("                          ");
            }
        }
        if (arg1Format != null) {
            result.setFormat(format);
            result.move(arg1.getDate());
        } else {
            result.move(FormatDateTime.format(type, format, arg1.toString(), locale));
        }
        return result;
    }

    public static final Variable test_date_time(Variable arg1, int type, String format, String locale) {
        return new Numeric(1);
    }
}

