/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.LockFileInterface;
import com.heirloomcomputing.ecs.exec.LockedFileException;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;

public class LockFile {
    private static final String LOCK_FILE_CHANNEL = "com.heirloomcomputing.ecs.exec.jdk14.LockFileChannel";
    private static final String LOCK_FILE_RENAME = "com.heirloomcomputing.ecs.exec.LockFileRename";
    private static LockFileInterface lockFile;

    private static void initializeLockFileInstance() {
        Class<?> c = null;
        String lockFileExtension = RuntimeEnvironment.getGlobalParameter("LOCK-FILE");
        if (lockFileExtension != null) {
            if (lockFileExtension.equalsIgnoreCase("JDK11")) {
                lockFileExtension = LOCK_FILE_RENAME;
            } else if (lockFileExtension.equalsIgnoreCase("JDK14")) {
                lockFileExtension = LOCK_FILE_CHANNEL;
            }
            lockFileExtension = lockFileExtension.replace('/', '.');
            if (lockFileExtension.endsWith(".class")) {
                lockFileExtension = lockFileExtension.substring(0, lockFileExtension.length() - 6);
            }
        }
        if (lockFile == null && lockFileExtension != null && lockFileExtension.indexOf(46) < 0) {
            try {
                c = Class.forName("com.heirloomcomputing.ecs.exec.LockFile" + lockFileExtension);
                lockFile = (LockFileInterface)c.newInstance();
            }
            catch (Throwable t) {
                c = null;
            }
        }
        if (lockFile == null && lockFileExtension != null) {
            try {
                c = Class.forName(lockFileExtension);
                lockFile = (LockFileInterface)c.newInstance();
            }
            catch (Throwable t) {
                c = null;
            }
        }
        if (lockFile == null) {
            try {
                c = Class.forName(LOCK_FILE_RENAME);
                lockFile = (LockFileInterface)c.newInstance();
            }
            catch (Throwable t) {
                c = null;
            }
        }
        if (lockFile == null) {
            try {
                c = Class.forName(LOCK_FILE_CHANNEL);
                lockFile = (LockFileInterface)c.newInstance();
            }
            catch (Throwable t) {
                c = null;
            }
        }
        if (RuntimeEnvironment.isGlobalParameter("LOCK_FILE_VERBOSE")) {
            System.out.println("LockFile in use: " + lockFile + ", class=" + c);
        }
    }

    public static String sharingNoOthers(Object file2, String name, int openMode) throws LockedFileException {
        if (lockFile == null) {
            return null;
        }
        return lockFile.sharingNoOthers(file2, name, openMode);
    }

    public static String sharingReadOnly(Object file2, String name, int openMode) throws LockedFileException {
        if (lockFile == null) {
            return null;
        }
        return lockFile.sharingReadOnly(file2, name, openMode);
    }

    public static String sharingAllOthers(Object file2, String name, int openMode) throws LockedFileException {
        if (lockFile == null) {
            return null;
        }
        return lockFile.sharingAllOthers(file2, name, openMode);
    }

    public static boolean releaseSharing(Object file2, String name) {
        if (lockFile == null) {
            return false;
        }
        return lockFile.releaseSharing(file2, name);
    }

    public static void releaseSharing() {
        if (lockFile != null) {
            lockFile.releaseSharing();
        }
    }

    public static boolean isLockWhileOpen() {
        if (lockFile != null) {
            return lockFile.isLockWhileOpen();
        }
        return false;
    }

    public static int transformOpenMode(int openMode) {
        if (lockFile != null) {
            return lockFile.transformOpenMode(openMode);
        }
        return openMode;
    }

    static {
        LockFile.initializeLockFileInstance();
    }
}

