/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.LockFileInterface;
import com.heirloomcomputing.ecs.exec.LockedFileException;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class LockFileRename
implements LockFileInterface {
    private static final String NO = "no_";
    private static final String AOI = "aoi_";
    private static final String AOO = "aoo_";
    private static final String ROI = "roi_";
    private static final String ROO = "roo_";
    private Hashtable<String, String> names = new Hashtable();

    private final String prefixFilename(String basename, String prefix) {
        try {
            File f = new File(basename);
            String name = f.getName();
            String parent = f.getParent();
            if (name == null) {
                name = "";
            }
            name = prefix + name;
            if (parent != null) {
                name = parent + File.separator + name;
            }
            return name;
        }
        catch (Exception exception) {
            return prefix + basename;
        }
    }

    private boolean exists(String basename) {
        if (new File(basename).exists()) {
            return true;
        }
        if (new File(this.prefixFilename(basename, NO)).exists()) {
            return true;
        }
        if (new File(this.prefixFilename(basename, AOI)).exists()) {
            return true;
        }
        if (new File(this.prefixFilename(basename, AOO)).exists()) {
            return true;
        }
        if (new File(this.prefixFilename(basename, ROI)).exists()) {
            return true;
        }
        return new File(this.prefixFilename(basename, ROO)).exists();
    }

    private boolean createOutputBase(String name) {
        try {
            FileOutputStream fout = new FileOutputStream(name);
            fout.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sharingNoOthers(Object fileObject, String name, int openMode) throws LockedFileException {
        Hashtable<String, String> hashtable = this.names;
        synchronized (hashtable) {
            File f = new File(name);
            if (f.exists()) {
                String filename = this.prefixFilename(name, NO);
                if (f.renameTo(new File(filename))) {
                    this.names.put(name, filename);
                    return filename;
                }
                throw new LockedFileException();
            }
            if ((openMode & 7) == 2 || (openMode & 7) == 6) {
                if (this.exists(name)) {
                    throw new LockedFileException();
                }
                if (this.createOutputBase(name)) {
                    return this.sharingNoOthers(fileObject, name, openMode);
                }
            } else if (this.exists(name)) {
                throw new LockedFileException();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sharingReadOnly(Object fileObject, String name, int openMode) throws LockedFileException {
        Hashtable<String, String> hashtable = this.names;
        synchronized (hashtable) {
            String filename;
            File f = new File(name);
            if (f.exists() && f.renameTo(new File(filename = (openMode & 7) == 1 ? this.prefixFilename(name, ROI) : this.prefixFilename(name, ROO)))) {
                this.names.put(name, filename);
                return filename;
            }
            if ((openMode & 7) == 2 || (openMode & 7) == 6) {
                if (this.exists(name)) {
                    throw new LockedFileException();
                }
                if (this.createOutputBase(name)) {
                    return this.sharingReadOnly(fileObject, name, openMode);
                }
            }
            if (new File(filename = this.prefixFilename(name, AOI)).exists()) {
                this.names.put(name, filename);
                return filename;
            }
            if ((openMode & 7) != 1) {
                if (this.exists(name)) {
                    throw new LockedFileException();
                }
                return null;
            }
            filename = this.prefixFilename(name, ROI);
            if (new File(filename).exists()) {
                this.names.put(name, filename);
                return filename;
            }
            if (this.exists(name)) {
                throw new LockedFileException();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sharingAllOthers(Object fileObject, String name, int openMode) throws LockedFileException {
        Hashtable<String, String> hashtable = this.names;
        synchronized (hashtable) {
            String filename;
            File f = new File(name);
            if (f.exists() && f.renameTo(new File(filename = (openMode & 7) == 1 ? this.prefixFilename(name, AOI) : this.prefixFilename(name, AOO)))) {
                this.names.put(name, filename);
                return filename;
            }
            if ((openMode & 7) == 2 || (openMode & 7) == 6) {
                if (this.exists(name)) {
                    throw new LockedFileException();
                }
                if (this.createOutputBase(name)) {
                    return this.sharingAllOthers(fileObject, name, openMode);
                }
            }
            if (new File(filename = this.prefixFilename(name, AOI)).exists()) {
                this.names.put(name, filename);
                return filename;
            }
            filename = this.prefixFilename(name, AOO);
            if (new File(filename).exists()) {
                this.names.put(name, filename);
                return filename;
            }
            if ((openMode & 7) != 1) {
                if (this.exists(name)) {
                    throw new LockedFileException();
                }
                return null;
            }
            filename = this.prefixFilename(name, ROI);
            if (new File(filename).exists()) {
                this.names.put(name, filename);
                return filename;
            }
            filename = this.prefixFilename(name, ROO);
            if (new File(filename).exists()) {
                this.names.put(name, filename);
                return filename;
            }
            if (this.exists(name)) {
                throw new LockedFileException();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseSharing(Object fileObject, String name) {
        Hashtable<String, String> hashtable = this.names;
        synchronized (hashtable) {
            try {
                File dest;
                File source;
                String storage = this.names.get(name);
                if (storage != null && storage instanceof String && (source = new File(storage)).renameTo(dest = new File(name))) {
                    this.names.remove(name);
                    return true;
                }
            }
            catch (Exception releaseException) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSharing() {
        Hashtable<String, String> hashtable = this.names;
        synchronized (hashtable) {
            Enumeration<String> e = this.names.elements();
            while (e.hasMoreElements()) {
                try {
                    String orig = e.nextElement();
                    this.releaseSharing(null, this.names.get(orig));
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean isLockWhileOpen() {
        return false;
    }

    @Override
    public int transformOpenMode(int openMode) {
        return openMode;
    }
}

