/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.MFFile;
import com.heirloomcomputing.ecs.exec.MFFilePointer;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.bTreeNode;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import java.nio.charset.Charset;

public class MFBTreeNode
extends bTreeNode {
    public static final Charset debugcs = Charset.forName("iso-8859-1");
    public static final boolean debugMode = false;
    private MFFile file = null;
    private MFFilePointer currentLocation = null;
    private comparableByteArray keyTemplate = null;
    private int bTreeIndex = -1;
    private byte[] mainBuffer = null;
    private int numberOfKeys = 0;
    private int maxKeys;
    private int minKeys;
    private int keyLength;
    private int childLength;
    private long[] duplicateCount;
    private int keyBase;
    boolean securityFlag = false;

    public static void debug(String text) {
        System.out.println("MFBTreeNode: " + text);
    }

    public MFBTreeNode(MFFile file2, int order, comparableByteArray nodeKeyTemplate, int bTreeIndex, int keyTemplateLength) {
        this.maxKeys = order - 1;
        this.minKeys = this.maxKeys / 2;
        this.duplicateCount = new long[this.maxKeys];
        this.keyTemplate = nodeKeyTemplate;
        this.keyLength = nodeKeyTemplate.length();
        this.keyBase = file2.getIdxHeaderSize() + 2;
        this.childLength = file2.getFilePointerSize();
        this.bTreeIndex = bTreeIndex;
        this.file = file2;
        this.mainBuffer = new byte[file2.getIndexNodeRecordSize()];
        long currentRecordKey = file2.addKeyRecord(this.toByteArray());
        this.currentLocation = new MFFilePointer(currentRecordKey, file2.isIdx8());
    }

    public MFBTreeNode(MFFile file2, int order, long recordKey, comparableByteArray nodeKeyTemplate, int bTreeIndex, int keyTemplateLength) {
        this.maxKeys = order - 1;
        this.minKeys = this.maxKeys / 2;
        this.duplicateCount = new long[this.maxKeys];
        this.keyTemplate = nodeKeyTemplate;
        this.keyLength = nodeKeyTemplate.length();
        this.keyBase = file2.getIdxHeaderSize() + 2;
        this.childLength = file2.getFilePointerSize();
        this.bTreeIndex = bTreeIndex;
        this.file = file2;
        this.mainBuffer = new byte[file2.getIndexNodeRecordSize()];
        byte[] bytes = file2.getKeyRecord(recordKey);
        this.fromByteArray(bytes);
        this.currentLocation = new MFFilePointer(recordKey, file2.isIdx8());
    }

    @Override
    public final Object getLocation() {
        return this.currentLocation;
    }

    @Override
    public final int getNumberOfKeys() {
        return this.numberOfKeys;
    }

    @Override
    public final int getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public final int getMinKeys() {
        return this.minKeys;
    }

    @Override
    public final long getDuplicateCount(int keyNumber) {
        if (keyNumber < 0 || keyNumber >= this.numberOfKeys) {
            return -1L;
        }
        return this.duplicateCount[keyNumber];
    }

    @Override
    public final void setDuplicateCount(int keyNumber, long count) {
        this.duplicateCount[keyNumber] = count;
    }

    @Override
    public final int getChildLength() {
        return this.childLength;
    }

    @Override
    public final int getKeyLength() {
        return this.keyLength;
    }

    @Override
    public final int getKeyByteOffset(int keyNumber) {
        return this.keyBase + (this.keyLength + this.childLength) * keyNumber;
    }

    @Override
    public final int getChildByteOffset(int childNumber) {
        return this.keyBase + (this.keyLength + this.childLength) * childNumber + this.keyLength;
    }

    @Override
    public Object getChild(int childNumber) {
        if (childNumber >= this.getNumberOfKeys() || childNumber < 0) {
            return null;
        }
        return super.getChild(childNumber);
    }

    @Override
    public boolean getChild(int childNumber, byte[] bytes, int offset) {
        if (childNumber >= this.getNumberOfKeys() || childNumber < 0) {
            return false;
        }
        return super.getChild(childNumber, bytes, offset);
    }

    @Override
    public int findKeyWithChild(byte[] childBytes, int offset, int startIndex) {
        int count;
        byte[] buffer = this.getBuffer();
        int numKeys = this.getNumberOfKeys();
        for (count = startIndex; count < numKeys && MFBTreeNode.compareBytes(buffer, this.getChildByteOffset(count), this.childLength, childBytes, offset, this.childLength, false) != 0; ++count) {
        }
        if (count < numKeys) {
            return count;
        }
        return -1;
    }

    @Override
    public final bTreeNode getNode(Object myNodePointer, bTreeNode reuseNode) {
        if (myNodePointer == null) {
            return null;
        }
        MFFilePointer nodePointer = (MFFilePointer)myNodePointer;
        MFBTreeNode node = (MFBTreeNode)reuseNode;
        long recordKey = nodePointer.getRecordKey();
        node.fromByteArray(this.file.getKeyRecord(recordKey));
        node.currentLocation = new MFFilePointer(recordKey, this.file.isIdx8());
        return node;
    }

    @Override
    public final bTreeNode getNode(Object myNodePointer) {
        if (myNodePointer == null) {
            return null;
        }
        return this.newInstance(((MFFilePointer)myNodePointer).getRecordKey());
    }

    @Override
    public final void setNode() {
        if (this.currentLocation == null) {
            return;
        }
        if (this.numberOfKeys <= 0 && !this.isRoot()) {
            this.file.deleteKeyRecord(this.currentLocation.getRecordKey());
        } else {
            this.file.updateKeyRecord(this.currentLocation.getRecordKey(), this.toByteArray());
        }
    }

    @Override
    public final Object getData(Object myNodePointer) {
        if (myNodePointer == null) {
            return null;
        }
        long recordKey = ((MFFilePointer)myNodePointer).getRecordKey();
        return this.file.getDataRecord(recordKey);
    }

    @Override
    public final bTreeNode newInstance() {
        return new MFBTreeNode(this.file, this.maxKeys + 1, this.keyTemplate, this.bTreeIndex, this.keyLength);
    }

    public final bTreeNode newInstance(long recordKey) {
        return new MFBTreeNode(this.file, this.maxKeys + 1, recordKey, this.keyTemplate, this.bTreeIndex, this.keyLength);
    }

    private final boolean fromByteArray(byte[] tempBytes) {
        boolean securityFlag2;
        int hdr;
        if (tempBytes == null) {
            return false;
        }
        boolean suppressLeading = this.file.getSuppressLeadingChars(this.bTreeIndex);
        boolean suppressTrailing = this.file.getSuppressTrailingSpaces(this.bTreeIndex);
        boolean suppressDuplicates = false;
        if (this.file.getSuppressDuplicateKeys(this.bTreeIndex) && this.file.getDuplicatesAllowed(this.bTreeIndex)) {
            suppressDuplicates = true;
        }
        boolean securityFlag1 = (tempBytes[hdr = this.file.getIdxHeaderSize()] & 0x80) != 0;
        int end = tempBytes.length - (this.file.isIdx8() ? 1 : 3);
        boolean bl = securityFlag2 = (tempBytes[end] & 0x80) != 0;
        if (securityFlag1 != securityFlag2) {
            // empty if block
        }
        if (this.file.isIdx8() || (tempBytes[end + 1] | tempBytes[end + 2]) != 0) {
            // empty if block
        }
        int endKVB = (tempBytes[hdr] & 0x7F) << 8 | tempBytes[hdr + 1] & 0xFF;
        int index = this.file.getIdxHeaderSize() + 2;
        int i = 0;
        this.keyBase = index;
        while (index < endKVB) {
            index = this.fromKeyValueBlockBytes(i, index, suppressLeading, suppressTrailing, suppressDuplicates, tempBytes);
            ++i;
        }
        this.numberOfKeys = i;
        this.bTreeIndex = tempBytes[end - 1] & 0xFF;
        int height = tempBytes[end] & 0x7F;
        this.setHeight(height);
        this.setLeaf(height == 0);
        System.arraycopy(tempBytes, 0, this.mainBuffer, 0, tempBytes.length);
        return true;
    }

    private int fromKeyValueBlockBytes(int i, int index, boolean suppressLeading, boolean suppressTrailing, boolean suppressDuplicates, byte[] tempBytes) {
        if (suppressLeading) {
            // empty if block
        }
        if (suppressTrailing) {
            // empty if block
        }
        index += this.keyLength;
        if (suppressDuplicates) {
            // empty if block
        }
        index += this.file.getFilePointerSize();
        if (suppressDuplicates) {
            // empty if block
        }
        return index;
    }

    private final byte[] toByteArray() {
        byte[] tempBytes = this.mainBuffer;
        this.securityFlag = !this.securityFlag;
        int hdr = this.file.getIdxHeaderSize();
        this.file.setRecordHeader(tempBytes, 2);
        int index = hdr + 2;
        boolean suppressLeading = this.file.getSuppressLeadingChars(this.bTreeIndex);
        boolean suppressTrailing = this.file.getSuppressTrailingSpaces(this.bTreeIndex);
        boolean suppressDuplicates = false;
        if (this.file.getSuppressDuplicateKeys(this.bTreeIndex) && this.file.getDuplicatesAllowed(this.bTreeIndex)) {
            suppressDuplicates = true;
        }
        this.keyBase = index;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            index = this.toKeyValueBlockBytes(i, index, suppressLeading, suppressTrailing, suppressDuplicates);
        }
        int endKVB = index;
        tempBytes[hdr] = (byte)(endKVB >> 8 & 0xFF);
        tempBytes[hdr + 1] = (byte)(endKVB & 0xFF);
        if (this.securityFlag) {
            int n = hdr;
            tempBytes[n] = (byte)(tempBytes[n] | 0x80);
        }
        int end = tempBytes.length - (this.file.isIdx8() ? 1 : 3);
        tempBytes[end - 1] = (byte)this.bTreeIndex;
        tempBytes[end] = (byte)this.getHeight();
        if (this.securityFlag) {
            int n = end;
            tempBytes[n] = (byte)(tempBytes[n] | 0x80);
        }
        if (!this.file.isIdx8()) {
            tempBytes[end + 1] = 0;
            tempBytes[end + 2] = 0;
        }
        return tempBytes;
    }

    private int toKeyValueBlockBytes(int i, int index, boolean suppressLeading, boolean suppressTrailing, boolean suppressDuplicates) {
        if (suppressLeading) {
            // empty if block
        }
        if (suppressTrailing) {
            // empty if block
        }
        index += this.keyLength;
        if (suppressDuplicates) {
            // empty if block
        }
        index += this.file.getFilePointerSize();
        if (suppressDuplicates) {
            // empty if block
        }
        return index;
    }

    @Override
    public void free() {
        super.free();
        this.numberOfKeys = 0;
        this.duplicateCount = new long[this.maxKeys];
    }

    @Override
    public final String toString() {
        String text = "";
        boolean showData = false;
        String lineSep = RuntimeEnvironment.getGlobalParameter("line.separator");
        int numKeys = this.getNumberOfKeys();
        Object l = this.getLocation();
        String loc = "";
        if (l != null) {
            loc = l.toString();
        }
        text = loc + " " + numKeys + ": ";
        text = this.isRoot() ? text + "(Root) " : text + "       ";
        if (this.isLeaf()) {
            text = text + "(Leaf) ";
            for (int count = 0; count < numKeys; ++count) {
                Object child = this.getChild(count);
                text = text + child.toString();
                if (showData) {
                    text = text + ":" + new String((byte[])this.getData(child), debugcs);
                }
                text = text + "[" + new String(this.getKey(count).toByteArray(), debugcs) + "]";
            }
            text = text + lineSep;
        } else {
            text = text + "  ";
            for (int count = 0; count < numKeys; ++count) {
                text = text + this.getChild(count);
                text = text + "[" + new String(this.getKey(count).toByteArray(), debugcs) + "]";
            }
            text = text + lineSep;
        }
        return text;
    }

    @Override
    protected final byte[] getBuffer() {
        return this.mainBuffer;
    }

    @Override
    protected Object convertBytesToChildObject(int childNumber) {
        if (childNumber >= this.getNumberOfKeys()) {
            return null;
        }
        int offset = this.getChildByteOffset(childNumber);
        return new MFFilePointer(this.mainBuffer, offset, this.file.isIdx8());
    }

    @Override
    protected boolean convertChildObjectToBytes(Object childObject, int childNumber) {
        if (childObject == null) {
            return false;
        }
        int offset = this.getChildByteOffset(childNumber);
        return this.convertChildObjectToBytes(childObject, this.mainBuffer, offset);
    }

    @Override
    protected boolean convertChildObjectToBytes(Object childObject, byte[] bytes, int offset) {
        if (childObject == null) {
            return false;
        }
        try {
            ((MFFilePointer)childObject).writeBytes(bytes, offset);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected comparableByteArray convertBytesToKeyObject(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return null;
        }
        comparableByteArray keyObject = this.keyTemplate.copy();
        byte[] keyBytes = new byte[len];
        System.arraycopy(bytes, offset, keyBytes, 0, len);
        keyObject.fromByteArray(keyBytes);
        return keyObject;
    }

    @Override
    protected boolean convertKeyObjectToBytes(comparableByteArray keyObject, byte[] bytes, int offset) {
        if (keyObject == null) {
            return false;
        }
        byte[] keyBytes = keyObject.toByteArray();
        if (keyBytes != null) {
            System.arraycopy(keyBytes, 0, bytes, offset, keyBytes.length);
        }
        return true;
    }

    protected boolean checkSanityLT1k(byte[] src, int srcoff, byte[] dst, int dstoff, int len) {
        boolean rc;
        boolean bl = rc = srcoff < 0 || srcoff > src.length || dstoff < 0 || dstoff > dst.length || len < 0 || srcoff + len > dst.length || dstoff + len > dst.length;
        if (rc) {
            throw new RuntimeException("*** Heirloom Computing internal error MFBTreeNode: System.arraycopy() bounds");
        }
        return rc;
    }

    protected boolean checkSanityLT1k(long[] src, int srcoff, long[] dst, int dstoff, int len) {
        boolean rc;
        boolean bl = rc = srcoff < 0 || srcoff > src.length || dstoff < 0 || dstoff > dst.length || len < 0 || srcoff + len > dst.length || dstoff + len > dst.length;
        if (rc) {
            throw new RuntimeException("*** Heirloom Computing internal error MFBTreeNode: System.arraycopy() bounds");
        }
        return rc;
    }

    @Override
    protected boolean insertKeyIntoBufferAndIncreaseNumberOfKeys(int keyNumberPosition, byte[] keyBytes, int keyOffset, int keyLen, byte[] childBytes, int childOffset, long duplicateCount) {
        ++this.numberOfKeys;
        int displacement = this.keyLength + this.childLength;
        int sourceOffset = this.getKeyByteOffset(keyNumberPosition);
        int destOffset = sourceOffset + displacement;
        int totalBytesToMove = this.mainBuffer.length - sourceOffset - displacement;
        System.arraycopy(this.mainBuffer, sourceOffset, this.mainBuffer, destOffset, totalBytesToMove);
        System.arraycopy(keyBytes, keyOffset, this.mainBuffer, sourceOffset, keyLen);
        System.arraycopy(childBytes, childOffset, this.mainBuffer, sourceOffset + this.keyLength, this.childLength);
        if (this.numberOfKeys < this.maxKeys) {
            System.arraycopy(this.duplicateCount, keyNumberPosition, this.duplicateCount, keyNumberPosition + 1, this.numberOfKeys - keyNumberPosition);
        }
        this.duplicateCount[keyNumberPosition] = duplicateCount;
        return true;
    }

    @Override
    protected boolean deleteKeyFromBufferAndDecreaseNumberOfKeys(int keyNumberPosition) {
        int numKeys = this.getNumberOfKeys();
        if (keyNumberPosition < 0 || keyNumberPosition >= numKeys) {
            return false;
        }
        try {
            int displacement = this.keyLength + this.childLength;
            int sourceOffset = this.getKeyByteOffset(keyNumberPosition + 1);
            int destOffset = sourceOffset - displacement;
            int totalBytesToMove = this.mainBuffer.length - sourceOffset;
            System.arraycopy(this.mainBuffer, sourceOffset, this.mainBuffer, destOffset, totalBytesToMove);
            if (keyNumberPosition + 1 < this.maxKeys) {
                System.arraycopy(this.duplicateCount, keyNumberPosition + 1, this.duplicateCount, keyNumberPosition, this.numberOfKeys - keyNumberPosition - 1);
            }
            --this.numberOfKeys;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected boolean moveFromNode(bTreeNode sourceNode, int n) {
        if (n == 0) {
            return true;
        }
        boolean returnValue = true;
        if (sourceNode.getNumberOfKeys() < n) {
            returnValue = false;
            n = sourceNode.getNumberOfKeys();
        }
        if (this.numberOfKeys + n > this.getMaxKeys()) {
            returnValue = false;
            n = this.getMaxKeys() - this.numberOfKeys;
        }
        try {
            MFBTreeNode source = (MFBTreeNode)sourceNode;
            int keyNumberPosition = this.getNumberOfKeys();
            this.numberOfKeys += n;
            int ourOffset = this.getKeyByteOffset(keyNumberPosition);
            int sourceOffset = source.getKeyByteOffset(0);
            int totalBytesToMove = (source.keyLength + source.childLength) * n;
            byte[] sourceBuffer = source.getBuffer();
            System.arraycopy(sourceBuffer, sourceOffset, this.mainBuffer, ourOffset, totalBytesToMove);
            System.arraycopy(source.duplicateCount, 0, this.duplicateCount, keyNumberPosition, n);
            int displacement = sourceOffset + totalBytesToMove;
            int amount = sourceBuffer.length - displacement;
            if (amount > 0) {
                System.arraycopy(sourceBuffer, displacement, sourceBuffer, sourceOffset, amount);
            }
            if ((amount = source.getNumberOfKeys() - n) > 0) {
                System.arraycopy(source.duplicateCount, n, source.duplicateCount, 0, amount);
            }
            source.numberOfKeys -= n;
            return returnValue;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

