/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.BTreeHandler;
import com.heirloomcomputing.ecs.exec.BTreeIndexedFile;
import com.heirloomcomputing.ecs.exec.MFBTreeHandler;
import com.heirloomcomputing.ecs.exec.MFFile;
import com.heirloomcomputing.ecs.exec.MFFilePointer;
import com.heirloomcomputing.ecs.exec.Utilities;

public class MFIndexedFile
extends BTreeIndexedFile {
    private static final boolean debugMode = false;
    private MFFile file = null;
    private int nodeSize = -1;
    private int bTreeIndex = 0;

    public static void debug(String text) {
        Utilities.debugOutput("MFIndexedFile: " + text);
    }

    @Override
    boolean file_init(String filename) {
        this.file = null;
        this.nodeSize = -1;
        this.bTreeIndex = 0;
        int maxKeyLth = -1;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (this.keyLength[i] <= maxKeyLth) continue;
            maxKeyLth = this.keyLength[i];
        }
        this.nodeSize = maxKeyLth > 238 ? 4096 : 1024;
        this.file = new MFFile(this.nodeSize, this.numberOfKeys, this.recordFrom, this.recordTo, this.dependingOn, this.keyCompression, this.dataCompression, this.idxFormat, this.keyLength, this.keyDuplicates, this.keyStartLocation, this.keyOffsets, this.keyArray, this.masterRecord, this.newModes, this.dataLockRecord, this.idxLockRecord);
        return this.file_setFilename(filename);
    }

    @Override
    boolean file_setFilename(String filename) {
        if (this.file == null) {
            return false;
        }
        int status = this.file.setFilename(filename);
        this.setIOStatus(status);
        return status == 0;
    }

    @Override
    int file_open(int mode) {
        return this.file.open(mode);
    }

    @Override
    int file_close(int mode) {
        int status = this.file.close(mode);
        if (status == 0) {
            this.bTreeIndex = 0;
        }
        return status;
    }

    @Override
    int file_close() {
        int status = this.file.close();
        if (status == 0) {
            this.bTreeIndex = 0;
        }
        return status;
    }

    @Override
    int file_setHeaderInformation() {
        int height = 0;
        if (this.keyBTree != null && this.keyBTree[0] != null) {
            height = (int)this.keyBTree[0].getTreeHeight();
        }
        return this.file.updateHeaderInformation(this.keyStartLocation, height);
    }

    @Override
    boolean file_getHeaderInformation() {
        boolean flag = this.file.checkHeaderInformation();
        if (!flag) {
            return false;
        }
        for (int i = 0; i < this.numberOfKeys; ++i) {
            this.keyStartLocation[i] = this.file.getKeyStartLocation(i);
        }
        return true;
    }

    @Override
    BTreeHandler file_getBTreeHandler() {
        return new MFBTreeHandler(this.file, this.bTreeIndex++);
    }

    @Override
    Object file_addData(byte[] data) {
        return this.file_addData(data, 0, data.length);
    }

    @Override
    Object file_addData(byte[] data, int offset, int length) {
        long recordKey = this.file.addDataRecord(data, offset, length);
        if (recordKey < 0L) {
            return null;
        }
        return new MFFilePointer(recordKey, this.file.isIdx8());
    }

    @Override
    int file_removeData(Object location) {
        if (!(location instanceof MFFilePointer)) {
            this.warning("MFIndexedFile.file_removeData", "internal error");
            return -30;
        }
        MFFilePointer p = (MFFilePointer)location;
        long recordKey = p.getRecordKey();
        return this.file.deleteDataRecord(recordKey);
    }

    @Override
    final boolean file_isOpen() {
        if (this.file == null) {
            return false;
        }
        return this.file.fileIsOpen();
    }

    @Override
    final boolean file_isInput() {
        if (this.file == null) {
            return false;
        }
        return this.file.isInput();
    }

    @Override
    final boolean file_isOutput() {
        if (this.file == null) {
            return false;
        }
        return this.file.isOutput();
    }

    @Override
    final boolean file_isIO() {
        if (this.file == null) {
            return false;
        }
        return this.file.isIO();
    }

    @Override
    final boolean file_isExtend() {
        if (this.file == null) {
            return false;
        }
        return this.file.isExtend();
    }

    @Override
    final boolean file_isWritable() {
        if (this.file == null) {
            return false;
        }
        return this.file.isWritable();
    }

    @Override
    final boolean file_isReadable() {
        if (this.file == null) {
            return false;
        }
        return this.file.isReadable();
    }

    @Override
    final boolean file_isNewFile() {
        if (this.file == null) {
            return false;
        }
        return this.file.isNewFile();
    }

    @Override
    void file_flushCache() {
        if (this.file != null) {
            this.file.flushCache();
        }
    }

    @Override
    void file_reset() {
        if (this.file != null) {
            this.file.reset();
        }
    }

    @Override
    boolean file_deleteFile() {
        if (this.file != null) {
            return this.file.deleteFile();
        }
        return false;
    }

    @Override
    boolean file_dataLock(Object lockObject) {
        if (!(lockObject instanceof MFFilePointer)) {
            return false;
        }
        MFFilePointer p = (MFFilePointer)lockObject;
        return this.dataLockRecord.lock(p.getRecordKey() + 1L);
    }

    @Override
    boolean file_dataUnlock(Object lockObject) {
        if (!(lockObject instanceof MFFilePointer)) {
            return false;
        }
        MFFilePointer p = (MFFilePointer)lockObject;
        this.dataLockRecord.unlock(p.getRecordKey() + 1L);
        return true;
    }

    @Override
    final int file_mapStatusCode(int status) {
        return status;
    }

    @Override
    final boolean isFixed() {
        boolean override_fixed;
        boolean bl = override_fixed = (this.newModes & 1) != 0;
        if (override_fixed) {
            return true;
        }
        return !this.isVariable();
    }

    @Override
    final boolean isVariable() {
        boolean override_varying;
        boolean override_variable = (this.newModes & 2) != 0;
        boolean bl = override_varying = (this.newModes & 4) != 0;
        if (override_variable || override_varying) {
            return true;
        }
        return this.dependingOn != null;
    }
}

