/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.hp.mpe.Intrinsic;
import com.hp.mpe.IntrinsicFile;
import java.util.Hashtable;

public class MPEIntrinsic
implements ICallableProgramGiving {
    private static Hashtable<String, IntrinsicFile> intrinsicFiles = null;
    private static String defaultJar = "sysintr.jar";
    private static boolean traceMode = false;
    private Intrinsic intrinsic;
    private String name;
    private static final Class<Character> characterClass;
    private static final Class<Boolean> booleanClass;
    private static final Class<Short> shortClass;
    private static final Class<Integer> integerClass;
    private static final Class<Long> longClass;
    private static final Class<Float> floatClass;
    private static final Class<Double> doubleClass;
    private static final Class<Void> voidClass;
    private static final Class<byte[]> bytesClass;

    private static void setupIntrinsics() {
        try {
            traceMode = RuntimeEnvironment.isGlobalParameter("MPETRACE");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String value = RuntimeEnvironment.getGlobalParameter("INTRINSICSJAR");
            if (value != null) {
                defaultJar = value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String convertName(String name) {
        return name.replace('\'', 't');
    }

    public MPEIntrinsic(String name) {
        this(name, null);
    }

    public MPEIntrinsic(String name, String source) {
        this.name = name;
        IntrinsicFile ifile = null;
        name = this.convertName(name);
        block6: for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                if (source != null) {
                    if (source.endsWith(".jar")) {
                        this.intrinsic = Intrinsic.loadFromJar((String)source, (String)name);
                    } else {
                        if (intrinsicFiles != null) {
                            ifile = intrinsicFiles.get(source);
                        }
                        if (ifile == null && (ifile = new IntrinsicFile(source)) != null) {
                            ifile.open();
                            intrinsicFiles.put(source, ifile);
                        }
                        if (ifile != null) {
                            this.intrinsic = ifile.loadDefinition(name);
                        }
                    }
                } else {
                    this.intrinsic = Intrinsic.loadFromJar((String)defaultJar, (String)name);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.intrinsic != null) break;
            switch (attempt) {
                case 0: {
                    name = name.toLowerCase();
                    continue block6;
                }
                case 1: {
                    name = name.toUpperCase();
                }
            }
        }
        this.intrinsic.setTrace(traceMode);
    }

    @Override
    public Object callGiving(parameterList param) {
        try {
            if (this.intrinsic == null) {
                return new Numeric(0);
            }
            if (traceMode) {
                System.out.println("");
                System.out.println("Elastic COBOL MPE Intrinsic Call: '" + this.name + "'");
            }
            if (traceMode) {
                if (param != null) {
                    System.out.println(" Elastic COBOL: " + param.size() + " parameters.");
                } else {
                    System.out.println(" Elastic COBOL: no parameters");
                }
            }
            if (param != null) {
                for (int i = 0; i < param.size(); ++i) {
                    if (param.isOmitted(i)) continue;
                    Class operand = this.intrinsic.getParameterClass(i);
                    if (traceMode) {
                        System.out.println(" Elastic COBOL: IN param expected: " + operand);
                    }
                    if (operand == shortClass) {
                        short value = param.getShort(i);
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: IN param short '" + value + "'");
                        }
                        this.intrinsic.setParameter(i, (Object)new Short(value));
                        continue;
                    }
                    if (operand == characterClass) {
                        char value = param.getChar(i);
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: IN param char '" + value + "'");
                        }
                        this.intrinsic.setParameter(i, (Object)new Character(value));
                        continue;
                    }
                    if (operand == booleanClass) {
                        boolean value = param.getBoolean(i);
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: IN param boolean '" + value + "'");
                        }
                        this.intrinsic.setParameter(i, (Object)new Boolean(value));
                        continue;
                    }
                    if (operand == integerClass) {
                        int value = param.getInt(i);
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: IN param int '" + value + "'");
                        }
                        this.intrinsic.setParameter(i, (Object)new Integer(value));
                        continue;
                    }
                    if (operand == floatClass) {
                        float value = param.getFloat(i);
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: IN param float '" + value + "'");
                        }
                        this.intrinsic.setParameter(i, (Object)new Float(value));
                        continue;
                    }
                    if (operand == doubleClass) {
                        double value = param.getDouble(i);
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: IN param double '" + value + "'");
                        }
                        this.intrinsic.setParameter(i, (Object)new Double(value));
                        continue;
                    }
                    if (operand == longClass) {
                        long value = param.getLong(i);
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: IN param long '" + value + "'");
                        }
                        this.intrinsic.setParameter(i, (Object)new Long(value));
                        continue;
                    }
                    if (operand == voidClass || operand != bytesClass) continue;
                    byte[] value = param.getArgument(i);
                    if (traceMode) {
                        System.out.println(" Elastic COBOL: IN param bytes '" + new String(value) + "'");
                    }
                    this.intrinsic.setParameter(i, (Object)value);
                }
            }
            Object invokeResult = this.intrinsic.invoke();
            if (param != null) {
                if (traceMode) {
                    System.out.println(" Elastic COBOL: Intrinsic Finished, result=" + invokeResult);
                }
                for (int i = 0; i < param.size(); ++i) {
                    try {
                        if (!param.isByReference(i)) continue;
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: OUT convention=" + this.intrinsic.getParameter(i).getHowPassed());
                        }
                        Object result = this.intrinsic.getParameter(i).getParmValue();
                        Class operand = this.intrinsic.getParameterClass(i);
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: OUT class=" + operand + ", data='" + result + "'");
                        }
                        if (operand == shortClass) {
                            short value = (Short)result;
                            if (traceMode) {
                                System.out.println(" Elastic COBOL: OUT param short=" + value);
                            }
                            param.setParameter(i, value);
                            continue;
                        }
                        if (operand == characterClass) {
                            char value = ((Character)result).charValue();
                            if (traceMode) {
                                System.out.println(" Elastic COBOL: OUT param char=" + value);
                            }
                            param.setParameter(i, value);
                            continue;
                        }
                        if (operand == booleanClass) {
                            boolean value = (Boolean)result;
                            if (traceMode) {
                                System.out.println(" Elastic COBOL: OUT param boolean=" + value);
                            }
                            param.setParameter(i, value);
                            continue;
                        }
                        if (operand == integerClass) {
                            int value = (Integer)result;
                            if (traceMode) {
                                System.out.println(" Elastic COBOL: OUT param int=" + value);
                            }
                            param.setParameter(i, value);
                            continue;
                        }
                        if (operand == floatClass) {
                            float value = ((Float)result).floatValue();
                            if (traceMode) {
                                System.out.println(" Elastic COBOL: OUT param float=" + value);
                            }
                            param.setParameter(i, value);
                            continue;
                        }
                        if (operand == doubleClass) {
                            double value = (Double)result;
                            if (traceMode) {
                                System.out.println(" Elastic COBOL: OUT param double=" + value);
                            }
                            param.setParameter(i, value);
                            continue;
                        }
                        if (operand == longClass) {
                            long value = (Long)result;
                            if (traceMode) {
                                System.out.println(" Elastic COBOL: OUT param long=" + value);
                            }
                            param.setParameter(i, value);
                            continue;
                        }
                        if (operand == voidClass || operand != bytesClass) continue;
                        byte[] value = (byte[])result;
                        if (traceMode) {
                            System.out.println(" Elastic COBOL: OUT param bytes='" + new String(value) + "'");
                        }
                        param.setArgumentValue(i, value);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (invokeResult == null) {
                return new Numeric(0);
            }
            Class operand = this.intrinsic.getReturnClass();
            if (traceMode) {
                System.out.println(" Elastic COBOL: return type class=" + operand);
                if (invokeResult != null) {
                    System.out.println(" Elastic COBOL: invokeResult.getClass()=" + invokeResult.getClass());
                }
            }
            if (operand == null) {
                return new Numeric(0);
            }
            if (operand == shortClass) {
                return new Numeric(((Short)invokeResult).shortValue());
            }
            if (operand == characterClass) {
                return new Variable(String.valueOf(((Character)invokeResult).charValue()));
            }
            if (operand == booleanClass) {
                return new Numeric((Boolean)invokeResult != false ? 1 : 0);
            }
            if (operand == integerClass) {
                return new Numeric((Integer)invokeResult);
            }
            if (operand == floatClass) {
                return new Comp1(((Float)invokeResult).floatValue());
            }
            if (operand == doubleClass) {
                return new Comp2((Double)invokeResult);
            }
            if (operand == longClass) {
                return new Long((Long)invokeResult);
            }
            if (operand == voidClass) {
                return new Numeric(0);
            }
            if (operand == bytesClass) {
                return new String((byte[])invokeResult);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Object callGiving() {
        return this.callGiving(null);
    }

    @Override
    public void call() {
        this.callGiving(null);
    }

    @Override
    public void call(parameterList param) {
        this.callGiving(param);
    }

    @Override
    public void cancel() {
    }

    @Override
    public String redirectCall() {
        return null;
    }

    static {
        MPEIntrinsic.setupIntrinsics();
        characterClass = Character.class;
        booleanClass = Boolean.class;
        shortClass = Short.class;
        integerClass = Integer.class;
        longClass = Long.class;
        floatClass = Float.class;
        doubleClass = Double.class;
        voidClass = Void.class;
        bytesClass = byte[].class;
    }
}

