/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Utilities;
import java.applet.Applet;
import java.applet.AudioClip;
import java.net.URL;
import java.util.Vector;

public class MediaAudio {
    public static final int SND_SYNC = 0;
    public static final int SND_ASYNC = 1;
    public static final int SND_LOOP = 8;
    public static final int SND_NOSTOP = 16;
    private static final int SND_MASK = 31;
    private static AudioClip currentAudioClip = null;
    private static Vector<AudioClip> priorAudioClips = new Vector();

    public static boolean isAsync(int status) {
        return (status & 1) != 0;
    }

    public static boolean isLoop(int status) {
        return (status & 8) != 0;
    }

    public static boolean isNoStop(int status) {
        return (status & 0x10) != 0;
    }

    public static final void stop() {
        try {
            if (currentAudioClip != null) {
                currentAudioClip.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            int length = priorAudioClips.size();
            for (int i = 0; i < length; ++i) {
                AudioClip haltSound = priorAudioClips.elementAt(i);
                haltSound.stop();
            }
        }
        catch (Throwable t) {
            priorAudioClips.setSize(0);
        }
    }

    public static final boolean playSound(String soundName, int soundFlags) {
        soundFlags &= 0x1F;
        if (soundName == null && currentAudioClip != null) {
            currentAudioClip.stop();
            currentAudioClip = null;
            return true;
        }
        if (soundName != null && soundName.indexOf("://") < 0) {
            if (Utilities.isApplet()) {
                try {
                    soundName = new URL(Utilities.getDocumentBase(), soundName).toString();
                }
                catch (Throwable throwable) {}
            } else {
                soundName = "file:" + soundName;
            }
        }
        try {
            MediaAudio.playSound12(soundName, soundFlags);
            return true;
        }
        catch (Throwable throwable) {
            try {
                MediaAudio.playSound11(soundName, soundFlags);
                return true;
            }
            catch (Throwable throwable2) {
                return false;
            }
        }
    }

    public static final void playSound11(String soundName, int soundFlags) throws Throwable {
        if (Utilities.isApplet() && soundName != null) {
            if (currentAudioClip != null) {
                if (!MediaAudio.isNoStop(soundFlags)) {
                    MediaAudio.stop();
                } else {
                    priorAudioClips.addElement(currentAudioClip);
                }
                currentAudioClip = null;
            }
            currentAudioClip = Utilities.getApplet().getAppletContext().getAudioClip(new URL(soundName));
            if (MediaAudio.isLoop(soundFlags)) {
                currentAudioClip.loop();
            } else {
                currentAudioClip.play();
            }
        }
        throw new Exception("JDK 1.1 App: No Audio");
    }

    public static final void playSound12(String soundName, int soundFlags) throws Throwable {
        if (Utilities.isApplet()) {
            if (soundName != null) {
                if (currentAudioClip != null) {
                    if (!MediaAudio.isNoStop(soundFlags)) {
                        MediaAudio.stop();
                    } else {
                        priorAudioClips.addElement(currentAudioClip);
                    }
                    currentAudioClip = null;
                }
                currentAudioClip = Utilities.getApplet().getAppletContext().getAudioClip(new URL(soundName));
                if (MediaAudio.isLoop(soundFlags)) {
                    currentAudioClip.loop();
                } else {
                    currentAudioClip.play();
                }
            }
        } else if (soundName != null) {
            if (currentAudioClip != null) {
                if (!MediaAudio.isNoStop(soundFlags)) {
                    MediaAudio.stop();
                } else {
                    priorAudioClips.addElement(currentAudioClip);
                }
                currentAudioClip = null;
            }
            currentAudioClip = Applet.newAudioClip(new URL(soundName));
            if (MediaAudio.isLoop(soundFlags)) {
                currentAudioClip.loop();
            } else {
                currentAudioClip.play();
            }
        }
    }

    public static final void playSound13(String soundName, int soundFlags) throws Throwable {
    }
}

