/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.parameterList;

public class NativeCall
implements ICallableProgramGiving {
    private static final Object syncObject = new Object();
    public static final int PARAMS_RIGHT_TO_LEFT = 0;
    public static final int PARAMS_LEFT_TO_RIGHT = 1;
    public static final int PARAMS_REMOVED_FROM_STACK_BY_CALLER = 0;
    public static final int PARAMS_REMOVED_FROM_STACK_BY_CALLED = 2;
    public static final int RETURN_CODE_UPDATED_ON_EXIT = 0;
    public static final int RETURN_CODE_NOT_UPDATED_ON_EXIT = 4;
    public static final int NORMAL_LINKING_BEHAVIOR = 0;
    public static final int CALL_RESOLVED_AT_LINK_TIME = 8;
    public static final int OS2_OPTLINK = 16;
    public static final int THUNKED_TO_16_BIT = 32;
    public static final int CC_CDECL = 0;
    public static final int NT_STDCALL = 64;
    public static final int CC_UNSAFE = 128;
    private static boolean logMode = false;
    private static boolean initialized;
    private static boolean supported;
    static int defaultCallingConvention;
    private String functionName;
    private int callingConvention = -1;

    private static void addShutdownHook() {
        Shutdown.addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (!supported) {
                    return;
                }
                NativeCall.unloadDefaultLinkage();
            }
        });
    }

    private static void determineLogMode() {
        logMode = RuntimeEnvironment.isGlobalParameter("LOG_NATIVE");
        if (logMode) {
            NativeCall.log("logging enabled for native calls");
        }
    }

    private static void log(String s) {
        if (!logMode) {
            return;
        }
        System.out.println("log.native: java: " + s);
    }

    private static synchronized boolean initialize() {
        block7: {
            if (initialized) {
                return supported;
            }
            initialized = true;
            if (logMode) {
                NativeCall.log("initialize()");
            }
            try {
                NativeCall.addShutdownHook();
                supported = true;
                NativeCall.loadDefaultLinkage();
            }
            catch (Throwable cannotLoadLibrary) {
                if (!logMode) break block7;
                NativeCall.log("could not load successfully, " + cannotLoadLibrary);
                try {
                    NativeCall.log("java.library.path='" + System.getProperty("java.library.path") + "'");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cannotLoadLibrary.printStackTrace(System.out);
            }
        }
        if (logMode) {
            NativeCall.log("returning that native calling is supported");
        }
        return supported;
    }

    public static boolean isSupported() {
        NativeCall.initialize();
        return supported;
    }

    public static void loadDefaultLinkage() {
        if (!supported) {
            return;
        }
        if (logMode) {
            NativeCall.log("loading default linkage");
        }
        try {
            String temp = RuntimeEnvironment.getGlobalParameter("DLL-LINK");
            String load = null;
            if (temp != null) {
                int strtIdx = 0;
                int index = -1;
                do {
                    load = (index = temp.indexOf(44, index + 1)) < 0 ? temp.substring(strtIdx) : temp.substring(strtIdx, index);
                    if ((load = load.trim()).length() > 0) {
                        new NativeCall(load).call();
                    }
                    strtIdx = index + 1;
                } while (index >= 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (logMode) {
            NativeCall.log("loading default linkage done");
        }
    }

    public static void unloadDefaultLinkage() {
        if (!supported) {
            return;
        }
        if (logMode) {
            NativeCall.log("unloading default linkage");
        }
        try {
            String temp = RuntimeEnvironment.getGlobalParameter("DLL-LINK");
            String load = null;
            if (temp != null) {
                int strtIdx = 0;
                int index = -1;
                do {
                    load = (index = temp.indexOf(44, index + 1)) < 0 ? temp.substring(strtIdx) : temp.substring(strtIdx, index);
                    if ((load = load.trim()).length() > 0) {
                        new NativeCall(load).cancel();
                    }
                    strtIdx = index + 1;
                } while (index >= 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (logMode) {
            NativeCall.log("unloading default linkage done");
        }
    }

    private static void determineCallingConvention() {
        try {
            String temp = RuntimeEnvironment.getGlobalParameter("DLL-CONVENTION");
            if (temp != null) {
                int acuCallingConvention = ConvertData.parseInt(temp);
                if (acuCallingConvention == 0) {
                    defaultCallingConvention = 0;
                } else if (acuCallingConvention == 1) {
                    defaultCallingConvention = 64;
                } else if (acuCallingConvention == 2) {
                    defaultCallingConvention = 128;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isFound(String name, int callingConvention) {
        try {
            boolean result;
            int callingConvention2;
            if (logMode) {
                NativeCall.log("is '" + name + "' found?");
            }
            int n = callingConvention2 = callingConvention < 0 ? defaultCallingConvention : callingConvention;
            callingConvention2 = callingConvention2 < 0 ? (RuntimeEnvironment.isWindows() ? 64 : 0) : callingConvention;
            int isFound = NativeCall.is_found(name, callingConvention2);
            boolean bl = result = isFound != -1;
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("name=" + name + ". callingConvention=" + callingConvention + ". callingConvention2=" + callingConvention2 + ". isFound=" + isFound + ". defaultCallingConvention=" + defaultCallingConvention + ". ");
            }
            if (logMode) {
                NativeCall.log("is '" + name + "' found? " + result);
            }
            return result;
        }
        catch (Throwable is_found_not_found) {
            if (logMode) {
                NativeCall.log("is '" + name + "' found? could not call native function, " + is_found_not_found);
            }
            return false;
        }
    }

    private void setCallingConvention(int convention) {
        this.callingConvention = convention;
    }

    public int getCallingConvention() {
        return this.callingConvention;
    }

    private void setFunctionName(String value) {
        this.functionName = value;
    }

    public NativeCall(String functionName) {
        this(functionName, -1);
    }

    public NativeCall(String functionName, int callingConvention) {
        this.setCallingConvention(callingConvention < 0 ? (defaultCallingConvention < 0 ? (RuntimeEnvironment.isWindows() ? 64 : 0) : defaultCallingConvention) : callingConvention);
        this.setFunctionName(functionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callGiving() {
        Object object = syncObject;
        synchronized (object) {
            if (logMode) {
                NativeCall.log("Calling native function '" + this.functionName + "' with giving");
            }
            try {
                long result = this.native_call_long(this.functionName, this.callingConvention, 0, null);
                if (NativeCall.isPreviousMissing()) {
                    if (logMode) {
                        NativeCall.log("Calling native function '" + this.functionName + "': missing");
                    }
                    throw new RuntimeException("Native Function Not Found");
                }
                if (logMode) {
                    NativeCall.log("Calling native function '" + this.functionName + "': " + result + " done");
                }
                return new Numeric(result);
            }
            catch (UnsatisfiedLinkError ex) {
                if (logMode) {
                    NativeCall.log("Failed native_call_long calling native function '" + this.functionName + "' with giving");
                }
                return new Numeric(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call() {
        Object object = syncObject;
        synchronized (object) {
            block9: {
                if (logMode) {
                    NativeCall.log("Calling native function '" + this.functionName + "'");
                }
                try {
                    this.native_call_long(this.functionName, this.callingConvention, 0, null);
                    if (NativeCall.isPreviousMissing()) {
                        if (logMode) {
                            NativeCall.log("Calling native function '" + this.functionName + "': missing");
                        }
                        throw new RuntimeException("Native Function Not Found");
                    }
                    if (logMode) {
                        NativeCall.log("Calling native function '" + this.functionName + "' done");
                    }
                }
                catch (UnsatisfiedLinkError ex) {
                    if (!logMode) break block9;
                    NativeCall.log("Failed native_call_long calling native function '" + this.functionName + "' with giving");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callGiving(parameterList param) {
        Object object = syncObject;
        synchronized (object) {
            int param_size;
            if (logMode) {
                NativeCall.log("Calling native param function '" + this.functionName + "' with giving");
            }
            int n = param_size = param != null ? param.getLength() : 0;
            if (param_size > 48) {
                System.err.println("***Elastic COBOL runtime error: Native call parameter limit exceeded. Contact Heirloom support!");
                System.exit(16);
            }
            try {
                long result = this.native_call_long(this.functionName, this.callingConvention, param_size, param);
                if (NativeCall.isPreviousMissing()) {
                    if (logMode) {
                        NativeCall.log("Calling native function '" + this.functionName + "': missing");
                    }
                    throw new RuntimeException("Native Function Not Found");
                }
                if (logMode) {
                    NativeCall.log("Calling native function '" + this.functionName + "': " + result + " done");
                }
                return new Numeric(result);
            }
            catch (UnsatisfiedLinkError ex) {
                if (logMode) {
                    NativeCall.log("Failed native_call_long calling native function '" + this.functionName + "' with giving");
                }
                return new Numeric(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(parameterList param) {
        Object object = syncObject;
        synchronized (object) {
            block10: {
                int param_size;
                if (logMode) {
                    NativeCall.log("Calling native param function '" + this.functionName + "'");
                }
                int n = param_size = param != null ? param.getLength() : 0;
                if (param_size > 48) {
                    System.err.println("***Warning***");
                    System.err.println("Native call parameter limit exceeded. Contact Heirloom support!");
                }
                try {
                    this.native_call_long(this.functionName, this.callingConvention, param_size, param);
                    if (NativeCall.isPreviousMissing()) {
                        if (logMode) {
                            NativeCall.log("Calling native function '" + this.functionName + "': missing");
                        }
                        throw new RuntimeException("Native Function Not Found");
                    }
                    if (logMode) {
                        NativeCall.log("Calling native function '" + this.functionName + "' done");
                    }
                }
                catch (UnsatisfiedLinkError ex) {
                    if (!logMode) break block10;
                    NativeCall.log("Failed native_call_long calling native function '" + this.functionName + "' with giving");
                }
            }
        }
    }

    @Override
    public void cancel() {
        block3: {
            try {
                if (logMode) {
                    NativeCall.log("Cancelling native function '" + this.functionName + "'");
                }
                this.native_cancel(this.functionName, this.callingConvention);
            }
            catch (UnsatisfiedLinkError ex) {
                if (!logMode) break block3;
                NativeCall.log("Failed native_cancel calling native function '" + this.functionName + "' with giving");
            }
        }
    }

    @Override
    public String redirectCall() {
        return null;
    }

    private static boolean isPreviousMissing() {
        try {
            return NativeCall.is_found(null, -1) <= 0;
        }
        catch (UnsatisfiedLinkError ex) {
            if (logMode) {
                NativeCall.log("Failed is_found()");
            }
            return true;
        }
    }

    private static native int is_found(String var0, int var1);

    private native long native_call_long(String var1, int var2, int var3, parameterList var4);

    private native void native_cancel(String var1, int var2);

    static {
        defaultCallingConvention = -1;
        NativeCall.determineLogMode();
        NativeCall.determineCallingConvention();
    }
}

