/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ArrayIndexOutOfBoundsVariable;
import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.Cache;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.DisplayMVS;
import com.heirloomcomputing.ecs.exec.DisplayP;
import com.heirloomcomputing.ecs.exec.Index;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.NumericSubscript;
import com.heirloomcomputing.ecs.exec.PackedDecimalI;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public class Numeric
extends Variable
implements Cloneable,
comparableByteArray {
    private static final long serialVersionUID = 1L;
    private String origNumString;
    public static boolean onSizeErrorCond = false;
    public static final Numeric conditionCode = new Numeric();
    public static final Numeric tally = new Numeric();
    public static final Numeric ZERO = new Numeric();
    protected Bignum value;
    private static final String spacesString = "                                                                                                ";

    public Numeric() {
        this.flagBits |= 0x4000000;
        this.value = new Bignum();
    }

    public Numeric(String setPic, String setValue) {
        super(setPic, setValue);
        this.flagBits |= 0x4000000;
        this.value = new Bignum(this.quickNumeric(setValue));
    }

    public Numeric(Bignum param) {
        this.flagBits |= 0x4000000;
        this.value = new Bignum(param);
    }

    public Numeric(boolean dummy, Bignum param) {
        this.flagBits |= 0x4000000;
        this.value = param;
    }

    public Numeric(String param) {
        this.flagBits |= 0x4000000;
        this.setOrigNumString(param);
        this.value = new Bignum(this.quickNumeric(param));
    }

    public Numeric(Index param) {
        this.flagBits |= 0x4000000;
        this.value = new Bignum(param.toInt());
    }

    public Numeric(int param) {
        this.flagBits |= 0x4000000;
        this.value = new Bignum(param);
    }

    public Numeric(boolean param) {
        this.flagBits |= 0x4000000;
        this.value = new Bignum(param ? 1 : 0);
    }

    public Numeric(long param) {
        this.flagBits |= 0x4000000;
        this.value = new Bignum(param);
    }

    public Numeric(double param) {
        this.flagBits |= 0x4000000;
        this.value = new Bignum(param);
    }

    public Numeric(char param) {
        this.flagBits |= 0x4000000;
        this.value = new Bignum(param);
    }

    public Numeric(Numeric param) {
        this.flagBits |= 0x4000000;
        this.value = param.toModifyBignum();
        if (param.isSizeError()) {
            this.setSizeError();
        }
    }

    public final NumericSubscript createNumericArray(int dimensions) {
        int[] siz = this.createArraySiz(dimensions);
        int[] dim = this.createArrayDim(dimensions);
        if (siz == null) {
            return null;
        }
        NumericSubscript vs = new NumericSubscript(this, dim, siz);
        this.setSubscriptChild(vs);
        return vs;
    }

    public final NumericSubscript createNumericArray(int dimensions, NumericSubscript redefinedFrom) {
        int[] siz = this.createArraySiz(dimensions);
        int[] dim = this.createArrayDim(dimensions);
        if (siz == null) {
            return null;
        }
        NumericSubscript vs = new NumericSubscript(this, dim, siz, redefinedFrom);
        this.setSubscriptChild(vs);
        return vs;
    }

    @Override
    public final boolean isNumericInstance() {
        return true;
    }

    @Override
    public int getStorageClass() {
        return 0;
    }

    @Override
    public boolean isZero() {
        return this.value.isZero();
    }

    public int compareZero() {
        return this.value.signum();
    }

    @Override
    public int compareSpaces() {
        return this.compareZero();
    }

    public boolean isNaN() {
        return false;
    }

    public void setNaN() {
    }

    public boolean isNegativeInfinity() {
        return false;
    }

    public void setNegativeInfinity() {
    }

    public boolean isPositiveInfinity() {
        return false;
    }

    public void setPositiveInfinity() {
    }

    public boolean isInfinite() {
        return this.isPositiveInfinity() || this.isNegativeInfinity();
    }

    public void setInfinite() {
        this.setPositiveInfinity();
    }

    public Numeric add(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value.adding(param.toBignum());
        this.numericString = null;
        return this;
    }

    public Numeric add(Bignum param) {
        this.value.adding(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable add(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().add(param2.toBignum());
        this.numericString = null;
        return this;
    }

    @Override
    public Variable add(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.add(param2.toBignum());
        this.numericString = null;
        return this;
    }

    @Override
    public Variable add(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().add(param2);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable add(Bignum param1, Bignum param2) {
        this.value = param1.add(param2);
        this.numericString = null;
        return this;
    }

    private final String quickNumeric(String param) {
        int len = param.length() - 1;
        if (param.charAt(len) != '-') {
            return param;
        }
        return "-" + param.substring(0, len);
    }

    protected final comparableByteArray copyVariable() {
        return super.copy();
    }

    @Override
    public comparableByteArray copy() {
        return new Numeric(this);
    }

    public Numeric add(int param1) {
        if (this.isSizeError()) {
            return this;
        }
        this.value.adding(param1);
        this.numericString = null;
        return this;
    }

    public Numeric add(Index param1) {
        return this.add(param1.toInt());
    }

    public Numeric add(int param1, int param2) {
        this.value.make(param1 + param2);
        this.numericString = null;
        return this;
    }

    public Numeric add(Index param1, int param2) {
        return this.add(param1.toInt(), param2);
    }

    public Numeric add(int param1, Index param2) {
        return this.add(param1, param2.toInt());
    }

    public Numeric add(Index param1, Index param2) {
        return this.add(param1.toInt(), param2.toInt());
    }

    public static Comp1 addGiving(Comp1 param1, Comp1 param2) {
        return new Comp1(param1.toFloat() + param2.toFloat());
    }

    public static Comp2 addGiving(Comp1 param1, Comp2 param2) {
        return new Comp2((double)param1.toFloat() + param2.toDouble());
    }

    public static Comp2 addGiving(Comp2 param1, Comp1 param2) {
        return new Comp2(param1.toDouble() + (double)param2.toFloat());
    }

    public static Comp2 addGiving(Comp2 param1, Comp2 param2) {
        return new Comp2(param1.toDouble() + param2.toDouble());
    }

    public static Numeric addGiving(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        return new Numeric(true, param1.toBignum().add(param2.toBignum()));
    }

    public static Numeric addGiving(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        return new Numeric(true, param1.toBignum().add(param2));
    }

    public static Numeric addGiving(Numeric param1, Index param2) {
        if (param1.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        return new Numeric(true, param1.toBignum().add(param2.toInt()));
    }

    public static Numeric addGiving(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        return new Numeric(true, param1.add(param2.toBignum()));
    }

    public static Numeric addGiving(Bignum param1, Bignum param2) {
        return new Numeric(true, param1.add(param2));
    }

    public static Numeric addGiving(Bignum param1, Index param2) {
        return new Numeric(true, param1.add(param2.toInt()));
    }

    public static Numeric addGiving(Index param1, Numeric param2) {
        if (param2.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        return new Numeric(true, param2.toBignum().add(param1.toInt()));
    }

    public static Numeric addGiving(Index param1, Bignum param2) {
        return new Numeric(true, param2.add(param1.toInt()));
    }

    public static Numeric addGiving(Index param1, Index param2) {
        return new Numeric(param1.toInt() + param2.toInt());
    }

    public Numeric addRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value.adding(param.toBignum());
        this.numericString = null;
        return this;
    }

    public Numeric addRounded(Bignum param) {
        this.value.adding(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable addRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().add(param2.toBignum());
        this.numericString = null;
        return this;
    }

    @Override
    public Variable addRounded(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.add(param2.toBignum());
        this.numericString = null;
        return this;
    }

    @Override
    public Variable addRounded(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().add(param2);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable addRounded(Bignum param1, Bignum param2) {
        this.value = param1.add(param2);
        this.numericString = null;
        return this;
    }

    public Numeric sub(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value.subtracting(param.toBignum());
        this.numericString = null;
        return this;
    }

    public Numeric sub(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().subtract(param2.toBignum());
        this.numericString = null;
        return this;
    }

    public static Comp1 subGiving(Comp1 param1, Comp1 param2) {
        return new Comp1(param1.toFloat() - param2.toFloat());
    }

    public static Comp2 subGiving(Comp1 param1, Comp2 param2) {
        return new Comp2((double)param1.toFloat() - param2.toDouble());
    }

    public static Comp2 subGiving(Comp2 param1, Comp1 param2) {
        return new Comp2(param1.toDouble() - (double)param2.toFloat());
    }

    public static Comp2 subGiving(Comp2 param1, Comp2 param2) {
        return new Comp2(param1.toDouble() - param2.toDouble());
    }

    public static Numeric subGiving(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        return new Numeric(true, param1.toBignum().subtract(param2.toBignum()));
    }

    public static Numeric negateGiving(Numeric param) {
        if (param.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        return param.negate();
    }

    public Numeric negate() {
        return new Numeric(true, this.value.negate());
    }

    public Numeric subRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value.subtracting(param.toBignum());
        this.numericString = null;
        return this;
    }

    public Numeric subRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().subtract(param2.toBignum());
        this.numericString = null;
        return this;
    }

    public Numeric mul(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum paramValue = param.toBignum();
        this.value.multiplying(paramValue);
        this.numericString = null;
        return this;
    }

    public Numeric mul(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().multiply(param2.toBignum());
        this.numericString = null;
        return this;
    }

    public static Comp1 mulGiving(Comp1 param1, Comp1 param2) {
        return new Comp1(param1.toFloat() * param2.toFloat());
    }

    public static Comp2 mulGiving(Comp1 param1, Comp2 param2) {
        return new Comp2((double)param1.toFloat() * param2.toDouble());
    }

    public static Comp2 mulGiving(Comp2 param1, Comp1 param2) {
        return new Comp2(param1.toDouble() * (double)param2.toFloat());
    }

    public static Comp2 mulGiving(Comp2 param1, Comp2 param2) {
        return new Comp2(param1.toDouble() * param2.toDouble());
    }

    public static Numeric mulGiving(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        return new Numeric(true, param1.toBignum().multiply(param2.toBignum()));
    }

    public Numeric mulRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum paramValue = param.toBignum();
        this.value.multiplying(paramValue);
        this.numericString = null;
        return this;
    }

    public Numeric mulRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().multiply(param2.toBignum());
        this.numericString = null;
        return this;
    }

    public Numeric div(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum dividend = param.toBignum();
        if (dividend.isZero()) {
            this.setSizeError();
            return this;
        }
        this.value.dividing(dividend);
        this.numericString = null;
        return this;
    }

    public Numeric div(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().divide(dividend);
        this.numericString = null;
        return this;
    }

    public static Comp1 divGiving(Comp1 param1, Comp1 param2) {
        float dividend = param2.toFloat();
        if ((double)dividend == 0.0) {
            return (Comp1)new Comp1(0.0f).setSizeError();
        }
        return new Comp1(param1.toFloat() / dividend);
    }

    public static Comp2 divGiving(Comp1 param1, Comp2 param2) {
        double dividend = param2.toDouble();
        if (dividend == 0.0) {
            return (Comp2)new Comp2(0.0).setSizeError();
        }
        return new Comp2((double)param1.toFloat() / dividend);
    }

    public static Comp2 divGiving(Comp2 param1, Comp1 param2) {
        float dividend = param2.toFloat();
        if ((double)dividend == 0.0) {
            return (Comp2)new Comp2(0.0).setSizeError();
        }
        return new Comp2(param1.toDouble() / (double)dividend);
    }

    public static Comp2 divGiving(Comp2 param1, Comp2 param2) {
        double dividend = param2.toDouble();
        if (dividend == 0.0) {
            return (Comp2)new Comp2(0.0).setSizeError();
        }
        return new Comp2(param1.toDouble() / dividend);
    }

    public static Numeric divGiving(Numeric param1, Numeric param2) {
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            return (Numeric)new Numeric().setSizeError();
        }
        return new Numeric(true, param1.toBignum().divide(dividend));
    }

    public Numeric divRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum dividend = param.toBignum();
        if (dividend.isZero()) {
            this.setSizeError();
            return this;
        }
        this.value.dividing(dividend);
        this.numericString = null;
        return this;
    }

    public Numeric divRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().divide(dividend);
        this.numericString = null;
        return this;
    }

    public Numeric mod(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum dividend = param.toBignum();
        if (dividend.isZero()) {
            this.setSizeError();
            return this;
        }
        this.value.remaindering(dividend);
        this.numericString = null;
        return this;
    }

    public Numeric mod(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().remainder(dividend);
        this.numericString = null;
        return this;
    }

    public static Comp1 modGiving(Comp1 param1, Comp1 param2) {
        float dividend = param2.toFloat();
        if ((double)dividend == 0.0) {
            return (Comp1)new Comp1(0.0f).setSizeError();
        }
        return new Comp1(param1.toFloat() % dividend);
    }

    public static Comp2 modGiving(Comp1 param1, Comp2 param2) {
        double dividend = param2.toDouble();
        if (dividend == 0.0) {
            return (Comp2)new Comp2(0.0f).setSizeError();
        }
        return new Comp2((double)param1.toFloat() % dividend);
    }

    public static Comp2 modGiving(Comp2 param1, Comp1 param2) {
        float dividend = param2.toFloat();
        if ((double)dividend == 0.0) {
            return (Comp2)new Comp2(0.0f).setSizeError();
        }
        return new Comp2(param1.toDouble() % (double)dividend);
    }

    public static Comp2 modGiving(Comp2 param1, Comp2 param2) {
        double dividend = param2.toDouble();
        if (dividend == 0.0) {
            return (Comp2)new Comp2(0.0f).setSizeError();
        }
        return new Comp2(param1.toDouble() % dividend);
    }

    public static Numeric modGiving(Numeric param1, Numeric param2) {
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            return (Numeric)new Numeric().setSizeError();
        }
        return new Numeric(true, param1.toBignum().remainder(dividend));
    }

    public Numeric rem(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum dividend = param.toBignum();
        if (dividend.isZero()) {
            this.setSizeError();
            return this;
        }
        this.value.remaindering(dividend);
        this.numericString = null;
        return this;
    }

    public Numeric rem(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().remainder(dividend);
        this.numericString = null;
        return this;
    }

    public static Comp1 remGiving(Comp1 param1, Comp1 param2) {
        float dividend = param2.toFloat();
        if ((double)dividend == 0.0) {
            return (Comp1)new Comp1(0.0f).setSizeError();
        }
        return new Comp1(param1.toFloat() % dividend);
    }

    public static Comp2 remGiving(Comp1 param1, Comp2 param2) {
        double dividend = param2.toDouble();
        if (dividend == 0.0) {
            return (Comp2)new Comp2(0.0f).setSizeError();
        }
        return new Comp2((double)param1.toFloat() % dividend);
    }

    public static Comp2 remGiving(Comp2 param1, Comp1 param2) {
        float dividend = param2.toFloat();
        if ((double)dividend == 0.0) {
            return (Comp2)new Comp2(0.0f).setSizeError();
        }
        return new Comp2(param1.toDouble() % (double)dividend);
    }

    public static Comp2 remGiving(Comp2 param1, Comp2 param2) {
        double dividend = param2.toDouble();
        if (dividend == 0.0) {
            return (Comp2)new Comp2(0.0f).setSizeError();
        }
        return new Comp2(param1.toDouble() % dividend);
    }

    public static Numeric remGiving(Numeric param1, Numeric param2) {
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            return (Numeric)new Numeric().setSizeError();
        }
        return new Numeric(true, param1.toBignum().remainder(dividend));
    }

    public static Numeric remGiving(Numeric param1, Numeric param2, Numeric quotient) {
        if (param1.isSizeError() || param2.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            return new Numeric().setNumericSizeError();
        }
        return Numeric.subGiving(param1, Numeric.mulGiving(quotient, param2));
    }

    public static Numeric remGiving(Numeric param1, Numeric param2, Variable quotient) {
        if (param1.isSizeError() || param2.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        Bignum dividend = param2.toBignum();
        if (dividend.isZero()) {
            return new Numeric().setNumericSizeError();
        }
        return Numeric.subGiving(param1, Numeric.mulGiving(new Numeric(quotient.toBignum()), param2));
    }

    public Numeric pow(Numeric param) {
        if (param.isSizeError()) {
            return new Numeric().setNumericSizeError();
        }
        this.value.powing(param.toBignum());
        this.numericString = null;
        return this;
    }

    public Numeric pow(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().pow(param2.toBignum());
        this.numericString = null;
        return this;
    }

    public static Comp1 powGiving(Comp1 param1, Comp1 param2) {
        return new Comp1(Math.pow(param1.toDouble(), param2.toDouble()));
    }

    public static Comp2 powGiving(Comp1 param1, Comp2 param2) {
        return new Comp2(Math.pow(param1.toDouble(), param2.toDouble()));
    }

    public static Comp2 powGiving(Comp2 param1, Comp1 param2) {
        return new Comp2(Math.pow(param1.toDouble(), param2.toDouble()));
    }

    public static Comp2 powGiving(Comp2 param1, Comp2 param2) {
        return new Comp2(Math.pow(param1.toDouble(), param2.toDouble()));
    }

    public static Numeric powGiving(Numeric param1, Numeric param2) {
        return new Numeric(Math.pow(param1.toDouble(), param2.toDouble()));
    }

    public Numeric powRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value.powing(param.toBignum());
        this.numericString = null;
        return this;
    }

    public Numeric powRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.value = param1.toBignum().pow(param2.toBignum());
        this.numericString = null;
        return this;
    }

    public boolean isBetween(Numeric param1, Numeric param2) {
        return this.compare(param1) >= 0 && this.compare(param2) <= 0;
    }

    @Override
    void performNumericValidation(Object obj) {
        if (((Numeric)obj).value.requiresNumericValidate()) {
            if (obj instanceof DisplayP) {
                ((DisplayP)obj).checkNumericContent();
            } else if (obj instanceof DisplayMVS) {
                ((DisplayMVS)obj).checkNumericContent();
            } else if (obj instanceof PackedDecimalI) {
                ((PackedDecimalI)obj).checkNumericContent();
            }
        }
    }

    @Override
    public int compare(Numeric param) {
        this.performNumericValidation(this);
        this.performNumericValidation(param);
        Bignum thisBignum = this.toBignum();
        Bignum thatBignum = param.toBignum();
        if (thisBignum.isiAmNotNumeric() || thatBignum.isiAmNotNumeric()) {
            return this.compare(param.toString());
        }
        return this.value.compareTo(thatBignum);
    }

    @Override
    public int compare(Numeric param, String alphabet) {
        this.toBignum();
        return this.value.compareTo(param.toBignum());
    }

    @Override
    public int compare(int x, String alphabet) {
        int temp = this.value.intValue();
        if (temp < x) {
            return -1;
        }
        if (temp > x) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(Variable param) {
        if (param == Variable.LOW_VALUES) {
            if (Arrays.equals(this.getBytes(), new byte[this.length()])) {
                return 0;
            }
            return 1;
        }
        this.performNumericValidation(this);
        if (param.isTypeNumeric()) {
            this.performNumericValidation((Numeric)param);
        }
        if (param.isSpecial()) {
            return super.compare(param);
        }
        if (!param.isTypeNumericEdited()) {
            if (this.toBignum().isiAmNotNumeric() || param.toBignum().isiAmNotNumeric()) {
                return this.compare(param.toString());
            }
            return super.compare(param);
        }
        this.toBignum();
        return this.value.compareTo(param.toBignum());
    }

    @Override
    public int compare(Comp1 param) {
        int rc = param.compare(this);
        if (rc < 0) {
            return 1;
        }
        if (rc > 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compare(Comp2 param) {
        int rc = param.compare(this);
        if (rc < 0) {
            return 1;
        }
        if (rc > 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public char toChar() {
        return (char)this.value.intValue();
    }

    @Override
    public byte toByte() {
        return (byte)this.value.intValue();
    }

    @Override
    public short toShort() {
        return (short)this.value.intValue();
    }

    @Override
    public int toInt() {
        return this.value.intValue();
    }

    @Override
    public long toLong() {
        return this.value.longValue();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public int lengthNational() {
        return this.getAcceptSize();
    }

    @Override
    public int getAcceptSize() {
        return 22;
    }

    @Override
    public String toNationalString() {
        String result = this.toDisplayString();
        if (result == null) {
            return null;
        }
        int maxSize = this.getAcceptSize();
        if (maxSize > result.length()) {
            if ((maxSize -= result.length()) > 31) {
                maxSize = 31;
            }
            return spacesString.substring(0, maxSize) + result;
        }
        return result;
    }

    @Override
    public String toNationalString(int fieldSize) {
        String result = this.toNationalString();
        if (result == null) {
            return result;
        }
        if (fieldSize <= 0 || fieldSize > 159) {
            return result;
        }
        int resultLength = result.length();
        if (fieldSize < resultLength) {
            return result.substring(resultLength - fieldSize);
        }
        if (fieldSize == resultLength) {
            return result;
        }
        return Variable.all(' ', fieldSize - resultLength) + result;
    }

    @Override
    public Bignum toBignum() {
        if (this.redefinedFrom != null && this.redefinedFrom instanceof DataPointer) {
            return new Bignum(((DataPointer)this.redefinedFrom).getPointerAddress());
        }
        return this.value;
    }

    @Override
    public Bignum toModifyBignum() {
        if (this.redefinedFrom != null && this.redefinedFrom instanceof DataPointer) {
            return new Bignum(((DataPointer)this.redefinedFrom).getPointerAddress());
        }
        return new Bignum(this.value);
    }

    @Override
    public float toFloat() {
        return this.value.floatValue();
    }

    @Override
    public double toDouble() {
        return this.value.doubleValue();
    }

    @Override
    public boolean toBoolean() {
        return !this.value.isZero();
    }

    @Override
    public String toNumericString() {
        if (this.numericString != null) {
            return this.numericString;
        }
        if (this.alwaysFlush) {
            return this.value.toString();
        }
        this.numericString = this.value.toString();
        return this.numericString;
    }

    @Override
    public String toScalelessString() {
        return this.value.toString();
    }

    @Override
    public Variable moveZeroes() {
        return this.move(0);
    }

    @Override
    public Variable moveAll(char param) {
        super.moveAll(param);
        this.numericString = null;
        this.valid = false;
        this.dirty = false;
        return this;
    }

    @Override
    public Variable move(char param) {
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(byte param) {
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(short param) {
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(int param) {
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(long param) {
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(String param) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("param=" + param + ". getName()=" + this.getName() + ". ");
        }
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable moveNational(String param) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("param=" + param + ". getName()=" + this.getName() + ". ");
        }
        return this.move(param);
    }

    @Override
    public Variable move(char[] param) {
        this.value.make(param, param.length);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(char[] param, int length) {
        this.value.make(param, length);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(char[] param, int offset, int length) {
        this.value.make(param, offset, length);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(byte[] param) {
        this.value.make(param, param.length);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(byte[] param, int length) {
        this.value.make(param, length);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(byte[] param, int offset, int length) {
        this.value.make(param, offset, length);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(Bignum param) {
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(float param) {
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(double param) {
        this.value.make(param);
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(Numeric param) {
        this.value = param.toModifyBignum();
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(Variable param) {
        this.value = param.toModifyBignum();
        this.numericString = null;
        return this;
    }

    @Override
    public Variable move(Index x) {
        return this.move(x.toInt());
    }

    @Override
    public Variable move(boolean param) {
        return this.move(param ? 1 : 0);
    }

    public Numeric floor() {
        this.value.floor();
        return this;
    }

    public Numeric ceil() {
        this.value.ceil();
        return this;
    }

    @Override
    public String toDisplayString() {
        return this.value.toString();
    }

    protected String massageFloatString(String param) {
        int length = param.length();
        boolean negative = false;
        boolean decimalFound = false;
        boolean digitFound = false;
        boolean efound = false;
        char[] result = new char[length + 1];
        int resultCounter = 1;
        result[0] = 45;
        char decimalPoint = this.getDecimal();
        for (int i = 0; i < length; ++i) {
            char c = param.charAt(i);
            if (!(c != 'e' && c != 'E' || efound)) {
                efound = true;
                result[resultCounter++] = 101;
                continue;
            }
            if (c == '-') {
                if (efound) {
                    result[resultCounter++] = 45;
                    continue;
                }
                negative = true;
                continue;
            }
            if (c == decimalPoint) {
                if (decimalFound) continue;
                result[resultCounter++] = 46;
                decimalFound = true;
                continue;
            }
            if (c >= '0' && c <= '9') {
                result[resultCounter++] = c;
                digitFound = true;
                continue;
            }
            if ((c & 0x40) != 64) continue;
            negative = true;
            if ((c = (char)(c & 0x3F)) < '0' || c > '9') continue;
            result[resultCounter++] = c;
            digitFound = true;
        }
        if (!digitFound) {
            return "0";
        }
        return negative ? new String(result, 0, resultCounter) : new String(result, 1, resultCounter - 1);
    }

    public boolean isFloat() {
        return false;
    }

    private Numeric numericElement(int[] usingIndex) {
        int i;
        Object[] tmpa = this.arrayChild;
        for (i = 0; i < usingIndex.length - 1; ++i) {
            Object tmpo = tmpa[usingIndex[i]];
            if (!(tmpo instanceof Object[])) {
                return null;
            }
            tmpa = (Object[])tmpo;
        }
        return (Numeric)tmpa[usingIndex[i]];
    }

    @Override
    public Numeric numericSubscript(int[] usingIndex) {
        try {
            Numeric result = (Numeric)this.clone();
            int dimension = usingIndex.length - 1;
            Variable temp = this;
            int offset = this.pointerAddress;
            while (true) {
                int dimension_subscript;
                Numeric closestNumericRedef = null;
                while (temp != null && temp.maxIndex <= 1 && !temp.isArray()) {
                    if (closestNumericRedef == null && temp.redefinedFrom != null && temp.redefinedFrom instanceof Numeric) {
                        closestNumericRedef = (Numeric)temp.redefinedFrom;
                    }
                    temp = temp.parent;
                }
                if (temp == null) {
                    String name = this.getName();
                    name = name != null ? " on " + name : "";
                    CobolException.runtimeError("Table Subscript has illegal depth" + name, null);
                    return null;
                }
                if ((dimension_subscript = usingIndex[dimension--] - 1) >= temp.maxIndex || dimension_subscript < 0) {
                    String name = this.getName();
                    name = name != null ? " on " + name : "";
                    CobolException.runtimeError("Illegal Table Subscript " + (dimension_subscript + 1) + " for size " + temp.maxIndex + name);
                    return null;
                }
                offset += dimension_subscript * temp.itemSize;
                if (dimension < 0) {
                    result.setAddress(offset);
                    result.setTableElement();
                    if (Cache.forbid) {
                        if (this.arrayChild != null) {
                            result.redefinedFrom = this.numericElement(usingIndex);
                        } else if (this.redefinedFrom != null) {
                            result.redefinedFrom = this.redefinedFrom;
                        }
                        if (result.redefinedFrom == null && closestNumericRedef != null) {
                            result.redefinedFrom = closestNumericRedef.arrayChild != null ? closestNumericRedef.numericElement(usingIndex) : closestNumericRedef;
                            if (result.redefinedFrom != null) {
                                if (result.redefinedFrom.redefinedTo == null) {
                                    result.redefinedFrom.redefinedTo = new ArrayList(1);
                                }
                                result.redefinedFrom.redefinedTo.add(result);
                            }
                        }
                        result.dirty = false;
                        result.valid = false;
                    }
                    return result;
                }
                temp = temp.parent;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Numeric numericSubscript(int n1) {
        return this.numericSubscript(new int[]{n1});
    }

    @Override
    public Numeric numericSubscript(int n1, int n2) {
        return this.numericSubscript(new int[]{n1, n2});
    }

    @Override
    public Numeric numericSubscript(int n1, int n2, int n3) {
        return this.numericSubscript(new int[]{n1, n2, n3});
    }

    @Override
    public Numeric numericSubscript(int n1, int n2, int n3, int n4) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4});
    }

    @Override
    public Numeric numericSubscript(int n1, int n2, int n3, int n4, int n5) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4, n5});
    }

    @Override
    public Numeric numericSubscript(int n1, int n2, int n3, int n4, int n5, int n6) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4, n5, n6});
    }

    @Override
    public Numeric numericSubscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4, n5, n6, n7});
    }

    @Override
    public Numeric numericSubscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4, n5, n6, n7, n8});
    }

    @Override
    public String toInspectString() {
        return this.toDisplayString();
    }

    @Override
    protected String toCompareString() {
        String valueString = this.value.toString();
        int i = valueString.indexOf(46);
        if (i > 0) {
            valueString = valueString.substring(0, i);
        } else if (i == 0) {
            valueString = "0";
        }
        if (memoryCharset != null) {
            valueString = new String(valueString.getBytes(memoryCharset), defaultCharset);
        }
        return valueString;
    }

    @Override
    public Object getObjectParameter() {
        return this.toBigDecimal();
    }

    @Override
    public boolean isNullIndicator() {
        return this.compare(0) < 0;
    }

    @Override
    public Object getSqlObject() {
        return new BigDecimal(this.toNumericString());
    }

    @Override
    public Object getSqlObject(boolean trim) {
        return this.getSqlObject();
    }

    @Override
    protected int canStore(String value) {
        return 0;
    }

    public Variable moveSE(char param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSE(byte param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSE(short param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSE(int param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSE(long param) {
        this.value.make(param);
        return this;
    }

    @Override
    public Variable moveSE(String param) {
        this.value.make(param);
        return this;
    }

    @Override
    public Variable moveSE(Bignum param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSE(float param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSE(double param) {
        this.value.make(param);
        return this;
    }

    @Override
    public Variable moveSE(Numeric param) {
        this.value.make(param.toBignum());
        return this;
    }

    @Override
    public Variable moveSE(Variable param) {
        this.value.make(param.toBignum());
        return this;
    }

    public Variable moveSER(char param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSER(byte param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSER(short param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSER(int param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSER(long param) {
        this.value.make(param);
        return this;
    }

    @Override
    public Variable moveSER(String param) {
        this.value.make(param);
        return this;
    }

    @Override
    public Variable moveSER(Bignum param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSER(float param) {
        this.value.make(param);
        return this;
    }

    public Variable moveSER(double param) {
        this.value.make(param);
        return this;
    }

    @Override
    public Variable moveSER(Numeric param) {
        this.value.make(param.toBignum());
        return this;
    }

    @Override
    public Variable moveSER(Variable param) {
        this.value.make(param.toBignum());
        return this;
    }

    @Override
    public Variable moveR(Bignum param) {
        this.value.make(param);
        return this;
    }

    @Override
    public Variable moveR(Numeric param) {
        this.value = param.toModifyBignum();
        return this;
    }

    @Override
    public final boolean isNumericDisplay() {
        return true;
    }

    @Override
    public final boolean isDefinedNumeric() {
        return true;
    }

    @Override
    protected int getBasicType() {
        return super.getBasicType(16);
    }

    @Override
    protected int getBasicType(int preferredType) {
        return super.getBasicType(preferredType | 0x10);
    }

    @Override
    int generateReturnCode() {
        return this.toInt();
    }

    @Override
    public int getArgumentType() {
        return 97;
    }

    @Override
    public byte[] getArgument() {
        this.flushToMemory();
        if (ConvertNumericsToInt) {
            return ConvertData.nativeLongToGivenBytes(this.value.longValue(), 4);
        }
        return super.getArgument();
    }

    @Override
    public void setArgument(byte[] data) {
        this.setDirtyNoFill();
        if (ConvertNumericsToInt) {
            this.value.make(ConvertData.nativeBytesToLong(data));
        }
        super.setArgument(data);
        this.fillFromMemory();
    }

    public String getOrigNumString() {
        return this.origNumString;
    }

    private void setOrigNumString(String parm) {
        this.origNumString = parm;
    }

    @Override
    public int getType() {
        return this.getBasicType(16);
    }

    public Numeric get(Numeric[] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0];
    }

    public Numeric get(Numeric[][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0];
    }

    public Numeric get(Numeric[][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0];
    }

    public Numeric get(Numeric[][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0];
    }

    public Numeric get(Numeric[][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0];
    }

    public Numeric get(Numeric[][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0];
    }

    public Numeric get(Numeric[][][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]][idxArray[6]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0][0];
    }

    public Numeric get(Numeric[][][][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]][idxArray[6]][idxArray[7]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0][0][0];
    }

    public Numeric get(NumericSubscript array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array.get(idxArray);
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return ArrayIndexOutOfBoundsVariable.garbage;
    }

    @Override
    public void cleanAncestorsContinue() {
        this.flushToMemory();
    }
}

