/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.PackedDecimal;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public final class PackedDecimalA
extends PackedDecimal
implements Cloneable,
comparableByteArray {
    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.PackedDecimalA";
    }

    @Override
    public final String getUsage() {
        return "PackedDecimalA";
    }

    @Override
    protected void calcPadding() {
        this.usePadding = (this.picLength & 1) == 0;
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            int c;
            boolean trailing;
            byte bufferPlace = this.place;
            Bignum storeValue = this.value;
            if (this.scale > 0) {
                if (this.place > 0) {
                    storeValue = this.value.movePointRight(this.scale);
                    this.place = (byte)(this.place - this.scale);
                } else {
                    storeValue = this.value.movePointLeft(this.scale);
                }
            }
            boolean negative = false;
            String absbuffer = storeValue.toString();
            int length = absbuffer.length();
            if (length > 2 && absbuffer.startsWith("0.")) {
                absbuffer = absbuffer.substring(1);
                --length;
            } else if (length > 1 && absbuffer.charAt(0) == '-') {
                negative = true;
                if (length > 3 && absbuffer.startsWith("-0.")) {
                    absbuffer = absbuffer.substring(2);
                    length -= 2;
                } else {
                    absbuffer = absbuffer.substring(1);
                    --length;
                }
            }
            int byteLow = 14;
            int byteHigh = 14;
            int store = 0;
            boolean storingNibble = false;
            int decimal = absbuffer.indexOf(46);
            if (decimal < 0) {
                decimal = length;
            }
            int rightMost = this.picLength;
            int load = decimal - (rightMost - this.place);
            boolean leading = this.signPosition == 2 || this.signPosition == 4;
            boolean bl = trailing = this.signPosition == 3 || this.signPosition == 5;
            if (leading) {
                c = negative ? 45 : 43;
                byteLow = this.charToNibble((char)c);
                storingNibble = true;
            }
            if (this.usePadding) {
                if (!storingNibble) {
                    byteLow = 48;
                } else {
                    byteHigh = 48;
                    this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteLow << 4 | byteHigh));
                    ++store;
                }
                storingNibble = !storingNibble;
            }
            for (int i = 0; i < this.picLength; ++i) {
                if (load >= 0) {
                    if (load == decimal) {
                        ++load;
                    }
                    c = load >= length ? 48 : (int)absbuffer.charAt(load);
                } else {
                    c = 48;
                }
                if (!storingNibble) {
                    byteLow = this.charToNibble((char)c);
                } else {
                    byteHigh = this.charToNibble((char)c);
                    this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteLow << 4 | byteHigh));
                    ++store;
                }
                storingNibble = !storingNibble;
                ++load;
            }
            if (storingNibble) {
                byteHigh = trailing ? (int)(negative ? this.charToNibble('-') : this.charToNibble('+')) : (this.signPosition == 0 ? 15 : 14);
                this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteLow << 4 | byteHigh));
            } else if (trailing) {
                byteLow = negative ? this.charToNibble('-') : this.charToNibble('+');
                byteHigh = 14;
                this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteHigh | byteLow << 4));
            }
            this.place = bufferPlace;
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in PACKED-DECIMAL-A storage of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    private final byte charToNibble(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '+': {
                return 15;
            }
            case '-': {
                return 13;
            }
        }
        return 14;
    }

    private final char nibbleToChar(byte b) {
        switch (b) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 12: {
                return '+';
            }
            case 15: {
                return '+';
            }
            case 13: {
                return '-';
            }
        }
        return ' ';
    }

    @Override
    public final void fillFromMemoryNow() {
        try {
            byte temporaryPlace = this.place;
            if (this.scale > 0 && this.place > 0) {
                temporaryPlace = (byte)(temporaryPlace - this.scale);
            }
            boolean negative = false;
            boolean decimalFound = false;
            boolean digitFound = false;
            int load = 0;
            int b1 = 0;
            int decimal = this.picLength - temporaryPlace;
            if (this.usePadding) {
                ++decimal;
            }
            int itemSizeTimes2 = this.itemSize * 2;
            int resultCounter = 0;
            if (this.fillArray == null) {
                this.fillArray = new char[itemSizeTimes2 + 4];
            }
            this.fillArray[resultCounter++] = 48;
            for (int i = 0; i < itemSizeTimes2; ++i) {
                int b;
                if ((i & 1) == 0) {
                    b = this.pointerMemory.getByte(this.pointerAddress + load);
                    ++load;
                    b1 = (byte)(b & 0xF);
                    b = (byte)(b >> 4 & 0xF);
                } else {
                    b = b1;
                }
                if (this.isSignNegative(b)) {
                    negative = true;
                }
                if (resultCounter - 1 == decimal) {
                    decimalFound = true;
                    this.fillArray[resultCounter++] = 46;
                }
                if (b < 0 || b > 9) continue;
                this.fillArray[resultCounter++] = (char)(b + 48);
                digitFound = true;
            }
            if (!decimalFound) {
                this.fillArray[resultCounter++] = 46;
            }
            if (negative) {
                this.fillArray[0] = 45;
            }
            if (!digitFound) {
                this.value = new Bignum();
                this.value.setiAmNotNumeric(true);
                this.dirty = false;
            } else {
                this.value = new Bignum(this.fillArray, resultCounter);
            }
            this.numericString = null;
            if (this.scale > 0) {
                this.value.movingPoint(this.scale, temporaryPlace);
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in PACKED-DECIMAL-A retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public int getType() {
        return this.getBasicType(208);
    }

    @Override
    public void initData() {
        int e = this.pointerAddress + this.length();
        super.initData();
        if (this.signPosition == 3 || this.signPosition == 5) {
            this.pointerMemory.setByte(e - 1, (byte)12);
        } else if (this.signPosition == 2 || this.signPosition == 4) {
            this.pointerMemory.setByte(0, (byte)12);
        } else if (this.signPosition == 0) {
            this.pointerMemory.setByte(e - 1, (byte)15);
        }
    }
}

