/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exception.EcDataIncompatible;
import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.ICallableProgram;
import com.heirloomcomputing.ecs.exec.ICobolInterface;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ProcedurePointer
extends Variable
implements Runnable {
    private ICobolInterface program;
    private ICallableProgram callable;
    private Runnable runnable;
    private int paragraph;
    private int paragraphTo;
    private Context context;

    @Override
    public String toString() {
        if (this.runnable != null) {
            return "ProcedurePointer (" + this.runnable + ")";
        }
        return "ProcedurePointer { (" + this.paragraph + "," + this.paragraphTo + "): program=" + this.program + ", callable=" + this.callable + "}";
    }

    public ProcedurePointer() {
        this.paragraph = -1;
        this.paragraphTo = -1;
    }

    public ProcedurePointer(ICobolInterface program, int performFrom) {
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.program = program;
        this.paragraph = performFrom;
    }

    public ProcedurePointer(ICobolInterface program, int performFrom, int performTo) {
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.program = program;
        this.paragraph = performFrom;
        this.paragraphTo = performTo;
    }

    public ProcedurePointer(ICobolInterface program, Context context, int performFrom) {
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.program = program;
        this.paragraph = performFrom;
        this.context = context;
    }

    public ProcedurePointer(ICobolInterface program, Context context, int performFrom, int performTo) {
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.program = program;
        this.paragraph = performFrom;
        this.paragraphTo = performTo;
        this.context = context;
    }

    ProcedurePointer(Object program, Context context, int entryLabel) {
        block2: {
            this.paragraph = -1;
            this.paragraphTo = -1;
            try {
                this.program = (ICobolInterface)program;
            }
            catch (RuntimeException e) {
                if (!LogSetup.IS_LOGGING_INFO) break block2;
                LogSetup.LOGGER.info("catch(RuntimeException e)");
                e.printStackTrace();
            }
        }
        this.paragraph = entryLabel;
        this.context = context;
    }

    public ProcedurePointer(ProcedurePointer param) {
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.program = param.program;
        this.callable = param.callable;
        this.paragraph = param.paragraph;
        this.paragraphTo = param.paragraphTo;
        this.context = param.context;
    }

    public ProcedurePointer(Variable param) {
        this.paragraph = -1;
        this.paragraphTo = -1;
        if (param instanceof ProcedurePointer) {
            ProcedurePointer procParam = (ProcedurePointer)param;
            this.program = procParam.program;
            this.callable = procParam.callable;
            this.paragraph = procParam.paragraph;
            this.paragraphTo = procParam.paragraphTo;
        } else {
            this.paragraph = param.toInt();
            this.paragraphTo = -1;
        }
    }

    public void setProcedurePointer(Runnable runnable) {
        this.runnable = runnable;
        this.program = null;
        this.callable = null;
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.context = null;
    }

    public void setProcedurePointer(Object pointer) {
        if (pointer == null) {
            this.runnable = null;
            this.program = null;
            this.callable = null;
            this.paragraph = -1;
            this.paragraphTo = -1;
            this.context = null;
        } else if (pointer instanceof Runnable) {
            this.setProcedurePointer((Runnable)pointer);
        } else if (pointer instanceof ProcedurePointer) {
            this.setProcedurePointer((ProcedurePointer)pointer);
        } else if (pointer instanceof Variable) {
            this.setProcedurePointer((Variable)pointer);
        } else {
            throw new EcDataIncompatible();
        }
    }

    public void setProcedurePointer(ProcedurePointer pointer) {
        this.program = pointer.program;
        this.callable = pointer.callable;
        this.paragraph = pointer.paragraph;
        this.paragraphTo = pointer.paragraphTo;
        this.runnable = pointer.runnable;
    }

    public void setProcedurePointer(Variable pointer) {
        if (pointer instanceof ProcedurePointer) {
            this.setProcedurePointer((ProcedurePointer)pointer);
            return;
        }
        this.paragraph = pointer == null ? -1 : pointer.toInt();
        this.paragraphTo = -1;
        this.runnable = null;
    }

    public void setProcedure(ICobolInterface pprogram) {
        if (pprogram == null) {
            this.setProcedure();
            return;
        }
        this.program = pprogram;
        this.callable = pprogram;
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.runnable = null;
    }

    public void setProcedure(ICobolInterface pprogram, int paragraph) {
        this.program = pprogram;
        this.callable = pprogram;
        this.paragraph = paragraph;
        this.paragraphTo = -1;
        this.runnable = null;
    }

    public void setProcedure(ICobolInterface pprogram, int paragraph, int paragraphTo) {
        this.program = pprogram;
        this.callable = pprogram;
        this.paragraph = paragraph;
        this.paragraphTo = paragraphTo;
        this.runnable = null;
    }

    public void setProcedure(Runnable runnable) {
        this.runnable = runnable;
        this.program = null;
        this.callable = null;
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.context = null;
    }

    public void setProcedure(int paragraph) {
        this.program = null;
        this.callable = null;
        this.paragraph = paragraph;
        this.runnable = null;
    }

    public void setProcedure(int paragraph, int paragraphTo) {
        this.program = null;
        this.callable = null;
        this.paragraph = paragraph;
        this.paragraphTo = paragraphTo;
        this.runnable = null;
    }

    public void setProcedure() {
        this.program = null;
        this.callable = null;
        this.paragraph = -1;
        this.paragraphTo = -1;
        this.runnable = null;
    }

    public void setProcedure(ICallableProgram pcallable) {
        block2: {
            try {
                this.program = null;
                this.callable = pcallable;
                this.program = (ICobolInterface)this.callable;
            }
            catch (Exception any) {
                if (!LogSetup.IS_LOGGING_INFO) break block2;
                LogSetup.LOGGER.info("catch(Exception any)");
                any.printStackTrace();
            }
        }
    }

    public void perform(int currentThread, int entry) {
        if (this.program != null) {
            block6: {
                try {
                    this.program.run(currentThread, entry);
                }
                catch (Throwable t) {
                    if (!LogSetup.IS_LOGGING_INFO) break block6;
                    LogSetup.LOGGER.info("catch(Throwable t)");
                    t.printStackTrace();
                }
            }
            return;
        }
        if (this.callable != null) {
            block7: {
                try {
                    this.callable.call();
                }
                catch (Throwable t) {
                    if (!LogSetup.IS_LOGGING_INFO) break block7;
                    LogSetup.LOGGER.info("catch(Throwable t)");
                    t.printStackTrace();
                }
            }
            return;
        }
    }

    public void perform(int entry) {
        if (this.program != null) {
            block6: {
                try {
                    this.program.run(-1, entry);
                }
                catch (Throwable t) {
                    if (!LogSetup.IS_LOGGING_INFO) break block6;
                    LogSetup.LOGGER.info("catch(Throwable t)");
                    t.printStackTrace();
                }
            }
            return;
        }
        if (this.callable != null) {
            block7: {
                try {
                    this.callable.call();
                }
                catch (Throwable t) {
                    if (!LogSetup.IS_LOGGING_INFO) break block7;
                    LogSetup.LOGGER.info("catch(Throwable t)");
                    t.printStackTrace();
                }
            }
            return;
        }
    }

    public void perform() {
        if (this.program != null) {
            block12: {
                if (this.paragraph == -1 || this.paragraphTo == -1) {
                    if (this.context != null && this.paragraph >= 0) {
                        this.context.setEntryParagraph(this.paragraph);
                    }
                    try {
                        this.program.run(-1, this.paragraph);
                    }
                    catch (Throwable t) {
                        if (LogSetup.IS_LOGGING_INFO) {
                            LogSetup.LOGGER.info("catch(Throwable t)");
                            t.printStackTrace();
                        }
                        break block12;
                    }
                }
                try {
                    this.program.perform(this.paragraph, this.paragraphTo);
                }
                catch (Throwable t) {
                    if (!LogSetup.IS_LOGGING_INFO) break block12;
                    LogSetup.LOGGER.info("catch(Throwable t)");
                    t.printStackTrace();
                }
            }
            return;
        }
        if (this.callable != null) {
            block13: {
                try {
                    this.callable.call();
                }
                catch (Throwable t) {
                    if (!LogSetup.IS_LOGGING_INFO) break block13;
                    LogSetup.LOGGER.info("catch(Throwable t)");
                    t.printStackTrace();
                }
            }
            return;
        }
        if (this.runnable != null) {
            this.runnable.run();
            return;
        }
    }

    @Override
    public void run() {
        this.perform();
    }

    public boolean equals(Object o) {
        if (o instanceof ProcedurePointer) {
            return this.equals((ProcedurePointer)o);
        }
        return false;
    }

    public boolean equals(ProcedurePointer x) {
        return this.program == x.program && this.paragraph == x.paragraph && this.callable == x.callable && this.paragraphTo == x.paragraphTo;
    }

    public boolean equals(int x) {
        return this.paragraph == x && this.callable == null;
    }

    public int getParagraph() {
        return this.paragraph;
    }

    public int getFinalParagraph() {
        return this.paragraphTo;
    }

    public boolean hasValidProgram() {
        return this.program != null;
    }

    public Object getProgramObject() {
        if (this.program != null) {
            return this.program;
        }
        return this.callable;
    }

    public Object getLockObject() {
        if (this.program != null) {
            return this.program;
        }
        if (this.callable != null) {
            return this.callable;
        }
        return this.getClass();
    }

    @Override
    public void flushDirtyToMemory() {
    }

    @Override
    public void flushToMemory() {
    }

    @Override
    public void fillFromMemory() {
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public byte toByte() {
        return (byte)this.paragraph;
    }

    @Override
    public short toShort() {
        return (short)this.paragraph;
    }

    @Override
    public int toInt() {
        return this.paragraph;
    }

    @Override
    public long toLong() {
        return this.paragraph;
    }

    @Override
    public float toFloat() {
        return this.paragraph;
    }

    @Override
    public double toDouble() {
        return this.paragraph;
    }

    @Override
    public Bignum toBignum() {
        return new Bignum(this.paragraph);
    }

    @Override
    public Bignum toModifyBignum() {
        return new Bignum(this.paragraph);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("ProcedurePointer cannot be serialized.");
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException("ProcedurePointer cannot be serialized.");
    }

    public Context getContext() {
        return this.context;
    }
}

