/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesUtil {
    private static final String PGM = "PropertiesUtil";
    private static final boolean THROW_ON_LOAD_FAILURE = true;
    private static final boolean IS_DEBUG = false;

    private PropertiesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String filename, ClassLoader loader) {
        if (filename == null) {
            throw new IllegalArgumentException("null input: name");
        }
        Properties result = null;
        InputStream in = null;
        try {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if ((in = loader.getResourceAsStream(filename)) != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (Exception e) {
            System.out.println("Error in program PropertiesUtil\n");
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
        }
        if (result == null) {
            try {
                in = new FileInputStream(new File(filename));
                result = new Properties();
                result.load(in);
                in.close();
            }
            catch (Exception e) {
                try {
                    in = new FileInputStream(new File("workdir" + File.separator + filename));
                    result = new Properties();
                    result.load(in);
                    in.close();
                }
                catch (Exception f) {
                    try {
                        in = new FileInputStream(new File("resources" + File.separator + filename));
                        result = new Properties();
                        result.load(in);
                        in.close();
                    }
                    catch (Exception g) {
                        try {
                            in = new FileInputStream(new File(".." + File.separator + "resources" + File.separator + filename));
                            result = new Properties();
                            result.load(in);
                            in.close();
                        }
                        catch (Exception h) {
                            result = null;
                        }
                    }
                }
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("could not load [" + filename + "] as a classloader resource");
        }
        return result;
    }

    public static Properties loadProperties(String name) {
        return PropertiesUtil.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    public static ArrayList<String> listValues(Properties prop, String keyStart, String valueStart) {
        String func = ".listValues(P,S,S)";
        int keyLength = keyStart.length();
        int valueLength = valueStart.length();
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<Object, Object>> set = prop.entrySet();
        for (Map.Entry<Object, Object> ele : set) {
            String value;
            String key = (String)ele.getKey();
            if (key.length() < keyLength || !keyStart.equalsIgnoreCase(key.substring(0, keyLength)) || (value = (String)ele.getValue()).length() < valueLength || !valueStart.equalsIgnoreCase(value.substring(0, valueLength))) continue;
            list.add(value.substring(valueLength));
        }
        return list;
    }

    public static ArrayList<String> listKeys(Properties prop, String keyStart, String valueStart) {
        String func = ".listKeys(P,S,S)";
        int keyLength = keyStart.length();
        int valueLength = valueStart.length();
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<Object, Object>> set = prop.entrySet();
        for (Map.Entry<Object, Object> ele : set) {
            String value;
            String key = (String)ele.getKey();
            if (key.length() < keyLength || !keyStart.equalsIgnoreCase(key.substring(0, keyLength)) || (value = (String)ele.getValue()).length() < valueLength || !valueStart.equalsIgnoreCase(value.substring(0, valueLength))) continue;
            list.add(key.substring(keyLength));
        }
        return list;
    }

    public static Properties swapProperties(Properties props) {
        Enumeration<Object> subs = props.keys();
        String env_key = "";
        while (subs.hasMoreElements()) {
            String key = (String)subs.nextElement();
            String val = props.getProperty(key);
            env_key = val.startsWith("%") && val.endsWith("%") ? val.replaceAll("%", "") : key.replaceAll("\\.", "_");
            String newval = System.getenv(env_key);
            if (newval == null) continue;
            props.setProperty(key, newval);
        }
        return props;
    }
}

