/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Variable;

public final class QuickVector {
    private static final int INITIAL_CAPACITY = 4;
    public Variable[] elementData;
    private int elementCount;

    public String toString() {
        String result = "[QuickVector elementCount=" + this.elementCount + ": ";
        for (int i = 0; i < this.elementCount; ++i) {
            if (i != 0) {
                result = result + ",";
            }
            result = result + this.elementData[i].getName();
        }
        return result + "]";
    }

    public String toDescription() {
        String result = "[QuickVector elementCount=" + this.elementCount + ": ";
        for (int i = 0; i < this.elementCount; ++i) {
            if (i != 0) {
                result = result + ", ";
            }
            result = result + this.elementData[i].getName() + "-" + (this.elementData[i].dirty ? "dirty" : "clean");
        }
        return result + "]";
    }

    public void reset() {
        this.elementCount = 0;
    }

    public QuickVector copy() {
        QuickVector copy = new QuickVector();
        copy.elementCount = this.elementCount;
        if (this.elementData == null) {
            copy.elementData = null;
        } else {
            int elementDataLength = this.elementData.length;
            copy.elementData = new Variable[elementDataLength];
            System.arraycopy(this.elementData, 0, copy.elementData, 0, elementDataLength);
        }
        return copy;
    }

    public QuickVector(int initialCapacity) {
        this.elementData = new Variable[initialCapacity];
    }

    public QuickVector() {
        this.elementData = new Variable[4];
    }

    public QuickVector(Variable obj) {
        this.elementData = new Variable[4];
        this.elementData[this.elementCount++] = obj;
    }

    public QuickVector(QuickVector copy) {
        this.elementCount = copy.elementCount;
        this.elementData = new Variable[this.elementCount];
        System.arraycopy(copy.elementData, 0, this.elementData, 0, this.elementCount);
    }

    public final void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Variable[] oldData = this.elementData;
            if (minCapacity < (oldCapacity <<= 2)) {
                minCapacity = oldCapacity;
            }
            this.elementData = new Variable[minCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean contains(Variable elem) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(Variable elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(Variable elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final Variable elementAt(int index) {
        return this.elementData[index];
    }

    public final void addElement(Variable obj) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = obj;
    }

    public final void addElementIfNecessary(Variable obj) {
        if (!this.contains(obj)) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = obj;
        }
    }

    public final void add(QuickVector qv) {
        if (qv == null) {
            return;
        }
        int qv_size = qv.size();
        this.ensureCapacity(this.elementCount + qv_size);
        Variable[] qv_elementData = qv.elementData;
        for (int i = 0; i < qv_size; ++i) {
            this.elementData[this.elementCount++] = qv_elementData[i];
        }
    }

    public final void removeElementAt(int index) {
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final boolean removeElement(Variable obj) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (obj != this.elementData[i]) continue;
            int j = this.elementCount - i - 1;
            if (j > 0) {
                System.arraycopy(this.elementData, i + 1, this.elementData, i, j);
            }
            --this.elementCount;
            this.elementData[this.elementCount] = null;
            return true;
        }
        return false;
    }

    public final boolean flushToMemory() {
        boolean rc = false;
        for (int i = 0; i < this.elementCount; ++i) {
            Variable v = this.elementData[i];
            if (v.dirty) {
                v.flushDirtyToMemory();
                rc = true;
            }
            v.valid = false;
        }
        return rc;
    }
}

