/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.NIORandomAccessFile;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RandomAccessFileFactory {
    private static final int MULTIPLE = 1024;
    private static final Hashtable<String, Integer> bufHashTable = new Hashtable();

    private static void loadBufferTable() {
        String prop = RuntimeEnvironment.getGlobalParameter("IO-BUFFER-SIZE");
        if ("BYDDNAME".equalsIgnoreCase(prop)) {
            Hashtable<String, String> props = RuntimeEnvironment.getGlobalRuntimeEnvironment().getProperties();
            Properties sysProps = System.getProperties();
            sysProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> props.put((String)key, (String)value)));
            for (String s : props.keySet()) {
                if (!s.startsWith("IO-BUFFER-SIZE-")) continue;
                String ddname = s.replaceAll("IO-BUFFER-SIZE-", "");
                int v = RandomAccessFileFactory.getBufSize(props.get(s));
                String k = props.get(ddname).replaceFirst("^(EC|MF|MF3|MF8|IBM|IBMV|IBMVB|SYNC|CISAM|DISAM|EISAM|AS400|CB|ACU):", "");
                if (k == null) {
                    k = props.get(ddname.toUpperCase()).replaceFirst("^(EC|MF|MF3|MF8|IBM|IBMV|IBMVB|SYNC|CISAM|DISAM|EISAM|AS400|CB|ACU):", "");
                }
                if (k == null) {
                    k = props.get(ddname.toLowerCase()).replaceFirst("^(EC|MF|MF3|MF8|IBM|IBMV|IBMVB|SYNC|CISAM|DISAM|EISAM|AS400|CB|ACU):", "");
                }
                bufHashTable.put(k, v);
            }
        } else {
            int size = RandomAccessFileFactory.getBufSize(prop);
            bufHashTable.put("ALL", size);
        }
    }

    private static int getBufSize(String prop) {
        int size;
        try {
            if (prop != null) {
                int number;
                String patternString = "([0-9]+)([bkmgBKMG]?)";
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(prop);
                String alloc = "";
                String type = "";
                if (matcher.find()) {
                    alloc = matcher.group(1);
                    type = matcher.group(2);
                }
                if (type.length() <= 0) {
                    number = Integer.parseInt(alloc);
                } else if (type.equalsIgnoreCase("B")) {
                    number = Integer.parseInt(alloc);
                } else if (type.equalsIgnoreCase("K")) {
                    int reqNum = Integer.parseInt(alloc);
                    number = reqNum * 1024;
                } else {
                    int reqNum;
                    long result;
                    number = type.equalsIgnoreCase("M") ? ((result = (long)(reqNum = Integer.parseInt(alloc)) * 0x100000L - 1L) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)result) : (type.equalsIgnoreCase("G") ? ((result = (long)(reqNum = Integer.parseInt(alloc)) * 0x40000000L - 1L) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)result) : 0);
                }
                if (number == Integer.MAX_VALUE) {
                    size = number;
                } else if (number == 0) {
                    size = 0;
                } else if (number < 0) {
                    size = -1;
                } else {
                    size = 1024;
                    size = number % 1024 != 0 ? (number / 1024 + 1) * 1024 : number;
                }
            } else {
                size = -1;
            }
        }
        catch (NumberFormatException nfe) {
            size = -1;
        }
        return size;
    }

    public static RandomAccessFile getInstance(String filename, String mode, int bufsize, String bufType) throws IOException {
        if (bufsize == 0) {
            return new NIORandomAccessFile(filename, mode);
        }
        if (bufsize < 0) {
            return new RandomAccessFile(filename, mode);
        }
        return new NIORandomAccessFile(filename, mode, bufsize, bufType);
    }

    public static RandomAccessFile getInstance(File file2, String mode, int bufsize, String bufType) throws IOException {
        if (bufsize == 0) {
            return new NIORandomAccessFile(file2, mode);
        }
        if (bufsize < 0) {
            return new RandomAccessFile(file2, mode);
        }
        return new NIORandomAccessFile(file2, mode, bufsize, bufType);
    }

    public static RandomAccessFile getInstance(File file2, String mode) throws IOException {
        String filename = file2.getAbsolutePath();
        String bufType = null;
        int bufSize = -1;
        if (bufHashTable.containsKey("ALL")) {
            bufType = "ALL";
            bufSize = bufHashTable.getOrDefault("ALL", -1);
        } else {
            bufType = "DDNAME";
            bufSize = bufHashTable.getOrDefault(filename, -1);
        }
        return RandomAccessFileFactory.getInstance(file2, mode, bufSize, bufType);
    }

    public static RandomAccessFile getInstance(String filename, String mode) throws IOException {
        int bufSize = -1;
        String bufType = null;
        if (bufHashTable.containsKey("ALL")) {
            bufType = "ALL";
            bufSize = bufHashTable.getOrDefault("ALL", -1);
        } else {
            bufType = "DDNAME";
            bufSize = bufHashTable.getOrDefault(filename, -1);
        }
        return RandomAccessFileFactory.getInstance(filename, mode, bufSize, bufType);
    }

    static {
        RandomAccessFileFactory.loadBufferTable();
    }
}

