/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.BTreeHandler;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.bTreeNode;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import com.heirloomcomputing.ecs.exec.recordBlockFile;
import com.heirloomcomputing.ecs.exec.recordBlockFileBTreeNode;
import com.heirloomcomputing.ecs.exec.recordPointer;

public class RecordBlockFileBTreeHandler
extends BTreeHandler {
    int order = 5;
    recordBlockFile file = null;
    int handlerID = 0;

    public static void debug(String text) {
        Utilities.debugOutput("recordBlockFileBTreeHandler: " + text);
    }

    public RecordBlockFileBTreeHandler(recordBlockFile file2, int handlerID) {
        this.file = file2;
        this.handlerID = handlerID;
    }

    @Override
    int getBTreeType() {
        return 0;
    }

    @Override
    int getBTreeOrder() {
        return this.order;
    }

    @Override
    int compareLocation(Object location1, Object location2, boolean truncate) {
        if (!(location1 instanceof recordPointer) || !(location2 instanceof recordPointer)) {
            throw new RuntimeException("Location(s) are not of type recordPointer");
        }
        recordPointer pointer1 = (recordPointer)location1;
        recordPointer pointer2 = (recordPointer)location2;
        return pointer1.compare(pointer2, truncate);
    }

    private void initOrder(recordBlockFile file2) {
        try {
            int maxRecSize = file2.getMaxRecordSize();
            int maximumKeySize = this.getMaximumKeySize();
            this.order = (maxRecSize - 31) / (maximumKeySize + 4 + 12) + 1;
        }
        catch (Exception e) {
            this.order = file2.getMaxRecordSize() / 2;
        }
    }

    @Override
    bTreeNode getBTreeNode(comparableByteArray keyTemplate) {
        this.initOrder(this.file);
        return new recordBlockFileBTreeNode(this.file, this.order, keyTemplate, this.handlerID);
    }

    @Override
    bTreeNode getBTreeNode(comparableByteArray keyTemplate, Object location) {
        if (!(location instanceof recordPointer)) {
            throw new RuntimeException("location not of type recordPointer");
        }
        this.initOrder(this.file);
        recordPointer pointer = (recordPointer)location;
        long blockNumber = pointer.getBlockNumber();
        int key = pointer.getRecordKey();
        return new recordBlockFileBTreeNode(this.file, this.order, blockNumber, key, keyTemplate, this.handlerID);
    }
}

