/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ArrayIndexOutOfBoundsVariable;
import com.heirloomcomputing.ecs.exec.Beep;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.IEnvironment;
import com.heirloomcomputing.ecs.exec.KeyStroke;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.PropertiesUtil;
import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.Switch;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class RuntimeEnvironment
implements IEnvironment {
    public static boolean isIBM = false;
    public static boolean isIBMASC = false;
    public static boolean isIBMEBC = false;
    public static boolean isMF = false;
    public static boolean isEC = true;
    public static boolean outTrace = true;
    static RuntimeEnvironment globalRuntimeEnvironment;
    static boolean retExcepToIDE;
    static String IDEComponentDesc;
    public static boolean G_firstTime;
    private IEnvironment parent;
    private Hashtable<String, String> programProperties = new Hashtable();
    private boolean parsingConfigFile;
    private boolean endianSet;
    private int ARGUMENT_BASE;
    private boolean systemPropertiesDisallowed;
    private int argumentCount;
    private String cmdLine = "";
    private boolean LITTLE_ENDIAN;
    private static int CHECKOS;
    private static Date jobDate;

    public static void setTraceSwitch(boolean trace2) {
        outTrace = trace2;
    }

    public static RuntimeEnvironment getGlobalRuntimeEnvironment() {
        if (globalRuntimeEnvironment == null) {
            globalRuntimeEnvironment = new RuntimeEnvironment();
        }
        return globalRuntimeEnvironment;
    }

    public static void setReturnExcepToIDE(boolean mode, String desc) {
        retExcepToIDE = mode;
        IDEComponentDesc = desc;
    }

    public static boolean returnExcepToIDE() {
        return retExcepToIDE;
    }

    public static String getIDEComponentDesc() {
        return IDEComponentDesc;
    }

    public static void setGlobalRuntimeEnvironment(IEnvironment environment) {
        RuntimeEnvironment.getGlobalRuntimeEnvironment().setParent(environment);
    }

    public static void setGlobalRuntimeEnvironment(Object program, String[] args) {
        RuntimeEnvironment.getGlobalRuntimeEnvironment().initializeApplication(program, args);
    }

    public static void setGlobalRuntimeEnvironment(Object program) {
        RuntimeEnvironment.getGlobalRuntimeEnvironment().initializeProgram(program);
    }

    public static String getGlobalParameter(String name) {
        return RuntimeEnvironment.getGlobalRuntimeEnvironment().getParameter(name);
    }

    public static void setGlobalParameter(String name, String value) {
        if (name.equalsIgnoreCase("DT")) {
            isMF = false;
            isIBMEBC = false;
            isIBMASC = false;
            isIBM = false;
            isEC = true;
            switch (value) {
                case "0": {
                    isEC = true;
                    break;
                }
                case "1": {
                    isIBMASC = true;
                    isIBM = true;
                    isEC = false;
                    break;
                }
                case "3": {
                    isIBMEBC = true;
                    isIBM = true;
                    isEC = false;
                    break;
                }
                case "5": {
                    isMF = true;
                    isEC = false;
                }
            }
        }
        RuntimeEnvironment.getGlobalRuntimeEnvironment().setParameter(name, value);
    }

    public static boolean isGlobalParameter(String name) {
        return RuntimeEnvironment.getGlobalRuntimeEnvironment().isParameter(name);
    }

    public static int getArchitecture() {
        int arch = 32;
        String s = RuntimeEnvironment.getGlobalParameter("pointerArchitecture");
        if (s != null && s.trim().equalsIgnoreCase("64")) {
            arch = 64;
        }
        return arch;
    }

    public static boolean canJVMExit() {
        boolean canExit = false;
        String param = RuntimeEnvironment.getGlobalParameter("JVM-ERROR-EXIT");
        if (param == null || param.toLowerCase().matches("[1ty]")) {
            canExit = true;
        }
        return canExit;
    }

    public static boolean isEBPEnv() {
        boolean isEnv = true;
        String param = RuntimeEnvironment.getGlobalParameter("EBP-ENVIRONMENT");
        if (param == null || param.toLowerCase().matches("[0fn]")) {
            isEnv = false;
        }
        return isEnv;
    }

    public static boolean isGlobalParameter(String name, boolean defaultValue) {
        return RuntimeEnvironment.getGlobalRuntimeEnvironment().isParameter(name, defaultValue);
    }

    public static final boolean isParameterValue(String result) {
        return RuntimeEnvironment.isParameterValue(result, false);
    }

    public static final boolean isParameterValue(String result, boolean defaultValue) {
        if (result == null) {
            return defaultValue;
        }
        if ((result = result.trim()).length() == 0) {
            return defaultValue;
        }
        switch (result.charAt(0)) {
            case 'O': 
            case 'o': {
                if (result.length() > 1) {
                    switch (result.charAt(1)) {
                        case 'N': 
                        case 'n': {
                            return true;
                        }
                        case 'F': 
                        case 'f': {
                            return false;
                        }
                    }
                }
                return false;
            }
            case '0': 
            case 'F': 
            case 'N': 
            case 'f': 
            case 'n': {
                return false;
            }
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return true;
            }
        }
        return defaultValue;
    }

    public RuntimeEnvironment(Object program) {
        this(program.getClass().getName());
    }

    public RuntimeEnvironment(String name) {
        this();
        this.initializeProgram(name);
    }

    public RuntimeEnvironment() {
        this.programProperties.put("ELASTIC-COBOL-VERSION", "" + Version.getMajor() + "." + Version.getMinor() + "." + Version.getSubMinor());
        this.programProperties.put("CONSOLE-FONT-KO", "\ubc14\ud0d5\uccb4");
        this.programProperties.put("CONSOLE-FONT-SIZE-KO", "16");
        this.initialize();
    }

    public void setParent(IEnvironment environment) {
        this.parent = environment;
    }

    private void initialize() {
        RuntimeEnvironment.readDeployProperties(this);
        this.parseSystemProperties();
    }

    private void initializeProgram(String name) {
        int index = name.lastIndexOf(46);
        this.parseConfigFile(this.getInputStream(name + ".ini"));
        if (index >= 0) {
            this.parseConfigFile(this.getInputStream(name.substring(index + 1) + ".ini"));
        }
        this.parseConfigFile(this.getInputStream(name + ".properties"));
        if (index >= 0) {
            this.parseConfigFile(this.getInputStream(name.substring(index + 1) + ".properties"));
        }
        this.initialize();
    }

    private void initializeProgram(Object program) {
        String name = program.getClass().getName();
        this.initializeProgram(name);
    }

    public static void readDeployProperties(Object This) {
        if (G_firstTime) {
            try {
                G_firstTime = false;
                File dp = new File("deploy.properties");
                if (!dp.exists() || !dp.canRead()) {
                    URL uri = This.getClass().getResource("/deploy.properties");
                    dp = uri != null ? new File(uri.toURI()) : ((uri = This.getClass().getResource("/WEB-INF/deploy.properties")) != null ? new File(uri.toURI()) : ((uri = This.getClass().getResource("/WEB-INF/classes/deploy.properties")) != null ? new File(uri.toURI()) : null));
                }
                if (dp != null && dp.exists() && dp.canRead()) {
                    try {
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.info("Loaded properties file:" + dp.getAbsolutePath());
                        }
                        Properties p = new Properties();
                        FileInputStream readStream = new FileInputStream(dp);
                        p.load(readStream);
                        p = PropertiesUtil.swapProperties(p);
                        for (String name1 : p.stringPropertyNames()) {
                            String value1 = p.getProperty(name1);
                            System.setProperty(name1, value1);
                        }
                        readStream.close();
                    }
                    catch (Exception e) {
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.info("Error Loading properties file:" + dp.getAbsolutePath());
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initializeApplication(String name, String[] args) {
        this.parseArguments(args);
        this.setCommandLine(args);
        try {
            String result = System.getProperty("CBLCONFIG");
            InputStream fin = null;
            String etcfilename = File.separator + "etc" + File.separator + "cblconfi";
            if (fin == null && result != null) {
                fin = this.getInputStream(result);
            }
            if (fin == null) {
                fin = this.getInputStream("cblconfig");
            }
            if (fin == null) {
                fin = this.getInputStream("cblconfi");
            }
            if (fin == null) {
                fin = this.getInputStream("cobopt.cfg");
            }
            if (fin == null) {
                fin = this.getInputStream(etcfilename + "g");
            }
            if (fin == null) {
                fin = this.getInputStream(etcfilename);
            }
            if (fin != null) {
                this.parseConfigFile(fin);
            }
            RuntimeEnvironment.readDeployProperties(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializeProgram(name);
    }

    private void initializeApplication(Object program, String[] args) {
        this.initializeApplication(program.getClass().getName(), args);
    }

    private InputStream getInputStream(String name) {
        return Utilities.getInputStream(name);
    }

    public static boolean isLittleEndian() {
        return RuntimeEnvironment.getGlobalRuntimeEnvironment().LITTLE_ENDIAN;
    }

    public static boolean isBigEndian() {
        return !RuntimeEnvironment.isLittleEndian();
    }

    private static int checkOS() {
        String OS;
        if (CHECKOS == 0 && (OS = RuntimeEnvironment.getGlobalParameter("os.name").toLowerCase()) != null) {
            if (OS.contains("win")) {
                CHECKOS = 1;
            } else if (OS.contains("as400") || OS.contains("os400") || OS.contains("os/400")) {
                CHECKOS = 2;
            } else if (OS.contains("mac")) {
                CHECKOS = 3;
            } else if (OS.contains("zlinux")) {
                CHECKOS = 4;
            } else if (OS.contains("zos") || OS.contains("uss")) {
                CHECKOS = 5;
            } else if (OS.contains("linux") || OS.contains("ubuntu") || OS.contains("centos") || OS.contains("suse") || OS.contains("rhel")) {
                CHECKOS = 6;
            } else if (OS.contains("nix") || OS.contains("aix") || OS.contains("sunos") || OS.contains("solaris")) {
                CHECKOS = 7;
            }
        }
        return CHECKOS;
    }

    public static boolean isWindows() {
        return RuntimeEnvironment.checkOS() == 1;
    }

    public static boolean isAS400() {
        return RuntimeEnvironment.checkOS() == 2;
    }

    public static boolean isMac() {
        return RuntimeEnvironment.checkOS() == 3;
    }

    public static boolean isZLinux() {
        return RuntimeEnvironment.checkOS() == 4;
    }

    public static boolean isZOS() {
        return RuntimeEnvironment.checkOS() == 5;
    }

    public static boolean isLinux() {
        return RuntimeEnvironment.checkOS() == 6;
    }

    public static boolean isUNIX() {
        return RuntimeEnvironment.checkOS() == 7;
    }

    public Hashtable<String, String> getProperties() {
        return this.programProperties;
    }

    public final void setParameter(String name, String value) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("name=" + name + ". value=" + value + ". ");
        }
        try {
            if (name != null) {
                if (name.startsWith("dcb.")) {
                    System.setProperty(name, value);
                }
                name = name.toUpperCase().replace('_', '-').replace('.', '-');
                if (value == null) {
                    this.programProperties.remove(name);
                    return;
                }
                this.programProperties.put(name, value);
                if ((name.equals("A-CONFIG") || name.equals("ECOBOL-CONFIG") || name.equals("-C") || name.equals("COBCONFIG")) && !this.parsingConfigFile) {
                    this.parsingConfigFile = true;
                    this.parseConfigFile(this.getInputStream(value));
                    this.parsingConfigFile = false;
                } else if (name.equals("DUMP-CONFIG")) {
                    this.getParameter("CONFIG-DUMP-LOAD-PARAMS");
                    this.dumpConfig(value);
                } else if (name.equals("DUMP-CONFIG-EXIT")) {
                    this.getParameter("CONFIG-DUMP-LOAD-PARAMS");
                    this.dumpConfig(value);
                    Shutdown.System_exit(0);
                } else if (name.equals("KEYSTROKE")) {
                    KeyStroke.setKeyStroke(value);
                } else if (name.equals("MENU-ITEM")) {
                    KeyStroke.setMenuItem(value);
                } else if (name.equals("KEYBOARD")) {
                    KeyStroke.setKeyboard(value);
                } else if (name.equals("ECOBOL-CPU-ENDIAN")) {
                    this.LITTLE_ENDIAN = value.toUpperCase().indexOf("LITTLE") >= 0;
                    this.endianSet = true;
                } else if (name.equals("SUN-CPU-ENDIAN")) {
                    this.LITTLE_ENDIAN = value.toUpperCase().indexOf("LITTLE") >= 0;
                    this.endianSet = true;
                } else if (name.equals("APPICON")) {
                    Utilities.setIconImage(value);
                } else if (name.equals("BELL")) {
                    Beep.setBeepEnabled(RuntimeEnvironment.isParameterValue(value));
                } else if (name.equals("BACKGROUND-INTENSITY")) {
                    if ((value = value.trim()).length() > 0) {
                        switch (value.charAt(0)) {
                            case '0': 
                            case '2': {
                                Utilities.setBackgroundIntensity(true);
                                break;
                            }
                            case '1': {
                                Utilities.setBackgroundIntensity(false);
                            }
                        }
                    }
                } else if (name.equals("TEXT")) {
                    int index = value.indexOf(61);
                    if (index >= 0) {
                        String left = value.substring(0, index);
                        String right = value.substring(index + 1);
                        int leftValue = ConvertData.parseInt(left);
                        ResourceManager.setConfigurationText(leftValue, right.trim());
                    }
                } else if (name.equals("BE")) {
                    Variable.setByteEncoding(value);
                } else if (name.equals("IE")) {
                    Variable.setInternationalEncoding(value);
                } else if (name.equals("NUMPROC")) {
                    Variable.setPackedSignEncoding(value);
                } else if (name.equals("CHECKINDEX")) {
                    if (value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("ON") || value.equalsIgnoreCase("1")) {
                        Variable.setBoundsCheck(true);
                    } else {
                        Variable.setBoundsCheck(false);
                    }
                } else if (name.equals("EXTERNALS")) {
                    if (value.equalsIgnoreCase("SESSIONSAFE") || value.equalsIgnoreCase("ON") || value.equalsIgnoreCase("1")) {
                        Context.setSessionSafe(true);
                    } else if (value.equalsIgnoreCase("GLOBAL") || value.equalsIgnoreCase("OFF") || value.equalsIgnoreCase("0")) {
                        Context.setSessionSafe(false);
                    } else {
                        System.err.println("Elastic COBOL runtime configuration error:  -DEXTERNALS=SESSIONSAFE|ON|1|GLOBAL|OFF|0");
                    }
                } else if (name.equals("GARBAGE")) {
                    if (value.equalsIgnoreCase("VERBOSE")) {
                        ArrayIndexOutOfBoundsVariable.setQuietMode(1);
                    } else if (value.equalsIgnoreCase("QUIET")) {
                        ArrayIndexOutOfBoundsVariable.setQuietMode(2);
                    }
                } else if (name.equals("TRUNC")) {
                    if (value.equalsIgnoreCase("BINARY") || value.equalsIgnoreCase("BIN")) {
                        Variable.setRoundOverflow();
                    } else if (value.equalsIgnoreCase("STD")) {
                        Variable.setTruncateStandard();
                    } else {
                        Variable.setTruncateOpt();
                    }
                } else if (name.equals("BUFFER-OVERRUN")) {
                    Variable.setBufferOverrun(value.toString());
                } else if (name.equals("SYSTEMENVFILE")) {
                    this.parseDDCardName(value);
                } else if (!this.endianSet) {
                    if (name.equals("OS-ARCH") && (value.indexOf("86") >= 0 || value.toUpperCase().indexOf("PENTIUM") >= 0 || value.toUpperCase().indexOf("IA32") >= 0 || value.toUpperCase().indexOf("IA-32") >= 0)) {
                        this.LITTLE_ENDIAN = true;
                        this.endianSet = true;
                    } else if (name.equals("SUN-IO-UNICODE-ENCODING") && value.toUpperCase().indexOf("LITTLE") >= 0) {
                        this.LITTLE_ENDIAN = true;
                        this.endianSet = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isParameter(String param) {
        return RuntimeEnvironment.isParameterValue(this.getParameter(param));
    }

    public final boolean isParameter(String param, boolean defaultValue) {
        return RuntimeEnvironment.isParameterValue(this.getParameter(param), defaultValue);
    }

    public final String getParameter(int number) {
        return this.getParameter("parameter" + this.format(number, 2));
    }

    @Override
    public final String getParameter(String param) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("param=" + param + ". ");
        }
        if (param == null || param.isEmpty()) {
            return null;
        }
        String result = null;
        if (!this.systemPropertiesDisallowed) {
            try {
                result = System.getProperty(param);
                if (result != null) {
                    return result;
                }
                result = System.getProperty(param.toUpperCase());
                if (result != null) {
                    return result;
                }
            }
            catch (Exception t) {
                this.systemPropertiesDisallowed = true;
            }
            try {
                result = this.getEnvarIgnoreCase(param);
                if (result != null) {
                    return result.trim();
                }
            }
            catch (Exception t) {
                this.systemPropertiesDisallowed = true;
            }
        }
        try {
            param = param.trim();
            String uparam = param.toUpperCase();
            String uparamdash = uparam.replace('_', '-').replace('.', '-');
            result = this.programProperties.get(uparamdash);
            if (result != null) {
                return result;
            }
            if (this.parent != null) {
                result = this.parent.getParameter(param);
                if (result == null) {
                    result = this.parent.getParameter(uparam);
                }
                if (result == null) {
                    result = this.parent.getParameter(param.toLowerCase());
                }
                if (result != null) {
                    this.setParameter(uparamdash, result);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public final String getEnvarIgnoreCase(String param) {
        String result = null;
        Map<String, String> envars = System.getenv();
        for (Map.Entry<String, String> entry : envars.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(param)) continue;
            result = entry.getValue();
            break;
        }
        return result;
    }

    public void parseSystemProperties() {
        try {
            Properties systemProperties = System.getProperties();
            String propertyName = null;
            String currentProperty = null;
            Enumeration<?> e = systemProperties.propertyNames();
            while (e.hasMoreElements()) {
                propertyName = (String)e.nextElement();
                currentProperty = System.getProperty(propertyName);
                this.setParameter(propertyName, currentProperty);
            }
        }
        catch (Exception systemException) {
            try {
                this.setSystemParameter("JAVA.VERSION", "java.version");
                this.setSystemParameter("JAVA.VENDOR", "java.vendor");
                this.setSystemParameter("JAVA.VENDOR.URL", "java.vendor.url");
                this.setSystemParameter("JAVA.CLASS.VERSION", "java.class.version");
                this.setSystemParameter("OS.NAME", "os.name");
                this.setSystemParameter("OS.ARCH", "os.arch");
                this.setSystemParameter("OS.VERSION", "os.version");
                this.setSystemParameter("FILE.SEPARATOR", "file.separator");
                this.setSystemParameter("PATH.SEPARATOR", "path.separator");
                this.setSystemParameter("LINE.SEPARATOR", "line.separator");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setSystemParameter(String paramName, String propName) {
        try {
            this.setParameter(paramName, propName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseDDCardName(String filename) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(filename)));){
            String line = null;
            line = reader.readLine();
            while (line != null) {
                try {
                    String paramName = line.substring(0, line.indexOf("="));
                    String propName = line.substring(line.indexOf("=") + 1);
                    this.setSystemParameter(paramName, propName);
                }
                catch (Exception e) {
                    CobolException.runtimeError("Parsing error", "Problem parsing the passed arguments to the program", (Throwable)e);
                }
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parseConfigFile(InputStream fin) {
        if (fin == null) {
            return;
        }
        try {
            BufferedReader d = new BufferedReader(new InputStreamReader(fin));
            String line = null;
            String keyword = null;
            String value = null;
            int length = 0;
            char c = '\u0000';
            boolean stripping = false;
            int stripped = 0;
            try {
                block12: do {
                    if ((line = d.readLine()) != null) {
                        if ((line = line.trim()).startsWith("set ")) {
                            try {
                                line = line.substring(4);
                                line = line.trim();
                            }
                            catch (Exception exception) {}
                        } else if (line.startsWith("setenv ")) {
                            try {
                                line = line.substring(7);
                                line = line.trim();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (line == null || line.startsWith("#") || line.startsWith("[")) continue;
                    try {
                        length = line.length();
                        stripping = true;
                        stripped = 0;
                        for (int i = 0; i < length; ++i) {
                            c = line.charAt(i);
                            if (c == ' ' || c == '\t' || c == ':' || c == '=') {
                                if (!stripping) {
                                    keyword = line.substring(stripped, i);
                                    value = line.substring(i + 1).trim();
                                    value = value.replace('\t', ' ');
                                    this.setParameter(keyword, value);
                                    continue block12;
                                }
                                stripped = i + 1;
                                continue;
                            }
                            stripping = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (line != null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                d.close();
                fin.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parseArguments(String[] args) {
        try {
            this.setCommandLine(args);
            if (args == null) {
                this.setArgumentCount(0);
                return;
            }
            this.setArgumentCount(args.length);
            for (int i = 0; i < args.length; ++i) {
                int switchNumber;
                char switchChar;
                if (args[i] == null) continue;
                this.setParameter("parameter" + this.format(i + this.ARGUMENT_BASE, 2), args[i]);
                if (args[i].length() == 2 && (args[i].charAt(0) == '/' || args[i].charAt(0) == '-')) {
                    switchChar = args[i].charAt(1);
                    switchNumber = -1;
                    if (switchChar >= 'a' && switchChar <= 'z') {
                        switchNumber = switchChar - 97 + 1;
                    } else if (switchChar >= 'A' && switchChar <= 'Z') {
                        switchNumber = switchChar - 65 + 1;
                    } else if (switchChar >= '1' && switchChar <= '9') {
                        switchNumber = switchChar - 49 + 1;
                    }
                    if (switchNumber >= 1) {
                        Switch.setSwitch(switchNumber, true);
                    }
                } else if (args[i].length() == 3 && (args[i].charAt(0) == '/' || args[i].charAt(0) == '-') && args[i].charAt(1) == '-') {
                    switchChar = args[i].charAt(2);
                    switchNumber = -1;
                    if (switchChar >= 'a' && switchChar <= 'z') {
                        switchNumber = switchChar - 97 + 1;
                    } else if (switchChar >= 'A' && switchChar <= 'Z') {
                        switchNumber = switchChar - 65 + 1;
                    } else if (switchChar >= '1' && switchChar <= '9') {
                        switchNumber = switchChar - 49 + 1;
                    }
                    if (switchNumber >= 1) {
                        Switch.setSwitch(switchNumber, false);
                    }
                }
                int index = args[i].indexOf(61);
                if (index < 0) continue;
                String argumentName = "";
                String argumentValue = "";
                try {
                    argumentName = args[i].substring(0, index);
                }
                catch (Exception e) {
                    argumentName = "";
                }
                try {
                    argumentValue = args[i].substring(index + 1);
                }
                catch (Exception e) {
                    argumentValue = "";
                }
                this.setParameter(argumentName, argumentValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCommandLine(String[] args) {
        try {
            if (args == null) {
                return;
            }
            int length = 0;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                length += args[i].length() + 1;
            }
            StringBuffer result = new StringBuffer(length);
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    result.append(' ');
                }
                if (args[i] == null) continue;
                if (args[i].indexOf(32) >= 0) {
                    result.append('\"').append(args[i]).append('\"');
                    continue;
                }
                result.append(args[i]);
            }
            this.setCommandLine(result.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCommandLine(String passCmdLine) {
        if (passCmdLine != null) {
            this.cmdLine = passCmdLine;
        }
    }

    public String getCommandLine() {
        return this.cmdLine;
    }

    public void dumpConfig(String value) {
        try {
            FileOutputStream fout = null;
            OutputStream out = null;
            if (value.equalsIgnoreCase("SYSOUT") || value.equalsIgnoreCase("STDOUT")) {
                out = System.out;
            } else if (value.equalsIgnoreCase("SYSERR") || value.equalsIgnoreCase("STDERR")) {
                out = System.err;
            } else {
                fout = new FileOutputStream(value);
                out = fout;
            }
            Enumeration<String> keys = this.programProperties.keys();
            String key = null;
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                if (value == null) continue;
                value = this.programProperties.get(key);
                out.write((key + "=" + value + "\n").getBytes());
            }
            if (fout != null) {
                fout.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setArgumentCount(int n) {
        this.argumentCount = n;
        this.setParameter("parameters", String.valueOf(this.argumentCount));
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    private final String format(int n, int digits) {
        if (digits <= 0) {
            return "";
        }
        String result = String.valueOf(n);
        if (result.length() == digits) {
            return result;
        }
        if (result.length() > digits) {
            return result.substring(0, digits);
        }
        int deficitDigits = digits - result.length();
        char[] deficit = new char[deficitDigits];
        for (int i = 0; i < deficitDigits; ++i) {
            deficit[i] = 48;
        }
        return new StringBuffer(digits).append(deficit).append(result).toString();
    }

    public static Date getJobDate() {
        return jobDate;
    }

    static {
        retExcepToIDE = false;
        G_firstTime = true;
        CHECKOS = 0;
        jobDate = null;
        jobDate = new Date();
    }
}

