/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.Index;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.util.String2;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;

public class ScreenProperty
extends com.heirloomcomputing.term.ScreenProperty {
    public static final int COLOR_BIT_REVERSE_VIDEO = 1024;
    public static final int COLOR_BIT_LOW_INTENSITY = 2048;
    public static final int COLOR_BIT_HIGH_INTENSITY = 4096;
    public static final int COLOR_BIT_UNDERLINE = 8192;
    public static final int COLOR_BIT_BLINK = 16384;
    public static final int COLOR_BIT_PROTECTED = 32768;
    public static final int COLOR_BIT_BG_LOW_INTENSITY = 65536;
    public static final int COLOR_BIT_BG_HIGH_INTENSITY = 131072;
    public static final boolean debugMode = false;
    private static final Class<String>[] templateString = new Class[]{String.class};
    private static final Class<Integer>[] templateInteger = new Class[]{Integer.TYPE};
    private static final Class<Double>[] templateDouble = new Class[]{Double.TYPE};
    private static final Class<Boolean>[] templateBoolean = new Class[]{Boolean.TYPE};
    private static final Class<Long>[] templateLong = new Class[]{Long.TYPE};
    private static final Class<ProcedurePointer>[] templateProcedurePointer = new Class[]{ProcedurePointer.class};
    private static final Class<Variable>[] templateVariable = new Class[]{Variable.class};
    private static final Class<?>[] templateEmpty = new Class[0];
    private static final Class<IDatatype[]>[] templateArray = new Class[]{IDatatype[].class};
    private static final String[] EARLY_PROPERTIES = new String[]{"setUnsorted(", "setPaged(", "setUpper(", "setLower(", "setFontHandle(", "setFontName(", "setFont(", "setControlFont("};
    private float line = -1.0f;
    private float col = -1.0f;
    private int properties;
    private int additionalProperties;
    private int fg = -1;
    private int bg = -1;
    private int size = -1;
    private Vector<HandleScreenProperty> handleScreenProperties;
    private Variable sizeSym;
    private Variable colSym;
    private Variable lineSym;
    private Variable colorSym;
    private Variable atSym;
    private Variable mainVariable;
    private String defaultValue;
    private char prompt;
    public static final int WANG_FAC = 128;
    public static final int WANG_UL = 32;
    public static final int WANG_PRO = 4;
    public static final int WANG_NUM = 2;
    public static final int WANG_UPR = 1;
    public static final int WANG_SU = 24;
    public static final int WANG_FL = 16;
    public static final int WANG_LO = 8;
    public static final int WANG_HI = 0;
    public static final int WANG_BELL = 224;

    public ScreenProperty() {
    }

    public ScreenProperty(int properties, int fg, int bg, float line, float col) {
        if (fg == 0 && bg == 0) {
            fg = -1;
            bg = -1;
        }
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.line = line;
        this.col = col;
    }

    public ScreenProperty(int properties, int fg, int bg) {
        if (fg == 0 && bg == 0) {
            fg = -1;
            bg = -1;
        }
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.line = 1.0f;
        this.col = 1.0f;
    }

    public ScreenProperty(int properties, int fg, int bg, int line, int col) {
        this(properties, fg, bg, (float)line, (float)col);
    }

    public ScreenProperty(int properties, int fg, int bg, Numeric line, int col) {
        this(properties, fg, bg, line, (float)col);
    }

    public ScreenProperty(int properties, int fg, int bg, Numeric line, float col) {
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.lineSym = line;
        this.col = col;
    }

    public ScreenProperty(int properties, int fg, int bg, int line, Numeric col) {
        this(properties, fg, bg, (float)line, col);
    }

    public ScreenProperty(int properties, int fg, int bg, float line, Numeric col) {
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.line = line;
        this.colSym = col;
    }

    public ScreenProperty(int properties, int fg, int bg, Numeric line, Numeric col) {
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.lineSym = line;
        this.colSym = col;
    }

    public ScreenProperty(int properties, int fg, int bg, int line, int col, int prompt) {
        this(properties, fg, bg, (float)line, (float)col, prompt);
    }

    public ScreenProperty(int properties, int fg, int bg, float line, float col, int prompt) {
        this.prompt = (char)prompt;
        if (fg == 0 && bg == 0) {
            fg = -1;
            bg = -1;
        }
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.line = line;
        this.col = col;
    }

    public ScreenProperty(int properties, int fg, int bg, Numeric line, int col, int prompt) {
        this(properties, fg, bg, line, (float)col, prompt);
    }

    public ScreenProperty(int properties, int fg, int bg, Numeric line, float col, int prompt) {
        this.prompt = (char)prompt;
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.lineSym = line;
        this.col = col;
    }

    public ScreenProperty(int properties, int fg, int bg, int line, Numeric col, int prompt) {
        this(properties, fg, bg, (float)line, col, prompt);
    }

    public ScreenProperty(int properties, int fg, int bg, float line, Numeric col, int prompt) {
        this.prompt = (char)prompt;
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.line = line;
        this.colSym = col;
    }

    public ScreenProperty(int properties, int fg, int bg, Numeric line, Numeric col, int prompt) {
        this.prompt = (char)prompt;
        this.properties = properties;
        this.fg = fg;
        this.bg = bg;
        this.lineSym = line;
        this.colSym = col;
    }

    public final boolean isBlankScreen() {
        return (this.properties & 1) != 0;
    }

    public final boolean isBlankLine() {
        return (this.properties & 2) != 0;
    }

    public final boolean isAuto() {
        return (this.properties & 4) != 0;
    }

    public final boolean isSecure() {
        return (this.properties & 8) != 0;
    }

    public final boolean isRequired() {
        return (this.properties & 0x10) != 0;
    }

    public final boolean isFull() {
        return (this.properties & 0x20) != 0;
    }

    public final boolean isBell() {
        return (this.properties & 0x40) != 0;
    }

    public final boolean isBlink() {
        return (this.properties & 0x80) != 0;
    }

    public final boolean isEraseEOL() {
        return (this.properties & 0x100) != 0;
    }

    public final boolean isEraseEOS() {
        return (this.properties & 0x200) != 0;
    }

    public final boolean isHighlight() {
        return (this.properties & 0x400) != 0;
    }

    public final boolean isLowlight() {
        return (this.properties & 0x800) != 0;
    }

    public final boolean isReverseVideo() {
        return (this.properties & 0x1000) != 0;
    }

    public final boolean isUnderline() {
        return (this.properties & 0x2000) != 0;
    }

    public final boolean isLineRelative() {
        return (this.properties & 0x4000) != 0;
    }

    public final boolean isColumnRelative() {
        return (this.properties & 0x8000) != 0;
    }

    public final int getForegroundColor() {
        this.parseColor();
        return this.fg;
    }

    public final int getBackgroundColor() {
        this.parseColor();
        return this.bg;
    }

    public final boolean isGrid() {
        return (this.properties & 0x10000000) != 0;
    }

    public final boolean isLeftline() {
        return (this.properties & 0x40000000) != 0;
    }

    public final boolean isOverline() {
        return (this.properties & 0x1000000) != 0;
    }

    public final boolean isSpaceFill() {
        return (this.properties & 0x2000000) != 0;
    }

    public final boolean isZeroFill() {
        return (this.properties & 0x4000000) != 0;
    }

    public final boolean isPosition() {
        return (this.properties & 0x8000000) != 0;
    }

    public final char getPrompt() {
        return this.prompt;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSize() {
        return this.sizeSym != null || this.size >= 0;
    }

    public int getSize() {
        return this.sizeSym != null ? this.sizeSym.toInt() : this.size;
    }

    public final void setForegroundColor(int value) {
        this.colorSym = null;
        this.fg = value;
    }

    public final void setBackgroundColor(int value) {
        this.colorSym = null;
        this.bg = value;
    }

    public final boolean isLineRelativeMinus() {
        return (this.additionalProperties & 8) != 0;
    }

    public final boolean isColumnRelativeMinus() {
        return (this.additionalProperties & 4) != 0;
    }

    public final boolean isLineInPixels() {
        return (this.additionalProperties & 0x20) != 0;
    }

    public final boolean isColumnInPixels() {
        return (this.additionalProperties & 0x10) != 0;
    }

    public final float getLine() {
        if (this.atSym != null) {
            switch (this.atSym.length()) {
                case 7: 
                case 8: {
                    return this.atSym.toInt() / 10000;
                }
                case 5: 
                case 6: {
                    return this.atSym.toInt() / 1000;
                }
                case 3: 
                case 4: {
                    return this.atSym.toInt() / 100;
                }
                case 1: 
                case 2: {
                    return this.atSym.toInt() / 10;
                }
            }
        }
        return this.lineSym != null ? this.lineSym.toFloat() : this.line;
    }

    public final float getColumn() {
        if (this.atSym != null) {
            switch (this.atSym.length()) {
                case 7: 
                case 8: {
                    return this.atSym.toInt() % 10000;
                }
                case 5: 
                case 6: {
                    return this.atSym.toInt() % 1000;
                }
                case 3: 
                case 4: {
                    return this.atSym.toInt() % 100;
                }
                case 1: 
                case 2: {
                    return this.atSym.toInt() % 10;
                }
            }
        }
        return this.colSym != null ? this.colSym.toFloat() : this.col;
    }

    public final void setLine(int line) {
        this.setLine((float)line);
    }

    public final void setLine(float line) {
        if (this.lineSym != null) {
            this.lineSym.move(line);
            this.line = 0.0f;
        } else {
            this.line = line;
        }
    }

    public final void setColumn(int col) {
        this.setColumn((float)col);
    }

    public final void setColumn(float col) {
        if (this.colSym != null) {
            this.colSym.move(col);
            this.col = 0.0f;
        } else {
            this.col = col;
        }
    }

    public final ScreenProperty withBlankScreen() {
        this.properties |= 1;
        return this;
    }

    public final ScreenProperty withBlankLine() {
        this.properties |= 2;
        return this;
    }

    public final ScreenProperty withAuto() {
        this.properties |= 4;
        return this;
    }

    public final ScreenProperty withSecure() {
        this.properties |= 8;
        return this;
    }

    public final ScreenProperty withRequired() {
        this.properties |= 0x10;
        return this;
    }

    public final ScreenProperty withFull() {
        this.properties |= 0x20;
        return this;
    }

    public final ScreenProperty withBell() {
        this.properties |= 0x40;
        return this;
    }

    public final ScreenProperty withBlink() {
        this.properties |= 0x80;
        return this;
    }

    public final ScreenProperty withEraseEOL() {
        this.properties |= 0x100;
        return this;
    }

    public final ScreenProperty withEraseEOS() {
        this.properties |= 0x200;
        return this;
    }

    public final ScreenProperty withHighlight() {
        this.properties |= 0x400;
        return this;
    }

    public final ScreenProperty withLowlight() {
        this.properties |= 0x800;
        return this;
    }

    public final ScreenProperty withReverseVideo() {
        this.properties |= 0x1000;
        return this;
    }

    public final ScreenProperty withUnderline() {
        this.properties |= 0x2000;
        return this;
    }

    public final ScreenProperty withLineRelative() {
        this.properties |= 0x4000;
        return this;
    }

    public final ScreenProperty withColumnRelative() {
        this.properties |= 0x8000;
        return this;
    }

    public final ScreenProperty withForegroundColor(int fg) {
        this.fg = fg;
        return this;
    }

    public final ScreenProperty withBackgroundColor(int bg) {
        this.bg = bg;
        return this;
    }

    public final ScreenProperty withGrid() {
        this.properties |= 0x10000000;
        return this;
    }

    public final ScreenProperty withLeftline() {
        this.properties |= 0x40000000;
        return this;
    }

    public final ScreenProperty withOverline() {
        this.properties |= 0x1000000;
        return this;
    }

    public final ScreenProperty withSpaceFill() {
        this.properties |= 0x2000000;
        return this;
    }

    public final ScreenProperty withZeroFill() {
        this.properties |= 0x4000000;
        return this;
    }

    public final ScreenProperty withSize(int n) {
        this.size = n;
        this.sizeSym = null;
        return this;
    }

    public final ScreenProperty withSize(Variable v) {
        this.sizeSym = v;
        this.size = -1;
        return this;
    }

    public final ScreenProperty withColor(Variable v) {
        this.colorSym = v;
        return this;
    }

    public final ScreenProperty withColor(int v) {
        this.parseColor(v);
        return this;
    }

    public final ScreenProperty withDefault(String s) {
        this.defaultValue = s;
        return this;
    }

    public final ScreenProperty withDefault(Variable v) {
        this.defaultValue = v.toText();
        return this;
    }

    public final ScreenProperty withControl(Variable controlVariable) {
        String controlString = controlVariable.toString();
        return this.withControl(controlString);
    }

    public final ScreenProperty withControl(String controlString) {
        String[] s = controlString.toLowerCase().replaceAll(",", " ").split("\\s+");
        int c = s.length;
        for (int i = 0; i < c; ++i) {
            if (s[i].equals("foreground-color")) {
                if (s[i + 1].equals("black")) {
                    this.setForegroundColor(0);
                    continue;
                }
                if (s[i + 1].equals("blue")) {
                    this.setForegroundColor(1);
                    continue;
                }
                if (s[i + 1].equals("green")) {
                    this.setForegroundColor(2);
                    continue;
                }
                if (s[i + 1].equals("cyan")) {
                    this.setForegroundColor(3);
                    continue;
                }
                if (s[i + 1].equals("red")) {
                    this.setForegroundColor(4);
                    continue;
                }
                if (s[i + 1].equals("magenta")) {
                    this.setForegroundColor(5);
                    continue;
                }
                if (s[i + 1].equals("yellow")) {
                    this.setForegroundColor(6);
                    continue;
                }
                if (s[i + 1].equals("brown")) {
                    this.setForegroundColor(6);
                    continue;
                }
                if (!s[i + 1].equals("white")) continue;
                this.setForegroundColor(7);
                continue;
            }
            if (s[i].equals("background-color")) {
                if (s[i + 1].equals("black")) {
                    this.setBackgroundColor(0);
                    continue;
                }
                if (s[i + 1].equals("blue")) {
                    this.setBackgroundColor(1);
                    continue;
                }
                if (s[i + 1].equals("green")) {
                    this.setBackgroundColor(2);
                    continue;
                }
                if (s[i + 1].equals("cyan")) {
                    this.setBackgroundColor(3);
                    continue;
                }
                if (s[i + 1].equals("red")) {
                    this.setBackgroundColor(4);
                    continue;
                }
                if (s[i + 1].equals("magenta")) {
                    this.setBackgroundColor(5);
                    continue;
                }
                if (s[i + 1].equals("yellow")) {
                    this.setBackgroundColor(6);
                    continue;
                }
                if (s[i + 1].equals("brown")) {
                    this.setBackgroundColor(6);
                    continue;
                }
                if (!s[i + 1].equals("white")) continue;
                this.setBackgroundColor(7);
                continue;
            }
            if (s[i].equals("high") || s[i].equals("highlight") || s[i].equals("bright") || s[i].equals("bold")) {
                this.properties |= 0x400;
                continue;
            }
            if (s[i].equals("low") || s[i].equals("lowlight") || s[i].equals("dim")) {
                this.properties |= 0x800;
                continue;
            }
            if (s[i].equals("underline")) {
                this.properties |= 0x2000;
                continue;
            }
            if (!s[i].equals("reverse")) continue;
            this.properties |= 0x1000;
        }
        return this;
    }

    private void parseColor() {
        if (this.colorSym != null) {
            this.parseColor(this.colorSym.toInt());
        }
    }

    private void parseColor(int mask) {
        int color2 = mask & 0x3FF;
        if ((mask & 0x800) != 0) {
            this.properties |= 0x800;
        }
        if ((mask & 0x1000) != 0) {
            this.properties |= 0x400;
        }
        if ((mask & 0x400) != 0) {
            this.properties |= 0x1000;
        }
        if ((mask & 0x2000) != 0) {
            this.properties |= 0x2000;
        }
        if ((mask & 0x4000) != 0) {
            this.properties |= 0x80;
        }
        int color_bg = color2 / 32 - 1;
        int color_fg = color2 % 32 - 1;
        if (color_bg >= 0) {
            this.bg = color_bg & 0xF;
        }
        if (color_fg >= 0) {
            this.fg = color_fg &= 0xF;
        }
    }

    public final ScreenProperty withAdditionalProperties(int n) {
        this.additionalProperties = n;
        return this;
    }

    public final int getAdditionalProperties() {
        return this.additionalProperties;
    }

    public final int getProperties() {
        return this.properties;
    }

    public final int setProperties(int properties) {
        this.properties = properties;
        return this.properties;
    }

    public final boolean isNoUpdate() {
        return (this.additionalProperties & 0x40) != 0;
    }

    public final boolean isUpdate() {
        return !this.isNoUpdate();
    }

    public final boolean isNoTab() {
        return (this.additionalProperties & 2) != 0;
    }

    public Variable getMainVariable() {
        return this.mainVariable;
    }

    public ScreenProperty setMainProperties(Variable v, int screenProps, int fore, int back) {
        this.properties = screenProps;
        this.fg = fore;
        this.bg = back;
        IO.setProperty(v, this);
        this.mainVariable = v;
        if (v.getChild() != null && this.handleScreenProperties != null) {
            this.setMainGroupProperties(v);
        }
        return this;
    }

    public ScreenProperty setMainProperties(int screenProps, int fore, int back) {
        this.properties = screenProps;
        this.fg = fore;
        this.bg = back;
        return this;
    }

    public ScreenProperty withLine(int value) {
        this.line = value;
        return this;
    }

    public ScreenProperty withLine(double value) {
        this.line = (float)value;
        return this;
    }

    public ScreenProperty withLine(Variable value) {
        this.lineSym = value;
        return this;
    }

    public ScreenProperty withAt(int value, int size) {
        switch (size) {
            case 7: 
            case 8: {
                this.withLine(value / 10000);
                this.withColumn(value % 10000);
                break;
            }
            case 5: 
            case 6: {
                this.withLine(value / 1000);
                this.withColumn(value % 1000);
                break;
            }
            case 3: 
            case 4: {
                this.withLine(value / 100);
                this.withColumn(value % 100);
                break;
            }
            case 1: 
            case 2: {
                this.withLine(value / 10);
                this.withColumn(value % 10);
            }
        }
        return this;
    }

    public ScreenProperty withAt(double value, int size) {
        return this.withAt((int)value, size);
    }

    public ScreenProperty withAt(Variable value, int size) {
        this.atSym = value;
        return this;
    }

    public ScreenProperty withColumn(int value) {
        this.col = value;
        return this;
    }

    public ScreenProperty withColumn(double value) {
        this.col = (float)value;
        return this;
    }

    public ScreenProperty withColumn(Variable value) {
        this.colSym = value;
        return this;
    }

    public ScreenProperty withPrompt(int value) {
        this.prompt = (char)value;
        return this;
    }

    public ScreenProperty withPrompt(char value) {
        this.prompt = value;
        return this;
    }

    public ScreenProperty withPrompt(double value) {
        this.prompt = (char)value;
        return this;
    }

    public ScreenProperty withPrompt(Variable value) {
        return this.withPrompt(value.toString());
    }

    public ScreenProperty withPrompt(Numeric value) {
        return this.withPrompt(value.toInt());
    }

    public ScreenProperty withPrompt(String s) {
        if (s != null && s.length() > 0) {
            return this.withPrompt(s.charAt(0));
        }
        return this;
    }

    private char propertyType(String property) {
        block4: {
            try {
                if (property == null) {
                    return '\u0000';
                }
                int index = property.indexOf(37);
                if (index >= 0) {
                    return Character.toLowerCase(property.charAt(index + 1));
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block4;
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
        }
        return '\u0000';
    }

    public void addProperty(String property, Variable value) {
        this.registerLateProperty(property, new Variable[]{value});
    }

    public void addProperty(String property, Index value) {
        this.registerLateProperty(property, new Index[]{value});
    }

    public void addProperty(String property, Object value) {
        this.registerLateProperty(property, new Object[]{value});
    }

    public void addProperty(String property, int value1, int value2) {
        this.registerLateProperty(property, new Object[]{new Integer(value1), new Integer(value2)});
    }

    public void addProperty(String property, boolean value) {
        switch (this.propertyType(property)) {
            case 'b': {
                this.registerProperty(property, new Boolean[]{new Boolean(value)});
                break;
            }
            case 'i': {
                this.registerProperty(property, new Integer[]{new Integer(value ? 1 : 0)});
                break;
            }
            case 'l': {
                this.registerProperty(property, new Long[]{new Long(value ? 1L : 0L)});
                break;
            }
            case 'd': {
                this.registerProperty(property, new Double[]{new Double(value ? 1.0 : 0.0)});
                break;
            }
            case 's': {
                this.registerProperty(property, new String[]{value ? "1" : "0"});
                break;
            }
            case 'v': {
                this.registerProperty(property, new Numeric[]{value ? new Numeric(1) : new Numeric()});
                break;
            }
            default: {
                this.registerProperty(property, null);
            }
        }
    }

    public void addProperty(String property, byte value) {
        switch (this.propertyType(property)) {
            case 'b': {
                this.registerProperty(property, new Boolean[]{new Boolean(value != 0)});
                break;
            }
            case 'i': {
                this.registerProperty(property, new Integer[]{new Integer(value)});
                break;
            }
            case 'l': {
                this.registerProperty(property, new Long[]{new Long(value)});
                break;
            }
            case 'd': {
                this.registerProperty(property, new Double[]{new Double(value)});
                break;
            }
            case 's': {
                this.registerProperty(property, new String[]{String.valueOf(value)});
                break;
            }
            case 'v': {
                this.registerProperty(property, new Numeric[]{new Numeric(value)});
                break;
            }
            case 'p': {
                this.registerLateProperty(property, new Integer[]{new Integer(value)});
                break;
            }
            default: {
                this.registerProperty(property, null);
            }
        }
    }

    public void addProperty(String property, short value) {
        switch (this.propertyType(property)) {
            case 'b': {
                this.registerProperty(property, new Boolean[]{new Boolean(value != 0)});
                break;
            }
            case 'i': {
                this.registerProperty(property, new Integer[]{new Integer(value)});
                break;
            }
            case 'l': {
                this.registerProperty(property, new Long[]{new Long(value)});
                break;
            }
            case 'd': {
                this.registerProperty(property, new Double[]{new Double(value)});
                break;
            }
            case 's': {
                this.registerProperty(property, new String[]{String.valueOf(value)});
                break;
            }
            case 'v': {
                this.registerProperty(property, new Numeric[]{new Numeric(value)});
                break;
            }
            case 'p': {
                this.registerLateProperty(property, new Integer[]{new Integer(value)});
                break;
            }
            default: {
                this.registerProperty(property, null);
            }
        }
    }

    public void addProperty(String property, int value) {
        switch (this.propertyType(property)) {
            case 'b': {
                this.registerProperty(property, new Boolean[]{new Boolean(value != 0)});
                break;
            }
            case 'i': {
                this.registerProperty(property, new Integer[]{new Integer(value)});
                break;
            }
            case 'l': {
                this.registerProperty(property, new Long[]{new Long(value)});
                break;
            }
            case 'd': {
                this.registerProperty(property, new Double[]{new Double(value)});
                break;
            }
            case 's': {
                this.registerProperty(property, new String[]{String.valueOf(value)});
                break;
            }
            case 'v': {
                this.registerProperty(property, new Numeric[]{new Numeric(value)});
                break;
            }
            case 'p': {
                this.registerLateProperty(property, new Integer[]{new Integer(value)});
                break;
            }
            default: {
                this.registerProperty(property, null);
            }
        }
    }

    public void addProperty(String property, long value) {
        switch (this.propertyType(property)) {
            case 'b': {
                this.registerProperty(property, new Boolean[]{new Boolean(value != 0L)});
                break;
            }
            case 'i': {
                this.registerProperty(property, new Integer[]{new Integer((int)value)});
                break;
            }
            case 'l': {
                this.registerProperty(property, new Long[]{new Long(value)});
                break;
            }
            case 'd': {
                this.registerProperty(property, new Double[]{new Double(value)});
                break;
            }
            case 's': {
                this.registerProperty(property, new String[]{String.valueOf(value)});
                break;
            }
            case 'v': {
                this.registerProperty(property, new Numeric[]{new Numeric(value)});
                break;
            }
            case 'p': {
                this.registerLateProperty(property, new Integer[]{new Integer((int)value)});
                break;
            }
            default: {
                this.registerProperty(property, null);
            }
        }
    }

    public void addProperty(String property, float value) {
        switch (this.propertyType(property)) {
            case 'b': {
                this.registerProperty(property, new Boolean[]{new Boolean(value != 0.0f)});
                break;
            }
            case 'i': {
                this.registerProperty(property, new Integer[]{new Integer((int)value)});
                break;
            }
            case 'l': {
                this.registerProperty(property, new Long[]{new Long((long)value)});
                break;
            }
            case 'd': {
                this.registerProperty(property, new Double[]{new Double(value)});
                break;
            }
            case 's': {
                this.registerProperty(property, new String[]{String.valueOf(value)});
                break;
            }
            case 'v': {
                this.registerProperty(property, new Comp1[]{new Comp1(value)});
                break;
            }
            default: {
                this.registerProperty(property, null);
            }
        }
    }

    public void addProperty(String property, double value) {
        switch (this.propertyType(property)) {
            case 'b': {
                this.registerProperty(property, new Boolean[]{new Boolean(value != 0.0)});
                break;
            }
            case 'i': {
                this.registerProperty(property, new Integer[]{new Integer((int)value)});
                break;
            }
            case 'l': {
                this.registerProperty(property, new Long[]{new Long((long)value)});
                break;
            }
            case 'd': {
                this.registerProperty(property, new Double[]{new Double(value)});
                break;
            }
            case 's': {
                this.registerProperty(property, new String[]{String.valueOf(value)});
                break;
            }
            case 'v': {
                this.registerProperty(property, new Comp2[]{new Comp2(value)});
                break;
            }
            default: {
                this.registerProperty(property, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addProperty(String property, String value) {
        propertyType = this.propertyType(property);
        switch (propertyType) {
            case 'b': {
                booleanValue = false;
                try {
                    if (value != null && value.length() > 0) {
                        value = value.trim();
                        c = value.charAt(0);
                        switch (c) {
                            case 'T': 
                            case 't': {
                                booleanValue = true;
                                break;
                            }
                            case 'F': 
                            case 'f': {
                                break;
                            }
                            default: {
                                booleanValue = Integer.parseInt(value) != 0;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) ** GOTO lbl22
                    LogSetup.LOGGER.info("catch(Exception e). ");
                    e.printStackTrace();
                }
lbl22:
                // 3 sources

                this.registerProperty(property, new Boolean[]{new Boolean(booleanValue)});
                break;
            }
            case 'i': {
                intValue = null;
                try {
                    intValue = new Integer(value.trim());
                }
                catch (Exception e) {
                    intValue = new Integer(0);
                    if (!LogSetup.IS_LOGGING_INFO) ** GOTO lbl34
                    LogSetup.LOGGER.info("catch(Exception e). ");
                    e.printStackTrace();
                }
lbl34:
                // 3 sources

                this.registerProperty(property, new Integer[]{intValue});
                break;
            }
            case 'l': {
                longValue = null;
                try {
                    longValue = new Long(value.trim());
                }
                catch (Exception e) {
                    longValue = new Long(0L);
                    if (!LogSetup.IS_LOGGING_INFO) ** GOTO lbl46
                    LogSetup.LOGGER.info("catch(Exception e). ");
                    e.printStackTrace();
                }
lbl46:
                // 3 sources

                this.registerProperty(property, new Long[]{longValue});
                break;
            }
            case 'd': {
                this.registerProperty(property, new Double[]{new Double(value)});
                break;
            }
            case 's': {
                this.registerProperty(property, new String[]{value});
                break;
            }
            case 'v': {
                this.registerProperty(property, new Variable[]{new Variable(value)});
                break;
            }
            case 'a': {
                this.registerProperty(property, new Variable[]{new Variable(value)});
                break;
            }
            default: {
                this.registerProperty(property, null);
            }
        }
    }

    public void addProperty(String property) {
        if (property.indexOf("%b") >= 0) {
            this.registerProperty(property, new Boolean[]{new Boolean(true)});
        } else {
            this.registerProperty(property, null);
        }
    }

    private void registerProperty(String property, Object[] params) {
        if (this.handleScreenProperties == null) {
            this.handleScreenProperties = new Vector();
        }
        HandleScreenProperty elem = new HandleScreenProperty(property, params);
        for (int i = 0; i < EARLY_PROPERTIES.length; ++i) {
            if (!property.startsWith(EARLY_PROPERTIES[i])) continue;
            this.handleScreenProperties.insertElementAt(elem, 0);
            return;
        }
        this.handleScreenProperties.addElement(elem);
    }

    private void registerLateProperty(String property, Object[] params) {
        if (this.handleScreenProperties == null) {
            this.handleScreenProperties = new Vector();
        }
        HandleScreenProperty elem = new HandleScreenProperty(property, params, true);
        for (int i = 0; i < EARLY_PROPERTIES.length; ++i) {
            if (!property.startsWith(EARLY_PROPERTIES[i])) continue;
            this.handleScreenProperties.insertElementAt(elem, 0);
            return;
        }
        this.handleScreenProperties.addElement(elem);
    }

    private final void setMainGroupProperties(Variable v) {
        if (this.handleScreenProperties == null) {
            return;
        }
        int handleLength = this.handleScreenProperties.size();
        for (v = v.getChild(); v != null; v = v.getSibling()) {
            ScreenProperty other = IO.getProperty(v);
            if (other != null) {
                Vector<HandleScreenProperty> otherVector = other.handleScreenProperties;
                if (otherVector == null) {
                    other.handleScreenProperties = new Vector();
                    otherVector = other.handleScreenProperties;
                }
                boolean found = false;
                int otherVectorSize = otherVector.size();
                for (int i = 0; i < handleLength; ++i) {
                    int j;
                    found = false;
                    HandleScreenProperty element = this.handleScreenProperties.elementAt(i);
                    for (j = 0; j < otherVectorSize; ++j) {
                        if (!element.equals(otherVector.elementAt(j))) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    found = false;
                    for (j = 0; j < EARLY_PROPERTIES.length; ++j) {
                        if (!element.getName().startsWith(EARLY_PROPERTIES[j])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        otherVector.addElement(element);
                        continue;
                    }
                    otherVector.insertElementAt(element, 0);
                }
            }
            if (v.getChild() == null) continue;
            this.setMainGroupProperties(v.getChild());
        }
    }

    private void applyHandlePropertiesToGroup(Variable mainVariable) {
        if (mainVariable.getChild() != null) {
            mainVariable = mainVariable.getChild();
            do {
                this.applyHandlePropertiesToGroup(mainVariable);
            } while ((mainVariable = mainVariable.getSibling()) != null);
            return;
        }
        ScreenProperty prop = IO.getProperty(mainVariable);
        if (prop.handleScreenProperties == null) {
            return;
        }
        int size = this.handleScreenProperties.size();
        for (int i = 0; i < size; ++i) {
            try {
                HandleScreenProperty property = this.handleScreenProperties.elementAt(i);
                prop.handleScreenProperties.insertElementAt(new HandleScreenProperty(property), 0);
                continue;
            }
            catch (Throwable t) {
                if (!LogSetup.IS_LOGGING_INFO) continue;
                LogSetup.LOGGER.info("catch(Throwable t). ");
                t.printStackTrace();
            }
        }
    }

    public void applyHandleProperties() {
        block50: {
            if (this.handleScreenProperties == null) {
                return;
            }
            try {
                Component mainComponent = null;
                try {
                    mainComponent = this.mainVariable.getHandle().getComponent();
                }
                catch (Throwable formMainComponent) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch(Throwable formMainComponent). ");
                        formMainComponent.printStackTrace();
                    }
                    return;
                }
                int size = this.handleScreenProperties.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        String displayableString;
                        HandleScreenProperty property;
                        block48: {
                            property = this.handleScreenProperties.elementAt(i);
                            displayableString = null;
                            if (LogSetup.IS_LOGGING) {
                                displayableString = String2.makeDisplayable("1. property=" + property.toDebugString() + ". ");
                                LogSetup.LOGGER.finest(displayableString);
                            }
                            if (property.m == null) {
                                try {
                                    String methodName = property.methodName;
                                    int paren = methodName.indexOf(40);
                                    if (paren < 0) break block48;
                                    String params = methodName.substring(paren + 1);
                                    methodName = methodName.substring(0, paren);
                                    paren = params.indexOf(37);
                                    int param = params.charAt(paren + 1);
                                    property.type = Character.toLowerCase((char)param);
                                    if ("setFrom".equals(methodName) && property.type == 's') {
                                        property.type = (char)118;
                                        param = 118;
                                    }
                                    Class<Object>[] c = null;
                                    switch (param) {
                                        case 115: {
                                            c = templateString;
                                            break;
                                        }
                                        case 105: {
                                            c = templateInteger;
                                            break;
                                        }
                                        case 100: {
                                            c = templateDouble;
                                            break;
                                        }
                                        case 98: {
                                            c = templateBoolean;
                                            break;
                                        }
                                        case 108: {
                                            c = templateLong;
                                            break;
                                        }
                                        case 112: {
                                            c = templateProcedurePointer;
                                            break;
                                        }
                                        case 118: {
                                            c = templateVariable;
                                            break;
                                        }
                                        case 97: {
                                            c = templateArray;
                                            break;
                                        }
                                        default: {
                                            c = templateEmpty;
                                        }
                                    }
                                    Class<Object> searchClass = mainComponent.getClass();
                                    Method applicableMethod = null;
                                    while (applicableMethod == null) {
                                        block49: {
                                            try {
                                                applicableMethod = searchClass.getDeclaredMethod(methodName, c);
                                            }
                                            catch (Throwable t) {
                                                if (!LogSetup.IS_LOGGING_INFO) break block49;
                                                LogSetup.LOGGER.info("catch(Throwable t). t=" + t + ". ");
                                            }
                                        }
                                        if (applicableMethod != null || (searchClass = searchClass.getSuperclass()) != null) continue;
                                    }
                                    property.m = applicableMethod;
                                }
                                catch (Throwable t2) {
                                    if (!LogSetup.IS_LOGGING_INFO) break block48;
                                    LogSetup.LOGGER.info("catch(Throwable t2). ");
                                    t2.printStackTrace();
                                }
                            }
                        }
                        if (property.m == null) continue;
                        Object[] params = property.params;
                        if (property.late) {
                            Object[] newParams = null;
                            switch (property.type) {
                                case 's': {
                                    newParams = new Object[]{String.valueOf(params[0])};
                                    break;
                                }
                                case 'i': {
                                    newParams = new Object[1];
                                    if (params[0] instanceof Variable) {
                                        newParams[0] = new Integer(((Variable)params[0]).toInt());
                                        break;
                                    }
                                    if (!(params[0] instanceof Index)) break;
                                    newParams[0] = new Integer(((Index)params[0]).toInt());
                                    break;
                                }
                                case 'l': {
                                    newParams = new Object[1];
                                    if (params[0] instanceof Variable) {
                                        newParams[0] = new Long(((Variable)params[0]).toLong());
                                        break;
                                    }
                                    if (!(params[0] instanceof Index)) break;
                                    newParams[0] = new Long(((Index)params[0]).toInt());
                                    break;
                                }
                                case 'd': {
                                    newParams = new Object[1];
                                    if (params[0] instanceof Variable) {
                                        newParams[0] = new Double(((Variable)params[0]).toDouble());
                                        break;
                                    }
                                    if (!(params[0] instanceof Index)) break;
                                    newParams[0] = new Double(((Index)params[0]).toInt());
                                    break;
                                }
                                case 'b': {
                                    newParams = new Object[1];
                                    if (params[0] instanceof Variable) {
                                        newParams[0] = new Boolean(((Variable)params[0]).toInt() != 0);
                                        break;
                                    }
                                    if (!(params[0] instanceof Index)) break;
                                    newParams[0] = new Boolean(((Index)params[0]).toInt() != 0);
                                    break;
                                }
                                case 'p': {
                                    if (params[0] instanceof ProcedurePointer) {
                                        newParams = new Object[]{params[0]};
                                        break;
                                    }
                                    throw new RuntimeException("Old Procedure Pointer Style Used.  Recompile to resolve.");
                                }
                                case 'v': {
                                    newParams = new Object[1];
                                    if (!(params[0] instanceof Variable)) {
                                        newParams[0] = new Variable(params[0].toString());
                                        break;
                                    }
                                    newParams[0] = params[0];
                                    break;
                                }
                                case 'a': {
                                    newParams = new Object[1];
                                    if (params[0] instanceof Object[]) {
                                        newParams[0] = params[0];
                                        break;
                                    }
                                    if (!(params[0] instanceof IDatatype)) break;
                                    newParams[0] = ((IDatatype)params[0]).getElements();
                                    break;
                                }
                                default: {
                                    newParams = new Object[]{};
                                }
                            }
                            params = newParams;
                        }
                        try {
                            displayableString = null;
                            if (LogSetup.IS_LOGGING) {
                                displayableString = String2.makeDisplayable("2. property=<" + property.toDebugString() + ">. property.m=<" + property.m.getName() + ">. mainComponent=<" + mainComponent + ">. params=" + Arrays.toString(params) + ".");
                                LogSetup.LOGGER.finer(displayableString);
                            }
                            property.m.invoke((Object)mainComponent, params);
                        }
                        catch (Throwable invocationException) {
                            if (!LogSetup.IS_LOGGING_INFO) continue;
                            LogSetup.LOGGER.info("catch(Throwable invocationException). ");
                            invocationException.printStackTrace();
                        }
                        continue;
                    }
                    catch (Throwable masterPropertyCatch) {
                        if (!LogSetup.IS_LOGGING_INFO) continue;
                        LogSetup.LOGGER.info("catch(Throwable masterPropertyCatch). ");
                        masterPropertyCatch.printStackTrace();
                    }
                }
            }
            catch (Throwable masterAllCatch) {
                if (!LogSetup.IS_LOGGING_INFO) break block50;
                LogSetup.LOGGER.info("catch(Throwable masterAllCatch). ");
                masterAllCatch.printStackTrace();
            }
        }
    }

    public void setFAC(int wangProperties) {
        if ((wangProperties & 0x80) != 128) {
            return;
        }
        int synkronixProperties = 0;
        if ((wangProperties & 0x20) == 32) {
            synkronixProperties |= 0x2000;
        }
        synkronixProperties = (wangProperties & 0x18) == 24 ? (synkronixProperties |= 8) : ((wangProperties & 0x10) == 16 ? (synkronixProperties |= 0x80) : ((wangProperties & 8) == 8 ? (synkronixProperties |= 0x800) : (synkronixProperties |= 0x400)));
        if ((wangProperties & 0xE0) == 224) {
            synkronixProperties |= 0x40;
        }
        this.setProperties(synkronixProperties);
    }

    public void setFAC(char c) {
        this.setFAC((int)c);
    }

    public void setFAC(String text) {
        if (text != null && text.length() > 0) {
            this.setFAC(text.charAt(0));
        }
    }

    public int getFAC() {
        int synkronixProperties = this.getProperties();
        int wang = 128;
        if ((synkronixProperties & 0x2000) == 8192) {
            wang |= 0x20;
        }
        wang = (synkronixProperties & 8) == 8 ? (wang |= 0x18) : ((synkronixProperties & 0x80) == 128 ? (wang |= 0x10) : ((synkronixProperties & 0x800) == 2048 ? (wang |= 8) : (wang |= 0)));
        if ((synkronixProperties & 0x40) == 64) {
            wang |= 0xE0;
        }
        return wang;
    }

    class HandleScreenProperty {
        private boolean late;
        String methodName;
        Method m;
        Object[] params;
        char type;

        public boolean equals(Object o) {
            if (o instanceof HandleScreenProperty) {
                return this.methodName.equals(((HandleScreenProperty)o).methodName);
            }
            return false;
        }

        public String toString() {
            return "HandleScreenProperty [name='" + this.methodName + "', lateBound=" + this.late + ", type=" + this.type + ", m=" + this.m + ", params=" + this.params + "]";
        }

        public String toDebugString() {
            return "HandleScreenProperty [methodName=" + this.methodName + ". late=" + this.late + ". type=" + this.type + ". Method m=" + this.m + ". Object[] params=" + Arrays.deepToString(this.params) + "]";
        }

        public HandleScreenProperty(HandleScreenProperty copy) {
            this.late = copy.late;
            this.methodName = copy.methodName;
            this.params = copy.params;
        }

        public HandleScreenProperty(String name, Object[] params) {
            this.methodName = name;
            this.params = params;
        }

        public HandleScreenProperty(String name, Object[] params, boolean late) {
            this.methodName = name;
            this.params = params;
            this.late = late;
        }

        public String getName() {
            return this.methodName;
        }
    }
}

