/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

public class Semaphore {
    private volatile int counter;

    public Semaphore() {
        this(0);
    }

    public Semaphore(int max) throws IllegalArgumentException {
        if (max < 0) {
            throw new IllegalArgumentException(max + "<0");
        }
        this.counter = max;
    }

    public synchronized void release() {
        if (this.counter == 0) {
            this.notify();
        }
        ++this.counter;
    }

    public synchronized void acquire() throws InterruptedException {
        while (this.counter == 0) {
            this.wait();
        }
        --this.counter;
    }

    public synchronized void acquire(long maxWait) throws InterruptedException {
        while (this.counter == 0) {
            this.wait(maxWait);
        }
        --this.counter;
    }
}

