/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.XOpenScreen;
import com.heirloomcomputing.term.ScreenHandler;
import com.heirloomcomputing.term.ServletHandler;
import javax.servlet.http.HttpServletRequest;

public class ServletScreen
extends XOpenScreen {
    public static final boolean debugMode = false;
    private ServletHandler currentServletHandler = null;
    private boolean servletLogging = false;
    private Object httpServletRequest = null;

    public ServletScreen() {
    }

    public ServletScreen(boolean servletLogging) {
        this.servletLogging = servletLogging;
    }

    @Override
    protected ScreenHandler initializeTerm(boolean hasGUI) {
        if (this.currentServletHandler == null) {
            this.currentServletHandler = new ServletHandler();
            return this.currentServletHandler;
        }
        return this.currentServletHandler;
    }

    public void setObject(Object o) {
        this.initializeTerm(false);
        this.currentServletHandler.setObject(o);
    }

    public void setObject(Object o, Object request) {
        this.setObject(o);
        this.httpServletRequest = request;
    }

    public Object getObject() {
        return this.currentServletHandler.getObject();
    }

    @Override
    public IO newInstance(String title) {
        return new ServletScreen();
    }

    protected void fillInIdentifiers(Variable v, Object httpServletRequestObject) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpServletRequestObject;
        Variable child = null;
        while (v != null) {
            if (v.isIdentified()) {
                try {
                    String result = httpServletRequest.getParameter(v.getIdentifier());
                    if (result == null) {
                        v.moveSpaces();
                    } else {
                        v.move(result);
                    }
                }
                catch (Exception parameterException) {
                    v.moveSpaces();
                }
            }
            if ((child = v.getChild()) != null) {
                this.fillInIdentifiers(child, httpServletRequest);
            }
            v = v.getSibling();
        }
    }

    @Override
    protected boolean acceptExternalForm(Variable v, float line, float column) {
        try {
            this.fillInIdentifiers(v, this.httpServletRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public synchronized boolean accept(Variable v, float line, float column) {
        if (v != null && v.isExternalForm()) {
            return this.acceptExternalForm(v, line, column);
        }
        return super.accept(v, line, column);
    }

    @Override
    public synchronized boolean display(String text) {
        if (this.servletLogging) {
            System.out.println("ServletLog: display to HTML page: '" + text + "'");
        }
        return super.display(text);
    }
}

