/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

class SessionManager {
    public static int MAX_LOCKS = 1000;
    private int sessionNumber = 0;
    private static int maxSessionNumber = 0;
    private boolean fileIsAlwaysRecordChanged = false;
    private int mode = 0;
    private long[] locks = new long[MAX_LOCKS];
    private long[] notifies = new long[MAX_LOCKS];
    private int endOfLockQueue = 0;
    private int endOfNotifyQueue = 0;
    public static final int NOTIFIED = 0;
    public static final int NOTIFIED_ALREADY = 1;
    public static final int NOTIFIED_TOO_MANY = 2;
    public static final int NOTIFIED_EXCEPTION = 3;
    public static final int LOCK_READ_ALREADY = 0;
    public static final int LOCK_WRITE_ALREADY = 1;
    public static final int LOCK_NOTIFY = 2;
    public static final int LOCK_NO_NOTIFY = 3;
    public static final int LOCK_REJECTED_TOO_MANY = 4;
    public static final int LOCK_EXCEPTION = 5;
    public static final int UNLOCK = 0;
    public static final int UNLOCK_ALREADY = 1;
    public static final int UNLOCK_EXCEPTION = 2;
    public static final int IS_LOCK = 0;
    public static final int IS_LOCK_EQUIVALENT = 1;
    public static final int IS_FREE = 2;
    public static final int IS_EXCEPTION = 3;
    public static final int IS_NOTIFY = 4;

    public void setFileIsAlwaysRecordChanged() {
        this.fileIsAlwaysRecordChanged = true;
    }

    public boolean isFileAlwaysRecordChanged() {
        return this.fileIsAlwaysRecordChanged;
    }

    public static void setMaxLocks(int n) {
        MAX_LOCKS = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public SessionManager() {
        this.sessionNumber = ++maxSessionNumber;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public String toString() {
        return "{Session " + this.sessionNumber + ":eolq=" + this.endOfLockQueue + ", eonq=" + this.endOfNotifyQueue + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lock(long lockNumber) {
        try {
            long[] lArray = this.locks;
            synchronized (this.locks) {
                int firstZero = -1;
                long examine = 0L;
                for (int i = 0; i < this.endOfLockQueue; ++i) {
                    examine = this.locks[i];
                    if (lockNumber == examine) {
                        if (lockNumber >= 0L) {
                            // ** MonitorExit[var3_2] (shouldn't be in output)
                            return 1;
                        }
                    } else if (lockNumber == -examine) {
                        if (examine < 0L) {
                            // ** MonitorExit[var3_2] (shouldn't be in output)
                            return 0;
                        }
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return 1;
                    }
                    if (examine != 0L || firstZero >= 0) continue;
                    firstZero = i;
                }
                if (firstZero < 0) {
                    if (this.endOfLockQueue >= MAX_LOCKS) {
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return 4;
                    }
                    firstZero = this.endOfLockQueue++;
                }
                this.locks[firstZero] = lockNumber;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return this.removeNotify(lockNumber) ? 2 : 3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int notify(long lockNumber) {
        try {
            long[] lArray = this.notifies;
            synchronized (this.notifies) {
                int firstZero = -1;
                long examine = 0L;
                for (int i = 0; i < this.endOfNotifyQueue; ++i) {
                    examine = this.notifies[i];
                    if (lockNumber == this.notifies[i]) {
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return 1;
                    }
                    if (examine != 0L || firstZero >= 0) continue;
                    firstZero = i;
                }
                if (firstZero < 0) {
                    if (this.endOfNotifyQueue >= MAX_LOCKS) {
                        this.setFileIsAlwaysRecordChanged();
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return 2;
                    }
                    firstZero = this.endOfNotifyQueue++;
                }
                this.notifies[firstZero] = lockNumber;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unlock(long lockNumber) {
        try {
            long[] lArray = this.locks;
            synchronized (this.locks) {
                for (int i = 0; i < this.endOfLockQueue; ++i) {
                    if (lockNumber != this.locks[i]) continue;
                    this.locks[i] = 0L;
                    while (this.endOfLockQueue > 0 && this.locks[this.endOfLockQueue - 1] == 0L) {
                        --this.endOfLockQueue;
                    }
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return 0;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isLocked(long lockNumber) {
        try {
            long[] lArray = this.locks;
            synchronized (this.locks) {
                long examine = 0L;
                int result = 2;
                for (int i = 0; i < this.endOfLockQueue; ++i) {
                    examine = this.locks[i];
                    if (lockNumber == examine) {
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return 0;
                    }
                    if (lockNumber != -examine) continue;
                    result = 1;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return result;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isNotified(long lockNumber) {
        try {
            long[] lArray = this.notifies;
            synchronized (this.notifies) {
                for (int i = 0; i < this.endOfNotifyQueue; ++i) {
                    if (lockNumber != this.notifies[i]) continue;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return 4;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return 2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNotify(long lockNumber) {
        try {
            long[] lArray = this.notifies;
            synchronized (this.notifies) {
                long examine = 0L;
                for (int i = 0; i < this.endOfNotifyQueue; ++i) {
                    examine = this.notifies[i];
                    if (lockNumber != examine && lockNumber != -examine) continue;
                    this.notifies[i] = 0L;
                    while (this.endOfNotifyQueue > 0 && this.notifies[this.endOfNotifyQueue - 1] == 0L) {
                        --this.endOfNotifyQueue;
                    }
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockEmpty() {
        long[] lArray = this.locks;
        synchronized (this.locks) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.endOfLockQueue == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotifyEmpty() {
        long[] lArray = this.notifies;
        synchronized (this.notifies) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.endOfNotifyQueue == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileChanged() {
        long[] lArray = this.notifies;
        synchronized (this.notifies) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.endOfNotifyQueue > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        long[] lArray = this.locks;
        synchronized (this.locks) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.endOfLockQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll() {
        long[] lArray = this.locks;
        synchronized (this.locks) {
            this.endOfLockQueue = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unlockAllBut(long lockNumber) {
        long[] lArray = this.locks;
        synchronized (this.locks) {
            try {
                boolean found = false;
                for (int i = 0; i < this.endOfLockQueue; ++i) {
                    if (this.locks[i] != lockNumber) continue;
                    found = true;
                    break;
                }
                this.locks[0] = lockNumber;
                this.endOfLockQueue = 1;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return found ? 3 : 2;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return 5;
            }
        }
    }
}

