/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Memory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SmartHeap {
    public static final int MASK_INDIRECT = Integer.MAX_VALUE;
    private List<Memory> directPointers = new ArrayList<Memory>(100);
    private int nextDirectPointer;
    private Vector<SmartHeapElement> indirectPointers;
    private Map<Memory, Map<Integer, Integer>> indirectPointersMemory;
    private int nextIndirectPointer;
    private static final ThreadLocal<SmartHeap> SH = new ThreadLocal<SmartHeap>(){

        @Override
        protected SmartHeap initialValue() {
            return new SmartHeap();
        }
    };

    public SmartHeap() {
        this.directPointers.add(0, null);
        this.directPointers.add(1, null);
        this.nextDirectPointer = 2;
        this.indirectPointers = new Vector(1000, 10000);
        this.indirectPointers.add(null);
        this.nextIndirectPointer = 1;
        this.indirectPointersMemory = new HashMap<Memory, Map<Integer, Integer>>(100);
        HashMap<Object, Integer> addrVal = new HashMap<Object, Integer>(100);
        addrVal.put(null, 0);
        this.indirectPointersMemory.put(null, addrVal);
    }

    public static synchronized SmartHeap get() {
        SmartHeap ourSmartHeap = SH.get();
        if (ourSmartHeap == null) {
            ourSmartHeap = new SmartHeap();
            SH.set(ourSmartHeap);
        }
        return ourSmartHeap;
    }

    public static synchronized void release() {
        SmartHeap current = SmartHeap.get();
        if (current != null) {
            SH.set(null);
        }
    }

    public static int index(Memory mem) {
        SmartHeap current = SmartHeap.get();
        int index = current.directPointers.indexOf(mem);
        if (index < 0) {
            current.directPointers.add(current.nextDirectPointer, mem);
            index = current.nextDirectPointer++;
        }
        return index;
    }

    public static int index(Memory mem, int addr) {
        Integer index;
        SmartHeap current = SmartHeap.get();
        Map<Integer, Integer> addrIndex = current.indirectPointersMemory.get(mem);
        if (addrIndex == null) {
            SmartHeap smartHeap = current;
            smartHeap.getClass();
            SmartHeapElement findOrInsert = smartHeap.new SmartHeapElement(mem, addr);
            index = SmartHeap.getNextFreeIndirectPointer();
            SmartHeap.allocateIndirectMemory(index, findOrInsert);
            HashMap<Integer, Integer> addrVal = new HashMap<Integer, Integer>(100);
            addrVal.put(addr, index);
            current.indirectPointersMemory.put(mem, addrVal);
        } else {
            index = addrIndex.get(addr);
            if (index == null) {
                SmartHeap smartHeap = current;
                smartHeap.getClass();
                SmartHeapElement findOrInsert = smartHeap.new SmartHeapElement(mem, addr);
                index = SmartHeap.getNextFreeIndirectPointer();
                SmartHeap.allocateIndirectMemory(index, findOrInsert);
                addrIndex.put(addr, index);
            }
        }
        return index;
    }

    private static void allocateIndirectMemory(int index, SmartHeapElement obj) {
        SmartHeap current = SmartHeap.get();
        if (current.indirectPointers.size() == index) {
            current.indirectPointers.add(obj);
        } else {
            if (current.indirectPointers.get(index) != null) {
                throw new IllegalStateException("Overwriting indirect memory cell that is not free (not null) at index : " + index);
            }
            current.indirectPointers.setElementAt(obj, index);
        }
    }

    static int getNextFreeIndirectPointer() {
        SmartHeap current = SmartHeap.get();
        int indexOf = current.indirectPointers.indexOf(null, 1);
        int freeIndex = 0;
        freeIndex = indexOf > 0 ? indexOf : current.nextIndirectPointer++;
        return freeIndex;
    }

    public static Memory memoryD(int index) {
        SmartHeap current = SmartHeap.get();
        if (index <= 0 || index > current.directPointers.size()) {
            return null;
        }
        Memory find = current.directPointers.get(index);
        if (find == null) {
            return null;
        }
        return find;
    }

    public static Memory memoryI(int index) {
        SmartHeap current = SmartHeap.get();
        if (index <= 0 || index > current.indirectPointers.size()) {
            return null;
        }
        SmartHeapElement find = current.indirectPointers.elementAt(index);
        if (find == null) {
            return null;
        }
        return find.memory;
    }

    public static int addressI(int index) {
        SmartHeap current = SmartHeap.get();
        if (index <= 0 || index > current.indirectPointers.size()) {
            return -1;
        }
        SmartHeapElement find = current.indirectPointers.elementAt(index);
        if (find == null) {
            return -1;
        }
        return find.address;
    }

    public static void free(int pointer) {
        SmartHeap current = SmartHeap.get();
        if ((pointer & Integer.MIN_VALUE) == 0) {
            int index = pointer >> 16;
            if (index > 0 && index < current.directPointers.size()) {
                current.directPointers.set(index, null);
            }
        } else {
            int index = pointer & Integer.MAX_VALUE;
            if (index > 0 && index < current.indirectPointers.size()) {
                SmartHeapElement find = current.indirectPointers.elementAt(index);
                current.indirectPointers.setElementAt(null, index);
                if (find != null && find.memory != null) {
                    Map<Integer, Integer> addrIndex = current.indirectPointersMemory.get(find.memory);
                    addrIndex.remove(find.address);
                    if (addrIndex.size() == 0) {
                        current.indirectPointersMemory.remove(find.memory);
                    }
                }
            }
        }
    }

    private class SmartHeapElement {
        Memory memory;
        int address;

        public SmartHeapElement(Memory memory, int address) {
            this.memory = memory;
            this.address = address;
        }

        public boolean equals(Object sh) {
            if (sh == null || sh.getClass() != this.getClass()) {
                return false;
            }
            return this.memory == ((SmartHeapElement)sh).memory && this.address == ((SmartHeapElement)sh).address;
        }
    }
}

