/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.SqlCursor;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.sql.InMemoryResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class SqlCursors {
    public static final String DEFAULT_CURSOR_NAME = "default";
    private ArrayList<ResultSet> SavedResultSets = null;
    private HashMap<String, ArrayList<Integer>> SavedStoredProcs = null;
    private final Hashtable<String, SqlCursor> cursors = new Hashtable();
    private int openSequence = 0;
    private boolean logMode;

    public void setLogMode(boolean value) {
        this.logMode = value;
    }

    private String cursorName(Object name) {
        if (name == null) {
            return DEFAULT_CURSOR_NAME;
        }
        String text = String.valueOf(name);
        if ((text = text.trim()).length() == 0) {
            return DEFAULT_CURSOR_NAME;
        }
        return text.toLowerCase();
    }

    public final SqlCursor getCursor(Object cursorName) {
        if (cursorName instanceof SqlCursor) {
            return (SqlCursor)cursorName;
        }
        return this.cursors.get(this.cursorName(cursorName));
    }

    public final Hashtable<String, SqlCursor> getCursors() {
        return this.cursors;
    }

    public final SqlCursor allocate(Object cursorName) {
        return this.allocate(cursorName, false);
    }

    public final SqlCursor allocate(Object passCursorName, boolean withHold) {
        String cursorName = this.cursorName(passCursorName);
        SqlCursor currentCursor = this.getCursor(cursorName);
        if (currentCursor != null) {
            currentCursor.reset(withHold);
        } else {
            currentCursor = new SqlCursor(cursorName, withHold, this);
            this.cursors.put(cursorName, currentCursor);
        }
        currentCursor.setLogMode(this.logMode);
        return currentCursor;
    }

    public final SqlCursor reAllocate(Object cursorName) {
        return this.reAllocate(cursorName, false);
    }

    public final SqlCursor reAllocate(Object passCursorName, boolean withHold) {
        String cursorName = this.cursorName(passCursorName);
        SqlCursor currentCursor = this.getCursor(cursorName);
        if (currentCursor != null) {
            try {
                currentCursor.resetParameters();
                currentCursor.setValid(false);
                currentCursor.closeRs();
                currentCursor.setValid(true);
                currentCursor.setWithHold(withHold);
            }
            catch (SQLException sQLException) {}
        } else {
            currentCursor = new SqlCursor(cursorName, withHold, this);
            this.cursors.put(cursorName, currentCursor);
        }
        currentCursor.setLogMode(this.logMode);
        return currentCursor;
    }

    public final SqlCursor allocateOpen(Object passCursorName, boolean withHold) throws SQLException {
        String cursorName = this.cursorName(passCursorName);
        SqlCursor currentCursor = this.getCursor(cursorName);
        if (currentCursor != null) {
            currentCursor.setLogMode(this.logMode);
            if (currentCursor.isOpen()) {
                throw new SQLException("Elastic COBOL SQL: Invalid Cursor State, Cursor Already Open", "24000", 24000);
            }
            currentCursor.reset(withHold);
        } else {
            currentCursor = new SqlCursor(cursorName, withHold, this);
            this.cursors.put(cursorName, currentCursor);
            currentCursor.setLogMode(this.logMode);
        }
        return currentCursor;
    }

    public final SqlCursor reAllocateOpen(Object passCursorName, boolean withHold) throws SQLException {
        String cursorName = this.cursorName(passCursorName);
        SqlCursor currentCursor = this.getCursor(cursorName);
        if (currentCursor != null) {
            currentCursor.setLogMode(this.logMode);
            if (currentCursor.isOpen()) {
                throw new SQLException("Elastic COBOL SQL: Invalid Cursor State, Cursor Already Open", "24000", 24000);
            }
            try {
                currentCursor.resetParameters();
                currentCursor.setValid(false);
                currentCursor.closeRs();
                currentCursor.setValid(true);
                currentCursor.setWithHold(withHold);
            }
            catch (SQLException sQLException) {}
        } else {
            currentCursor = new SqlCursor(cursorName, withHold, this);
            this.cursors.put(cursorName, currentCursor);
            currentCursor.setLogMode(this.logMode);
        }
        return currentCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveResultSet(String storedProcName, ResultSet resultSet) throws SQLException {
        if (this.SavedResultSets == null) {
            this.SavedResultSets = new ArrayList();
        }
        if (this.SavedStoredProcs == null) {
            this.SavedStoredProcs = new HashMap();
        }
        ArrayList<ResultSet> arrayList = this.SavedResultSets;
        synchronized (arrayList) {
            this.SavedResultSets.add(new InMemoryResultSet(resultSet));
            Integer number = new Integer(this.SavedResultSets.size() - 1);
            if (this.SavedStoredProcs.get(storedProcName) == null) {
                this.SavedStoredProcs.put(storedProcName, new ArrayList());
            }
            this.SavedStoredProcs.get(storedProcName).add(number);
        }
    }

    public final void associateLocator(String storedProcName, Variable[] locatorVariables) throws SQLException {
        if (this.SavedStoredProcs == null || this.SavedStoredProcs.get(storedProcName) == null) {
            throw new SQLException("Elastic COBOL SQL: 24000: Stored Procedure '" + storedProcName + "' not called", "24000");
        }
        if (locatorVariables.length > this.SavedStoredProcs.get(storedProcName).size()) {
            throw new SQLException("Elastic COBOL SQL: 24000: Stored Procedure '" + storedProcName + "' did not return as many result sets as you want to ASSOCIATE with locator variables", "24000");
        }
        ArrayList<Integer> ar = this.SavedStoredProcs.get(storedProcName);
        int idx = 0;
        for (Variable locator : locatorVariables) {
            locator.fromInt(ar.get(idx++));
        }
    }

    public final SqlCursor allocateOpen(String passCursorName, Variable loc) throws SQLException {
        String cursorName = this.cursorName(passCursorName);
        SqlCursor currentCursor = this.getCursor(cursorName);
        if (currentCursor != null) {
            currentCursor.setLogMode(this.logMode);
            if (currentCursor.isOpen()) {
                throw new SQLException("Elastic COBOL SQL: Invalid Cursor State, Cursor Already Open", "24000", 24000);
            }
        } else {
            currentCursor = new SqlCursor(cursorName, false, this);
            this.cursors.put(cursorName, currentCursor);
            currentCursor.setLogMode(this.logMode);
        }
        if (this.SavedResultSets == null || loc.toInt() < 0 || loc.toInt() >= this.SavedResultSets.size()) {
            throw new SQLException("Elastic COBOL SQL: Invalid Locator Variable State, Locator not associated with a Stored Procedure", "24000", 24000);
        }
        currentCursor.setResultSet(this.SavedResultSets.get(loc.toInt()));
        return currentCursor;
    }

    public final SqlCursor findStmtNameOrAllocate(String psName, String crName) throws SQLException {
        try {
            Enumeration<String> e = this.cursors.keys();
            while (e.hasMoreElements()) {
                String csName = e.nextElement();
                try {
                    SqlCursor currentCursor = this.getCursor(csName);
                    if (!currentCursor.ofPSName(psName)) continue;
                    return currentCursor;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        SqlCursor allocedCursor = this.allocate(crName);
        allocedCursor.setPSName(psName);
        return allocedCursor;
    }

    public final boolean deallocate(Object passCursorName) throws SQLException {
        String cursorName = this.cursorName(passCursorName);
        SqlCursor currentCursor = this.getCursor(cursorName);
        if (currentCursor != null) {
            this.cursors.remove(cursorName);
            return currentCursor.close();
        }
        return false;
    }

    public final void deallocateAll() throws SQLException {
        try {
            Enumeration<String> e = this.cursors.keys();
            while (e.hasMoreElements()) {
                String cursorName = e.nextElement();
                try {
                    this.deallocate(cursorName);
                }
                catch (Exception exception) {}
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public final SqlCursor open(Object cursorName) throws SQLException {
        SqlCursor cursor = this.getCursor(cursorName);
        if (cursor == null) {
            throw new SQLException("Elastic COBOL SQL: 24000.R6: Cannot open non-existant cursor", "24000");
        }
        if (!cursor.open()) {
            throw new SQLException("Elastic COBOL SQL: 24000.R6: Cannot open an already opened cursor", "24000");
        }
        return cursor;
    }

    public final void close(Object cursorName) throws SQLException {
        SqlCursor cursor = this.getCursor(cursorName);
        if (cursor == null) {
            throw new SQLException("Elastic COBOL SQL: 24000.R7: Cannot close non-existant cursor", "24000");
        }
        if (!cursor.close()) {
            throw new SQLException("Elastic COBOL SQL: 24000.R7: Cannot close an already closed cursor", "24000");
        }
    }

    public final void closeAll() {
        try {
            Enumeration<String> e = this.cursors.keys();
            while (e.hasMoreElements()) {
                try {
                    SqlCursor cursor = this.cursors.get(e.nextElement());
                    cursor.deallocate();
                }
                catch (Exception exception) {}
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.cursors.clear();
    }

    public final void closeAllNotHeld() throws SQLException {
        Enumeration<String> e2;
        try {
            e2 = this.cursors.keys();
            while (e2.hasMoreElements()) {
                try {
                    SqlCursor cursor = this.cursors.get(e2.nextElement());
                    if (cursor.isHold()) continue;
                    cursor.deallocate();
                }
                catch (Exception cursor) {}
            }
        }
        catch (NoSuchElementException e2) {
            // empty catch block
        }
        try {
            e2 = this.cursors.keys();
            while (e2.hasMoreElements()) {
                try {
                    String key = e2.nextElement();
                    SqlCursor cursor = this.cursors.get(key);
                    if (cursor.isHold()) continue;
                    this.cursors.remove(key);
                }
                catch (Exception exception) {}
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public final void deallocatePrepare(Object passPsName) throws SQLException {
        String psName = String.valueOf(passPsName);
        try {
            Enumeration<String> e = this.cursors.keys();
            while (e.hasMoreElements()) {
                if (!this.cursors.get(e.nextElement()).ofPSName(psName)) continue;
                this.deallocate(e.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public int assignNextOpenSequence() {
        return this.openSequence++;
    }
}

