/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

public class StringToIcon {
    private static final int[] colorMapping = new int[256];
    private int buildLine = -1;
    private int width;
    private int height;
    private int[] pixelBuffer;

    public static void setColor(char colorChar, Color color2) {
        StringToIcon.setColor(colorChar, color2.getRGB());
    }

    public static void setColor(char colorChar, int rgb) {
        StringToIcon.colorMapping[colorChar & 0xFF] = rgb;
    }

    public StringToIcon() {
        this.width = 0;
        this.height = 0;
    }

    public StringToIcon(int width, int height) {
        if (width > 0 && height > 0) {
            this.width = width;
            this.height = height;
            this.pixelBuffer = new int[width * height];
        }
    }

    public Image createImage() {
        if (this.pixelBuffer == null) {
            return null;
        }
        MemoryImageSource mis = new MemoryImageSource(this.width, this.height, this.pixelBuffer, 0, this.width);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public void setPixels(String pixels) {
        ++this.buildLine;
        this.setPixels(this.buildLine, pixels);
    }

    public void setPixels(int buildLine, String pixels) {
        if (pixels == null) {
            return;
        }
        int offset = buildLine * this.width;
        int size = this.width;
        if (pixels.length() < size) {
            size = pixels.length();
        }
        for (int i = 0; i < size; ++i) {
            this.pixelBuffer[offset + i] = colorMapping[Character.toUpperCase(pixels.charAt(i))];
        }
    }

    static {
        StringToIcon.colorMapping[32] = Color.black.getRGB();
        StringToIcon.colorMapping[65] = new Color(23, 2, 253).getRGB();
        StringToIcon.colorMapping[66] = new Color(81, 67, 252).getRGB();
        StringToIcon.colorMapping[67] = new Color(205, 201, 252).getRGB();
        StringToIcon.colorMapping[68] = new Color(239, 237, 253).getRGB();
        StringToIcon.colorMapping[69] = new Color(138, 128, 252).getRGB();
        StringToIcon.colorMapping[60] = Color.darkGray.getRGB();
        StringToIcon.colorMapping[124] = Color.gray.getRGB();
        StringToIcon.colorMapping[71] = Color.green.getRGB();
        StringToIcon.colorMapping[62] = Color.lightGray.getRGB();
        StringToIcon.colorMapping[77] = Color.magenta.getRGB();
        StringToIcon.colorMapping[79] = Color.orange.getRGB();
        StringToIcon.colorMapping[80] = Color.pink.getRGB();
        StringToIcon.colorMapping[82] = Color.red.getRGB();
        StringToIcon.colorMapping[87] = Color.white.getRGB();
        StringToIcon.colorMapping[89] = Color.yellow.getRGB();
        StringToIcon.colorMapping[86] = new Color(128, 0, 128).getRGB();
    }
}

