/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.util.MultiMap;
import java.util.Map;

public abstract class Subscript {
    private static long MODIFY_ONCE;
    private long mapModifyOnce;
    private Variable base;
    private Variable reusableInstance;
    private int[] offsets;
    private int[] indices;
    private MultiMap proxy;

    public Subscript(Variable orig, int[] maxIndexes, int[] sizes) {
        this.base = orig;
        this.reusableInstance = (Variable)this.base.clone();
        this.reusableInstance.maxIndex = 1;
        this.proxy = new MultiMap(true, maxIndexes);
        this.offsets = new int[sizes.length];
        this.indices = new int[maxIndexes.length];
        for (int i = 0; i < sizes.length; ++i) {
            this.offsets[this.offsets.length - i - 1] = sizes[i];
            this.indices[maxIndexes.length - i - 1] = maxIndexes[i] - 1;
        }
    }

    public abstract Variable gett(int ... var1);

    public abstract Variable get(int ... var1);

    protected abstract Variable put(int ... var1);

    public int elements() {
        int rc = 1;
        for (int i = 0; i < this.indices.length; ++i) {
            rc *= this.indices[i];
        }
        return rc;
    }

    private void flushIt(Map<Integer, Object> m) {
        if (m == null) {
            return;
        }
        for (int i = 1; i <= m.size(); ++i) {
            Object o = m.get(i);
            if (o instanceof Map) {
                this.flushIt((Map)o);
                continue;
            }
            Variable proxy = (Variable)o;
            if (proxy == null) continue;
            proxy.flushToMemory();
        }
    }

    protected void resetMemoryAndAddressIfNeeded(Variable prx, int ... dims) {
        Variable baseObject = this.getBase();
        int baseAddress = baseObject.getAddress();
        Memory baseMemory = baseObject.getMemory();
        int ptrAddr = baseAddress;
        for (int i = 0; i < dims.length; ++i) {
            ptrAddr += this.offsets[i] * (dims[i] - 1);
        }
        if (prx.getMemory() != baseMemory || prx.getAddress() != ptrAddr) {
            prx.setMemoryOld(baseMemory);
            prx.setAddress(ptrAddr);
            prx.valid = false;
            prx.dirty = false;
        }
    }

    protected void flushAll() {
        MODIFY_ONCE = ++Variable.ModifyOnce;
        this.flushAllContinue();
    }

    protected void flushAllContinue() {
        if (this.mapModifyOnce == MODIFY_ONCE) {
            return;
        }
        this.mapModifyOnce = MODIFY_ONCE;
        this.getBase().flushToMemory();
        this.getReusableInstance().flushToMemory();
        this.flushIt(this.getProxy().getMap());
    }

    public void finished() {
        this.flushAll();
        this.clear();
    }

    public MultiMap getProxy() {
        return this.proxy;
    }

    public Variable getBase() {
        return this.base;
    }

    public Variable getReusableInstance() {
        return this.reusableInstance;
    }

    public void clear() {
        this.getProxy().clear();
    }
}

