/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.ICobolProgram;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.LNF;
import com.heirloomcomputing.ecs.exec.MediaImage;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.StringToIcon;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.UtilitiesAwtFrame;
import com.heirloomcomputing.ecs.exec.UtilitiesJFC;
import com.heirloomcomputing.ecs.exec.basicFile;
import com.heirloomcomputing.ecs.exec.smartFile;
import com.heirloomcomputing.ecs.jfc.LWindow;
import com.heirloomcomputing.term.ScreenHandler;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.swing.RootPaneContainer;

public class Utilities {
    private static final int DEFAULT_COLUMNS = 80;
    private static final int DEFAULT_LINES = 25;
    private static Window mainWindow;
    private static Applet applet;
    private static Frame trackFrame;
    private static Frame defaultFrame;
    private static Container trackPanel;
    private static boolean createTrackPanel;
    private static Container mainConsole;
    private static Image iconImage;
    private static boolean isApplet;
    private static boolean isMainApplication;
    private static boolean standardBackgroundIntensity;
    private static basicFile lastUsedFile;
    private static String defaultTitle;
    private static int preferredColumns;
    private static int preferredLines;
    private static UtilitiesJFC uJFC;
    private static boolean isJFC;
    private static boolean checkedJFC;
    private static Handle mainWindowHandle;
    private static ClassLoader classLoader;
    private static boolean developmentMode;
    private static final String TRANS_ENV = "TransEnv";

    public static void setDevelopmentMode(boolean state) {
        developmentMode = state;
    }

    public static boolean isCurrentEnviromentCICS() {
        return "TRUE".equalsIgnoreCase(System.getProperty(TRANS_ENV, "false"));
    }

    public static boolean isDevelopmentMode() {
        return developmentMode;
    }

    public static void debugOutput(String s) {
        System.err.printf("%s\n", s);
    }

    public static void setBackgroundIntensity(boolean state) {
        standardBackgroundIntensity = state;
    }

    public static final boolean isStandardBackgroundHigh() {
        return standardBackgroundIntensity;
    }

    public static void createGenericWindow(String useTitle, Container textPane, boolean useWindowColor) {
        Utilities.setMainWindow(new UtilitiesAwtFrame(useTitle, textPane, useWindowColor), true, Utilities.getIconImage());
    }

    public static void createGenericWindow(String useTitle, Container textPane) {
        Utilities.createGenericWindow(useTitle, textPane, false);
    }

    public static boolean setMainWindow(Window passMainWindow, boolean initial, Image iconImage) {
        boolean boolStatus = false;
        if (mainWindow == null || passMainWindow == null) {
            if (initial) {
                mainWindow = passMainWindow;
            }
            if (passMainWindow != null) {
                passMainWindow.addWindowListener(new CloseProgramListener(initial));
                if (initial && passMainWindow instanceof Frame) {
                    if (defaultFrame == null) {
                        defaultFrame = (Frame)passMainWindow;
                    }
                    if (trackFrame == null) {
                        trackFrame = (Frame)passMainWindow;
                    }
                }
            }
            boolStatus = true;
        }
        try {
            if (iconImage != null && passMainWindow instanceof Frame) {
                ((Frame)passMainWindow).setIconImage(iconImage);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return boolStatus;
    }

    public static void resetMainWindow() {
        mainWindow = null;
    }

    public static Window getMainWindow() {
        return mainWindow;
    }

    public static boolean hasMainWindow() {
        return mainWindow != null;
    }

    public static Object getDefaultAppletFrame() {
        try {
            if (mainWindow == null) {
                Utilities.createGenericWindow();
            }
            return mainWindow;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final ClassLoader getClassLoader() {
        return classLoader;
    }

    public static final void setClassLoader(Object o) {
        try {
            classLoader = o.getClass().getClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final Applet getApplet() {
        return applet;
    }

    public static final Container getTrackPanel() {
        return Utilities.getTrackPanel(createTrackPanel);
    }

    public static final Container getTrackPanel(boolean createIfNecessary) {
        if (trackPanel == null && createIfNecessary) {
            trackPanel = new Applet();
            trackPanel.setLayout(new BorderLayout());
        }
        createTrackPanel = false;
        return trackPanel;
    }

    public static final Component eliminateConsole() {
        Container console2 = mainConsole;
        try {
            if (console2 != null && trackPanel != null) {
                Utilities.getTrackPanelContentPane().remove(console2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        trackPanel = null;
        createTrackPanel = false;
        trackFrame = null;
        Utilities.resetMainWindow();
        return console2;
    }

    public static final void startApplet(Applet userApplet) {
        ThreadQueue.resetAppletExit();
        isApplet = true;
        applet = userApplet;
        trackPanel = userApplet;
        createTrackPanel = false;
        trackFrame = null;
        if (mainConsole != null) {
            Utilities.reset();
        }
        mainWindow = null;
        mainWindowHandle = null;
        mainConsole = null;
        Utilities.setClassLoader(userApplet);
        try {
            LNF.setNativeLookAndFeel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Shutdown.addShutdownHook();
    }

    public static final void startApplet(Object setApplet) {
        try {
            Utilities.startApplet((Applet)setApplet);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void stopApplet(Object currentApplet) {
        ThreadQueue.initiateAppletExit();
        try {
            Utilities.eliminateConsole();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Handle.resetHandles();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IO.resetStaticData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LNF.resetName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final boolean consoleExists() {
        return mainConsole != null;
    }

    public static final void setTitle(String title) {
        defaultTitle = title;
        try {
            if (applet != null) {
                applet.showStatus(title);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Frame f = Utilities.getFrame();
            if (f != null) {
                f.setTitle(title);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final Frame getFrame() {
        return defaultFrame == null ? (defaultFrame = trackFrame) : defaultFrame;
    }

    public static final void setFrame(Frame param) {
        defaultFrame = param;
    }

    public static final boolean isApplet() {
        return isApplet;
    }

    public static final boolean isApplication() {
        return !isApplet;
    }

    public static final boolean isMainApplication() {
        return isMainApplication;
    }

    public static final URL getCodeBase() {
        try {
            if (applet != null) {
                return applet.getCodeBase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final URL getDocumentBase() {
        try {
            if (applet != null) {
                return applet.getDocumentBase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final String format(int n, int digits) {
        if (digits <= 0) {
            return "";
        }
        String result = String.valueOf(n);
        if (result.length() == digits) {
            return result;
        }
        if (result.length() > digits) {
            return result.substring(0, digits);
        }
        int deficitDigits = digits - result.length();
        char[] deficit = new char[deficitDigits];
        for (int i = 0; i < deficitDigits; ++i) {
            deficit[i] = 48;
        }
        return new StringBuffer(digits).append(deficit).append(result).toString();
    }

    public static void initializeAppletAsApplication(Object panel, Object frame) {
        if (mainWindow != null) {
            frame = mainWindow;
        }
        if (frame == null) {
            return;
        }
        try {
            if (panel instanceof Container && (frame == null || frame instanceof Frame)) {
                trackPanel = (Container)panel;
                createTrackPanel = false;
                trackFrame = (Frame)frame;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Applet setApplet = (Applet)panel;
            if (setApplet != null) {
                Utilities.setClassLoader(setApplet);
                applet = setApplet;
                if (Utilities.getTrackPanel() == null) {
                    trackPanel = setApplet;
                }
                applet.setLayout(new BorderLayout());
            }
        }
        catch (Throwable setApplet) {
            // empty catch block
        }
        if (frame instanceof Component) {
            if (frame instanceof Frame) {
                Utilities.setFrame((Frame)frame);
            }
            Component cframe = (Component)frame;
            cframe.setBackground(Color.white);
            cframe.setForeground(Color.black);
            cframe.setVisible(true);
        }
    }

    public static int copy(String source, String dest) {
        int result;
        block16: {
            source = smartFile.convertFilename(source);
            dest = smartFile.convertFilename(dest);
            result = 0;
            try {
                FileInputStream fin = null;
                FileOutputStream fout = null;
                try {
                    block15: {
                        try {
                            fin = new FileInputStream(source);
                            fout = new FileOutputStream(dest);
                        }
                        catch (Exception openingException) {
                            result = 1;
                            if (fin != null) {
                                fin.close();
                            }
                            if (fout == null) break block15;
                            fout.close();
                        }
                    }
                    byte[] buffer = new byte[4096];
                    try {
                        int data;
                        do {
                            if ((data = fin.read(buffer)) == -1) continue;
                            fout.write(buffer, 0, data);
                        } while (data != -1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fin.close();
                    fin = null;
                    fout.close();
                    fout = null;
                }
                catch (Exception e) {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Exception e2) {
                            fin = null;
                        }
                    }
                    if (fout == null) break block16;
                    try {
                        fout.close();
                    }
                    catch (Exception e2) {
                        fout = null;
                    }
                }
            }
            catch (Throwable t) {
                result = 1;
            }
        }
        return result;
    }

    public static basicFile setLastUsedFile(basicFile file2) {
        lastUsedFile = file2;
        return lastUsedFile;
    }

    public static String getLastUsedFileName() {
        return lastUsedFile != null ? lastUsedFile.getFilename() : null;
    }

    public static String getLastUsedFileStatus() {
        return lastUsedFile != null ? lastUsedFile.getFileStatus() : null;
    }

    public static InputStream getInputStream(String filename) {
        return Utilities.getInputStream(classLoader, filename);
    }

    public static InputStream getInputStream(ClassLoader classLoader, String filename) {
        InputStream fis;
        block21: {
            fis = null;
            URL location = null;
            if (classLoader != null) {
                try {
                    fis = classLoader.getResourceAsStream(filename);
                    if (fis != null) {
                        return fis;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                fis = ClassLoader.getSystemResourceAsStream(filename);
                if (fis != null) {
                    return fis;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                block22: {
                    if (!isApplet && filename.indexOf("://") < 0) break block21;
                    try {
                        if (filename.indexOf("://") >= 0) {
                            location = new URL(filename);
                            break block22;
                        }
                        try {
                            location = new URL(Utilities.getDocumentBase(), filename);
                        }
                        catch (Exception notFoundAtDocBase) {
                            try {
                                location = new URL(Utilities.getCodeBase(), filename);
                            }
                            catch (Exception notFoundAtCodeBase) {
                                location = new URL(filename);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (location != null) {
                    fis = location.openStream();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fis != null) {
            return fis;
        }
        try {
            fis = new FileInputStream(filename);
            if (fis != null) {
                return fis;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fis;
    }

    public static void initializeRuntime(ICobolProgram userProgram, String[] args) {
        try {
            isMainApplication = true;
            isApplet = false;
            Shutdown.exitWhenFinished(true);
            Utilities.setClassLoader(userProgram);
            createTrackPanel = true;
            if (userProgram != null) {
                if (defaultTitle == null && (defaultTitle = userProgram.getClass().getName()) != null) {
                    int index = defaultTitle.lastIndexOf(46);
                    if (index >= 0 && index < defaultTitle.length() - 1) {
                        defaultTitle = defaultTitle.substring(index + 1);
                    }
                    if (defaultTitle.length() > 1) {
                        defaultTitle = Character.toUpperCase(defaultTitle.charAt(0)) + defaultTitle.substring(1).replace('_', ' ').replace('-', ' ').replace('.', ' ');
                    }
                }
                if (userProgram instanceof Container) {
                    trackPanel = (Container)((Object)userProgram);
                    createTrackPanel = false;
                    if (applet == null && userProgram instanceof Applet) {
                        applet = (Applet)((Object)userProgram);
                        applet.setLayout(new BorderLayout());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RuntimeEnvironment.setGlobalRuntimeEnvironment(userProgram, args);
        Shutdown.addShutdownHook();
    }

    public static String getDefaultTitle(String basicDefault) {
        String windowTitle = RuntimeEnvironment.getGlobalParameter("WINDOW-TITLE");
        if (windowTitle != null) {
            return windowTitle;
        }
        if (defaultTitle != null) {
            return defaultTitle;
        }
        return "Application";
    }

    public static int getColumns() {
        if (preferredColumns >= 0) {
            return preferredColumns;
        }
        String check = RuntimeEnvironment.getGlobalParameter("COLUMNS");
        if (check != null) {
            preferredColumns = ConvertData.parseInt(check);
            if (preferredColumns <= 0) {
                preferredColumns = 80;
                return 80;
            }
            return preferredColumns;
        }
        return 80;
    }

    public static void setColumns(int val) {
        preferredColumns = val;
    }

    public static int getLines() {
        if (preferredLines >= 0) {
            return preferredLines;
        }
        String check = RuntimeEnvironment.getGlobalParameter("LINES");
        if (check != null) {
            preferredLines = ConvertData.parseInt(check);
            if (preferredLines <= 0) {
                preferredLines = 25;
                return 25;
            }
            return preferredLines;
        }
        return 25;
    }

    public static void setLines(int val) {
        preferredLines = val;
    }

    public static Image getIconImage() {
        if (iconImage == null) {
            iconImage = Utilities.getDefaultIcon();
        }
        return iconImage;
    }

    public static void setIconImage(Image icon) {
        iconImage = icon;
    }

    public static void setIconImage(String value) {
        if (value == null) {
            return;
        }
        try {
            value = value.trim();
            iconImage = MediaImage.getImage(value);
            if (iconImage != null) {
                Utilities.setIconImage(iconImage);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Image getDefaultIcon() {
        try {
            StringToIcon icon = new StringToIcon(16, 16);
            icon.setPixels("BBBBBBBBBBWBBBBB");
            icon.setPixels("BBBBBBBBBBWBBBBB");
            icon.setPixels("BBBBBBBBBBWBBBBB");
            icon.setPixels("BBWWWWBBBBWWWWBB");
            icon.setPixels("BBWWWWBBBBWWWWBB");
            icon.setPixels("BBWWWWBBBBWWWWBB");
            icon.setPixels("BBWWWWBBBBWWWWBB");
            icon.setPixels("BBWWWWWWWWWWWWBB");
            icon.setPixels("BBWWWWWWWWWWWWBB");
            icon.setPixels("BBWWWWBBBBWWWWBB");
            icon.setPixels("BBWWWWBBBBWWWWBB");
            icon.setPixels("BBWWWWBBBBWWWWBB");
            icon.setPixels("BBWWWWBBBBWWWWBB");
            icon.setPixels("BBBBBWBBBBBBBBBB");
            icon.setPixels("BBBBBWBBBBBBBBBB");
            icon.setPixels("BBBBBWBBBBBBBBBB");
            return icon.createImage();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isJFC() {
        return isJFC;
    }

    public static void setMainWindowHandle(Handle h) {
        mainWindowHandle = h;
    }

    public static Handle getMainWindowHandle() {
        return mainWindowHandle;
    }

    static boolean associateNewTextPaneWithWindow(ScreenHandler term, String defaultTitle, boolean useWindowColor) {
        return Utilities.associateNewTextPaneWithWindow(term, defaultTitle, null, null, useWindowColor);
    }

    static boolean associateNewTextPaneWithWindow(ScreenHandler term, String defaultTitle, Color defaultFG, Color defaultBG) {
        return Utilities.associateNewTextPaneWithWindow(term, defaultTitle, defaultFG, defaultBG, false);
    }

    private static boolean associateNewTextPaneWithWindow(ScreenHandler term, String defaultTitle, Color defaultFG, Color defaultBG, boolean useWindowColor) {
        boolean mainConsoleExists;
        Container textPane = term.getPanelForWindow();
        if (textPane == null) {
            return false;
        }
        term.setDefaultColors(defaultFG, defaultBG);
        boolean bl = mainConsoleExists = mainConsole != null;
        if (!mainConsoleExists) {
            mainConsole = textPane;
        }
        if (!checkedJFC) {
            try {
                isJFC = !(textPane instanceof Panel);
            }
            catch (Throwable t) {
                isJFC = false;
            }
            checkedJFC = true;
        }
        if (isJFC) {
            try {
                if (uJFC == null) {
                    uJFC = new UtilitiesJFC();
                }
                return uJFC.addTextPaneToSomething(defaultTitle, term, textPane, mainConsoleExists, useWindowColor);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Utilities.addTextPaneToSomething(defaultTitle, term, textPane, mainConsoleExists, useWindowColor);
    }

    static void createGenericWindow() {
        try {
            if (uJFC == null) {
                uJFC = new UtilitiesJFC();
            }
            uJFC.createGenericWindow("Applet", applet);
        }
        catch (Throwable t) {
            Utilities.createGenericWindow("Applet", applet);
        }
    }

    public static Container getTrackPanelContentPane() {
        Container container = Utilities.getTrackPanel();
        try {
            return ((RootPaneContainer)((Object)container)).getContentPane();
        }
        catch (Throwable t) {
            return container;
        }
    }

    public static synchronized void reset() {
        block14: {
            try {
                Container container;
                Container panel = mainConsole;
                if (panel == null) {
                    return;
                }
                if (mainWindowHandle == null || !isJFC) {
                    Container container2 = Utilities.getTrackPanelContentPane();
                    if (container2 != null) {
                        container2.add("Center", panel);
                    }
                    if (!Utilities.isApplet()) {
                        Container parent;
                        for (parent = Utilities.getTrackPanel(); parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
                        }
                        if (parent == null) break block14;
                        Frame f = (Frame)parent;
                        f.setVisible(true);
                        try {
                            f.pack();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Container trackContainer = Utilities.getTrackPanel();
                        if (!trackContainer.isVisible()) {
                            trackContainer.setVisible(true);
                        }
                        if (trackFrame != null && !trackContainer.isVisible()) {
                            trackFrame.setVisible(true);
                        }
                        f.setResizable(false);
                        break block14;
                    }
                    Container trackContainer = Utilities.getTrackPanel();
                    if (trackContainer != null) {
                        panel.setForeground(trackContainer.getForeground());
                        panel.setBackground(trackContainer.getBackground());
                    }
                    break block14;
                }
                if (uJFC == null) {
                    uJFC = new UtilitiesJFC();
                }
                if ((container = Utilities.getTrackPanelContentPane()) != null) {
                    uJFC.reset(mainConsole, container);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean addTextPaneToSomething(String defaultTitle, ScreenHandler term, Container textPane, boolean mainConsoleExists, boolean useWindowColor) {
        if (Utilities.isApplet()) {
            Utilities.reset();
            return true;
        }
        if (mainConsoleExists || !mainConsoleExists && !Utilities.isApplet()) {
            String useTitle = defaultTitle;
            if (useTitle == null || useTitle.trim().length() == 0) {
                useTitle = Utilities.getDefaultTitle("Application");
            }
            Utilities.createGenericWindow(useTitle, textPane, useWindowColor);
        } else {
            Utilities.reset();
        }
        return true;
    }

    static {
        createTrackPanel = true;
        standardBackgroundIntensity = true;
        preferredColumns = -1;
        preferredLines = -1;
        classLoader = Utilities.class.getClassLoader();
    }

    static class CloseProgramListener
    implements WindowListener {
        private boolean initial;

        public CloseProgramListener(boolean initial) {
            this.initial = initial;
        }

        private LWindow findLWindow(Container component) {
            LWindow lwindow = null;
            Component[] components = component.getComponents();
            for (int i = 0; i < components.length; ++i) {
                Component comp = components[i];
                if (comp instanceof RootPaneContainer) {
                    comp = ((RootPaneContainer)((Object)comp)).getContentPane();
                }
                if (!(comp instanceof Container)) continue;
                if (comp instanceof LWindow && !((LWindow)comp).isSecondaryWindow()) {
                    return (LWindow)comp;
                }
                lwindow = this.findLWindow((Container)comp);
                if (lwindow == null) continue;
                return lwindow;
            }
            return lwindow;
        }

        @Override
        public void windowClosed(WindowEvent event) {
        }

        @Override
        public void windowDeactivated(WindowEvent event) {
        }

        @Override
        public void windowDeiconified(WindowEvent event) {
        }

        @Override
        public void windowIconified(WindowEvent event) {
        }

        @Override
        public void windowOpened(WindowEvent event) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void windowClosing(WindowEvent event) {
            try {
                Window window = null;
                try {
                    window = (Window)event.getSource();
                    LWindow lwindow = this.findLWindow(window);
                    if (lwindow != null) {
                        if (!lwindow.isSystemFrame()) {
                            return;
                        }
                        if (lwindow.processAcceptEvent(new AcceptEvent(lwindow.getHandle(), 0, 16415, event))) {
                            return;
                        }
                        if (!lwindow.processAcceptEvent(new AcceptEvent(lwindow.getHandle(), 0, 1, event))) {
                            // empty if block
                        }
                    }
                }
                catch (Throwable lwindow) {
                    // empty catch block
                }
                window.setVisible(false);
                window.dispose();
                Window checkMain = Utilities.getMainWindow();
                if (checkMain != window) {
                    if (checkMain != null) return;
                    if (isApplet) return;
                }
                if (!this.initial) return;
                Shutdown.userExit();
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void windowActivated(WindowEvent event) {
            try {
                Window window = (Window)event.getSource();
                LWindow lwindow = this.findLWindow(window);
                this.activate(lwindow, event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void activate(LWindow lwindow, WindowEvent event) {
            if (lwindow == null) {
                return;
            }
            if (lwindow.isBindToThread()) {
                Thread controllingThread = lwindow.getControllingThread();
                if (controllingThread != null && controllingThread == Thread.currentThread() && lwindow.hasEventProcedure() && lwindow.isModeless()) {
                    Handle.signalAccept(new AcceptEvent(lwindow.getHandle(), 0, 6, event));
                }
            } else if (lwindow.hasEventProcedure() && lwindow.isModeless()) {
                Handle.signalAccept(new AcceptEvent(lwindow.getHandle(), 0, 6, event));
            }
        }
    }
}

