/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import java.io.File;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlFile
extends basicFile
implements ContentHandler,
ErrorHandler,
Runnable {
    private Variable fileStatus;
    private Variable fileStatus2;
    private Variable fileStatus3;
    protected int minimum = -1;
    protected int maximum = -1;
    protected Variable dependingOn;
    protected boolean optional;
    protected String filename;
    protected Variable filenameVariable;
    protected boolean isOpen;
    protected int size;
    protected int readSize;
    protected String codeSet;
    protected boolean readable = true;
    protected boolean writable = false;
    protected boolean extend = false;
    protected int priorErrorCode;
    protected basicFile externalFile;
    protected int newModes;
    protected boolean override_variable;
    protected boolean override_fixed;
    protected boolean override_varying;
    protected byte[] fourbytes = new byte[4];
    protected int blockFrom;
    protected int blockTo;
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();
    private XMLReader xmlReader;
    private Locator locator;
    private boolean IGNORE_ALL;
    private boolean featureWhitespace;
    private boolean featureSkippedEntities;
    private boolean featureProcessingCode;
    private boolean featurePrefixes;
    private boolean featureElements;
    private Thread xmlThread;
    private Variable previousSearch;
    private XmlNode root;
    public static final int OPEN = 0;
    public static final int READ = 1;
    public static final int CLOSE = 3;
    private final SignalObject signalObject = new SignalObject();
    private final SignalObject returnObject = new SignalObject();
    private Vector<String> currentElements;
    private Vector<Vector<XmlNode>> currentWrites;
    private XmlNode currentElement;
    private Variable locatorPublic;
    private Variable locatorSystem;
    private Variable locatorLine;
    private Variable locatorColumn;
    public static final String FEATURE_EXTERNAL_PARAMETER = "http://xml.org/sax/features/external-parameter-entities";
    public static final String FEATURE_EXTERNAL_GENERAL = "http://xml.org/sax/features/external-general-entities";
    public static final String FEATURE_INTERN = "http://xml.org/sax/features/string-interning";
    public static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final int SIGNAL_DONE = 0;
    public static final int START_DOCUMENT = 1;
    public static final int END_DOCUMENT = 2;
    public static final int CHARACTERS = 3;
    public static final int IGNORABLE_WHITESPACE = 4;
    public static final int START_ELEMENT = 5;
    public static final int END_ELEMENT = 6;
    public static final int START_PREFIX_MAPPING = 7;
    public static final int END_PREFIX_MAPPING = 8;
    public static final int PROCESSING_INSTRUCTION = 9;
    public static final int SKIPPED_ENTITY = 10;
    public static final int SAX_ERROR = 11;
    public static final int SAX_WARNING = 12;
    public static final int SAX_FATAL = 13;
    public static final int PARSE_EXCEPTION = 14;
    public static final int READ_READY = 15;
    public static final int SIGNAL_ABORT = 0;
    private final char[] smallChar = new char[]{'0', '0'};
    private boolean addedAnyWrites = false;

    public final XmlFile settingExternalFile(Context context, String name) {
        Object copy = context.getExternalFile(this, name);
        if (copy == null) {
            return this;
        }
        if (!(copy instanceof XmlFile)) {
            return this;
        }
        if (copy == this) {
            return this;
        }
        XmlFile xmlExternalFile = (XmlFile)copy;
        this.externalFile = xmlExternalFile;
        this.priorErrorCode = xmlExternalFile.priorErrorCode;
        return this;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isExtend() {
        return this.extend;
    }

    public void setReadable(boolean state) {
        this.readable = state;
    }

    public void setWritable(boolean state) {
        this.writable = false;
    }

    public void setExtend(boolean state) {
        this.extend = false;
    }

    public XmlFile setFileStatus(Variable v) {
        this.fileStatus = v;
        return this;
    }

    public XmlFile setFileStatus2(Variable v) {
        this.fileStatus2 = v;
        return this;
    }

    public XmlFile setFileStatus3(Variable v) {
        this.fileStatus3 = v;
        return this;
    }

    public Variable getFileStatusVar() {
        return this.fileStatus;
    }

    public Variable getFileStatusVar2() {
        return this.fileStatus2;
    }

    public Variable getFileStatusVar3() {
        return this.fileStatus3;
    }

    public boolean isInput() {
        return this.isReadable() && !this.isWritable();
    }

    public boolean isOutput() {
        return this.isWritable() && !this.isReadable() && !this.isExtend();
    }

    public boolean isIO() {
        return this.isReadable() && this.isWritable();
    }

    public boolean useException() {
        return this.priorError() != 0 && this.priorError() != -10 && this.priorError() != 10 && this.priorError() != 7;
    }

    public boolean useExceptionNotInvalid() {
        int rc = this.priorError();
        if (rc > 0) {
            rc = -rc;
        }
        return rc <= 10 && rc != -22 && rc != -23 && rc != -24;
    }

    public boolean useAtEnd() {
        return this.priorError() == -10 || this.priorError() == 10;
    }

    public boolean isOK() {
        return this.priorError() > -10;
    }

    public int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public final synchronized int useException(int specific) {
        if (this.useException()) {
            return specific;
        }
        return -1;
    }

    public int useExceptionNotInvalid(int specific, int input, int output, int io, int extend) {
        if (this.useExceptionNotInvalid()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public final synchronized int useExceptionNotInvalid(int specific) {
        if (this.useExceptionNotInvalid()) {
            return specific;
        }
        return -1;
    }

    public int useAtEnd(int specific, int input, int output, int io, int extend) {
        if (this.priorError() == 10 || this.priorError() == -10) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public int useAtEnd(int specific) {
        if ((this.priorError() == 10 || this.priorError() == -10) && specific >= 0) {
            return specific;
        }
        return -1;
    }

    public void iostatus(String x) {
        try {
            this.iostatus(-Integer.decode(x.trim()).intValue());
        }
        catch (Exception e) {
            this.iostatus(0);
        }
    }

    public void iostatus(int status) {
        int n = status = status < 0 ? -status : 0;
        if (status == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            if (status == 0) {
                this.fileStatus.moveZeroes();
            } else if (status < 10) {
                this.smallChar[1] = (char)(status + 48);
                this.fileStatus.move(this.smallChar);
            } else {
                this.fileStatus.move(status);
            }
        }
    }

    public void iostatus(int status, String message2) {
        this.iostatus(status, message2, null);
    }

    public void iostatus(int status, String message2, String message3) {
        this.iostatus(status);
        if (this.fileStatus2 != null) {
            if (message2 == null) {
                this.fileStatus2.initialize();
            } else {
                this.fileStatus2.move(message2);
            }
        }
        if (this.fileStatus3 != null) {
            if (message3 == null) {
                this.fileStatus3.initialize();
            } else {
                this.fileStatus3.move(message3);
            }
        }
    }

    @Override
    public int priorError() {
        return this.externalFile != null ? this.externalFile.priorError() : this.priorErrorCode;
    }

    public void setPriorError(int status) {
        this.priorErrorCode = status;
        if (this.externalFile != null) {
            ((XmlFile)this.externalFile).setPriorError(status);
        }
    }

    public XmlFile declare(boolean optional, Variable filenameVariable, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, String codeSet, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, filenameVariable, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, codeSet);
    }

    public XmlFile declare(boolean optional, Variable filenameVariable, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, String codeSet) {
        String assignTo = "";
        this.filenameVariable = filenameVariable;
        if (filenameVariable != null) {
            assignTo = filenameVariable.toString();
        }
        return this.declare(optional, assignTo, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, codeSet);
    }

    public XmlFile declare(boolean optional, String assignTo, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, String codeSet, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, assignTo, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, codeSet);
    }

    public XmlFile declare(boolean optional, String assignTo, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, String codeSet) {
        int storageSpace;
        this.optional = optional;
        this.fileStatus = fileStatus;
        this.dependingOn = dependingOn;
        this.minimum = recordFrom;
        this.maximum = recordTo;
        if (this.maximum < 0) {
            this.maximum = -1;
        }
        if (this.minimum < 0) {
            this.minimum = -1;
        }
        if (this.minimum < 0 && this.maximum >= 0) {
            this.minimum = this.maximum;
        }
        if (this.maximum < 0 && this.minimum >= 0) {
            this.maximum = this.minimum;
        }
        if (this.minimum > this.maximum) {
            this.maximum = this.minimum;
        }
        if ((storageSpace = this.maximum + 4) < 1024) {
            storageSpace = 1024;
        }
        this.codeSet = codeSet;
        if (blockTo < blockFrom) {
            blockTo = blockFrom;
        }
        if (isRecords) {
            if (blockTo > 0) {
                blockTo *= recordTo;
            }
            if (blockFrom > 0) {
                blockFrom *= recordTo;
            }
        }
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.setFilename(assignTo);
        return this;
    }

    public XmlFile endDeclare() {
        return this;
    }

    public int getSize() {
        return this.maximum;
    }

    public int currentSize() {
        return this.dependingOn != null ? this.dependingOn.toInt() : this.getSize();
    }

    public void setFilename(String assignTo) {
        if (assignTo == null) {
            assignTo = "";
        }
        String locase = assignTo.toLowerCase();
        boolean retry = false;
        do {
            try {
                retry = false;
                if (locase.startsWith("xml:")) {
                    assignTo = assignTo.substring(4);
                    locase = locase.substring(4);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("nons:")) {
                    assignTo = assignTo.substring(5);
                    locase = locase.substring(5);
                    retry = true;
                    spf.setNamespaceAware(false);
                    continue;
                }
                if (locase.startsWith("ns:")) {
                    assignTo = assignTo.substring(3);
                    locase = locase.substring(3);
                    retry = true;
                    spf.setNamespaceAware(true);
                    continue;
                }
                if (locase.startsWith("nonsp:")) {
                    assignTo = assignTo.substring(6);
                    locase = locase.substring(6);
                    retry = true;
                    spf.setFeature(FEATURE_NAMESPACE_PREFIXES, false);
                    continue;
                }
                if (locase.startsWith("nsp:")) {
                    assignTo = assignTo.substring(4);
                    locase = locase.substring(4);
                    retry = true;
                    spf.setFeature(FEATURE_NAMESPACE_PREFIXES, true);
                    continue;
                }
                if (locase.startsWith("noint:")) {
                    assignTo = assignTo.substring(6);
                    locase = locase.substring(6);
                    retry = true;
                    spf.setFeature(FEATURE_INTERN, false);
                    continue;
                }
                if (locase.startsWith("int:")) {
                    assignTo = assignTo.substring(4);
                    locase = locase.substring(4);
                    retry = true;
                    spf.setFeature(FEATURE_INTERN, true);
                    continue;
                }
                if (locase.startsWith("noval:")) {
                    assignTo = assignTo.substring(6);
                    locase = locase.substring(6);
                    retry = true;
                    spf.setValidating(false);
                    continue;
                }
                if (locase.startsWith("val:")) {
                    assignTo = assignTo.substring(4);
                    locase = locase.substring(4);
                    retry = true;
                    spf.setValidating(true);
                    continue;
                }
                if (locase.startsWith("nogen:")) {
                    assignTo = assignTo.substring(6);
                    locase = locase.substring(6);
                    retry = true;
                    spf.setFeature(FEATURE_EXTERNAL_GENERAL, false);
                    continue;
                }
                if (locase.startsWith("gen:")) {
                    assignTo = assignTo.substring(4);
                    locase = locase.substring(4);
                    retry = true;
                    spf.setFeature(FEATURE_EXTERNAL_GENERAL, true);
                    continue;
                }
                if (locase.startsWith("nopar:")) {
                    assignTo = assignTo.substring(6);
                    locase = locase.substring(6);
                    retry = true;
                    spf.setFeature(FEATURE_EXTERNAL_PARAMETER, false);
                    continue;
                }
                if (locase.startsWith("par:")) {
                    assignTo = assignTo.substring(4);
                    locase = locase.substring(4);
                    retry = true;
                    spf.setFeature(FEATURE_EXTERNAL_PARAMETER, true);
                    continue;
                }
                if (locase.startsWith("nows:")) {
                    this.featureWhitespace = false;
                    assignTo = assignTo.substring(5);
                    locase = locase.substring(5);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("ws:")) {
                    this.featureWhitespace = true;
                    assignTo = assignTo.substring(3);
                    locase = locase.substring(3);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("noskip:")) {
                    this.featureSkippedEntities = false;
                    assignTo = assignTo.substring(7);
                    locase = locase.substring(7);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("skip:")) {
                    this.featureSkippedEntities = true;
                    assignTo = assignTo.substring(5);
                    locase = locase.substring(5);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("nopc:")) {
                    this.featureProcessingCode = false;
                    assignTo = assignTo.substring(5);
                    locase = locase.substring(5);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("pc:")) {
                    this.featureProcessingCode = true;
                    assignTo = assignTo.substring(3);
                    locase = locase.substring(3);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("noprefix:")) {
                    this.featurePrefixes = false;
                    assignTo = assignTo.substring(9);
                    locase = locase.substring(9);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("prefix:")) {
                    this.featurePrefixes = true;
                    assignTo = assignTo.substring(7);
                    locase = locase.substring(7);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("noelem:")) {
                    this.featureElements = false;
                    assignTo = assignTo.substring(7);
                    locase = locase.substring(7);
                    retry = true;
                    continue;
                }
                if (locase.startsWith("elem:")) {
                    this.featureElements = true;
                    assignTo = assignTo.substring(5);
                    locase = locase.substring(5);
                    retry = true;
                    continue;
                }
                if (!locase.startsWith("driver=") && !locase.startsWith("parser=")) continue;
                int colon = assignTo.indexOf(58);
                if (colon >= 0) {
                    System.setProperty("javax.xml.parsers.SAXParserFactory", assignTo.substring(7, colon).trim());
                    assignTo = assignTo.substring(colon + 1);
                    locase = locase.substring(colon + 1);
                    retry = true;
                    continue;
                }
                assignTo = assignTo.substring(7);
                locase = locase.substring(7);
                retry = false;
            }
            catch (Exception colon) {
                // empty catch block
            }
        } while (retry);
        if (assignTo.indexOf(58) <= 1) {
            File file2 = new File(assignTo);
            String path = file2.getAbsolutePath();
            if (Context.getGlobalFileCharacter() != '\uffff') {
                path = path.replace(Context.getGlobalFileCharacter(), '/');
            } else if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.filename = "file:" + path;
        } else {
            this.filename = assignTo;
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setFixed() {
        this.newModes = 1;
    }

    public void setVariable() {
        this.newModes = 2;
    }

    @Override
    public void init() {
        this.readSize = -1;
        if (this.isOpen) {
            this.close();
        }
    }

    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) {
        int timeout_mask = 0x2100000;
        return this.open(mode &= ~timeout_mask);
    }

    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) {
        int timeout_mask = 0x2100000;
        return this.open(mode &= ~timeout_mask);
    }

    public synchronized boolean openTimeoutRetries(int mode) {
        int timeout_mask = 0x2100000;
        return this.open(mode &= ~timeout_mask);
    }

    @Override
    public boolean close() {
        return this.close(0);
    }

    public boolean readNext(Variable data) {
        return this.read(data);
    }

    public boolean readPrevious(Variable data) {
        return this.readNext(data);
    }

    public boolean readNext(Variable data, int mode, Numeric timeout) {
        return this.read(data, mode, timeout);
    }

    public boolean readPrevious(Variable data, int mode, Numeric timeout) {
        return this.readNext(data, mode, timeout);
    }

    public boolean read(Variable data, int mode, Numeric timeout) {
        return this.read(data);
    }

    private String locatorMessage() {
        try {
            if (this.locator != null) {
                StringBuffer result = new StringBuffer(32);
                result.append(this.locator.getLineNumber()).append(':').append(this.locator.getColumnNumber());
                if (this.locator.getSystemId() != null) {
                    result.append(this.locator.getSystemId()).append(':');
                }
                if (this.locator.getPublicId() != null) {
                    result.append(this.locator.getPublicId());
                }
                return result.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return " ";
    }

    @Override
    public void run() {
        block4: {
            try {
                this.xmlReader.parse(this.filename);
            }
            catch (SAXException se) {
                if (!this.IGNORE_ALL) {
                    this.fillInLocator();
                    this.signal(14);
                    this.iostatus(-30, se.toString(), this.locatorMessage());
                    this.signal(0);
                    this.IGNORE_ALL = true;
                    this.abort();
                }
            }
            catch (Exception e) {
                if (this.IGNORE_ALL) break block4;
                this.fillInLocator();
                this.signal(14);
                this.iostatus(-30, e.toString(), this.locatorMessage());
                this.signal(0);
                this.IGNORE_ALL = true;
                this.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open(int mode) {
        String filename;
        mode = this.setOpenMode(mode);
        this.override_fixed = (this.newModes & 1) != 0;
        this.override_variable = (this.newModes & 2) != 0;
        boolean bl = this.override_varying = (this.newModes & 4) != 0;
        if (this.filenameVariable != null) {
            this.setFilename(this.filenameVariable.toString());
        }
        if ((filename = this.getFilename()) == null) {
            this.iostatus(-37, "No filename given.");
            this.isOpen = false;
            return false;
        }
        this.readSize = -1;
        if ((mode & 1) != 0) {
            this.setReadable(true);
        } else {
            this.setReadable(false);
        }
        if ((mode & 2) != 0) {
            this.setWritable(true);
        } else {
            this.setWritable(false);
        }
        if ((mode & 4) != 0) {
            this.setReadable(false);
            this.setWritable(true);
            this.setExtend(true);
        } else {
            this.setExtend(false);
        }
        if (this.isExtend()) {
            this.iostatus(-37, "Cannot open XML for EXTEND.");
            this.isOpen = false;
            return false;
        }
        if (this.isOutput()) {
            this.iostatus(-37, "Cannot open XML for OUTPUT.");
            this.isOpen = false;
            return false;
        }
        if (this.isIO()) {
            this.iostatus(-37, "Cannot open XML for IO.");
            this.isOpen = false;
            return false;
        }
        if (this.optional) {
            mode |= 8;
        }
        try {
            SAXParserFactory sAXParserFactory = spf;
            synchronized (sAXParserFactory) {
                SAXParser saxParser = spf.newSAXParser();
                this.xmlReader = saxParser.getXMLReader();
                this.xmlReader.setContentHandler(this);
                this.xmlReader.setErrorHandler(this);
            }
            this.IGNORE_ALL = false;
            this.currentElements = new Vector();
            this.currentWrites = new Vector();
            this.xmlThread = new ThreadQueue(this);
            this.xmlThread.start();
            this.doOpen();
            int returnCode = this.priorError();
            this.isOpen = returnCode >= -9 && returnCode <= 9;
            return this.isOpen;
        }
        catch (Exception e) {
            this.iostatus(-35, e.toString(), "Problem opening XML parser or file.");
            this.isOpen = false;
            return this.isOpen;
        }
    }

    public boolean close(int mode) {
        this.IGNORE_ALL = true;
        this.xmlReader = null;
        this.xmlThread = null;
        return !this.isOpen;
    }

    private void xmlSearchPrepare(Variable data) {
        if (this.previousSearch == data) {
            return;
        }
        this.previousSearch = data;
        this.root = new XmlNode(data);
    }

    @Override
    public boolean read(Variable data) {
        if (this.isExtend()) {
            this.iostatus(-47, "Cannot READ from EXTEND file.");
            return false;
        }
        this.xmlSearchPrepare(data);
        if (this.dependingOn != null) {
            this.readSize = this.dependingOn.toInt();
        } else {
            this.readSize = this.currentSize();
            if (this.readSize <= 0) {
                this.readSize = data.length();
            }
        }
        return this.doRead(data);
    }

    @Override
    public boolean write(Variable data) {
        return false;
    }

    public boolean write(Variable data, int mode, Numeric timeout) {
        return false;
    }

    public boolean rewrite(Variable data, int mode, Numeric timeout) {
        return false;
    }

    public boolean rewrite(Variable data) {
        return false;
    }

    @Override
    public boolean advance() {
        return false;
    }

    @Override
    public boolean advancePage() {
        return false;
    }

    @Override
    public boolean advance(int n) {
        return false;
    }

    @Override
    public Object getObject() {
        return this.xmlReader;
    }

    public boolean deleteFile() {
        String filename = this.getFilename();
        if (filename != null) {
            File ref = new File(filename);
            if (ref.exists()) {
                ref.delete();
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "XML FILE";
    }

    @Override
    public final Numeric getLinageCounter() {
        return new Numeric(0);
    }

    public void finalize() {
        this.init();
    }

    public void flushCache() {
    }

    @Override
    public void unlock() {
        this.iostatus(0, null);
    }

    protected final boolean writeHeader() {
        return true;
    }

    protected final int readHeader() {
        return 0;
    }

    public void exclusive() {
        this.iostatus(30, "Cannot EXCLUSIVE an XML file.");
    }

    public void exclusiveConditionally() {
        this.iostatus(30, "Cannot EXCLUSIVE an XML file.");
    }

    public void unexclusive() {
        this.iostatus(30, "Cannot UNEXCLUSIVE an XML file.");
    }

    private boolean doOpen() {
        return this.doXml(0, null);
    }

    private boolean doRead(Variable v) {
        return this.doXml(1, v);
    }

    private boolean doClose() {
        return this.doXml(3, null);
    }

    private boolean doXml(int command, Variable data) {
        int type = 0;
        boolean status = false;
        if (this.IGNORE_ALL) {
            return status;
        }
        while (true) {
            if ((type = this.waitForSignal()) == 0) {
                this.fillInLocator();
                return status;
            }
            block0 : switch (command) {
                case 0: {
                    switch (type) {
                        case 1: {
                            status = true;
                            this.iostatus(0, null);
                            break block0;
                        }
                        case 2: {
                            status = false;
                            this.iostatus(-10, null);
                            break block0;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            status = false;
                            this.iostatus(-39, "Expected start of document.");
                        }
                    }
                    break;
                }
                case 3: {
                    switch (type) {
                        case 1: {
                            this.iostatus(0, null);
                            break block0;
                        }
                        case 2: {
                            status = false;
                            this.iostatus(-10, null);
                            break block0;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            this.iostatus(0, null);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (type) {
                        case 1: {
                            this.skipSignal();
                            break block0;
                        }
                        case 2: {
                            this.iostatus(-10, null);
                            break block0;
                        }
                        case 3: {
                            this.skipSignal();
                            break block0;
                        }
                        case 4: {
                            this.skipSignal();
                            return status;
                        }
                        case 5: 
                        case 6: {
                            break block0;
                        }
                    }
                }
            }
        }
    }

    public XmlFile setPassword(Variable identifier) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        SignalObject signalObject = this.signalObject;
        synchronized (signalObject) {
            this.signalObject.setType(0);
            this.signalObject.notifyAll();
        }
        signalObject = this.signalObject;
        synchronized (signalObject) {
            this.signalObject.setType(0);
            this.signalObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(int signalType) {
        SignalObject signalObject = this.returnObject;
        synchronized (signalObject) {
            SignalObject signalObject2 = this.signalObject;
            synchronized (signalObject2) {
                this.signalObject.setType(signalType);
                this.signalObject.notifyAll();
            }
            try {
                this.returnObject.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int skipSignal() {
        int type = this.waitForSignal();
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForSignal() {
        int type = 0;
        SignalObject signalObject = this.signalObject;
        synchronized (signalObject) {
            SignalObject signalObject2 = this.returnObject;
            synchronized (signalObject2) {
                this.returnObject.notifyAll();
            }
            try {
                this.signalObject.wait();
                type = this.signalObject.getType();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return type;
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    @Override
    public void startDocument() {
        if (!this.IGNORE_ALL) {
            this.signal(1);
            this.signal(0);
        }
    }

    @Override
    public void endDocument() {
        if (!this.IGNORE_ALL) {
            this.signal(2);
            this.signal(0);
        }
    }

    private int level() {
        return this.currentElements.size();
    }

    private void addCurrentElement(String s) {
        this.currentElements.addElement(s);
    }

    private String currentElement() {
        return this.currentElement(this.level());
    }

    private String currentElement(int i) {
        return this.currentElements.elementAt(i);
    }

    private void fillInLocator() {
        if (this.locator != null) {
            this.setLocatorPublic(this.locator.getPublicId());
            this.setLocatorSystem(this.locator.getSystemId());
            this.setLocatorColumn(this.locator.getColumnNumber());
            this.setLocatorLine(this.locator.getLineNumber());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (length > 0 && !this.IGNORE_ALL && this.currentElement != null) {
            this.signal(3);
            try {
                this.currentElement.setContentOffset(0);
                this.currentElement.setContentLength(length);
                Variable v = this.currentElement.getContentData();
                if (v != null) {
                    v.move(ch, start, length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.signal(0);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (length > 0 && !this.IGNORE_ALL && this.featureWhitespace && this.currentElement != null) {
            this.signal(4);
            this.currentElement.setContentOffset(0);
            this.currentElement.setContentLength(length);
            Variable v = this.currentElement.getContentData();
            if (v != null) {
                v.move(ch, start, length);
            }
            this.signal(0);
        }
    }

    public boolean addCurrentWrite(XmlNode node) {
        if (node == null) {
            return false;
        }
        try {
            int level = this.level();
            if (this.currentWrites == null) {
                this.currentWrites = new Vector();
            }
            while (this.currentWrites.size() <= level) {
                this.currentWrites.addElement(new Vector());
            }
            Vector<XmlNode> levelVector = this.currentWrites.elementAt(level);
            if (levelVector != null) {
                if (levelVector.contains(node)) {
                    int currentWritesSize = this.currentWrites.size();
                    for (int i = 0; i < currentWritesSize; ++i) {
                        this.currentWrites.elementAt(i).setSize(0);
                    }
                    levelVector.addElement(node);
                    this.addedAnyWrites = true;
                    return true;
                }
                this.addedAnyWrites = true;
                levelVector.addElement(node);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void clearCurrentWrites() {
        if (this.currentWrites == null) {
            return;
        }
        int size = this.currentWrites.size();
        Vector<XmlNode> level = null;
        for (int i = 0; i < size; ++i) {
            level = this.currentWrites.elementAt(i);
            if (level == null) continue;
            level.setSize(0);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        if (localName == null || localName.length() == 0) {
            localName = qName;
        }
        if (!this.IGNORE_ALL) {
            if (localName != null) {
                this.addCurrentElement(localName);
            } else if (qName != null) {
                this.addCurrentElement(qName);
            }
            this.currentElement = this.root.find(this.currentElements);
            boolean oldWrites = this.addedAnyWrites;
            if (this.addCurrentWrite(this.currentElement)) {
                this.signal(15);
                this.signal(0);
                this.root.setBlank();
            } else if (this.level() == 2) {
                this.addedAnyWrites = false;
                if (oldWrites) {
                    this.clearCurrentWrites();
                    this.addCurrentWrite(this.currentElement);
                    this.signal(15);
                    this.signal(0);
                    this.root.setBlank();
                }
            }
            if (this.featureElements) {
                this.signal(5);
                String passName = qName;
                if (passName == null) {
                    passName = localName;
                }
                this.iostatus(-14, passName, namespaceURI);
            }
            if (this.currentElement != null) {
                if (qName != null) {
                    this.currentElement.setContentName(qName);
                } else if (localName != null) {
                    this.currentElement.setContentName(localName);
                }
                Vector<XmlAttribute> variableAttributes = this.currentElement.getAttributes();
                if (variableAttributes != null) {
                    int sizeOfVariableAttributes = variableAttributes.size();
                    XmlAttribute xmlAttribute = null;
                    int length = attrs.getLength();
                    String name = null;
                    int nameIndex = -1;
                    String xmlAttributeName = null;
                    for (int indexOfVar = 0; indexOfVar < sizeOfVariableAttributes; ++indexOfVar) {
                        xmlAttribute = variableAttributes.elementAt(indexOfVar);
                        if (xmlAttribute == null) continue;
                        xmlAttributeName = xmlAttribute.getName();
                        nameIndex = -1;
                        if (xmlAttributeName.startsWith("*")) {
                            if (xmlAttributeName.equals("*")) {
                                nameIndex = indexOfVar;
                            } else {
                                try {
                                    nameIndex = Integer.parseInt(xmlAttributeName.substring(1).trim()) - 1;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        boolean filled = false;
                        for (int i = 0; i < length; ++i) {
                            try {
                                name = attrs.getQName(i);
                            }
                            catch (Throwable cannotObtainQName) {
                                name = null;
                            }
                            if (name == null) {
                                try {
                                    name = attrs.getLocalName(i);
                                }
                                catch (Throwable cannotObtainQName) {
                                    // empty catch block
                                }
                            }
                            if (nameIndex < 0 && name != null && name.equals(xmlAttributeName)) {
                                nameIndex = i;
                            }
                            if (nameIndex != i) continue;
                            String alocalName = null;
                            String aqName = null;
                            String type = null;
                            String uri = null;
                            String value = null;
                            try {
                                alocalName = attrs.getLocalName(i);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                aqName = attrs.getQName(i);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                type = attrs.getType(i);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                uri = attrs.getURI(i);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                value = attrs.getValue(i);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (qName != null) {
                                xmlAttribute.setAttributeName(aqName);
                            } else if (localName != null) {
                                xmlAttribute.setAttributeName(alocalName);
                            }
                            xmlAttribute.setAttributeLocal(alocalName);
                            xmlAttribute.setAttributeQname(aqName);
                            xmlAttribute.setAttributeType(type);
                            xmlAttribute.setAttributeUri(uri);
                            xmlAttribute.setAttributeData(value);
                            if (value != null) {
                                xmlAttribute.setAttributeLength(value.length());
                            } else {
                                xmlAttribute.setAttributeLength(0);
                            }
                            filled = true;
                            break;
                        }
                        if (filled) continue;
                        xmlAttribute.setBlank();
                    }
                }
            }
            if (this.featureElements) {
                this.signal(0);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (!this.IGNORE_ALL) {
            if (this.featureElements) {
                this.signal(6);
                String passName = qName;
                if (passName == null) {
                    passName = localName;
                }
                this.iostatus(-15, passName, namespaceURI);
            }
            this.currentElements.setSize(this.currentElements.size() - 1);
            this.currentElement = this.root.find(this.currentElements);
            if (this.featureElements) {
                this.signal(0);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (!this.IGNORE_ALL && this.featurePrefixes) {
            this.signal(7);
            this.iostatus(-16, prefix, uri);
            this.signal(0);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (!this.IGNORE_ALL && this.featurePrefixes) {
            this.signal(8);
            this.iostatus(-17, prefix);
            this.signal(0);
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (!this.IGNORE_ALL && this.featureProcessingCode) {
            this.signal(9);
            this.iostatus(-18, target, data);
            this.signal(0);
        }
    }

    @Override
    public void skippedEntity(String name) {
        if (!this.IGNORE_ALL && this.featureSkippedEntities) {
            this.signal(10);
            this.iostatus(-21, name);
            this.signal(0);
        }
    }

    @Override
    public void error(SAXParseException error) {
        if (!this.IGNORE_ALL) {
            this.signal(11);
            this.iostatus(-20, error.getMessage());
            this.signal(0);
        }
    }

    @Override
    public void fatalError(SAXParseException error) {
        if (!this.IGNORE_ALL) {
            this.signal(13);
            this.iostatus(-30, error.getMessage());
            this.signal(0);
        }
    }

    @Override
    public void warning(SAXParseException error) {
        if (!this.IGNORE_ALL) {
            this.signal(12);
            this.iostatus(-11, error.getMessage());
            this.signal(0);
        }
    }

    public void setLocatorPublic(String s) {
        if (this.locatorPublic != null) {
            this.locatorPublic.move(s);
        }
    }

    public void setLocatorSystem(String s) {
        if (this.locatorSystem != null) {
            this.locatorSystem.move(s);
        }
    }

    public void setLocatorLine(int i) {
        if (this.locatorLine != null) {
            this.locatorLine.move(i);
        }
    }

    public void setLocatorColumn(int i) {
        if (this.locatorColumn != null) {
            this.locatorColumn.move(i);
        }
    }

    public class XmlNode {
        private String tag = null;
        private XmlNode parent = null;
        private Vector<XmlNode> children = null;
        private Variable reference = null;
        private Variable contentName = null;
        private Variable contentOffset = null;
        private Variable contentLength = null;
        private Variable contentData = null;
        private Vector<XmlAttribute> attributes = null;
        private boolean xmlCapable = false;

        public boolean isXmlCapable() {
            return this.xmlCapable;
        }

        public void setXmlCapable() {
            this.xmlCapable = true;
        }

        public void setBlank() {
            int i;
            int length;
            if (this.reference != null) {
                this.reference.initialize();
            }
            if (this.children != null) {
                length = this.children.size();
                for (i = 0; i < length; ++i) {
                    this.children.elementAt(i).setBlank();
                }
            }
            if (this.attributes != null) {
                length = this.attributes.size();
                for (i = 0; i < length; ++i) {
                    this.attributes.elementAt(i).setBlank();
                }
            }
        }

        public XmlNode(Variable root) {
            if (root != null) {
                this.reference = root;
                this.parent = null;
                this.tag = root.getIdentifier();
                this.addChildren(root.getChild());
                this.discover(root);
            }
        }

        public XmlNode(XmlNode parent, Variable reference) {
            if (reference != null) {
                this.reference = reference;
                this.tag = reference.getIdentifier();
            }
            if (parent != null) {
                this.parent = parent;
                parent.addChild(this);
            }
            if (reference != null) {
                this.addChildren(reference.getChild());
                this.discover(reference);
            }
        }

        public Variable getContentName() {
            return this.contentName;
        }

        public Variable getContentOffset() {
            return this.contentOffset;
        }

        public Variable getContentLength() {
            return this.contentLength;
        }

        public Variable getContentData() {
            return this.contentData;
        }

        public void setContentName(String s) {
            if (this.contentName != null) {
                this.contentName.move(s);
            }
        }

        public void setContentOffset(int i) {
            if (this.contentOffset != null) {
                this.contentOffset.move(i);
            }
        }

        public void setContentLength(int i) {
            if (this.contentLength != null) {
                this.contentLength.move(i);
            }
        }

        public void setContentData(String s) {
            if (this.contentData != null) {
                this.contentData.move(s);
            }
        }

        public Vector<XmlAttribute> getAttributes() {
            return this.attributes;
        }

        private void discover(Variable node) {
            if (node.isXml()) {
                return;
            }
            Variable content = null;
            Variable attribute = null;
            Variable locator = null;
            Variable attributeName = null;
            Variable attributeUri = null;
            Variable attributeLocal = null;
            Variable attributeQname = null;
            Variable attributeType = null;
            Variable attributeData = null;
            Variable attributeLength = null;
            Variable child = node.getChild();
            while (child != null) {
                boolean foundAttribute = false;
                attribute = null;
                if (child.isXml()) {
                    this.xmlCapable = true;
                    if (child.isXmlContent()) {
                        content = child;
                    } else if (child.isXmlAttribute()) {
                        attribute = child;
                        foundAttribute = true;
                    } else if (child.isXmlLocator()) {
                        locator = child;
                    }
                }
                for (Variable grand = child.getChild(); grand != null; grand = grand.getSibling()) {
                    if (!grand.isXml()) continue;
                    if (grand.isXmlAnyContent()) {
                        this.xmlCapable = true;
                        if (grand.isXmlContentOffset()) {
                            this.contentOffset = grand;
                            continue;
                        }
                        if (grand.isXmlContentLength()) {
                            this.contentLength = grand;
                            continue;
                        }
                        if (grand.isXmlContentData()) {
                            this.contentData = grand;
                            continue;
                        }
                        if (!grand.isXmlContentName()) continue;
                        this.contentName = grand;
                        continue;
                    }
                    if (grand.isXmlAnyAttribute()) {
                        this.xmlCapable = true;
                        foundAttribute = true;
                        if (grand.isXmlAttributeUri()) {
                            attributeUri = grand;
                            continue;
                        }
                        if (grand.isXmlAttributeLocal()) {
                            attributeLocal = grand;
                            continue;
                        }
                        if (grand.isXmlAttributeQname()) {
                            attributeQname = grand;
                            continue;
                        }
                        if (grand.isXmlAttributeType()) {
                            attributeType = grand;
                            continue;
                        }
                        if (grand.isXmlAttributeData()) {
                            attributeData = grand;
                            continue;
                        }
                        if (grand.isXmlAttributeLength()) {
                            attributeLength = grand;
                            continue;
                        }
                        if (!grand.isXmlAttributeName()) continue;
                        attributeName = grand;
                        continue;
                    }
                    if (!grand.isXmlAnyLocator()) continue;
                    this.xmlCapable = true;
                    if (grand.isXmlLocatorPublic()) {
                        XmlFile.this.locatorPublic = grand;
                        continue;
                    }
                    if (grand.isXmlLocatorSystem()) {
                        XmlFile.this.locatorSystem = grand;
                        continue;
                    }
                    if (grand.isXmlLocatorLine()) {
                        XmlFile.this.locatorLine = grand;
                        continue;
                    }
                    if (!grand.isXmlLocatorColumn()) continue;
                    XmlFile.this.locatorColumn = grand;
                }
                child = child.getSibling();
                if (!foundAttribute) continue;
                if (attributeData == null && attribute != null && attribute.getChild() == null) {
                    attributeData = attribute;
                }
                if (attribute != null) {
                    String attributeId = attribute.getIdentifier();
                    XmlAttribute xmlAttribute = new XmlAttribute(attributeId);
                    xmlAttribute.attributeName = attributeName;
                    xmlAttribute.attributeUri = attributeUri;
                    xmlAttribute.attributeLocal = attributeLocal;
                    xmlAttribute.attributeQname = attributeQname;
                    xmlAttribute.attributeType = attributeType;
                    xmlAttribute.attributeData = attributeData;
                    xmlAttribute.attributeLength = attributeLength;
                    if (this.attributes == null) {
                        this.attributes = new Vector();
                    }
                    this.attributes.addElement(xmlAttribute);
                }
                attributeName = null;
                attributeUri = null;
                attributeLocal = null;
                attributeQname = null;
                attributeType = null;
                attributeData = null;
                attributeLength = null;
                foundAttribute = false;
            }
            if (this.contentData == null && content != null && content.getChild() == null) {
                this.contentData = content;
            }
            if (XmlFile.this.locatorSystem == null && locator != null && locator.getChild() == null) {
                XmlFile.this.locatorSystem = locator;
            }
            if (this.contentData == null && node != null && node.getChild() == null) {
                this.contentData = node;
            }
        }

        private void addChildren(Variable child) {
            while (child != null) {
                child = child.getSibling();
            }
        }

        public void addChild(XmlNode child) {
            if (this.children == null) {
                this.children = new Vector();
            }
            this.children.addElement(child);
        }

        public boolean matches(String name) {
            if (this.tag == null) {
                return true;
            }
            if (this.tag.equals(name)) {
                return true;
            }
            return this.tag.equals("*");
        }

        public XmlNode find(Vector<String> currentElements) {
            if (currentElements == null || currentElements.size() <= 0) {
                return null;
            }
            return this.find(currentElements, 0, currentElements.elementAt(0));
        }

        public XmlNode find(Vector<String> currentElements, int index, String match) {
            try {
                if (this.matches(match)) {
                    if (this.children == null) {
                        return this;
                    }
                    if (this.isXmlCapable() && index == currentElements.size() - 1) {
                        return this;
                    }
                    match = currentElements.elementAt(++index);
                    int size = this.children.size();
                    XmlNode check = null;
                    for (int i = 0; i < size; ++i) {
                        check = this.children.elementAt(i).find(currentElements, index, match);
                        if (check == null) continue;
                        return check;
                    }
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public Variable getVariable() {
            return this.reference;
        }

        public XmlNode getParent() {
            return this.parent;
        }

        public int getCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public XmlNode getChild(int index) {
            return this.children.elementAt(index);
        }

        public String toString() {
            String s = "XmlNode[";
            s = s + "tag=" + this.tag;
            s = this.parent == null ? s + ",parent=none" : s + ",parent=" + this.parent.tag;
            s = this.children == null ? s + ",children=none" : s + ",children=" + this.children.size();
            if (this.contentName != null) {
                s = s + ",content-name";
            }
            if (this.contentOffset != null) {
                s = s + ",content-offset";
            }
            if (this.contentLength != null) {
                s = s + ",content-length";
            }
            if (this.contentData != null) {
                s = s + ",content-data";
            }
            if (this.attributes != null) {
                s = s + "attributes " + this.attributes.size();
            }
            s = s + "]";
            return s;
        }
    }

    public static class XmlAttribute {
        private String name = null;
        private Variable attributeName = null;
        private Variable attributeUri = null;
        private Variable attributeLocal = null;
        private Variable attributeQname = null;
        private Variable attributeType = null;
        private Variable attributeData = null;
        private Variable attributeLength = null;

        public XmlAttribute(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
            this.name = s;
        }

        public Variable getAttributeName() {
            return this.attributeName;
        }

        public Variable getAttributeUri() {
            return this.attributeUri;
        }

        public Variable getAttributeLocal() {
            return this.attributeLocal;
        }

        public Variable getAttributeQname() {
            return this.attributeQname;
        }

        public Variable getAttributeType() {
            return this.attributeType;
        }

        public Variable getAttributeData() {
            return this.attributeData;
        }

        public Variable getAttributeLength() {
            return this.attributeLength;
        }

        public void setAttributeName(String s) {
            if (this.attributeName != null) {
                this.attributeName.move(s);
            }
        }

        public void setAttributeUri(String s) {
            if (this.attributeUri != null) {
                this.attributeUri.move(s);
            }
        }

        public void setAttributeLocal(String s) {
            if (this.attributeLocal != null) {
                this.attributeLocal.move(s);
            }
        }

        public void setAttributeQname(String s) {
            if (this.attributeQname != null) {
                this.attributeQname.move(s);
            }
        }

        public void setAttributeType(String s) {
            if (this.attributeType != null) {
                this.attributeType.move(s);
            }
        }

        public void setAttributeData(String s) {
            if (this.attributeData != null) {
                this.attributeData.move(s);
            }
        }

        public void setAttributeLength(int i) {
            if (this.attributeLength != null) {
                this.attributeLength.move(i);
            }
        }

        public void setBlank() {
            if (this.attributeName != null) {
                this.attributeName.initialize();
            }
            if (this.attributeUri != null) {
                this.attributeUri.initialize();
            }
            if (this.attributeLocal != null) {
                this.attributeLocal.initialize();
            }
            if (this.attributeQname != null) {
                this.attributeQname.initialize();
            }
            if (this.attributeType != null) {
                this.attributeType.initialize();
            }
            if (this.attributeData != null) {
                this.attributeData.initialize();
            }
            if (this.attributeLength != null) {
                this.attributeLength.initialize();
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public static class SignalObject {
        private int type;

        public void setType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

